(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1825173,      35836]
NotebookOptionsPosition[   1821542,      35778]
NotebookOutlinePosition[   1821898,      35794]
CellTagsIndexPosition[   1821855,      35791]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"P", "/", "Q"}], "-", "type"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "\"\<E:\\\\220323\\\\az\\\\\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Poi1", "=", "\"\<Munc13-1\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Poi2", "=", "\"\<Cav2.1\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Import", "[", "\"\<211221_PQ_wt1.mx\>\"", "]"}], ",", 
        RowBox[{"Import", "[", "\"\<211221_PQ_wt2.mx\>\"", "]"}], ",", 
        RowBox[{"Import", "[", "\"\<220108_PQ_wt1.mx\>\"", "]"}], ",", 
        RowBox[{"Import", "[", "\"\<220108_PQ_wt2.mx\>\"", "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Import", "[", "\"\<211221_PQ_ko1.mx\>\"", "]"}], ",", 
        RowBox[{"Import", "[", "\"\<211221_PQ_ko2.mx\>\"", "]"}], ",", 
        RowBox[{"Import", "[", "\"\<220108_PQ_ko1.mx\>\"", "]"}], ",", 
        RowBox[{"Import", "[", "\"\<220108_PQ_ko2.mx\>\"", "]"}]}], "}"}], 
      "]"}]}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
   RowBox[{"(*", "Dataset", "*)"}], 
   StyleBox["\[IndentingNewLine]",
    FontColor->GrayLevel[0]], 
   RowBox[{"Dataset", "[", 
    RowBox[{"<|", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<WT\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<n\>\"", "\[Rule]", 
          RowBox[{"Length", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi1", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi2", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}]}], "|>"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<KO\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<n\>\"", "\[Rule]", 
          RowBox[{"Length", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi1", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi2", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}]}], "|>"}]}]}], "|>"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Histogram", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], ",", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]]}], "}"}], ",", "Automatic", ",", 
         "\"\<Probability\>\"", ",", 
         RowBox[{"ChartStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", "Red"}], "}"}]}], ",", 
         RowBox[{"ChartLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "0.6"}], "}"}], "}"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< intensity (A.U.)\>\""}], "]"}], ",",
               "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<Probability\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Histogram", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], ",", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]]}], "}"}], ",", "Automatic", ",", 
         "\"\<Probability\>\"", ",", 
         RowBox[{"ChartStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", "Red"}], "}"}]}], ",", 
         RowBox[{"ChartLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "0.6"}], "}"}], "}"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< intensity (A.U.)\>\""}], "]"}], ",",
               "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<Probability\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"wt", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"ko", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"wt", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"ko", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< intensity (A.U.)\>\""}], "]"}], ",",
               "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< intensity (A.U.)\>\""}], "]"}], ",",
               "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Dataset", "[", 
    RowBox[{"<|", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<WT\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< cluster intensity\>\""}], "]"}], 
          "\[Rule]", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< cluster intensity\>\""}], "]"}], 
          "\[Rule]", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}]}], "|>"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<KO\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< cluster intensity\>\""}], "]"}], 
          "\[Rule]", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< cluster intensity\>\""}], "]"}], 
          "\[Rule]", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}]}], "|>"}]}]}], "|>"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"wt", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"ko", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"wt", "[", 
         RowBox[{"[", "4", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"ko", "[", 
         RowBox[{"[", "4", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< cluster intensity (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< cluster intensity (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Dataset", "[", 
    RowBox[{"<|", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<WT\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<n\>\"", "\[Rule]", 
          RowBox[{"Length", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"wt", "[", 
              RowBox[{"[", "5", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< cluster number / AZ\>\""}], "]"}], 
          "\[Rule]", 
          RowBox[{"N", "[", 
           RowBox[{"Around", "[", 
            StyleBox[
             RowBox[{"Flatten", "[", 
              RowBox[{"wt", "[", 
               RowBox[{"[", "5", "]"}], "]"}], "]"}],
             FontColor->GrayLevel[0]], "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< cluster number / AZ\>\""}], "]"}], 
          "\[Rule]", 
          RowBox[{"N", "[", 
           RowBox[{"Around", "[", 
            StyleBox[
             RowBox[{"Flatten", "[", 
              RowBox[{"wt", "[", 
               RowBox[{"[", "6", "]"}], "]"}], "]"}],
             FontColor->GrayLevel[0]], "]"}], "]"}]}]}], "|>"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<KO\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<n\>\"", "\[Rule]", 
          RowBox[{"Length", "[", 
           StyleBox[
            RowBox[{"Flatten", "[", 
             RowBox[{"ko", "[", 
              RowBox[{"[", "5", "]"}], "]"}], "]"}],
            FontColor->GrayLevel[0]], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< cluster number / AZ\>\""}], "]"}], 
          "\[Rule]", 
          RowBox[{"N", "[", 
           RowBox[{"Around", "[", 
            StyleBox[
             RowBox[{"Flatten", "[", 
              RowBox[{"ko", "[", 
               RowBox[{"[", "5", "]"}], "]"}], "]"}],
             FontColor->GrayLevel[0]], "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< cluster number / AZ\>\""}], "]"}], 
          "\[Rule]", 
          RowBox[{"N", "[", 
           RowBox[{"Around", "[", 
            StyleBox[
             RowBox[{"Flatten", "[", 
              RowBox[{"ko", "[", 
               RowBox[{"[", "6", "]"}], "]"}], "]"}],
             FontColor->GrayLevel[0]], "]"}], "]"}]}]}], "|>"}]}]}], "|>"}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"wt", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"ko", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"wt", "[", 
         RowBox[{"[", "6", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"ko", "[", 
         RowBox[{"[", "6", "]"}], "]"}], "]"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< cluster number / AZ\>\""}], "]"}], 
              ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< cluster number / AZ\>\""}], "]"}], 
              ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Dataset", "[", 
    RowBox[{"<|", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<WT\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{"\"\<Center-to-center distance\>\"", "\[Rule]", 
         RowBox[{"N", "[", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"wt", "[", 
               RowBox[{"[", "7", "]"}], "]"}], "]"}], "*", "10"}],
            FontColor->GrayLevel[0]], "]"}], "]"}]}], "|>"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<KO\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{"\"\<Center-to-center distance\>\"", "\[Rule]", 
         RowBox[{"N", "[", 
          RowBox[{"Mean", "[", 
           StyleBox[
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"ko", "[", 
               RowBox[{"[", "7", "]"}], "]"}], "]"}], "*", "10"}],
            FontColor->GrayLevel[0]], "]"}], "]"}]}], "|>"}]}]}], "|>"}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"wt", "[", 
          RowBox[{"[", "7", "]"}], "]"}], "]"}], "*", "10"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko", "=", 
     RowBox[{"HistogramDistribution", "[", 
      StyleBox[
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"ko", "[", 
          RowBox[{"[", "7", "]"}], "]"}], "]"}], "*", "10"}],
       FontColor->GrayLevel[0]], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CDF", "[", 
        RowBox[{"dwt", ",", "x"}], "]"}], ",", 
       RowBox[{"CDF", "[", 
        RowBox[{"dko", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "200"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Center-to-center distance\>\"", ",", "20", ",", "Black"}], 
         "]"}], ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}],
          "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.850631126494832*^9, {3.850631289230739*^9, 3.8506312930215635`*^9}, {
   3.8506320317591977`*^9, 3.850632032204615*^9}, {3.850632738093646*^9, 
   3.8506327382848797`*^9}, {3.8506328751493816`*^9, 3.850632893181714*^9}, {
   3.8506329239341145`*^9, 3.8506329410856447`*^9}, {3.850633245389553*^9, 
   3.8506332686689353`*^9}, {3.8506336353585587`*^9, 3.850633652268852*^9}, {
   3.8508715625013247`*^9, 3.850871668697693*^9}, {3.8508742108246946`*^9, 
   3.8508742118794355`*^9}, {3.850874299674674*^9, 3.850874302921831*^9}, {
   3.852255243753298*^9, 3.852255255154745*^9}, {3.852255302817283*^9, 
   3.8522553057564907`*^9}, {3.852255421723476*^9, 3.8522554853870573`*^9}, {
   3.8522555868650494`*^9, 3.852255767351534*^9}, {3.8550449983657513`*^9, 
   3.855045024953273*^9}, {3.855045082616025*^9, 3.855045265141511*^9}, 
   3.8550453068996844`*^9, 3.855045387852111*^9, {3.8550454224321127`*^9, 
   3.855045435784006*^9}, {3.855045663045102*^9, 3.855045690883704*^9}, {
   3.8550457555967913`*^9, 3.855045797932139*^9}, {3.8550458322011466`*^9, 
   3.855046053445136*^9}, {3.8550460871082964`*^9, 3.855046090739597*^9}, {
   3.855046147125237*^9, 3.8550461986529436`*^9}, {3.855046303134*^9, 
   3.855046364994001*^9}, {3.8550463975474253`*^9, 3.8550463991774163`*^9}, {
   3.8550913541446652`*^9, 3.8550913639495344`*^9}, {3.8550915208644156`*^9, 
   3.855091523966199*^9}, {3.8552000693977733`*^9, 3.8552000746684036`*^9}, {
   3.8552816639015627`*^9, 3.8552816728676167`*^9}, {3.8552918778228893`*^9, 
   3.8552918812439575`*^9}, {3.855291919722221*^9, 3.855291920393938*^9}, {
   3.8553510947763577`*^9, 3.8553511045665007`*^9}, {3.855351148479122*^9, 
   3.8553511553633337`*^9}, {3.8553512328873453`*^9, 
   3.8553512530622263`*^9}, {3.858052398595792*^9, 3.858052402719792*^9}},
 CellLabel->
  "In[322]:=",ExpressionUUID->"c2de559c-653a-4358-8a25-a3d121998d00"],

Cell[BoxData[
 TemplateBox[{TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "n", "Total Munc13-1 intensity", "Total Cav2.1 intensity"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[
          Association[{All, 
             TypeSystem`PackageScope`KeyDummy[10]} -> 1, {All, "n"} -> 
           1, {All, "Total Munc13-1 intensity"} -> 
           1, {All, "Total Cav2.1 intensity"} -> 1], 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             TypeSystem`PackageScope`RowShape[
              Association[
              "n" -> TypeSystem`PackageScope`AtomShape[34], 
               "Total Munc13-1 intensity" -> 
               TypeSystem`PackageScope`AtomShape[60], 
               "Total Cav2.1 intensity" -> 
               TypeSystem`PackageScope`AtomShape[60]]]]], 2, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[1623171942], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "n", "Total Munc13-1 intensity", "Total Cav2.1 intensity"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real]}], 2], "HandleQ" -> True, "RowTarget" -> 20,
         "Data" -> TypeSystem`PackageScope`CacheHandle[1623171942]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 774317267][{
                    All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"n\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"n\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 774317267][{
                    All, "n"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[All, "n"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Munc13-1 intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Munc13-1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 774317267][{
                    All, "Total Munc13-1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[All, "Total Munc13-1 intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Cav2.1 intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Cav2.1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 774317267][{
                    All, "Total Cav2.1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[All, "Total Cav2.1 intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["WT", 
                    Style[
                    "WT", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 774317267][{
                    Key["WT"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                   GeneralUtilities`Slice[
                    Key["WT"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2297"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["n"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Total Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Total Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["KO", 
                    Style[
                    "KO", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 774317267][{
                    Key["KO"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                   GeneralUtilities`Slice[
                    Key["KO"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2195"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["n"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0.959014"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Total Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0.77813"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Total Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 774317267][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 774317267]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[774317267][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {394., {42., 48.}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 CellChangeTimes->{
  3.8508742146951265`*^9, 3.8508743038884163`*^9, 3.8508911808651085`*^9, 
   3.850891264590987*^9, 3.8509830931059465`*^9, 3.852255306774928*^9, 
   3.8522554865767984`*^9, 3.852255724728649*^9, 3.8522557675898933`*^9, 
   3.855045268472585*^9, {3.855045364108375*^9, 3.855045388586759*^9}, 
   3.855045920499544*^9, 3.8550460743314505`*^9, 3.8550462124263415`*^9, 
   3.8550463199491296`*^9, {3.8550463849728317`*^9, 3.855046414162945*^9}, 
   3.855281676100159*^9, 3.855287539289589*^9, 3.855287947160612*^9, 
   3.8552890319197254`*^9, 3.8553512953155193`*^9, 3.858052490076044*^9},
 CellLabel->
  "Out[327]=",ExpressionUUID->"715bb3c1-f8a9-4103-85d5-4f5b1208f5b5"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{
           {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
            EdgeForm[{Opacity[0.20299999999999999`], Thickness[Small]}], {{}, 
             {GrayLevel[0.5], Opacity[0.5], EdgeForm[{Opacity[
              0.20299999999999999`], Thickness[Small]}], 
              RectangleBox[{0.1, 0.}, {0.2, 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{0.2, 0.}, {0.3, 0.04397039616891598},
               RoundingRadius->0], RectangleBox[{0.3, 0.}, {0.4, 0.1023073574227253},
               RoundingRadius->0], RectangleBox[{0.4, 0.}, {0.5, 0.12451023073574227},
               RoundingRadius->0], RectangleBox[{0.5, 0.}, {0.6, 0.10491946016543317},
               RoundingRadius->0], RectangleBox[{0.6, 0.}, {0.7, 0.0892468437091859},
               RoundingRadius->0], RectangleBox[{0.7, 0.}, {0.8, 0.07139747496734872},
               RoundingRadius->0], RectangleBox[{0.8, 0.}, {0.9, 0.05267740531127558},
               RoundingRadius->0], RectangleBox[{0.9, 0.}, {1., 0.05093600348280366},
               RoundingRadius->0], RectangleBox[{1., 0.}, {1.1, 0.0413582934262081},
               RoundingRadius->0], RectangleBox[{1.1, 0.}, {1.2, 0.0391815411406182},
               RoundingRadius->0], RectangleBox[{1.2, 0.}, {1.3, 0.030474531998258596},
               RoundingRadius->0], RectangleBox[{1.3, 0.}, {1.4, 0.026121027427078797},
               RoundingRadius->0], RectangleBox[{1.4, 0.}, {1.5, 0.024379625598606878},
               RoundingRadius->0], RectangleBox[{1.5, 0.}, {1.6, 0.028297779712668697},
               RoundingRadius->0], RectangleBox[{1.6, 0.}, {1.7, 0.026556377884196777},
               RoundingRadius->0], RectangleBox[{1.7, 0.}, {1.8, 0.02002612102742708},
               RoundingRadius->0], RectangleBox[{1.8, 0.}, {1.9, 0.01044841097083152},
               RoundingRadius->0], RectangleBox[{1.9, 0.}, {2., 0.0195907705703091},
               RoundingRadius->0], RectangleBox[{2., 0.}, {2.1, 0.00827165868524162},
               RoundingRadius->0], RectangleBox[{2.1, 0.}, {2.2, 0.01044841097083152},
               RoundingRadius->0], RectangleBox[{2.2, 0.}, {2.3, 0.00914235959947758},
               RoundingRadius->0], RectangleBox[{2.3, 0.}, {2.4, 0.006965607313887679},
               RoundingRadius->0], RectangleBox[{2.4, 0.}, {2.5, 0.00522420548541576},
               RoundingRadius->0], RectangleBox[{2.5, 0.}, {2.6, 0.006530256856769699},
               RoundingRadius->0], RectangleBox[{2.6, 0.}, {2.7, 0.006530256856769699},
               RoundingRadius->0], RectangleBox[{2.7, 0.}, {2.8, 0.0056595559425337396},
               RoundingRadius->0], RectangleBox[{2.8, 0.}, {2.9, 0.0043535045711798},
               RoundingRadius->0], RectangleBox[{2.9, 0.}, {3., 0.0034828036569438396},
               RoundingRadius->0], RectangleBox[{3., 0.}, {3.1, 0.00391815411406182},
               RoundingRadius->0], RectangleBox[{3.1, 0.}, {3.2, 0.0034828036569438396},
               RoundingRadius->0], RectangleBox[{3.2, 0.}, {3.3, 0.0030474531998258597},
               RoundingRadius->0], RectangleBox[{3.3, 0.}, {3.4, 0.0017414018284719198},
               RoundingRadius->0], RectangleBox[{3.4, 0.}, {3.5, 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{3.6, 0.}, {3.7, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{3.7, 0.}, {3.8, 0.0030474531998258597},
               RoundingRadius->0], RectangleBox[{3.8, 0.}, {3.9, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{3.9, 0.}, {4., 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{4., 0.}, {4.1, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{4.1, 0.}, {4.2, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{4.2, 0.}, {4.3, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{4.3, 0.}, {4.4, 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{4.4, 0.}, {4.5, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{4.5, 0.}, {4.6, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{4.6, 0.}, {4.7, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{5.1, 0.}, {5.2, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{5.4, 0.}, {5.5, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{6., 0.}, {6.1, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{6.6, 0.}, {6.7, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{7.1, 0.}, {7.2, 0.00043535045711797995},
               RoundingRadius->0]}, {}, {}}, {{}, 
             {RGBColor[1, 0, 0], Opacity[0.5], EdgeForm[{Opacity[
              0.20299999999999999`], Thickness[Small]}], 
              RectangleBox[{0.1, 0.}, {0.2, 0.005466970387243736},
               RoundingRadius->0], RectangleBox[{0.2, 0.}, {0.3, 0.04920273348519362},
               RoundingRadius->0], RectangleBox[{0.3, 0.}, {0.4, 0.12118451025056948},
               RoundingRadius->0], RectangleBox[{0.4, 0.}, {0.5, 0.1357630979498861},
               RoundingRadius->0], RectangleBox[{0.5, 0.}, {0.6, 0.1020501138952164},
               RoundingRadius->0], RectangleBox[{0.6, 0.}, {0.7, 0.08747152619589978},
               RoundingRadius->0], RectangleBox[{0.7, 0.}, {0.8, 0.0724373576309795},
               RoundingRadius->0], RectangleBox[{0.8, 0.}, {0.9, 0.04829157175398633},
               RoundingRadius->0], RectangleBox[{0.9, 0.}, {1., 0.04738041002277904},
               RoundingRadius->0], RectangleBox[{1., 0.}, {1.1, 0.03644646924829157},
               RoundingRadius->0], RectangleBox[{1.1, 0.}, {1.2, 0.03553530751708428},
               RoundingRadius->0], RectangleBox[{1.2, 0.}, {1.3, 0.03325740318906606},
               RoundingRadius->0], RectangleBox[{1.3, 0.}, {1.4, 0.02733485193621868},
               RoundingRadius->0], RectangleBox[{1.4, 0.}, {1.5, 0.02733485193621868},
               RoundingRadius->0], RectangleBox[{1.5, 0.}, {1.6, 0.024145785876993165},
               RoundingRadius->0], RectangleBox[{1.6, 0.}, {1.7, 0.01685649202733485},
               RoundingRadius->0], RectangleBox[{1.7, 0.}, {1.8, 0.010933940774487472},
               RoundingRadius->0], RectangleBox[{1.8, 0.}, {1.9, 0.011389521640091117},
               RoundingRadius->0], RectangleBox[{1.9, 0.}, {2., 0.01776765375854214},
               RoundingRadius->0], RectangleBox[{2., 0.}, {2.1, 0.010933940774487472},
               RoundingRadius->0], RectangleBox[{2.1, 0.}, {2.2, 0.00683371298405467},
               RoundingRadius->0], RectangleBox[{2.2, 0.}, {2.3, 0.006378132118451025},
               RoundingRadius->0], RectangleBox[{2.3, 0.}, {2.4, 0.010022779043280182},
               RoundingRadius->0], RectangleBox[{2.4, 0.}, {2.5, 0.005466970387243736},
               RoundingRadius->0], RectangleBox[{2.5, 0.}, {2.6, 0.005466970387243736},
               RoundingRadius->0], RectangleBox[{2.6, 0.}, {2.7, 0.004555808656036446},
               RoundingRadius->0], RectangleBox[{2.7, 0.}, {2.8, 0.004100227790432802},
               RoundingRadius->0], RectangleBox[{2.8, 0.}, {2.9, 0.005466970387243736},
               RoundingRadius->0], RectangleBox[{2.9, 0.}, {3., 0.005466970387243736},
               RoundingRadius->0], RectangleBox[{3., 0.}, {3.1, 0.0031890660592255125},
               RoundingRadius->0], RectangleBox[{3.1, 0.}, {3.2, 0.002733485193621868},
               RoundingRadius->0], RectangleBox[{3.2, 0.}, {3.3, 0.0009111617312072893},
               RoundingRadius->0], RectangleBox[{3.3, 0.}, {3.4, 0.0031890660592255125},
               RoundingRadius->0], RectangleBox[{3.4, 0.}, {3.5, 0.002733485193621868},
               RoundingRadius->0], RectangleBox[{3.5, 0.}, {3.6, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{3.6, 0.}, {3.7, 0.002277904328018223},
               RoundingRadius->0], RectangleBox[{3.7, 0.}, {3.8, 0.001366742596810934},
               RoundingRadius->0], RectangleBox[{3.9, 0.}, {4., 0.0009111617312072893},
               RoundingRadius->0], RectangleBox[{4., 0.}, {4.1, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.2, 0.}, {4.3, 0.0009111617312072893},
               RoundingRadius->0], RectangleBox[{4.3, 0.}, {4.4, 0.0009111617312072893},
               RoundingRadius->0], RectangleBox[{4.4, 0.}, {4.5, 0.001366742596810934},
               RoundingRadius->0], RectangleBox[{4.5, 0.}, {4.6, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.6, 0.}, {4.7, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.7, 0.}, {4.8, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.8, 0.}, {4.9, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.9, 0.}, {5., 0.0009111617312072893},
               RoundingRadius->0], RectangleBox[{5.7, 0.}, {5.8, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{6.9, 0.}, {7., 0.00045558086560364467},
               
               RoundingRadius->
                0]}, {}, {}}}, {{{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {}}, {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {}}}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "SwatchLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Thickness[Small], 
                    Opacity[0.20299999999999999`]]], 
                    GrayLevel[0.5]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Thickness[Small], 
                    Opacity[0.20299999999999999`]]], 
                    RGBColor[1, 0, 0]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"SwatchLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.33333333333333337`], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0.5`", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0.5], Editable -> False, Selectable -> False]}],
                     "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.20299999999999999`", "]"}]}], 
                    "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], ",", 
                    RowBox[{"{", "}"}]}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", "None", "}"}]}], "}"}]}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.6}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{-0.04200000000000001, 0.},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Probability\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Munc13-1 intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImageSize->500,
         PlotRange->{{0.1, 7.2}, {All, All}},
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {None, 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{
            Directive[
             EdgeForm[
              Directive[
               Thickness[Small], 
               Opacity[0.20299999999999999`]]], 
             RGBColor[
             0.987148, 0.8073604000000001, 0.49470040000000004`]], {{{{}, {
                Directive[
                 Opacity[0.5], 
                 Directive[
                  EdgeForm[
                   Directive[
                    Thickness[Small], 
                    Opacity[0.20299999999999999`]]], 
                  RGBColor[
                  0.987148, 0.8073604000000001, 0.49470040000000004`]], 
                 Directive[
                  GrayLevel[0.5]]], {{{
                   
                   Rectangle[{0.1, 0.}, {0.2, 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.2, 0.}, {0.3, 0.04397039616891598}, 
                    "RoundingRadius" -> 0]}}, {{
                   Rectangle[{0.3, 0.}, {0.4, 0.1023073574227253}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.4, 0.}, {0.5, 0.12451023073574227`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.5, 0.}, {0.6, 0.10491946016543317`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.6, 0.}, {0.7, 0.0892468437091859}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.7, 0.}, {0.8, 0.07139747496734872}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.8, 0.}, {0.9, 0.05267740531127558}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.9, 0.}, {1., 0.05093600348280366}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1., 0.}, {1.1, 0.0413582934262081}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.1, 0.}, {1.2, 0.0391815411406182}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.2, 0.}, {1.3, 0.030474531998258596`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.3, 0.}, {1.4, 0.026121027427078797`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.4, 0.}, {1.5, 0.024379625598606878`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.5, 0.}, {1.6, 0.028297779712668697`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.6, 0.}, {1.7, 0.026556377884196777`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.7, 0.}, {1.8, 0.02002612102742708}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.8, 0.}, {1.9, 0.01044841097083152}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.9, 0.}, {2., 0.0195907705703091}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2., 0.}, {2.1, 0.00827165868524162}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.1, 0.}, {2.2, 0.01044841097083152}, 
                    "RoundingRadius" -> 0]}}, {{
                   Rectangle[{2.2, 0.}, {2.3, 0.00914235959947758}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.3, 0.}, {2.4, 0.006965607313887679}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.4, 0.}, {2.5, 0.00522420548541576}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.5, 0.}, {2.6, 0.006530256856769699}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.6, 0.}, {2.7, 0.006530256856769699}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.7, 0.}, {2.8, 0.0056595559425337396`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.8, 0.}, {2.9, 0.0043535045711798}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.9, 0.}, {3., 0.0034828036569438396`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3., 0.}, {3.1, 0.00391815411406182}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.1, 0.}, {3.2, 0.0034828036569438396`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.2, 0.}, {3.3, 0.0030474531998258597`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.3, 0.}, {3.4, 0.0017414018284719198`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.4, 0.}, {3.5, 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.6, 0.}, {3.7, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.7, 0.}, {3.8, 0.0030474531998258597`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.8, 0.}, {3.9, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.9, 0.}, {4., 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4., 0.}, {4.1, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.1, 0.}, {4.2, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   Rectangle[{4.2, 0.}, {4.3, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.3, 0.}, {4.4, 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.4, 0.}, {4.5, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.5, 0.}, {4.6, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.6, 0.}, {4.7, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{5.1, 0.}, {5.2, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{5.4, 0.}, {5.5, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{6., 0.}, {6.1, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{6.6, 0.}, {6.7, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{7.1, 0.}, {7.2, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}}}, {}, {}}}, {{{}, {
                Directive[
                 Opacity[0.5], 
                 Directive[
                  EdgeForm[
                   Directive[
                    Thickness[Small], 
                    Opacity[0.20299999999999999`]]], 
                  RGBColor[
                  0.987148, 0.8073604000000001, 0.49470040000000004`]], 
                 Directive[
                  RGBColor[1, 0, 0]]], {{{
                   
                   Rectangle[{0.1, 0.}, {0.2, 0.005466970387243736}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.2, 0.}, {0.3, 0.04920273348519362}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.3, 0.}, {0.4, 0.12118451025056948`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.4, 0.}, {0.5, 0.1357630979498861}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.5, 0.}, {0.6, 0.1020501138952164}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.6, 0.}, {0.7, 0.08747152619589978}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.7, 0.}, {0.8, 0.0724373576309795}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.8, 0.}, {0.9, 0.04829157175398633}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.9, 0.}, {1., 0.04738041002277904}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1., 0.}, {1.1, 0.03644646924829157}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.1, 0.}, {1.2, 0.03553530751708428}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.2, 0.}, {1.3, 0.03325740318906606}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.3, 0.}, {1.4, 0.02733485193621868}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.4, 0.}, {1.5, 0.02733485193621868}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.5, 0.}, {1.6, 0.024145785876993165`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.6, 0.}, {1.7, 0.01685649202733485}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.7, 0.}, {1.8, 0.010933940774487472`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.8, 0.}, {1.9, 0.011389521640091117`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.9, 0.}, {2., 0.01776765375854214}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2., 0.}, {2.1, 0.010933940774487472`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.1, 0.}, {2.2, 0.00683371298405467}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.2, 0.}, {2.3, 0.006378132118451025}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.3, 0.}, {2.4, 0.010022779043280182`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.4, 0.}, {2.5, 0.005466970387243736}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.5, 0.}, {2.6, 0.005466970387243736}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.6, 0.}, {2.7, 0.004555808656036446}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.7, 0.}, {2.8, 0.004100227790432802}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.8, 0.}, {2.9, 0.005466970387243736}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.9, 0.}, {3., 0.005466970387243736}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3., 0.}, {3.1, 0.0031890660592255125`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.1, 0.}, {3.2, 0.002733485193621868}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.2, 0.}, {3.3, 0.0009111617312072893}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.3, 0.}, {3.4, 0.0031890660592255125`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.4, 0.}, {3.5, 0.002733485193621868}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.5, 0.}, {3.6, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.6, 0.}, {3.7, 0.002277904328018223}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.7, 0.}, {3.8, 0.001366742596810934}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.9, 0.}, {4., 0.0009111617312072893}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4., 0.}, {4.1, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.2, 0.}, {4.3, 0.0009111617312072893}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.3, 0.}, {4.4, 0.0009111617312072893}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.4, 0.}, {4.5, 0.001366742596810934}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.5, 0.}, {4.6, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.6, 0.}, {4.7, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.7, 0.}, {4.8, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.8, 0.}, {4.9, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.9, 0.}, {5., 0.0009111617312072893}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{5.7, 0.}, {5.8, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{6.9, 0.}, {7., 0.00045558086560364467`}, 
                    "RoundingRadius" -> 
                    0]}}}}, {}, {}}}}}, {{{{{}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {}}}, {{{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {}}}}}, {
          AspectRatio -> GoldenRatio^(-1), Axes -> {True, True}, 
           AxesLabel -> {None, None}, 
           AxesOrigin -> {-0.04200000000000001, 0.}, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Probability", 20, 
               GrayLevel[0]], None}, {
              Style["Munc13-1 intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 500, 
           PlotRange -> {{0.1, 7.2}, {All, All}}, PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {None, 
              Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], {
          Placed[
           SwatchLegend[{{
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[0.5]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               RGBColor[1, 0, 0]]}, {
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.20299999999999999`]]], 
               GrayLevel[1]]}}, {{
              Style["WT", 20], 
              Style["KO", 20]}, {}}, 
            LegendMarkers -> {{Automatic, Automatic}, {None}}, 
            LabelStyle -> {}, LegendLayout -> "Column"], {0.9, 0.6}, 
           Identity]}]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {192., -189.}, {Center, Center}, {360., 360.}], 
    InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{
           {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
            EdgeForm[{Opacity[0.175], Thickness[Small]}], {{}, 
             {GrayLevel[0.5], Opacity[0.5], EdgeForm[{Opacity[0.175], 
              Thickness[Small]}], RectangleBox[{-0.1, 0.}, {0., 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{0., 0.}, {0.1, 0.01567261645624728},
               RoundingRadius->0], RectangleBox[{0.1, 0.}, {0.2, 0.0500653025685677},
               RoundingRadius->0], RectangleBox[{0.2, 0.}, {0.3, 0.07444492816717457},
               RoundingRadius->0], RectangleBox[{0.3, 0.}, {0.4, 0.08663474096647801},
               RoundingRadius->0], RectangleBox[{0.4, 0.}, {0.5, 0.10361340879407924},
               RoundingRadius->0], RectangleBox[{0.5, 0.}, {0.6, 0.07879843273835438},
               RoundingRadius->0], RectangleBox[{0.6, 0.}, {0.7, 0.07052677405311275},
               RoundingRadius->0], RectangleBox[{0.7, 0.}, {0.8, 0.0696560731388768},
               RoundingRadius->0], RectangleBox[{0.8, 0.}, {0.9, 0.05180670439703962},
               RoundingRadius->0], RectangleBox[{0.9, 0.}, {1., 0.048759251197213756},
               RoundingRadius->0], RectangleBox[{1., 0.}, {1.1, 0.03656943839791032},
               RoundingRadius->0], RectangleBox[{1.1, 0.}, {1.2, 0.027427078798432737},
               RoundingRadius->0], RectangleBox[{1.2, 0.}, {1.3, 0.028297779712668697},
               RoundingRadius->0], RectangleBox[{1.3, 0.}, {1.4, 0.026121027427078797},
               RoundingRadius->0], RectangleBox[{1.4, 0.}, {1.5, 0.025250326512842838},
               RoundingRadius->0], RectangleBox[{1.5, 0.}, {1.6, 0.026556377884196777},
               RoundingRadius->0], RectangleBox[{1.6, 0.}, {1.7, 0.02133217239878102},
               RoundingRadius->0], RectangleBox[{1.7, 0.}, {1.8, 0.01654331737048324},
               RoundingRadius->0], RectangleBox[{1.8, 0.}, {1.9, 0.014801915542011318},
               RoundingRadius->0], RectangleBox[{1.9, 0.}, {2., 0.01044841097083152},
               RoundingRadius->0], RectangleBox[{2., 0.}, {2.1, 0.011754462342185459},
               RoundingRadius->0], RectangleBox[{2.1, 0.}, {2.2, 0.00783630822812364},
               RoundingRadius->0], RectangleBox[{2.2, 0.}, {2.3, 0.013495864170657379},
               RoundingRadius->0], RectangleBox[{2.3, 0.}, {2.4, 0.012625163256421419},
               RoundingRadius->0], RectangleBox[{2.4, 0.}, {2.5, 0.00522420548541576},
               RoundingRadius->0], RectangleBox[{2.5, 0.}, {2.6, 0.00783630822812364},
               RoundingRadius->0], RectangleBox[{2.6, 0.}, {2.7, 0.0056595559425337396},
               RoundingRadius->0], RectangleBox[{2.7, 0.}, {2.8, 0.00783630822812364},
               RoundingRadius->0], RectangleBox[{2.8, 0.}, {2.9, 0.00522420548541576},
               RoundingRadius->0], RectangleBox[{2.9, 0.}, {3., 0.00391815411406182},
               RoundingRadius->0], RectangleBox[{3., 0.}, {3.1, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{3.1, 0.}, {3.2, 0.0021767522855899},
               RoundingRadius->0], RectangleBox[{3.2, 0.}, {3.3, 0.00391815411406182},
               RoundingRadius->0], RectangleBox[{3.3, 0.}, {3.4, 0.00478885502829778},
               RoundingRadius->0], RectangleBox[{3.4, 0.}, {3.5, 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{3.5, 0.}, {3.6, 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{3.6, 0.}, {3.7, 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{3.8, 0.}, {3.9, 0.0021767522855899},
               RoundingRadius->0], RectangleBox[{3.9, 0.}, {4., 0.0017414018284719198},
               RoundingRadius->0], RectangleBox[{4., 0.}, {4.1, 0.0017414018284719198},
               RoundingRadius->0], RectangleBox[{4.1, 0.}, {4.2, 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{4.2, 0.}, {4.3, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{4.3, 0.}, {4.4, 0.0021767522855899},
               RoundingRadius->0], RectangleBox[{4.4, 0.}, {4.5, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{4.5, 0.}, {4.6, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{4.6, 0.}, {4.7, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{4.8, 0.}, {4.9, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{4.9, 0.}, {5., 0.00130605137135394},
               RoundingRadius->0], RectangleBox[{5., 0.}, {5.1, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{5.2, 0.}, {5.3, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{5.3, 0.}, {5.4, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{6., 0.}, {6.1, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{6.2, 0.}, {6.3, 0.00043535045711797995},
               RoundingRadius->0], RectangleBox[{7.1, 0.}, {7.2, 0.0008707009142359599},
               RoundingRadius->0], RectangleBox[{7.3, 0.}, {7.4, 0.00043535045711797995},
               RoundingRadius->0]}, {}, {}}, {{}, 
             {RGBColor[1, 0, 0], Opacity[0.5], EdgeForm[{Opacity[0.175], 
              Thickness[Small]}], RectangleBox[{-0.1, 0.}, {0., 0.002733485193621868},
               RoundingRadius->0], RectangleBox[{0., 0.}, {0.1, 0.04009111617312073},
               RoundingRadius->0], RectangleBox[{0.1, 0.}, {0.2, 0.08656036446469248},
               RoundingRadius->0], RectangleBox[{0.2, 0.}, {0.3, 0.12118451025056948},
               RoundingRadius->0], RectangleBox[{0.3, 0.}, {0.4, 0.11480637813211846},
               RoundingRadius->0], RectangleBox[{0.4, 0.}, {0.5, 0.09157175398633258},
               RoundingRadius->0], RectangleBox[{0.5, 0.}, {0.6, 0.08018223234624146},
               RoundingRadius->0], RectangleBox[{0.6, 0.}, {0.7, 0.06241457858769932},
               RoundingRadius->0], RectangleBox[{0.7, 0.}, {0.8, 0.05603644646924829},
               RoundingRadius->0], RectangleBox[{0.8, 0.}, {0.9, 0.04054669703872437},
               RoundingRadius->0], RectangleBox[{0.9, 0.}, {1., 0.04236902050113895},
               RoundingRadius->0], RectangleBox[{1., 0.}, {1.1, 0.03644646924829157},
               RoundingRadius->0], RectangleBox[{1.1, 0.}, {1.2, 0.02915717539863326},
               RoundingRadius->0], RectangleBox[{1.2, 0.}, {1.3, 0.02915717539863326},
               RoundingRadius->0], RectangleBox[{1.3, 0.}, {1.4, 0.017312072892938495},
               RoundingRadius->0], RectangleBox[{1.4, 0.}, {1.5, 0.019134396355353075},
               RoundingRadius->0], RectangleBox[{1.5, 0.}, {1.6, 0.01958997722095672},
               RoundingRadius->0], RectangleBox[{1.6, 0.}, {1.7, 0.013211845102505695},
               RoundingRadius->0], RectangleBox[{1.7, 0.}, {1.8, 0.01366742596810934},
               RoundingRadius->0], RectangleBox[{1.8, 0.}, {1.9, 0.010022779043280182},
               RoundingRadius->0], RectangleBox[{1.9, 0.}, {2., 0.007289293849658315},
               RoundingRadius->0], RectangleBox[{2., 0.}, {2.1, 0.009567198177676537},
               RoundingRadius->0], RectangleBox[{2.1, 0.}, {2.2, 0.008200455580865604},
               RoundingRadius->0], RectangleBox[{2.2, 0.}, {2.3, 0.006378132118451025},
               RoundingRadius->0], RectangleBox[{2.3, 0.}, {2.4, 0.007289293849658315},
               RoundingRadius->0], RectangleBox[{2.4, 0.}, {2.5, 0.0036446469248291574},
               RoundingRadius->0], RectangleBox[{2.5, 0.}, {2.6, 0.005011389521640091},
               RoundingRadius->0], RectangleBox[{2.6, 0.}, {2.7, 0.0031890660592255125},
               RoundingRadius->0], RectangleBox[{2.7, 0.}, {2.8, 0.002733485193621868},
               RoundingRadius->0], RectangleBox[{2.8, 0.}, {2.9, 0.002277904328018223},
               RoundingRadius->0], RectangleBox[{2.9, 0.}, {3., 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{3., 0.}, {3.1, 0.0018223234624145787},
               RoundingRadius->0], RectangleBox[{3.1, 0.}, {3.2, 0.001366742596810934},
               RoundingRadius->0], RectangleBox[{3.2, 0.}, {3.3, 0.002733485193621868},
               RoundingRadius->0], RectangleBox[{3.3, 0.}, {3.4, 0.0009111617312072893},
               RoundingRadius->0], RectangleBox[{3.4, 0.}, {3.5, 0.0009111617312072893},
               RoundingRadius->0], RectangleBox[{3.5, 0.}, {3.6, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{3.6, 0.}, {3.7, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{3.7, 0.}, {3.8, 0.001366742596810934},
               RoundingRadius->0], RectangleBox[{3.8, 0.}, {3.9, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{3.9, 0.}, {4., 0.0009111617312072893},
               RoundingRadius->0], RectangleBox[{4., 0.}, {4.1, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.1, 0.}, {4.2, 0.001366742596810934},
               RoundingRadius->0], RectangleBox[{4.2, 0.}, {4.3, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.3, 0.}, {4.4, 0.001366742596810934},
               RoundingRadius->0], RectangleBox[{4.4, 0.}, {4.5, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.5, 0.}, {4.6, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{4.7, 0.}, {4.8, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{5., 0.}, {5.1, 0.00045558086560364467},
               RoundingRadius->0], RectangleBox[{5.4, 0.}, {5.5, 0.0009111617312072893},
               
               RoundingRadius->
                0]}, {}, {}}}, {{{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}, {}}, {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}}, {}}}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "SwatchLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Thickness[Small], 
                    Opacity[0.175]]], 
                    GrayLevel[0.5]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Thickness[Small], 
                    Opacity[0.175]]], 
                    RGBColor[1, 0, 0]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"SwatchLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.33333333333333337`], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0.5`", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0.5], Editable -> False, Selectable -> False]}],
                     "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.175`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "1", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], ",", 
                    RowBox[{"{", "}"}]}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", "None", "}"}]}], "}"}]}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.6}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{-0.25, 0.},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Probability\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Cav2.1 intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImageSize->500,
         PlotRange->{{-0.1, 7.4}, {All, All}},
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {None, 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{
            Directive[
             EdgeForm[
              Directive[
               Thickness[Small], 
               Opacity[0.175]]], 
             RGBColor[
             0.987148, 0.8073604000000001, 0.49470040000000004`]], {{{{}, {
                Directive[
                 Opacity[0.5], 
                 Directive[
                  EdgeForm[
                   Directive[
                    Thickness[Small], 
                    Opacity[0.175]]], 
                  RGBColor[
                  0.987148, 0.8073604000000001, 0.49470040000000004`]], 
                 Directive[
                  GrayLevel[0.5]]], {{{
                   
                   Rectangle[{-0.1, 0.}, {0., 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0., 0.}, {0.1, 0.01567261645624728}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.1, 0.}, {0.2, 0.0500653025685677}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.2, 0.}, {0.3, 0.07444492816717457}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.3, 0.}, {0.4, 0.08663474096647801}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.4, 0.}, {0.5, 0.10361340879407924`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.5, 0.}, {0.6, 0.07879843273835438}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.6, 0.}, {0.7, 0.07052677405311275}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.7, 0.}, {0.8, 0.0696560731388768}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.8, 0.}, {0.9, 0.05180670439703962}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.9, 0.}, {1., 0.048759251197213756`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1., 0.}, {1.1, 0.03656943839791032}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.1, 0.}, {1.2, 0.027427078798432737`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.2, 0.}, {1.3, 0.028297779712668697`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.3, 0.}, {1.4, 0.026121027427078797`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.4, 0.}, {1.5, 0.025250326512842838`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.5, 0.}, {1.6, 0.026556377884196777`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.6, 0.}, {1.7, 0.02133217239878102}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.7, 0.}, {1.8, 0.01654331737048324}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.8, 0.}, {1.9, 0.014801915542011318`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.9, 0.}, {2., 0.01044841097083152}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2., 0.}, {2.1, 0.011754462342185459`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.1, 0.}, {2.2, 0.00783630822812364}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.2, 0.}, {2.3, 0.013495864170657379`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.3, 0.}, {2.4, 0.012625163256421419`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.4, 0.}, {2.5, 0.00522420548541576}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.5, 0.}, {2.6, 0.00783630822812364}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.6, 0.}, {2.7, 0.0056595559425337396`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.7, 0.}, {2.8, 0.00783630822812364}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.8, 0.}, {2.9, 0.00522420548541576}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.9, 0.}, {3., 0.00391815411406182}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3., 0.}, {3.1, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.1, 0.}, {3.2, 0.0021767522855899}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.2, 0.}, {3.3, 0.00391815411406182}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.3, 0.}, {3.4, 0.00478885502829778}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.4, 0.}, {3.5, 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.5, 0.}, {3.6, 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.6, 0.}, {3.7, 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.8, 0.}, {3.9, 0.0021767522855899}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.9, 0.}, {4., 0.0017414018284719198`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4., 0.}, {4.1, 0.0017414018284719198`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.1, 0.}, {4.2, 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.2, 0.}, {4.3, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.3, 0.}, {4.4, 0.0021767522855899}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.4, 0.}, {4.5, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.5, 0.}, {4.6, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.6, 0.}, {4.7, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.8, 0.}, {4.9, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.9, 0.}, {5., 0.00130605137135394}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{5., 0.}, {5.1, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{5.2, 0.}, {5.3, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{5.3, 0.}, {5.4, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{6., 0.}, {6.1, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{6.2, 0.}, {6.3, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{7.1, 0.}, {7.2, 0.0008707009142359599}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{7.3, 0.}, {7.4, 0.00043535045711797995`}, 
                    "RoundingRadius" -> 0]}}}}, {}, {}}}, {{{}, {
                Directive[
                 Opacity[0.5], 
                 Directive[
                  EdgeForm[
                   Directive[
                    Thickness[Small], 
                    Opacity[0.175]]], 
                  RGBColor[
                  0.987148, 0.8073604000000001, 0.49470040000000004`]], 
                 Directive[
                  RGBColor[1, 0, 0]]], {{{
                   
                   Rectangle[{-0.1, 0.}, {0., 0.002733485193621868}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0., 0.}, {0.1, 0.04009111617312073}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.1, 0.}, {0.2, 0.08656036446469248}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.2, 0.}, {0.3, 0.12118451025056948`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.3, 0.}, {0.4, 0.11480637813211846`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.4, 0.}, {0.5, 0.09157175398633258}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.5, 0.}, {0.6, 0.08018223234624146}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.6, 0.}, {0.7, 0.06241457858769932}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.7, 0.}, {0.8, 0.05603644646924829}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.8, 0.}, {0.9, 0.04054669703872437}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{0.9, 0.}, {1., 0.04236902050113895}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1., 0.}, {1.1, 0.03644646924829157}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.1, 0.}, {1.2, 0.02915717539863326}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.2, 0.}, {1.3, 0.02915717539863326}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.3, 0.}, {1.4, 0.017312072892938495`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.4, 0.}, {1.5, 0.019134396355353075`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.5, 0.}, {1.6, 0.01958997722095672}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.6, 0.}, {1.7, 0.013211845102505695`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.7, 0.}, {1.8, 0.01366742596810934}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.8, 0.}, {1.9, 0.010022779043280182`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{1.9, 0.}, {2., 0.007289293849658315}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2., 0.}, {2.1, 0.009567198177676537}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.1, 0.}, {2.2, 0.008200455580865604}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.2, 0.}, {2.3, 0.006378132118451025}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.3, 0.}, {2.4, 0.007289293849658315}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.4, 0.}, {2.5, 0.0036446469248291574`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.5, 0.}, {2.6, 0.005011389521640091}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.6, 0.}, {2.7, 0.0031890660592255125`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.7, 0.}, {2.8, 0.002733485193621868}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.8, 0.}, {2.9, 0.002277904328018223}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{2.9, 0.}, {3., 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3., 0.}, {3.1, 0.0018223234624145787`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.1, 0.}, {3.2, 0.001366742596810934}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.2, 0.}, {3.3, 0.002733485193621868}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.3, 0.}, {3.4, 0.0009111617312072893}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.4, 0.}, {3.5, 0.0009111617312072893}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.5, 0.}, {3.6, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.6, 0.}, {3.7, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.7, 0.}, {3.8, 0.001366742596810934}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.8, 0.}, {3.9, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{3.9, 0.}, {4., 0.0009111617312072893}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4., 0.}, {4.1, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.1, 0.}, {4.2, 0.001366742596810934}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.2, 0.}, {4.3, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.3, 0.}, {4.4, 0.001366742596810934}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.4, 0.}, {4.5, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   Rectangle[{4.5, 0.}, {4.6, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{4.7, 0.}, {4.8, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{5., 0.}, {5.1, 0.00045558086560364467`}, 
                    "RoundingRadius" -> 0]}}, {{
                   
                   Rectangle[{5.4, 0.}, {5.5, 0.0009111617312072893}, 
                    "RoundingRadius" -> 
                    0]}}}}, {}, {}}}}}, {{{{{}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {}}}, {{{{}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}, {}}}}}, {
          AspectRatio -> GoldenRatio^(-1), Axes -> {True, True}, 
           AxesLabel -> {None, None}, AxesOrigin -> {-0.25, 0.}, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Probability", 20, 
               GrayLevel[0]], None}, {
              Style["Cav2.1 intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 500, 
           PlotRange -> {{-0.1, 7.4}, {All, All}}, PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {None, 
              Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], {
          Placed[
           SwatchLegend[{{
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[0.5]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               RGBColor[1, 0, 0]]}, {
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]], 
              Directive[
               Opacity[0.5], 
               EdgeForm[
                Directive[
                 Thickness[Small], 
                 Opacity[0.175]]], 
               GrayLevel[1]]}}, {{
              Style["WT", 20], 
              Style["KO", 20]}, {}}, 
            LegendMarkers -> {{Automatic, Automatic}, {None}}, 
            LabelStyle -> {}, LegendLayout -> "Column"], {0.9, 0.6}, 
           Identity]}]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {576., -189.}, {Center, Center}, {360., 360.}]}, {}},
  AspectRatio->0.6,
  ContentSelectable->True,
  ImageSize->1000,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.8508742146951265`*^9, 3.8508743038884163`*^9, 3.8508911808651085`*^9, 
   3.850891264590987*^9, 3.8509830931059465`*^9, 3.852255306774928*^9, 
   3.8522554865767984`*^9, 3.852255724728649*^9, 3.8522557675898933`*^9, 
   3.855045268472585*^9, {3.855045364108375*^9, 3.855045388586759*^9}, 
   3.855045920499544*^9, 3.8550460743314505`*^9, 3.8550462124263415`*^9, 
   3.8550463199491296`*^9, {3.8550463849728317`*^9, 3.855046414162945*^9}, 
   3.855281676100159*^9, 3.855287539289589*^9, 3.855287947160612*^9, 
   3.8552890319197254`*^9, 3.8553512953155193`*^9, 3.8580524987927876`*^9},
 CellLabel->
  "Out[328]=",ExpressionUUID->"98cda46c-1b32-4abf-824a-371a3e03d354"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT6SEaphClECPgRDGnDf
GVQ/yux6pkvN4D4zn5icsxlkP3UpZgQnzfA+S83Xsp0ZdD/Lx1uzFM0AP1dk
972SGYQ/95bWigvNED/dL4dDjRmUP4z+k/YGzSA/oBVPhooZpD9XsnKsBM0w
P4EIsyeJGbQ/PAxihwPNQD8qR5GIsnC0P4CuOK3eFUE/0oVv6dvHtD/DUA/T
uV5BPyQDLKsudrU/S5W8HnDwQT/G/aQu1NK2P1keF7bcE0M/DPOWNR+MuT93
MMzktVpFP5jdekO1/r4/slQ2QmjoST9BHFmk3lW/P/b2DGhDMUo/6lo3BQit
vz86meONHnpKPx7seWOtLcA/wt2Q2dQLSz9vaTYlANzAP9Bm63BBL0w/EmSv
qKU4wj/ueKCfGnZOP1hZoa/w8cQ/lE6FfuaBUT/v21QKohrFP+bwABTqo1E/
hl4IZVNDxT83k3yp7cVRP7Njbxq2lMU/2ddz1PQJUj8Obj2FezfGPx5hYioD
klI/pfDw3yxgxj9wA96/BrRSPzxzpDreiMY/waVZVQrWUj9qeAvwQNrGP2Tq
UIARGlM/xYLZWgZ9xz+pcz/WH6JTP1wFjbW3pcc/+hW7ayPEUz/yh0AQac7H
P0u4NgEn5lM/II2nxcsfyD/t/C0sLipUP7cPWyB9SMg/P5+pwTFMVD9Okg57
LnHIP5BBJVc1blQ/fJd1MJHCyD8zhhyCPLJUPxMaKYtC68g/hCiYF0DUVD+q
nNzl8xPJP9bKE61D9lQ/QB+QQKU8yT8mbY9CRxhVP9ehQ5tWZck/eA8L2Eo6
VT+QO0vYzW/JP6iZvFgKQ1U/FscaiA==
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAApPfnWmXDyT+eBUaOaFdiPzKsEQYc
CMo/LnhjEtDnbj/JLsVgzTDKP/98t2JMLHM/YLF4u35Zyj/mPT28sOR2P422
33Dhqso/nr9Ib3lVfj/owK3bpk3LP5Lhr2qFm4Y/ntVJsTGTzD+McmNoi76S
Pwv/gVxHHs8/DTs9Zw7QoD+YaVdeLEbPP6YmQR7FRKE/JNQsYBFuzz89EkXV
e7mhPz6p12Pbvc8/cOlMQ+mioj+5qZa1ty7QP9eXXB/EdaQ/7VPsvEvO0D+j
9HvXeRuoP1Wol8tzDdI/Pa66R+Vmrz8lUe7ow4vUP7cQHBTe/rY/Gn9HOmeh
1D+Zt2GoKz63PxCtoIsKt9Q/fl6nPHl9tz/6CFMuUeLUP0GsMmUU/Lc/0MC3
c9441T/OR0m2Svm4P3owgf745dU/4X52WLfzuj/ODxQULkDXPwjt0JyQ6L4/
wz1tZdFV1z/qkxYx3ie/P7hrxrZ0a9c/zDpcxStnvz+jx3hZu5bXP5KI5+3G
5b8/eH/dnkjt1z8OEn+ffnHAPyLvpiljmtg/mK2V8LRuwT8XHQB7BrDYPwmB
uLpbjsE/DEtZzKnF2D96VNuEAq7BP/emC2/w8Ng/XfsgGVDtwT/s1GTAkwbZ
P87OQ+P2DMI/4gK+ETcc2T9AomatnSzCP8xecLR9R9k/IkmsQetrwj/CjMkF
IV3ZP5QczwuSi8I/t7oiV8Ry2T8F8PHVOKvCP5Vq8rizhNk/1qmbAXXFwj+w
9hzX
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAn8hAen+u2T+tu/7k+BPDP4xyh5xR
ydk/glwi2IFRwz93zjk/mPTZP9Z2BobLtMM/Di615ckI2j8WPn08IOPDP6SN
MIz7HNo/VAX08nQRxD/RTCfZXkXaP9KT4V8ebsQ/K8sUcyWW2j/OsLw5cSfF
P9/H76ayN9s/xupy7Raaxj9HwaUOzXrcP7Ze31Rif8k/F7QR3gEB3z+WRrgj
+UnPP1yM+1TkFt8/FXlF2y58zz+iZOXLxizfP5ir0pJkrs8/LBW5uYtY3z9M
iPYAaAnQP0J2YJUVsN8/Te0QcNNt0D82nFemlC/gP0+3RU6qNtE/YV6mXaje
4D9US68KWMjSP4RKG5mZ6eA/leR15nLh0j+mNpDUivTgP9R9PMKN+tI/7A56
S20K4T9WsMl5wyzTP3a/TTkyNuE/VRXk6C6R0z+MIPUUvI3hP1nfGMcFWtQ/
tuJDzM884j9cc4KDs+vVP9ZIgfGNR+I/Lgf5KVkE1j/2rr4WTFLiPwCbb9D+
HNY/N3s5Ychn4j+mwlwdSk7WP7gTL/bAkuI/8BE3t+Cw1j/YeWwbf53iP8Kl
rV2GydY/+N+pQD2o4j+UOSQELOLWPzisJIu5veI/OGERUXcT1z+5RBogsuji
P4Kw6+oNdtc/2qpXRXDz4j9WRGKRs47XP/oQlWou/uI/KNjYN1mn1z863Q+1
qhPjP8z/xYSk2Nc/WkNN2mge4z+ekzwrSvHXP7Cb30LAKOM/CnooHAQJ2D8J
8x2c
                "]], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAtsqGI6Y94z/7atZZxjHYP9rbQm9h
SeM/P+Sd+Z5E2D/6QYCUH1TjP52lce3gVdg/Ow773ptp4z9cKBnVZHjYP7ym
8HOUlOM/2C1opGy92D/cDC6ZUp/jPzbvO5iuztg//HJrvhCq4z+VsA+M8N/Y
Pz0/5giNv+M/UzO3c3QC2T++19udherjP884BkN8R9k/vwjHx3ZA5D/FQ6Th
i9HZP8JqnRtZ7OQ/slngHqvl2j/1Jj0PrW3nP9lxpuLs694/PuJCx4p45z/+
HwKPYf3eP4adSH9og+c/Ic5dO9YO3z8WFFTvI5nnP2gqFZS/Md8/NgFrz5rE
5z/24oNFknffP3jbmI+IG+g/Cqow1JsB4D/8j/QPZMnoPykbDjdBjeA/REv6
x0HU6D868juN+5XgP4wGAIAf3+g/TMlp47We4D8dfQvw2vToP3B3xY8qsOA/
Pmoi0FEg6T+403zoE9PgP4YlKIgvK+k/yqqqPs7b4D/O4C1ADTbpP9uB2JSI
5OA/Xlc5sMhL6T//LzRB/fXgP39EUJA/d+k/RozrmeYY4T/I/1VIHYLpP1lj
GfCgIeE/ELtbAPuM6T9qOkdGWyrhPxcCRqkmj+k/OLOtlxks4T8oJvEr
                "]], 
               LineBox[{{0.8012755102040817, 0.5383186143416879}, {
                0.8024388112602567, 0.5389212822811081}, {0.8037652381656297, 
                0.5396084603470176}, {0.8064180919763757, 
                0.5409828164788363}, {0.8077445188817487, 
                0.5416699945447457}, {0.8090709457871217, 
                0.5423571726106551}, {0.8117237995978678, 
                0.5437315287424739}, {0.8170295072193599, 
                0.5464802410061115}, {0.8182677985372807, 
                0.547121758928761}, {0.8195060898552016, 
                0.5477632768514105}, {0.8219826724910432, 
                0.5490463126967093}, {0.8269358377627265, 
                0.5516123843873071}, {0.8368421683060933, 
                0.5567445277685028}, {0.8566548293928267, 
                0.567008814530894}, {0.8962801515662935, 
                0.5875373880556767}, {0.9739717509693491, 
                0.6277868452997498}, {0.9987244897959183, 
                0.6406104235338018}}], 
               LineBox[{{1.0012755102040816`, 0.6417848702389096}, {
                1.1369227129030104`, 0.696409886563032}, {1.1382548904425511`,
                 0.6969463533562733}, {1.1395870679820916`, 
                0.6974828201495145}, {1.142251423061173, 0.698555753735997}, {
                1.147580133219336, 0.700701620908962}, {1.158237553535662, 
                0.7049933552548922}, {1.1795523941683133`, 
                0.7135768239467521}, {1.180884571707854, 
                0.7141132907399934}, {1.1822167492473947`, 
                0.7146497575332347}, {1.1848811043264762`, 
                0.7157226911197172}, {1.190209814484639, 
                0.7178685582926821}, {1.1915419920241797`, 
                0.7184050250859234}, {1.1928741695637202`, 
                0.7189414918791646}, {1.1955385246428016`, 
                0.7200144254656471}, {1.1968707021823424`, 
                0.7205508922588884}, {1.198202879721883, 
                0.7210873590521296}, {1.1987244897959184`, 
                0.7212974109974857}}], 
               LineBox[{{1.2012755102040815`, 0.7221719989693745}, {
                1.2021994123405053`, 0.7224334427607003}, {1.203531589880046, 
                0.7228104194262212}, {1.2061959449591275`, 
                0.7235643727572629}, {1.2115246551172902`, 
                0.7250722794193464}, {1.222182075433616, 
                0.7280880927435135}, {1.2234898928959086`, 
                0.7284581760480369}, {1.224797710358201, 
                0.7288282593525602}, {1.2274133452827862`, 
                0.729568425961607}, {1.2326446151319568`, 
                0.7310487591797005}, {1.2431071548302977`, 
                0.7340094256158874}, {1.2640322342269796`, 
                0.7399307584882616}, {1.3058823930203434`, 
                0.7517734242330097}, {1.3839420330101317`, 
                0.7738625692018223}, {1.3987244897959183`, 
                0.7780456762591846}}], 
               LineBox[{{1.4012755102040815`, 0.7787425701669435}, {
                1.547629076117258, 0.8172902007187379}, {1.5987244897959185`, 
                0.8307480697982284}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T9aFQKMrJrqP/tq1Jsp
evs/NdKBLRl46z9UNl2RLn/7P5ida75veus/rAHmhjOE+z/7aFVPxnzrP16Y
93E9jvs/wv8ocXOB6z/BxRpIUaL7P04t0LTNius/hyBh9HjK+z9oiB48gp3r
PxPW7UzIGvw/mz67SuvC6z9soXZCzR/8P/4JpdtBxes/xGz/N9Ik/D9h1Y5s
mMfrP3YDESPcLvw/KGxijkXM6z/ZMDT570L8P7SZCdKf1es/n4t6pRdr/D/O
9FdZVOjrP/hWA5sccPw/McBB6qrq6z9QIoyQIXX8P5SLK3sB7es/Armdeyt/
/D9aIv+crvHrP2XmwFE/k/w/50+m4Aj76z++sUlHRJj8P0obkHFf/es/Fn3S
PEmd/D+t5nkCtv/rP8gT5CdTp/w/dH1NJGME7D8rQQf+Zrv8PwGr9Ge9Dew/
sKqrJ9jA/D+JfUVgRhDsPzQUUFFJxvw/EVCWWM8S7D8MAaNUk8f8P+nVBxNp
E+w/4izGQw==
                "]], LineBox[CompressedData["
1:eJwVkH0s1HEAh+9ysRRC0hoL44rKrrAI+1iJ6RTX8rLIu5zF1LGVssyqVSY3
0XY5u1r9k7e8TIpVLunaWq5285JzToiR7w+n0Pj5fdMfz56/nn8e17S8M5mb
eDyecIP/Llcsh5rrWETMPh/JdiRQRwdrawZYKFv0TZ93EZzoHFuxMrAoMBZ5
5+4mOH3fS7wwxULo/35/qzOBbllbkEpY0Iz0urN7COJS8lU6E4vvFZs9V1wI
UnzemNpYFqWzEcIgdwLZ0ClFod065lQ6F40XQcflqsNl2eu4kbNkORdKEP7U
NavFkYPKInA0uJDAV2Et1DhxcGpere65RuBSvvZT78pBGd8ZKy4iWC3sTxMc
4KCoDdDGFxM0Su4lxYVwqBT7v82/TWDPN8WsSznclfspaysIRpPVoRGdHGSO
ojiHOoIvMY1mSV0cFrrm7WrqCV6Lq7tlPRzypE1at0aCB0cKQmq0HHI6vMNE
zRs/bPYFzY9zyEo46CduJ6h/J/d5uJUi8bGXfUk3wRXnZLexRIqwvR5fiZ4g
LVoUa0ilcE99ZLxo2Ph3k186eIHCTGk192uEQDjzzNR7iUJtvbxt5gdBX9u0
uvMWReCy5uTkFIEoUpZc1UAh+ijVjCwSOBUfr5S3UNhQQ3/iHwKL1h2fStsp
GH/J5PASgdHxlXeJmqK+IUCg/0tQNrG2nttH4VFleWyAI7i6s/dQ9hCFQHtD
EsNjkB6hyswwUkxY/E7p4zM42hTSe26a4sn14WKdgIFw3JYfy1AUv4ySS8wZ
2DpM+EoWKc7Pf1B9s2DAhrdJI1cogjz9X0RtYQDfgTua1Y2+ZXB7giWDf7+e
ROs=
                "]], 
               LineBox[{{2.001275510204082, 0.9078250912903253}, {
                2.0039562426140143`, 0.9080760087775415}, {2.008820753763886, 
                0.9085313287153831}, {2.0185497760636295`, 
                0.9094419685910666}, {2.0380078206631165`, 
                0.9112632483424334}, {2.0393271393937447`, 
                0.9113867370351131}, {2.0406464581243724`, 
                0.9115102257277926}, {2.0432850955856283`, 
                0.9117572031131518}, {2.0485623705081406`, 
                0.9122511578838702}, {2.0591169203531647`, 
                0.9132390674253069}, {2.080226020043213, 
                0.9152148865081804}, {2.122444219423309, 
                0.9191665246739273}, {2.1987244897959184`, 
                0.926306384547724}}], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAe3+uVTacAUC4b+4ZH6btP2s0u9kJ
SwJA3C43gnHe7T/A0NWsuE0CQK4bj8ZO3+0/FW3wf2dQAkB/COcKLODtP7+l
JSbFVQJAI+KWk+bh7T8TF5BygGACQGqV9qRb5e0/u/lkC/d1AkD3+7XHRezt
Pwu/Dj3koAJAE8k0DRr67T9gWykQk6MCQOW1jFH3+u0/tfdD40GmAkC2ouSV
1PvtP18weYmfqwJAWnyUHo/97T+zoePVWrYCQKEv9C8EAe4/W4S4btHLAkAu
lrNS7gfuP6tJYqC+9gJASmMymMIV7j80LCE+P/kCQGUfmvmQFu4/vg7g27/7
AkCB2wFbXxfuP9DTXRfBAANAuVPRHfwY7j/0XVmOwwoDQCdEcKM1HO4/PnJQ
fMgeA0AFJa6uqCLuP1JNHneWMANAWmP8E2Uo7j8j+5YQ
                "]], 
               LineBox[{{2.4012755102040817`, 0.9426087043437312}, {
                2.412024645029292, 0.9432404558463012}, {2.414468401872563, 
                0.9433840810852396}, {2.419355915559106, 
                0.9436713315631166}, {2.429130942932191, 
                0.9442458325188704}, {2.4486809976783612`, 
                0.945394834430378}, {2.5334854370252864`, 
                0.950378987374146}, {2.5987244897959183`, 
                0.9542132373193071}}], LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAArrLhiGnPBEAjokhyKoruPyHdStij
hQVA8h8Nnpe27j+KwjuvVYgFQM0+Nsw/t+4/8qcshgeLBUCnXV/657fuP8Jy
DjRrkAVAW5uxVji57j9kCNKPMpsFQMUWVg/Zu+4/qDNZR8GwBUCXDZ+AGsHu
Py6KZ7be2wVAO/swY53L7j+Wb1iNkN4FQBUaWpFFzO4//1RJZELhBUDvOIO/
7czuP9AfKxKm5gVApHbVGz7O7j9xte5tbfEFQA3yedTe0O4/tOB1JfwGBkDf
6MJFINbuPzo3hJQZMgZAg9ZUKKPg7j/WYhk2nTQGQC3siRJA4e4/c46u1yA3
BkDYAb/83OHuP6zl2BooPAZALS0p0Rbj7j8elC2hNkYGQNeD/XmK5e4/ur/C
QrpIBkCBmTJkJ+buP1frV+Q9SwZALK9nTsTm7j+QQoInRVAGQIDa0SL+5+4/
AvHWrVNaBkAqMabLceruP54cbE/XXAZA1UbbtQ7r7j87SAHxWl8GQH9cEKCr
6+4/2HOWkt5hBkAqckWKSOzuP4WAUarJYwZAgVpFRMDs7j/XLcd6
                "]], 
               LineBox[{{2.8012755102040816`, 0.9665279912574518}, {
                2.8039259500890124`, 0.966631839576844}, {2.8051535791448154`,
                 0.9666799399751993}, {2.806381208200619, 
                0.9667280403735548}, {2.8088364663122256`, 
                0.9668242411702654}, {2.8137469825354393`, 
                0.967016642763687}, {2.814974611591243, 0.9670647431620424}, {
                2.816202240647046, 0.9671128435603977}, {2.818657498758653, 
                0.9672090443571085}, {2.8235680149818663`, 
                0.96740144595053}, {2.833389047428293, 0.967786249137373}, {
                2.853031112321146, 0.968555855511059}, {2.9382035922548035`, 
                0.9718930445376281}, {2.998724489795918, 
                0.9742643465745024}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAA4eUUvJwCCEDHrXo3+C3vPxPetaIC
xAhAXutjoZhK7z+ODH19t8YIQDS/qS//Su8/CjtEWGzJCEAKk++9ZUvvPwKY
0g3WzghAtzp72jJM7z/yUe94qdkIQA+KkhPNTe8/0MUoT1DvCEDAKMGFAVHv
P4ytm/udGglAImYeampX7z8I3GLWUh0JQPk5ZPjQV+8/hAoqsQcgCUDPDaqG
N1jvP3tnuGZxJQlAe7U1owRZ7z9qIdXRRDAJQNQETdyeWu8/SJUOqOtFCUCF
o3tO013vPwV9gVQ5cQlA5+DYMjxk7z+08ez5v3MJQE74JeqbZO8/ZGZYn0Z2
CUC0D3Oh+2TvP8RPL+pTewlAgj4NELtl7z+EIt1/boUJQB2cQe05Z+8/NJdI
JfWHCUCEs46kmWfvP+QLtMp7iglA68rbW/ln7z9E9YoViY8JQLn5dcq4aO8/
9Gn2ug+SCUAgEcOBGGnvP6TeYWCWlAlAhigQOXhp7z+5s4Td/JYJQLcd1C3T
ae8//mW0IQ==
                "]], LineBox[CompressedData["
1:eJwVx2tIk1EcgPFpSLzn1aJ5mSnTlmT74GUS6Bft/EWtoAtOuoi6WcYCdTqV
NnOCTsWtbJmrobU0S8FleSENU0LR4bykDS94obBS01S0o2MSpESnDw8PP0Ga
IkHmzOFwhLT/LyxuuxJey0DhzMdwVQbBg6ZV6GtkwJEavxCSSXBZlnF2vpWB
REX900A5wc7u206HLAwIKqO4XtkEd+iSzcZBBv6IxU6XqdP2hy74DjMw7Snb
NlBbVupqhOMMlNfpbW4Kgku7zwfHzDKw0fKlwiWHYCepOfHOBgOdYwUHdnMJ
5jRL25e4COKYLse0kuChzbnsek8E0vRLXJ6KYL1IHJLijUA1uhqaRM3rjmmd
4SN4dY+X+Z06ZFj4ZkSIgEUFi5v5BKes2JvaTiOYRJE2FzXBPQLdc3UGAomr
xRxRRHCRjCONyEKglCdZ1dSxzQV8hwJB5bh9qZd6QiSvzVIi6NcH+MUWE7yG
xabrGgQBbuXGeA3BXlLf6jPVCNbczpWklxKcZ2p/wLUguH3YlvRMS/D7fZPO
MoggPwfwAvW+VFuSN4xAPdkR4K8jWBcgUU6NI9A8rtlsoK5tQZJHcwj0vBtF
r+8SbO2TBXG3EDT6O172VBCMBOJAC0HQpLml3aOOL4s8lmdH0Lw4nxF1n+DP
Z909pn4jaG/sPTVA/Wuif8/gzMKHkzrriJ5g72XfsSPeLEyH+qzPVRIsiTto
HfBhYbZK/+noQ4IbzPa+XD4L8zt/3yZTB8lHOyaPs/C1c1n9jTrX9q6l5AQL
ix5XUwVVBHeJXjSFCVn4oRyJuUkdvasyGYJZ2Ihodf1Jrb2WZowWsbD1xH9H
aCA44aJffjX1Oj+bG0b9D+uTLCo=
                "]], LineBox[CompressedData["
1:eJwVzX0s1HEcB/BLku37LZ0zOVnXFbfCLXPk8fp9PLScwk6raGmlFGqeSnPl
qbMayubxFLYkDylWOkM4uWokmcceNmaWHtzEjynpWPr44733Xnv/8RaGxwZH
GHA4HFvMWpvx/dh+ZwK9Cp1Kmccyx1KtlXJXAs3PLUML0KUTJsnrPNDLKnkV
esJ7ObFBSqDFl+ffjI7eOBTF9SHQ+pF4jKKfRmnOag8QaBNkSmbQv3ofhcX7
oSMN7VfRablp8sEAAhr9itWufJYp5Ivd8kIIdG6f/ReN1thlGnNjCHSfH3il
R+8b2dqXH0dg7k/ALVLAMs+Sa/LMLhPgZ/XKrNAVfV2WFkkELj3pGpCiM2M3
iAVKAqZz7ePp6GC1Ui5WEQhT1OqNClnmh3tKiayDwMJtpSOviGW4/gn2ys0U
djQ4VdgVs0y51oS4cyk8OKrol6Id3Op18zwKQr1mJQgduHuq+gyfwk6fg8ev
oLONTgm9rCnYfAilGrTha5k5x53Cnr+pVwPvssyih5CTGkHB0avHP/4ey9xU
d4w7R1JQf9uUlIE2szupmYmmIMkOripCSyyLr4XFUXAaHl19gY5bor89r1Nw
iZhtNChhGV3jkm45l4JHFk9QiE6yV71VF1BoF4ccrkYbV0pqLqooeA6VKVrQ
ooKYc6OlFKTbRCNj6PD4r+Ot1RSg3jXLppRl5qduaBJqKXTKU5pc0OmnBWW2
dRS8FrWTMvT9oBOhJQ0UvJlD+2PQY+KBYUU7Bd/BsIWmtX2am7L+JYUZzcPp
bnR47RFRjpaC6rFu8jNadKGo3/wN/hXvHdOhddafksq7KOgyEkf06LovFjtt
eyjkx7W9J2Us8/N78xaHdxTu5PhWmqL/A0MJO48=
                "]], LineBox[CompressedData["
1:eJwV0H8s1HEcx/HT5Ud338+HC6tEhEg5VpmGuc87rCgj1MhE52pXW8vPmpSy
blpi65/iukqrf46Tu/Mr153JjsKyZXJaVNKOXLLPRm3Ijz798dpzj39fO3Pz
Us9t4PF4AWz/q22ZvHPhPQedHZWKjMeUlNVK88csHOTf9DZ+Yt7oOmWeG+NA
LuypIk8oEQl+yd2mODjpJwgV1lEy0icW1f3g4LhtfIuEWVmRZwz8yUGirolX
wLzDboGLohzERqUMjzIHLy41S5c42JemvPz8KSWHpx1XtAgBpwjojHhGib6O
+FuzEVyLyRmtUVOyULrgKJUi8H6x3NXPHJ6unv0iQ9DjXqNeZjY5O7d+PI9A
YBssya6n5G3510PvChGo7kVuD2igZDy3LKflNgLDZ/cz7RpKHAJNqnItgj9X
Bm0fmihJ4OfdWNUjePhNPmyvpaR6wje3tBVB9FG+6SCzSHk3qNiAoMIrsvoR
s+emTIPcjMCtVx0i01Gyf3bRkjSK4IBIUTSvp+S0LlzktYYgvzFi1aWNkpeZ
i3iIh2Fb8h6/I8zYwcgp+BjM8x4JZczdWdFONicM7pEr923MvoK49TZXDMb+
rmBzOyXTZ1PmEoMw2E/HZhV1UCJxcZ1d34tBWxl2q4G51jQy0xKCIV28q36C
OX5zhnVrGAZNscPvYwZKNK+zx60SDMn8gSr/V5Rc8rg4cP0EBpVPksliZH+9
EfeFpmOI7ZVMCk2UeBfQ3u+nMMzJQx1jmEs8m80PsjDUCH3EJcxDfYXd8TkY
iM4lTcu8uyis668Uw0yq3VUrc0V5imZAhmFtXtXo1EnJP59HHiY=
                "]], LineBox[CompressedData["
1:eJwVzn8s1HEcx/HzY+Tk85kb1Vq3cv3CcpqNMuX7zvphzo/OLEvpRD/QGRXl
UGid2i0dS1SHZceNK1TOVPuGITqt2nVEJURdUvbVlliS3v3x2nOP/15u8amR
R615PN5G3P/uCc0W2SQREAtHVeEsx6jWBDT3yAloBmbY4+jx538eZKUSOJ+g
MSrQJaK8htF0AruyLWMV6NlXBTV3cwmY9DmuFvTe7GCt7AIBg59INIeu3cCv
EigJlHX0iPlPOCbmXGF5popA7DtBsBjNepZc23mdwKRDXdYZdJ6yKn9IT8Am
qX/ErpVjnM7ahxyuJ0C257QsR99KTBFYGgmsdF6rdkc3Sfy1nIGAz6O0wBC0
xdnUZd1GIM5haUUhWlLJW+JhJtBaFxTj0sYxy1pkVzPmCSgmG/vc2jmmfkKo
IaEUpk+ojNs6OOZyhTJuOJyCMEJbGoE+Ejm1vkFKQeLDJsSjV7HsvbBoCrq5
qYVLaJX6QPeVeAoHlVIfMzrR7+YPvoLCs8oVmqROjhFddAm211G4bdLJS7s4
5u/WHKeBWgovDW3+dei3U+OvdXcozJcN2rHoouim2N33Kew7xK/6iF70jDyt
ZCk4fUvp3/SUY4ZM6kobMwWFrW9gJ/phwWyCuR//fAlzfIMuCZB5aAcp9PUe
G5xAS2rEhqBhCt7FN06Rbo55nPnCmP+VwmfhH91+dKmXr1r6nYLAyjVdjj45
Vh7lxlGAT147ctHuofKR9p8UNHrZ+2q0rVVfddEsBWNhZm0LerQ5IDnuN4Vf
acUZvWg2Weu9eYHCuih90Ad02WrHmcVFCtItnXQa/Q9bvDL2
                "]]},
              Annotation[#, "Charting`Private`Tag$72657#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT5zJlrO7yojPgRDGnDf
GVQ/dDkOaSyVAT8zn5icsxlkP8CcLhMGlRE/S83Xsp0ZdD9mzj7o8pQhP1dk
972SGYQ/OefGUumUMT/dL4dDjRmUP6LzCojklEE/oBVPhooZpD/X+awi4pRR
P4EIsyeJGbQ/8fz97+CUYT8qR5GIsnC0P6OYQ8oe4WE/0oVv6dvHtD9TNImk
XC1iPyQDLKsudrU/t2sUWdjFYj/G/aQu1NK2P3vaKsLP9mM/DPOWNR+MuT8G
uFeUvlhmP5jdekO1/r4/HHOxOJwcaz9BHFmk3lW/P80O9xLaaGs/6lo3BQit
vz9/qjztF7VrPx7seWOtLcA/4uHHoZNNbD9vaTYlANzAP6ZQ3gqLfm0/EmSv
qKU4wj8xLgvdeeBvP1hZoa/w8cQ/o3SywCtScj/v21QKohrFP6aGtfjDdXI/
hl4IZVNDxT+pmLgwXJlyP7Njbxq2lMU/rby+oIzgcj8Obj2FezfGP7cEy4Dt
bnM/pfDw3yxgxj+5Fs64hZJzPzxzpDreiMY/vCjR8B22cz9qeAvwQNrGP8FM
12BO/XM/xYLZWgZ9xz/LlONAr4t0P1wFjbW3pcc/zabmeEevdD/yh0AQac7H
P8+46bDf0nQ/II2nxcsfyD/U3O8gEBp1P7cPWyB9SMg/1+7yWKg9dT9Okg57
LnHIP9oA9pBAYXU/fJd1MJHCyD/fJPwAcah1PxMaKYtC68g/4Tb/OAnMdT+q
nNzl8xPJP+RIAnGh73U/QB+QQKU8yT/mWgWpORN2P9ehQ5tWZck/6GwI4dE2
dj+QO0vYzW/JP4vmInP5P3Y/VDcvbw==
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAApPfnWmXDyT/Ob0X5+Nd6PzKsEQYc
CMo/TiKth54UgT/JLsVgzTDKP/j63EVNP4M/YLF4u35Zyj+g0wwE/GmFP422
33Dhqso/5IRsgFm/iT/owK3bpk3LP73zlTwKNZE/ntVJsTGTzD9TVlU1xd+Z
Pwv/gVxHHs8/ww1qk52apT+YaVdeLEbPP1EBDuaQIqY/JNQsYBFuzz/b9LE4
hKqmPz6p12Pbvc8/99v53Wq6pz+5qZa1ty7QPy6qiSg42qk/7VPsvEvO0D+b
Rqm90hmuP1Wol8tzDdI/uz/084NMsz8lUe7ow4vUP5Z4Mx65y7s/Gn9HOmeh
1D86uh+zdRW8PxCtoIsKt9Q/4fsLSDJfvD/6CFMuUeLUPyh/5HGr8rw/0MC3
c9441T++hZXFnRm+P3owgf745dU/ccl7NsEzwD/ODxQULkDXP5XW3d2lgcI/
wz1tZdFV1z9n91MohKbCP7hrxrZ0a9c/ORjKcmLLwj+jx3hZu5bXP95Ztgcf
FcM/eH/dnkjt1z8n3Y4xmKjDPyLvpiljmtg/uuM/hYrPxD8XHQB7BrDYP4sE
ts9o9MQ/DEtZzKnF2D9dJSwaRxnFP/emC2/w8Ng/A2cYrwNjxT/s1GTAkwbZ
P9WHjvnhh8U/4gK+ETcc2T+oqAREwKzFP8xecLR9R9k/TOrw2Hz2xT/CjMkF
IV3ZPx8LZyNbG8Y/t7oiV8Ry2T/xK91tOUDGP5Vq8rizhNk/LWb7jshexj+e
3R4z
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAn8hAen+u2T/om3bIFrTGP4xyh5xR
ydk/Nc9JW9/zxj93zjk/mPTZPypRytDJWsc/Di615ckI2j/OblPtz4rHP6SN
MIz7HNo/b4zcCda6xz/RTCfZXkXaP7TH7kLiGsg/K8sUcyWW2j8/PhO1+trI
P9/H76ayN9s/UytcmStbyj9HwaUOzXrcP3wF7mGNW80/F7QR3gEB3z/n3Ih5
KK7RP1yM+1TkFt8/PrzVLC7I0T+iZOXLxizfP5WbIuAz4tE/LBW5uYtY3z9B
WrxGPxbSP0J2YJUVsN8/nNfvE1Z+0j82nFemlC/gP1DSVq6DTtM/YV6mXaje
4D+5xyTj3u7UP4RKG5mZ6eA/EKdxluQI1T+mNpDUivTgP2WGvknqItU/7A56
S20K4T8URViw9VbVP3a/TTkyNuE/bMKLfQy/1T+MIPUUvI3hPyK98hc6j9Y/
tuJDzM884j+JssBMlS/YP9ZIgfGNR+I/mUtTgiFJ2D/2rr4WTFLiP6nk5bet
Ytg/N3s5Ychn4j/MFgsjxpXYP7gTL/bAkuI/DntV+fb72D/YeWwbf53iPx4U
6C6DFdk/+N+pQD2o4j8urXpkDy/ZPzisJIu5veI/Tt+fzydi2T+5RBogsuji
P5FD6qVYyNk/2qpXRXDz4j+k3Hzb5OHZP/oQlWou/uI/tHUPEXH72T863Q+1
qhPjP9SnNHyJLto/WkNN2mge4z/kQMexFUjaP7Cb30LAKOM/tiLjlK1g2j87
jiLR
                "]], LineBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAtsqGI6Y94z+/KHZnPIraP9rbQm9h
SeM/kF/l8P6c2j/6QYCUH1TjP8zp/Kosrto/Ow773ptp4z9E/isfiNDaP7ym
8HOUlOM/MyeKBz8V2z/cDC6ZUp/jP26xocFsJts//HJrvhCq4z+qO7l7mjfb
Pz0/5giNv+M/IlDo7/VZ2z++19udherjPxF5Rtisnts/vwjHx3ZA5D/tygKp
GijcP8JqnRtZ7OQ/p257SvY63T/1Jj0PrW3nP6vjPk9AnuA/PuJCx4p45z9M
19Vq8KbgP4adSH9og+c/7MpshqCv4D8WFFTvI5nnPyyymr0AweA/NgFrz5rE
5z+tgPYrwePgP3jbmI+IG+g/sB2uCEIp4T/Alp5HZiboP1ARRSTyMeE/CFKk
/0Mx6D/wBNw/ojrhP5nIr2//Rug/MuwJdwJM4T+6tcZPdnLoP7O6ZeXCbuE/
/I/0D2TJ6D+2Vx3CQ7ThP0RL+sdB1Og/V0u03fO84T+MBgCAH9/oP/c+S/mj
xeE/HX0L8Nr06D84JnkwBNfhPz5qItBRIOk/uvTUnsT54T+GJSiILyvpP1ro
a7p0AuI/zuAtQA026T/62wLWJAviP15XObDIS+k/OsMwDYUc4j9/RFCQP3fp
P7yRjHtFP+I/yP9VSB2C6T9dhSOX9UfiPxC7WwD7jOk//Xi6sqVQ4j8XAkap
Jo/pPwH9DflhUuI/SBwREw==
                "]], LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAHTHtiQyk6T80xuhJvF/iP+jsbCiU
rek/QI4ATktk4j8wqHLgcbjpP27Tq/d9aeI/wB5+UC3O6T/JXQJL43PiPwja
gwgL2ek/9qKt9BV54j9QlYnA6OPpPyToWJ5IfuI/4QuVMKT56T9/cq/xrYji
PwL5qxAbJeo/NodcmHid4j8bzULzPy/qP7V1RNdSouI/NKHZ1WQ56j81ZCwW
LafiP2VJB5uuTeo/M0H8k+Gw4j/ImWIlQnbqPzD7m49KxOI/jzoZOmnH6j8r
b9uGHOviPxx8hmO3aes/IVdadcA44z82/2C2U67sPwsnWFII1OM/TE3AgkW4
7D9E2ychytjjP2ObH083wuw/fo/374vd4z+QN97nGtbsP/H3lo0P5+M/6W9b
GeL97D/WyNXIFvrjP5zgVXxwTe0/oWpTPyUg5D8BwkpCjeztPzauTixCbOQ/
GBCqDn/27T9wYh77A3HkPy5eCdtwAO4/qRbuycV15D9a+sdzVBTuPxt/jWdJ
f+Q/tDJFpRs87j8BUMyiUJLkP2ajPwiqi+4/y/FJGV+45D/MhDTOxirvP2E1
RQZ8BOU/Og/LApE17z8l6FJapQnlP6iZYTdbQO8/6Zpgrs4O5T+Dro6g71Xv
P3EAfFYhGeU/OtjochiB7z+By7Kmxi3lP6hif6fii+8/RX7A+u8y5T8W7RXc
rJbvPwkxzk4ZOOU/8QFDRUGs7z+Qlun2a0LlP6grnRdq1+8/oGEgRxFX5T8W
tjNMNOLvP2QULps6XOU/hEDKgP7s7z8oxzvvY2HlP31orA+N9e8/k1NIz3tl
5T9daDG4
                "]], 
               LineBox[{{1.0012755102040816`, 0.6697073590256148}, {
                1.0029484390136711`, 0.670309460966196}, {1.0055826833813366`,
                 0.6712575489162897}, {1.0161196608519991`, 
                0.6750499007166648}, {1.017436783035832, 
                0.6755239446917117}, {1.0187539052196648`, 
                0.6759979886667586}, {1.0213881495873305`, 
                0.6769460766168525}, {1.0266566383226616`, 
                0.67884225251704}, {1.0371936157933241`, 
                0.6826346043174151}, {1.0582675707346494`, 
                0.6902193079181654}, {1.1369227129030104`, 
                0.7185279923432247}, {1.1987244897959184`, 
                0.7407710008832691}}], 
               LineBox[{{1.2012755102040815`, 0.7416164985356329}, {
                1.3058823930203434`, 0.7733083331929514}, {
                1.3839420330101317`, 0.7969573812991971}, {
                1.3987244897959183`, 0.8014358932639116}}], 
               LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJzKQ3p9r9j/ji7rTN6vpP4IILFOG
ifc/i1CJvWY+6j8O0KzBo5P3P9nF2subQ+o/Jl+unt6n9z92sH3oBU7qP1Z9
sVhU0Pc/sIXDIdpi6j+1ubfMPyH4PyMwT5SCjOo/eh34g04m+D/K6ncbHY/q
P0CBODtdK/g/caWgoreR6j/MSLmpejX4P8Aa8rDsluo/5Ne6hrVJ+D9dBZXN
VqHqPxT2vUArcvg/l9raBiu26j90MsS0FsP4PwuFZnnT3+o/ZjQgoJHI+D+M
dMC0peLqP1g2fIsMzvg/DmQa8Hfl6j87OjRiAtn4PxFDzmYc6+o/AkKkD+7u
+D8YATZUZfbqP49RhGrFGvk/JX0FL/cM6z+AU+BVQCD5P6dsX2rJD+s/clU8
Qbsl+T8oXLmlmxLrP1ZZ9BexMPk/LDttHEAY6z8cYWTFnEb5PzL51AmJI+s/
qnBEIHRy+T9AdaTkGjrrP5xyoAvvd/k/wmT+H+086z+NdPz2aX35P0NUWFu/
P+s/cHi0zV+I+T9GMwzSY0XrP2J6ELnajfk/yCJmDTZI6z9UfGykVZP5P0oS
wEgIS+s/2c1vIWCU+T9e5Vx5kUvrP7QI4WI=
                "]], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAW2XDEdOe+T+x4EuztU/rPyiCgGbG
o/k/45Wr5RVR6z8ahNxRQan5P9icRsabUus//oeUKDe0+T/BqnyHp1XrP8SP
BNYiyvk/ksboCb9b6z+2kWDBnc/5P4fNg+pEXes/qJO8rBjV+T981B7Lyl7r
P4uXdIMO4Pk/ZOJUjNZh6z9Sn+Qw+vX5Pzb+wA7uZ+s/367Ei9Eh+j/aNZkT
HXTrP9DtBOwyJ/o/sB/12pt16z/ALEVMlCz6P4YJUaIad+s/oKrFDFc3+j8z
3QgxGHrrP2Kmxo3cTPo/jIR4ThOA6z/mnciP53f6Pz/TV4kJjOs/7YzMk/3N
+j+lcBb/9aPrP/tq1Jspevs/cKuT6s7T6z8rQQf+Zrv8P5wjiAoVLew/DAGj
VJPH/D8BgMUVdzDsPymtpgc=
                "]], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAjpj2RAbS/D8YTOu9cDPsPyCO++Ta
If4/YWBT7luV7D/6edViBCz+P5N60nNSmOw/rVGJXldA/j/5rtB+P57sPxMB
8VX9aP4/wxfNlBmq7D/fX8BESbr+P1jpxcDNwew/zFWtA16//j9xdoUDScPs
P7hLmsJyxP4/igNFRsTE7D+SN3RAnM7+P70dxMu6x+w/RQ8oPO/i/j8iUsLW
p83sP6u+jzOVC/8/7Lq+7IHZ7D93HV8i4Vz/P4GMtxg28ew/YlAwVtxh/z/w
jdjoqfLsP06DAYrXZv8/YI/5uB307D8m6aPxzXD/Pz6SO1kF9+w/1LTowLqE
/z/7l7+Z1PzsPzBMcl+UrP8/daPHGnMI7T8cf0OTj7H/P+Sk6OrmCe0/B7IU
x4q2/z9Upgm7WgvtP94Xty6BwP8/MqlLW0IO7T+M4/v9bdT/P++uz5sRFO0/
eBbNMWnZ/z9esPBrhRXtP2NJnmVk3v8/zbERPPkW7T86r0DNWuj/P6y0U9zg
Ge0/JuIRAVbt/z8btnSsVBvtPxEV4zRR8v8/ireVfMgc7T/8R7RoTPf/P/m4
tkw8Hu0/PzTWh8b6/z904n/VPx/tP8ZJ9Wo=
                "]], 
               LineBox[{{2.001275510204082, 0.9103638835944402}, {
                2.0039562426140143`, 0.9106020352208352}, {2.008820753763886, 
                0.9110341899699126}, {2.0185497760636295`, 
                0.9118984994680674}, {2.0380078206631165`, 
                0.9136271184643773}, {2.0393271393937447`, 
                0.9137443244563921}, {2.0406464581243724`, 
                0.9138615304484068}, {2.0432850955856283`, 
                0.9140959424324364}, {2.0485623705081406`, 
                0.9145647664004956}, {2.0591169203531647`, 
                0.915502414336614}, {2.080226020043213, 0.9173777102088505}, {
                2.122444219423309, 0.9211283019533237}, {2.1987244897959184`, 
                0.9279049091162662}}], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAe3+uVTacAUCbjEuhLrPtP2s0u9kJ
SwJAhQ49QYfs7T/A0NWsuE0CQJuUu4to7e0/FW3wf2dQAkCxGjrWSe7tP7+l
JSbFVQJA3SY3awzw7T8TF5BygGACQDU/MZWR8+0/u/lkC/d1AkDmbyXpm/rt
Pwu/Dj3koAJARtENkbAI7j9gWykQk6MCQFxXjNuRCe4/tfdD40GmAkBz3Qom
cwruP18weYmfqwJAn+kHuzUM7j+zoePVWrYCQPcBAuW6D+4/W4S4btHLAkCn
MvY4xRbuP6tJYqC+9gJACJTe4Nkk7j80LCE+P/kCQLdbHgOsJe4/vg7g27/7
AkBmI14lfibuP9DTXRfBAANAxLLdaSIo7j/0XVmOwwoDQIDR3PJqK+4/fUAY
LEQNA0AvmRwVPSzuPwYj18nEDwNA3mBcNw8t7j8Z6FQFxhQDQDzw23uzLu4/
PnJQfMgeA0D5DtsE/DHuP8dUDxpJIQNAqNYaJ84y7j9QN863ySMDQFeeWkmg
M+4/YvxL88ooA0C1LdqNRDXuP+veCpFLKwNAZPUZsBY27j90wckuzC0DQBO9
WdLoNu4//qOIzEwwA0DChJn0ujfuP1JNHneWMANALyGPHtM37j/hL86W
                "]], 
               LineBox[{{2.4012755102040817`, 0.9444888661614991}, {
                2.4046933744994785`, 0.9446757197904045}, {2.409580888186021, 
                0.9449429187163203}, {2.4108027666076564`, 
                0.9450097184477992}, {2.412024645029292, 
                0.9450765181792782}, {2.414468401872563, 
                0.9452101176422361}, {2.419355915559106, 
                0.9454773165681518}, {2.429130942932191, 
                0.9460117144199833}, {2.4486809976783612`, 
                0.9470805101236465}, {2.5334854370252864`, 
                0.9517167437098109}, {2.53472237080263, 0.951784366513128}, {
                2.5359593045799738`, 0.9518519893164453}, {
                2.5384331721346607`, 0.9519872349230797}, {
                2.5433809072440345`, 0.9522577261363484}, {2.553276377462783, 
                0.9527987085628858}, {2.5730673179002794`, 
                0.9538806734159608}, {2.5987244897959183`, 
                0.9552833434056996}}], 
               LineBox[{{2.601275510204082, 0.955408279484915}, {
                2.6150743461754633`, 0.9560054956203506}, {
                2.6174994935756546`, 0.9561104564417712}, {
                2.6223497883760363`, 0.9563203780846123}, {
                2.6320503779767996`, 0.9567402213702946}, {
                2.6514515571783264`, 0.957579907941659}, {2.6902539155813803`,
                 0.9592592810843881}, {2.774462852749733, 
                0.9629038592306265}, {2.798724489795918, 
                0.9639539073032405}}], LineBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAR0x7IgNpBkAe++Lfu9nuP/XKjeJw
gQdATzapxQ4X7z/cC9Vo/IMHQClXKT+dF+8/wkwc74eGB0ADeKm4KxjvP5DO
qvueiwdAuLmpq0gZ7z8q0scUzZUHQCI9qpGCG+8/XtkBRymqB0D1Q6td9h/v
P0QaSc20rAdAz2Qr14Qg7z8rW5BTQK8HQKmFq1ATIe8/+NweYFe0B0Bex6tD
MCLvP5LgO3mFvgdAx0qsKWok7z/G53Wr4dIHQJpRrfXdKO8/rCi9MW3VB0B0
ci1vbCnvP5NpBLj41wdAT5Ot6Pop7z9g65LED90HQATVrdsXK+8/+u6v3T3n
B0BtWK7BUS3vP+Av92PJ6QdAR3kuO+At7z/HcD7qVOwHQCKarrRuLu8/lPLM
9mvxB0DW266niy/vP3szFH338wdAsfwuIRow7z9idFsDg/YHQIsdr5qoMO8/
L/bpD5r7B0BAX6+NxTHvPx8a60Nj/QdAgLO6iCky7z+nOrBK
                "]], LineBox[CompressedData["
1:eJwVx2tIE1AYgOGxks5Zq1EZQhQ0mzYl1Mih0+h8pYvVtOXchhEstW2VRqFZ
WmOKsRTtBpGb3ViE5OYFDY0sopFupgbmhUxLDTWlUjnZmtIy7fTj5eURZp5V
GbgcDieY9f9jk4Ev73MRCC/iRd4uShrjDjWkIgQpXS5ZC7PNVCH5zEPQURKX
GxBNif7vtn3zAgTNy5Fv7cyVK3V5KhEC40RAJI6hZOl4kKQ3FEFhduygmlnf
1uNThiGwerOKHzJHXU7IT45A4FnR0x8TS0nHsviSPBaBSHS3wCilZMHvLdqT
hGBcH9HaFk+Jdq7sangeAt2UVlMIlGwYffqI60ag+VZt8h6g5AbfbH7WjqAI
nbwuO0gJLz4x7XQnAud2sd3GzK3sWzPQjWDJ4GiNV1DyM4UWOIcQPB53YEsS
JT0esfIwRbDwyWkLVFJyrf7enwebMFR21zZJ1JSg4cwB1RYMrbPZnlJmCy/8
yaqtGGb4Oz4MMZtOtBhzQjCAos5v1lCSJXzfmxiF4eubur3tWkrkFWsd0zIM
0tf177RHKAkwF6ulORg+NjVM5+soaZ6b+e06h2G2ZbfFzaw3ptn3X8DAedW5
ed0xStzKyO+pJgyhHRPJNcyW4JGiM1cw5A4HNQ6nUxJtk4f4SjGUjFXJwzIo
+bK6uctUjuHO1M6x88yJvvKNZTcxuH4o1gsyKfl1av6F4BaGPt9gzVHmqtGM
dOttDJN+Q4KD+XmTZWTRiqG2up8/x/wPYI7/GA==
                "]], 
               LineBox[{{3.201275510204082, 0.980891753056576}, {
                3.2049527235388684`, 0.9809671401181093}, {3.209886242298752, 
                0.9810682828717288}, {3.21975327981852, 0.9812705683789678}, {
                3.2209866595084913`, 0.9812958540673726}, {
                3.2222200391984623`, 0.9813211397557775}, {
                3.2246867985784045`, 0.9813717111325873}, {
                3.2296203173382887`, 0.9814728538862068}, {
                3.2394873548580567`, 0.9816751393934456}, {
                3.2592214298975932`, 0.9820797104079236}, {
                3.3447619504179835`, 0.9838333885051526}, {3.398724489795918, 
                0.9849396820231513}}], 
               LineBox[{{3.4012755102040817`, 0.9849861698665803}, {
                3.507084223974069, 0.9866733247558511}, {3.5920292423158866`, 
                0.9880278011303221}, {3.5987244897959183`, 
                0.9881345590628055}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQvW7Tw47M8zwOm+UZjqjPf29vFr789d1kXgc3nUiW
Xyvf2+/m5998PYPXYaf7xbthq97bH2u453i6iNdhbt3BCQKr39vfTqqN39TG
65D6ZuG35jXv7dnUd89qWMfr8O140qGs9e/tPZnz6/5u4HVYf1VOfyaQ33Nf
KalqM69DxuNbs48D+YIzujRLdvA63PoXVKqy4b29DGfUjvRDvA77TJ017gH5
Rq9/XPW7xuvQvli5L3DTe/vY9WaCsv94HSTqn0RabH1vvy3qB98FBj6HtENG
O7KAfD62XTzNzHwOW1gbxeYC+QdibDlecvA5BPTIXmbc9t5eicvl/xZhPofO
mWE+p4H8ZymBb300+Rx+bz5hF7fjvb2dgPDr/9p8Dp7fxeZOAPKn777yYpMe
n8N0q9Tfh4B8D6GIJxImfA7GBxl3qO98b79qf9ztJ3Z8DjnnrAw/Avl5Ujkn
a0L4HO6+WKPcshsYXkd1j+uH8zno6Pxu3Abkyxe+P/Ioks+hKt/zwQsgv0Jm
46GpMXwOJzZNt5Pe897+wvGiAx7xfA5i357O8QXyNYpN9v1O5HNIsTT5XQ/k
tzYErjqZzOdQt+nTsoVAPgCVZdnA
                "]], LineBox[CompressedData["
1:eJwVx3lIk3EYwPGpgTL190OxgnCpg7ItyoIyZdX7EOFmHqkoghEeFdnUxDS8
Mo+c1TCnNZOaSfY6sTwyjy7mVebsMNNZS5ApmaMifSdpgrnW0x9fvnx8ktKj
TtnzeDxf7P+loflChzMEivht1SYdxyi9Jd36VALR5RUiC3r27VpHXjoBX4Fw
YA2tFha1zWQReH8w2LK+h2NWRsu0LYUEBCU14TJ0RL6MjS8hYHHfbo5GN23l
17srCAyyvQWJ6LiCa7U5SgIpr+Za8tA6sfrG4WoCz5z2OLeiixT1xVMPCMSo
PujdejnGNdvxSGIrgR/y8csC9O3kNHfzQwKFQRNSEbozJJDlugjctxr1gDa7
jQ3a9xGwpkzr09EhdTwnkYFAg2xBP4Le8CS+4vwfAr/sXIav9nFM6zeBhoRS
qMqSDtsNcMyVO4oEUziFsN2bzQR9Mmp+S1skBf7CkoMn2lOnaw+LpVBy+h7j
j1aqjg2VJ1HIjLM+lqOT/W8t8nMpxECn1oAWlnrIHBspbHLxuqR9wTF/Ay64
GpsofBpevtuBnpyfHW9spnBd8a63D10Z23k86BEFZ1vu6iTaJo7KVOgorC1O
ZJCXHDM1pqpzMFAwGZUJ2einZSsnDB8paNSJF0vRakm8iP1MITYyoLYKHaLd
2XXIRGH0zZyxGf08Z+R18XcK/T1wdAZ9c8deVeRPCgV5G9Pm0RlfaqN9OAqB
+xaUq+htoanT/UsUOto1Qx6DHLPObqKhcoXC2bRzX33QM90SecIqBbE42N4P
rZOzfrusFMxmL+/96Bov52WbjQLL/j4QjP4HM7g31Q==
                "]]},
              
              Annotation[#, 
               "Charting`Private`Tag$72657#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, Automatic},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Munc13-1 intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT6SEaphClECPgRDGnDf
GVQ/yux6pkvN4D4zn5icsxlkP3UpZgQnzfA+S83Xsp0ZdD/Lx1uzFM0AP1dk
972SGYQ/95bWigvNED/dL4dDjRmUP4z+k/YGzSA/oBVPhooZpD9XsnKsBM0w
P4EIsyeJGbQ/PAxihwPNQD8qR5GIsnC0P4CuOK3eFUE/0oVv6dvHtD/DUA/T
uV5BPyQDLKsudrU/S5W8HnDwQT/G/aQu1NK2P1keF7bcE0M/DPOWNR+MuT93
MMzktVpFP5jdekO1/r4/slQ2QmjoST9BHFmk3lW/P/b2DGhDMUo/6lo3BQit
vz86meONHnpKPx7seWOtLcA/wt2Q2dQLSz9vaTYlANzAP9Bm63BBL0w/EmSv
qKU4wj/ueKCfGnZOP1hZoa/w8cQ/lE6FfuaBUT/v21QKohrFP+bwABTqo1E/
hl4IZVNDxT83k3yp7cVRP7Njbxq2lMU/2ddz1PQJUj8Obj2FezfGPx5hYioD
klI/pfDw3yxgxj9wA96/BrRSPzxzpDreiMY/waVZVQrWUj9qeAvwQNrGP2Tq
UIARGlM/xYLZWgZ9xz+pcz/WH6JTP1wFjbW3pcc/+hW7ayPEUz/yh0AQac7H
P0u4NgEn5lM/II2nxcsfyD/t/C0sLipUP7cPWyB9SMg/P5+pwTFMVD9Okg57
LnHIP5BBJVc1blQ/fJd1MJHCyD8zhhyCPLJUPxMaKYtC68g/hCiYF0DUVD+q
nNzl8xPJP9bKE61D9lQ/QB+QQKU8yT8mbY9CRxhVP9ehQ5tWZck/eA8L2Eo6
VT+QO0vYzW/JP6iZvFgKQ1U/FscaiA==
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAApPfnWmXDyT+eBUaOaFdiPzKsEQYc
CMo/LnhjEtDnbj/JLsVgzTDKP/98t2JMLHM/YLF4u35Zyj/mPT28sOR2P422
33Dhqso/nr9Ib3lVfj/owK3bpk3LP5Lhr2qFm4Y/ntVJsTGTzD+McmNoi76S
Pwv/gVxHHs8/DTs9Zw7QoD+YaVdeLEbPP6YmQR7FRKE/JNQsYBFuzz89EkXV
e7mhPz6p12Pbvc8/cOlMQ+mioj+5qZa1ty7QP9eXXB/EdaQ/7VPsvEvO0D+j
9HvXeRuoP1Wol8tzDdI/Pa66R+Vmrz8lUe7ow4vUP7cQHBTe/rY/Gn9HOmeh
1D+Zt2GoKz63PxCtoIsKt9Q/fl6nPHl9tz/6CFMuUeLUP0GsMmUU/Lc/0MC3
c9441T/OR0m2Svm4P3owgf745dU/4X52WLfzuj/ODxQULkDXPwjt0JyQ6L4/
wz1tZdFV1z/qkxYx3ie/P7hrxrZ0a9c/zDpcxStnvz+jx3hZu5bXP5KI5+3G
5b8/eH/dnkjt1z8OEn+ffnHAPyLvpiljmtg/mK2V8LRuwT8XHQB7BrDYPwmB
uLpbjsE/DEtZzKnF2D96VNuEAq7BP/emC2/w8Ng/XfsgGVDtwT/s1GTAkwbZ
P87OQ+P2DMI/4gK+ETcc2T9AomatnSzCP8xecLR9R9k/IkmsQetrwj/CjMkF
IV3ZP5QczwuSi8I/t7oiV8Ry2T8F8PHVOKvCP5Vq8rizhNk/1qmbAXXFwj+w
9hzX
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAn8hAen+u2T+tu/7k+BPDP4xyh5xR
ydk/glwi2IFRwz93zjk/mPTZP9Z2BobLtMM/Di615ckI2j8WPn08IOPDP6SN
MIz7HNo/VAX08nQRxD/RTCfZXkXaP9KT4V8ebsQ/K8sUcyWW2j/OsLw5cSfF
P9/H76ayN9s/xupy7Raaxj9HwaUOzXrcP7Ze31Rif8k/F7QR3gEB3z+WRrgj
+UnPP1yM+1TkFt8/FXlF2y58zz+iZOXLxizfP5ir0pJkrs8/LBW5uYtY3z9M
iPYAaAnQP0J2YJUVsN8/Te0QcNNt0D82nFemlC/gP0+3RU6qNtE/YV6mXaje
4D9US68KWMjSP4RKG5mZ6eA/leR15nLh0j+mNpDUivTgP9R9PMKN+tI/7A56
S20K4T9WsMl5wyzTP3a/TTkyNuE/VRXk6C6R0z+MIPUUvI3hP1nfGMcFWtQ/
tuJDzM884j9cc4KDs+vVP9ZIgfGNR+I/Lgf5KVkE1j/2rr4WTFLiPwCbb9D+
HNY/N3s5Ychn4j+mwlwdSk7WP7gTL/bAkuI/8BE3t+Cw1j/YeWwbf53iP8Kl
rV2GydY/+N+pQD2o4j+UOSQELOLWPzisJIu5veI/OGERUXcT1z+5RBogsuji
P4Kw6+oNdtc/2qpXRXDz4j9WRGKRs47XP/oQlWou/uI/KNjYN1mn1z863Q+1
qhPjP8z/xYSk2Nc/WkNN2mge4z+ekzwrSvHXP7Cb30LAKOM/CnooHAQJ2D8J
8x2c
                "]], 
               Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAtsqGI6Y94z/7atZZxjHYP9rbQm9h
SeM/P+Sd+Z5E2D/6QYCUH1TjP52lce3gVdg/Ow773ptp4z9cKBnVZHjYP7ym
8HOUlOM/2C1opGy92D/cDC6ZUp/jPzbvO5iuztg//HJrvhCq4z+VsA+M8N/Y
Pz0/5giNv+M/UzO3c3QC2T++19udherjP884BkN8R9k/vwjHx3ZA5D/FQ6Th
i9HZP8JqnRtZ7OQ/slngHqvl2j/1Jj0PrW3nP9lxpuLs694/PuJCx4p45z/+
HwKPYf3eP4adSH9og+c/Ic5dO9YO3z8WFFTvI5nnP2gqFZS/Md8/NgFrz5rE
5z/24oNFknffP3jbmI+IG+g/Cqow1JsB4D/8j/QPZMnoPykbDjdBjeA/REv6
x0HU6D868juN+5XgP4wGAIAf3+g/TMlp47We4D8dfQvw2vToP3B3xY8qsOA/
Pmoi0FEg6T+403zoE9PgP4YlKIgvK+k/yqqqPs7b4D/O4C1ADTbpP9uB2JSI
5OA/Xlc5sMhL6T//LzRB/fXgP39EUJA/d+k/RozrmeYY4T/I/1VIHYLpP1lj
GfCgIeE/ELtbAPuM6T9qOkdGWyrhPxcCRqkmj+k/OLOtlxks4T8oJvEr
                "]], 
               
               Line[{{0.8012755102040817, 0.5383186143416879}, {
                0.8024388112602567, 0.5389212822811081}, {0.8037652381656297, 
                0.5396084603470176}, {0.8064180919763757, 
                0.5409828164788363}, {0.8077445188817487, 
                0.5416699945447457}, {0.8090709457871217, 
                0.5423571726106551}, {0.8117237995978678, 
                0.5437315287424739}, {0.8170295072193599, 
                0.5464802410061115}, {0.8182677985372807, 
                0.547121758928761}, {0.8195060898552016, 
                0.5477632768514105}, {0.8219826724910432, 
                0.5490463126967093}, {0.8269358377627265, 
                0.5516123843873071}, {0.8368421683060933, 
                0.5567445277685028}, {0.8566548293928267, 
                0.567008814530894}, {0.8962801515662935, 
                0.5875373880556767}, {0.9739717509693491, 
                0.6277868452997498}, {0.9987244897959183, 
                0.6406104235338018}}], 
               
               Line[{{1.0012755102040816`, 0.6417848702389096}, {
                1.1369227129030104`, 0.696409886563032}, {1.1382548904425511`,
                 0.6969463533562733}, {1.1395870679820916`, 
                0.6974828201495145}, {1.142251423061173, 0.698555753735997}, {
                1.147580133219336, 0.700701620908962}, {1.158237553535662, 
                0.7049933552548922}, {1.1795523941683133`, 
                0.7135768239467521}, {1.180884571707854, 
                0.7141132907399934}, {1.1822167492473947`, 
                0.7146497575332347}, {1.1848811043264762`, 
                0.7157226911197172}, {1.190209814484639, 
                0.7178685582926821}, {1.1915419920241797`, 
                0.7184050250859234}, {1.1928741695637202`, 
                0.7189414918791646}, {1.1955385246428016`, 
                0.7200144254656471}, {1.1968707021823424`, 
                0.7205508922588884}, {1.198202879721883, 
                0.7210873590521296}, {1.1987244897959184`, 
                0.7212974109974857}}], 
               
               Line[{{1.2012755102040815`, 0.7221719989693745}, {
                1.2021994123405053`, 0.7224334427607003}, {1.203531589880046, 
                0.7228104194262212}, {1.2061959449591275`, 
                0.7235643727572629}, {1.2115246551172902`, 
                0.7250722794193464}, {1.222182075433616, 
                0.7280880927435135}, {1.2234898928959086`, 
                0.7284581760480369}, {1.224797710358201, 
                0.7288282593525602}, {1.2274133452827862`, 
                0.729568425961607}, {1.2326446151319568`, 
                0.7310487591797005}, {1.2431071548302977`, 
                0.7340094256158874}, {1.2640322342269796`, 
                0.7399307584882616}, {1.3058823930203434`, 
                0.7517734242330097}, {1.3839420330101317`, 
                0.7738625692018223}, {1.3987244897959183`, 
                0.7780456762591846}}], 
               
               Line[{{1.4012755102040815`, 0.7787425701669435}, {
                1.547629076117258, 0.8172902007187379}, {1.5987244897959185`, 
                0.8307480697982284}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T9aFQKMrJrqP/tq1Jsp
evs/NdKBLRl46z9UNl2RLn/7P5ida75veus/rAHmhjOE+z/7aFVPxnzrP16Y
93E9jvs/wv8ocXOB6z/BxRpIUaL7P04t0LTNius/hyBh9HjK+z9oiB48gp3r
PxPW7UzIGvw/mz67SuvC6z9soXZCzR/8P/4JpdtBxes/xGz/N9Ik/D9h1Y5s
mMfrP3YDESPcLvw/KGxijkXM6z/ZMDT570L8P7SZCdKf1es/n4t6pRdr/D/O
9FdZVOjrP/hWA5sccPw/McBB6qrq6z9QIoyQIXX8P5SLK3sB7es/Armdeyt/
/D9aIv+crvHrP2XmwFE/k/w/50+m4Aj76z++sUlHRJj8P0obkHFf/es/Fn3S
PEmd/D+t5nkCtv/rP8gT5CdTp/w/dH1NJGME7D8rQQf+Zrv8PwGr9Ge9Dew/
sKqrJ9jA/D+JfUVgRhDsPzQUUFFJxvw/EVCWWM8S7D8MAaNUk8f8P+nVBxNp
E+w/4izGQw==
                "]], 
               Line[CompressedData["
1:eJwVkH0s1HEAh+9ysRRC0hoL44rKrrAI+1iJ6RTX8rLIu5zF1LGVssyqVSY3
0XY5u1r9k7e8TIpVLunaWq5285JzToiR7w+n0Pj5fdMfz56/nn8e17S8M5mb
eDyecIP/Llcsh5rrWETMPh/JdiRQRwdrawZYKFv0TZ93EZzoHFuxMrAoMBZ5
5+4mOH3fS7wwxULo/35/qzOBbllbkEpY0Iz0urN7COJS8lU6E4vvFZs9V1wI
UnzemNpYFqWzEcIgdwLZ0ClFod065lQ6F40XQcflqsNl2eu4kbNkORdKEP7U
NavFkYPKInA0uJDAV2Et1DhxcGpere65RuBSvvZT78pBGd8ZKy4iWC3sTxMc
4KCoDdDGFxM0Su4lxYVwqBT7v82/TWDPN8WsSznclfspaysIRpPVoRGdHGSO
ojiHOoIvMY1mSV0cFrrm7WrqCV6Lq7tlPRzypE1at0aCB0cKQmq0HHI6vMNE
zRs/bPYFzY9zyEo46CduJ6h/J/d5uJUi8bGXfUk3wRXnZLexRIqwvR5fiZ4g
LVoUa0ilcE99ZLxo2Ph3k186eIHCTGk192uEQDjzzNR7iUJtvbxt5gdBX9u0
uvMWReCy5uTkFIEoUpZc1UAh+ijVjCwSOBUfr5S3UNhQQ3/iHwKL1h2fStsp
GH/J5PASgdHxlXeJmqK+IUCg/0tQNrG2nttH4VFleWyAI7i6s/dQ9hCFQHtD
EsNjkB6hyswwUkxY/E7p4zM42hTSe26a4sn14WKdgIFw3JYfy1AUv4ySS8wZ
2DpM+EoWKc7Pf1B9s2DAhrdJI1cogjz9X0RtYQDfgTua1Y2+ZXB7giWDf7+e
ROs=
                "]], 
               
               Line[{{2.001275510204082, 0.9078250912903253}, {
                2.0039562426140143`, 0.9080760087775415}, {2.008820753763886, 
                0.9085313287153831}, {2.0185497760636295`, 
                0.9094419685910666}, {2.0380078206631165`, 
                0.9112632483424334}, {2.0393271393937447`, 
                0.9113867370351131}, {2.0406464581243724`, 
                0.9115102257277926}, {2.0432850955856283`, 
                0.9117572031131518}, {2.0485623705081406`, 
                0.9122511578838702}, {2.0591169203531647`, 
                0.9132390674253069}, {2.080226020043213, 
                0.9152148865081804}, {2.122444219423309, 
                0.9191665246739273}, {2.1987244897959184`, 
                0.926306384547724}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAe3+uVTacAUC4b+4ZH6btP2s0u9kJ
SwJA3C43gnHe7T/A0NWsuE0CQK4bj8ZO3+0/FW3wf2dQAkB/COcKLODtP7+l
JSbFVQJAI+KWk+bh7T8TF5BygGACQGqV9qRb5e0/u/lkC/d1AkD3+7XHRezt
Pwu/Dj3koAJAE8k0DRr67T9gWykQk6MCQOW1jFH3+u0/tfdD40GmAkC2ouSV
1PvtP18weYmfqwJAWnyUHo/97T+zoePVWrYCQKEv9C8EAe4/W4S4btHLAkAu
lrNS7gfuP6tJYqC+9gJASmMymMIV7j80LCE+P/kCQGUfmvmQFu4/vg7g27/7
AkCB2wFbXxfuP9DTXRfBAANAuVPRHfwY7j/0XVmOwwoDQCdEcKM1HO4/PnJQ
fMgeA0AFJa6uqCLuP1JNHneWMANAWmP8E2Uo7j8j+5YQ
                "]], 
               
               Line[{{2.4012755102040817`, 0.9426087043437312}, {
                2.412024645029292, 0.9432404558463012}, {2.414468401872563, 
                0.9433840810852396}, {2.419355915559106, 
                0.9436713315631166}, {2.429130942932191, 
                0.9442458325188704}, {2.4486809976783612`, 
                0.945394834430378}, {2.5334854370252864`, 
                0.950378987374146}, {2.5987244897959183`, 
                0.9542132373193071}}], 
               Line[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAArrLhiGnPBEAjokhyKoruPyHdStij
hQVA8h8Nnpe27j+KwjuvVYgFQM0+Nsw/t+4/8qcshgeLBUCnXV/657fuP8Jy
DjRrkAVAW5uxVji57j9kCNKPMpsFQMUWVg/Zu+4/qDNZR8GwBUCXDZ+AGsHu
Py6KZ7be2wVAO/swY53L7j+Wb1iNkN4FQBUaWpFFzO4//1RJZELhBUDvOIO/
7czuP9AfKxKm5gVApHbVGz7O7j9xte5tbfEFQA3yedTe0O4/tOB1JfwGBkDf
6MJFINbuPzo3hJQZMgZAg9ZUKKPg7j/WYhk2nTQGQC3siRJA4e4/c46u1yA3
BkDYAb/83OHuP6zl2BooPAZALS0p0Rbj7j8elC2hNkYGQNeD/XmK5e4/ur/C
QrpIBkCBmTJkJ+buP1frV+Q9SwZALK9nTsTm7j+QQoInRVAGQIDa0SL+5+4/
AvHWrVNaBkAqMabLceruP54cbE/XXAZA1UbbtQ7r7j87SAHxWl8GQH9cEKCr
6+4/2HOWkt5hBkAqckWKSOzuP4WAUarJYwZAgVpFRMDs7j/XLcd6
                "]], 
               
               Line[{{2.8012755102040816`, 0.9665279912574518}, {
                2.8039259500890124`, 0.966631839576844}, {2.8051535791448154`,
                 0.9666799399751993}, {2.806381208200619, 
                0.9667280403735548}, {2.8088364663122256`, 
                0.9668242411702654}, {2.8137469825354393`, 
                0.967016642763687}, {2.814974611591243, 0.9670647431620424}, {
                2.816202240647046, 0.9671128435603977}, {2.818657498758653, 
                0.9672090443571085}, {2.8235680149818663`, 
                0.96740144595053}, {2.833389047428293, 0.967786249137373}, {
                2.853031112321146, 0.968555855511059}, {2.9382035922548035`, 
                0.9718930445376281}, {2.998724489795918, 
                0.9742643465745024}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAA4eUUvJwCCEDHrXo3+C3vPxPetaIC
xAhAXutjoZhK7z+ODH19t8YIQDS/qS//Su8/CjtEWGzJCEAKk++9ZUvvPwKY
0g3WzghAtzp72jJM7z/yUe94qdkIQA+KkhPNTe8/0MUoT1DvCEDAKMGFAVHv
P4ytm/udGglAImYeampX7z8I3GLWUh0JQPk5ZPjQV+8/hAoqsQcgCUDPDaqG
N1jvP3tnuGZxJQlAe7U1owRZ7z9qIdXRRDAJQNQETdyeWu8/SJUOqOtFCUCF
o3tO013vPwV9gVQ5cQlA5+DYMjxk7z+08ez5v3MJQE74JeqbZO8/ZGZYn0Z2
CUC0D3Oh+2TvP8RPL+pTewlAgj4NELtl7z+EIt1/boUJQB2cQe05Z+8/NJdI
JfWHCUCEs46kmWfvP+QLtMp7iglA68rbW/ln7z9E9YoViY8JQLn5dcq4aO8/
9Gn2ug+SCUAgEcOBGGnvP6TeYWCWlAlAhigQOXhp7z+5s4Td/JYJQLcd1C3T
ae8//mW0IQ==
                "]], 
               Line[CompressedData["
1:eJwVx2tIk1EcgPFpSLzn1aJ5mSnTlmT74GUS6Bft/EWtoAtOuoi6WcYCdTqV
NnOCTsWtbJmrobU0S8FleSENU0LR4bykDS94obBS01S0o2MSpESnDw8PP0Ga
IkHmzOFwhLT/LyxuuxJey0DhzMdwVQbBg6ZV6GtkwJEavxCSSXBZlnF2vpWB
REX900A5wc7u206HLAwIKqO4XtkEd+iSzcZBBv6IxU6XqdP2hy74DjMw7Snb
NlBbVupqhOMMlNfpbW4Kgku7zwfHzDKw0fKlwiWHYCepOfHOBgOdYwUHdnMJ
5jRL25e4COKYLse0kuChzbnsek8E0vRLXJ6KYL1IHJLijUA1uhqaRM3rjmmd
4SN4dY+X+Z06ZFj4ZkSIgEUFi5v5BKes2JvaTiOYRJE2FzXBPQLdc3UGAomr
xRxRRHCRjCONyEKglCdZ1dSxzQV8hwJB5bh9qZd6QiSvzVIi6NcH+MUWE7yG
xabrGgQBbuXGeA3BXlLf6jPVCNbczpWklxKcZ2p/wLUguH3YlvRMS/D7fZPO
MoggPwfwAvW+VFuSN4xAPdkR4K8jWBcgUU6NI9A8rtlsoK5tQZJHcwj0vBtF
r+8SbO2TBXG3EDT6O172VBCMBOJAC0HQpLml3aOOL4s8lmdH0Lw4nxF1n+DP
Z909pn4jaG/sPTVA/Wuif8/gzMKHkzrriJ5g72XfsSPeLEyH+qzPVRIsiTto
HfBhYbZK/+noQ4IbzPa+XD4L8zt/3yZTB8lHOyaPs/C1c1n9jTrX9q6l5AQL
ix5XUwVVBHeJXjSFCVn4oRyJuUkdvasyGYJZ2Ihodf1Jrb2WZowWsbD1xH9H
aCA44aJffjX1Oj+bG0b9D+uTLCo=
                "]], 
               Line[CompressedData["
1:eJwVzX0s1HEcB/BLku37LZ0zOVnXFbfCLXPk8fp9PLScwk6raGmlFGqeSnPl
qbMayubxFLYkDylWOkM4uWokmcceNmaWHtzEjynpWPr44733Xnv/8RaGxwZH
GHA4HFvMWpvx/dh+ZwK9Cp1Kmccyx1KtlXJXAs3PLUML0KUTJsnrPNDLKnkV
esJ7ObFBSqDFl+ffjI7eOBTF9SHQ+pF4jKKfRmnOag8QaBNkSmbQv3ofhcX7
oSMN7VfRablp8sEAAhr9itWufJYp5Ivd8kIIdG6f/ReN1thlGnNjCHSfH3il
R+8b2dqXH0dg7k/ALVLAMs+Sa/LMLhPgZ/XKrNAVfV2WFkkELj3pGpCiM2M3
iAVKAqZz7ePp6GC1Ui5WEQhT1OqNClnmh3tKiayDwMJtpSOviGW4/gn2ys0U
djQ4VdgVs0y51oS4cyk8OKrol6Id3Op18zwKQr1mJQgduHuq+gyfwk6fg8ev
oLONTgm9rCnYfAilGrTha5k5x53Cnr+pVwPvssyih5CTGkHB0avHP/4ey9xU
d4w7R1JQf9uUlIE2szupmYmmIMkOripCSyyLr4XFUXAaHl19gY5bor89r1Nw
iZhtNChhGV3jkm45l4JHFk9QiE6yV71VF1BoF4ccrkYbV0pqLqooeA6VKVrQ
ooKYc6OlFKTbRCNj6PD4r+Ot1RSg3jXLppRl5qduaBJqKXTKU5pc0OmnBWW2
dRS8FrWTMvT9oBOhJQ0UvJlD+2PQY+KBYUU7Bd/BsIWmtX2am7L+JYUZzcPp
bnR47RFRjpaC6rFu8jNadKGo3/wN/hXvHdOhddafksq7KOgyEkf06LovFjtt
eyjkx7W9J2Us8/N78xaHdxTu5PhWmqL/A0MJO48=
                "]], 
               Line[CompressedData["
1:eJwV0H8s1HEcx/HT5Ud338+HC6tEhEg5VpmGuc87rCgj1MhE52pXW8vPmpSy
blpi65/iukqrf46Tu/Mr153JjsKyZXJaVNKOXLLPRm3Ijz798dpzj39fO3Pz
Us9t4PF4AWz/q22ZvHPhPQedHZWKjMeUlNVK88csHOTf9DZ+Yt7oOmWeG+NA
LuypIk8oEQl+yd2mODjpJwgV1lEy0icW1f3g4LhtfIuEWVmRZwz8yUGirolX
wLzDboGLohzERqUMjzIHLy41S5c42JemvPz8KSWHpx1XtAgBpwjojHhGib6O
+FuzEVyLyRmtUVOyULrgKJUi8H6x3NXPHJ6unv0iQ9DjXqNeZjY5O7d+PI9A
YBssya6n5G3510PvChGo7kVuD2igZDy3LKflNgLDZ/cz7RpKHAJNqnItgj9X
Bm0fmihJ4OfdWNUjePhNPmyvpaR6wje3tBVB9FG+6SCzSHk3qNiAoMIrsvoR
s+emTIPcjMCtVx0i01Gyf3bRkjSK4IBIUTSvp+S0LlzktYYgvzFi1aWNkpeZ
i3iIh2Fb8h6/I8zYwcgp+BjM8x4JZczdWdFONicM7pEr923MvoK49TZXDMb+
rmBzOyXTZ1PmEoMw2E/HZhV1UCJxcZ1d34tBWxl2q4G51jQy0xKCIV28q36C
OX5zhnVrGAZNscPvYwZKNK+zx60SDMn8gSr/V5Rc8rg4cP0EBpVPksliZH+9
EfeFpmOI7ZVMCk2UeBfQ3u+nMMzJQx1jmEs8m80PsjDUCH3EJcxDfYXd8TkY
iM4lTcu8uyis668Uw0yq3VUrc0V5imZAhmFtXtXo1EnJP59HHiY=
                "]], 
               Line[CompressedData["
1:eJwVzn8s1HEcx/HzY+Tk85kb1Vq3cv3CcpqNMuX7zvphzo/OLEvpRD/QGRXl
UGid2i0dS1SHZceNK1TOVPuGITqt2nVEJURdUvbVlliS3v3x2nOP/15u8amR
R615PN5G3P/uCc0W2SQREAtHVeEsx6jWBDT3yAloBmbY4+jx538eZKUSOJ+g
MSrQJaK8htF0AruyLWMV6NlXBTV3cwmY9DmuFvTe7GCt7AIBg59INIeu3cCv
EigJlHX0iPlPOCbmXGF5popA7DtBsBjNepZc23mdwKRDXdYZdJ6yKn9IT8Am
qX/ErpVjnM7ahxyuJ0C257QsR99KTBFYGgmsdF6rdkc3Sfy1nIGAz6O0wBC0
xdnUZd1GIM5haUUhWlLJW+JhJtBaFxTj0sYxy1pkVzPmCSgmG/vc2jmmfkKo
IaEUpk+ojNs6OOZyhTJuOJyCMEJbGoE+Ejm1vkFKQeLDJsSjV7HsvbBoCrq5
qYVLaJX6QPeVeAoHlVIfMzrR7+YPvoLCs8oVmqROjhFddAm211G4bdLJS7s4
5u/WHKeBWgovDW3+dei3U+OvdXcozJcN2rHoouim2N33Kew7xK/6iF70jDyt
ZCk4fUvp3/SUY4ZM6kobMwWFrW9gJ/phwWyCuR//fAlzfIMuCZB5aAcp9PUe
G5xAS2rEhqBhCt7FN06Rbo55nPnCmP+VwmfhH91+dKmXr1r6nYLAyjVdjj45
Vh7lxlGAT147ctHuofKR9p8UNHrZ+2q0rVVfddEsBWNhZm0LerQ5IDnuN4Vf
acUZvWg2Weu9eYHCuih90Ad02WrHmcVFCtItnXQa/Q9bvDL2
                "]]}, "Charting`Private`Tag$72657#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT5zJlrO7yojPgRDGnDf
GVQ/dDkOaSyVAT8zn5icsxlkP8CcLhMGlRE/S83Xsp0ZdD9mzj7o8pQhP1dk
972SGYQ/OefGUumUMT/dL4dDjRmUP6LzCojklEE/oBVPhooZpD/X+awi4pRR
P4EIsyeJGbQ/8fz97+CUYT8qR5GIsnC0P6OYQ8oe4WE/0oVv6dvHtD9TNImk
XC1iPyQDLKsudrU/t2sUWdjFYj/G/aQu1NK2P3vaKsLP9mM/DPOWNR+MuT8G
uFeUvlhmP5jdekO1/r4/HHOxOJwcaz9BHFmk3lW/P80O9xLaaGs/6lo3BQit
vz9/qjztF7VrPx7seWOtLcA/4uHHoZNNbD9vaTYlANzAP6ZQ3gqLfm0/EmSv
qKU4wj8xLgvdeeBvP1hZoa/w8cQ/o3SywCtScj/v21QKohrFP6aGtfjDdXI/
hl4IZVNDxT+pmLgwXJlyP7Njbxq2lMU/rby+oIzgcj8Obj2FezfGP7cEy4Dt
bnM/pfDw3yxgxj+5Fs64hZJzPzxzpDreiMY/vCjR8B22cz9qeAvwQNrGP8FM
12BO/XM/xYLZWgZ9xz/LlONAr4t0P1wFjbW3pcc/zabmeEevdD/yh0AQac7H
P8+46bDf0nQ/II2nxcsfyD/U3O8gEBp1P7cPWyB9SMg/1+7yWKg9dT9Okg57
LnHIP9oA9pBAYXU/fJd1MJHCyD/fJPwAcah1PxMaKYtC68g/4Tb/OAnMdT+q
nNzl8xPJP+RIAnGh73U/QB+QQKU8yT/mWgWpORN2P9ehQ5tWZck/6GwI4dE2
dj+QO0vYzW/JP4vmInP5P3Y/VDcvbw==
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAApPfnWmXDyT/Ob0X5+Nd6PzKsEQYc
CMo/TiKth54UgT/JLsVgzTDKP/j63EVNP4M/YLF4u35Zyj+g0wwE/GmFP422
33Dhqso/5IRsgFm/iT/owK3bpk3LP73zlTwKNZE/ntVJsTGTzD9TVlU1xd+Z
Pwv/gVxHHs8/ww1qk52apT+YaVdeLEbPP1EBDuaQIqY/JNQsYBFuzz/b9LE4
hKqmPz6p12Pbvc8/99v53Wq6pz+5qZa1ty7QPy6qiSg42qk/7VPsvEvO0D+b
Rqm90hmuP1Wol8tzDdI/uz/084NMsz8lUe7ow4vUP5Z4Mx65y7s/Gn9HOmeh
1D86uh+zdRW8PxCtoIsKt9Q/4fsLSDJfvD/6CFMuUeLUPyh/5HGr8rw/0MC3
c9441T++hZXFnRm+P3owgf745dU/ccl7NsEzwD/ODxQULkDXP5XW3d2lgcI/
wz1tZdFV1z9n91MohKbCP7hrxrZ0a9c/ORjKcmLLwj+jx3hZu5bXP95Ztgcf
FcM/eH/dnkjt1z8n3Y4xmKjDPyLvpiljmtg/uuM/hYrPxD8XHQB7BrDYP4sE
ts9o9MQ/DEtZzKnF2D9dJSwaRxnFP/emC2/w8Ng/A2cYrwNjxT/s1GTAkwbZ
P9WHjvnhh8U/4gK+ETcc2T+oqAREwKzFP8xecLR9R9k/TOrw2Hz2xT/CjMkF
IV3ZPx8LZyNbG8Y/t7oiV8Ry2T/xK91tOUDGP5Vq8rizhNk/LWb7jshexj+e
3R4z
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAn8hAen+u2T/om3bIFrTGP4xyh5xR
ydk/Nc9JW9/zxj93zjk/mPTZPypRytDJWsc/Di615ckI2j/OblPtz4rHP6SN
MIz7HNo/b4zcCda6xz/RTCfZXkXaP7TH7kLiGsg/K8sUcyWW2j8/PhO1+trI
P9/H76ayN9s/UytcmStbyj9HwaUOzXrcP3wF7mGNW80/F7QR3gEB3z/n3Ih5
KK7RP1yM+1TkFt8/PrzVLC7I0T+iZOXLxizfP5WbIuAz4tE/LBW5uYtY3z9B
WrxGPxbSP0J2YJUVsN8/nNfvE1Z+0j82nFemlC/gP1DSVq6DTtM/YV6mXaje
4D+5xyTj3u7UP4RKG5mZ6eA/EKdxluQI1T+mNpDUivTgP2WGvknqItU/7A56
S20K4T8URViw9VbVP3a/TTkyNuE/bMKLfQy/1T+MIPUUvI3hPyK98hc6j9Y/
tuJDzM884j+JssBMlS/YP9ZIgfGNR+I/mUtTgiFJ2D/2rr4WTFLiP6nk5bet
Ytg/N3s5Ychn4j/MFgsjxpXYP7gTL/bAkuI/DntV+fb72D/YeWwbf53iPx4U
6C6DFdk/+N+pQD2o4j8urXpkDy/ZPzisJIu5veI/Tt+fzydi2T+5RBogsuji
P5FD6qVYyNk/2qpXRXDz4j+k3Hzb5OHZP/oQlWou/uI/tHUPEXH72T863Q+1
qhPjP9SnNHyJLto/WkNN2mge4z/kQMexFUjaP7Cb30LAKOM/tiLjlK1g2j87
jiLR
                "]], 
               Line[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAtsqGI6Y94z+/KHZnPIraP9rbQm9h
SeM/kF/l8P6c2j/6QYCUH1TjP8zp/Kosrto/Ow773ptp4z9E/isfiNDaP7ym
8HOUlOM/MyeKBz8V2z/cDC6ZUp/jP26xocFsJts//HJrvhCq4z+qO7l7mjfb
Pz0/5giNv+M/IlDo7/VZ2z++19udherjPxF5Rtisnts/vwjHx3ZA5D/tygKp
GijcP8JqnRtZ7OQ/p257SvY63T/1Jj0PrW3nP6vjPk9AnuA/PuJCx4p45z9M
19Vq8KbgP4adSH9og+c/7MpshqCv4D8WFFTvI5nnPyyymr0AweA/NgFrz5rE
5z+tgPYrwePgP3jbmI+IG+g/sB2uCEIp4T/Alp5HZiboP1ARRSTyMeE/CFKk
/0Mx6D/wBNw/ojrhP5nIr2//Rug/MuwJdwJM4T+6tcZPdnLoP7O6ZeXCbuE/
/I/0D2TJ6D+2Vx3CQ7ThP0RL+sdB1Og/V0u03fO84T+MBgCAH9/oP/c+S/mj
xeE/HX0L8Nr06D84JnkwBNfhPz5qItBRIOk/uvTUnsT54T+GJSiILyvpP1ro
a7p0AuI/zuAtQA026T/62wLWJAviP15XObDIS+k/OsMwDYUc4j9/RFCQP3fp
P7yRjHtFP+I/yP9VSB2C6T9dhSOX9UfiPxC7WwD7jOk//Xi6sqVQ4j8XAkap
Jo/pPwH9DflhUuI/SBwREw==
                "]], 
               Line[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAHTHtiQyk6T80xuhJvF/iP+jsbCiU
rek/QI4ATktk4j8wqHLgcbjpP27Tq/d9aeI/wB5+UC3O6T/JXQJL43PiPwja
gwgL2ek/9qKt9BV54j9QlYnA6OPpPyToWJ5IfuI/4QuVMKT56T9/cq/xrYji
PwL5qxAbJeo/NodcmHid4j8bzULzPy/qP7V1RNdSouI/NKHZ1WQ56j81ZCwW
LafiP2VJB5uuTeo/M0H8k+Gw4j/ImWIlQnbqPzD7m49KxOI/jzoZOmnH6j8r
b9uGHOviPxx8hmO3aes/IVdadcA44z82/2C2U67sPwsnWFII1OM/TE3AgkW4
7D9E2ychytjjP2ObH083wuw/fo/374vd4z+QN97nGtbsP/H3lo0P5+M/6W9b
GeL97D/WyNXIFvrjP5zgVXxwTe0/oWpTPyUg5D8BwkpCjeztPzauTixCbOQ/
GBCqDn/27T9wYh77A3HkPy5eCdtwAO4/qRbuycV15D9a+sdzVBTuPxt/jWdJ
f+Q/tDJFpRs87j8BUMyiUJLkP2ajPwiqi+4/y/FJGV+45D/MhDTOxirvP2E1
RQZ8BOU/Og/LApE17z8l6FJapQnlP6iZYTdbQO8/6Zpgrs4O5T+Dro6g71Xv
P3EAfFYhGeU/OtjochiB7z+By7Kmxi3lP6hif6fii+8/RX7A+u8y5T8W7RXc
rJbvPwkxzk4ZOOU/8QFDRUGs7z+Qlun2a0LlP6grnRdq1+8/oGEgRxFX5T8W
tjNMNOLvP2QULps6XOU/hEDKgP7s7z8oxzvvY2HlP31orA+N9e8/k1NIz3tl
5T9daDG4
                "]], 
               
               Line[{{1.0012755102040816`, 0.6697073590256148}, {
                1.0029484390136711`, 0.670309460966196}, {1.0055826833813366`,
                 0.6712575489162897}, {1.0161196608519991`, 
                0.6750499007166648}, {1.017436783035832, 
                0.6755239446917117}, {1.0187539052196648`, 
                0.6759979886667586}, {1.0213881495873305`, 
                0.6769460766168525}, {1.0266566383226616`, 
                0.67884225251704}, {1.0371936157933241`, 
                0.6826346043174151}, {1.0582675707346494`, 
                0.6902193079181654}, {1.1369227129030104`, 
                0.7185279923432247}, {1.1987244897959184`, 
                0.7407710008832691}}], 
               
               Line[{{1.2012755102040815`, 0.7416164985356329}, {
                1.3058823930203434`, 0.7733083331929514}, {
                1.3839420330101317`, 0.7969573812991971}, {
                1.3987244897959183`, 0.8014358932639116}}], 
               Line[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJzKQ3p9r9j/ji7rTN6vpP4IILFOG
ifc/i1CJvWY+6j8O0KzBo5P3P9nF2subQ+o/Jl+unt6n9z92sH3oBU7qP1Z9
sVhU0Pc/sIXDIdpi6j+1ubfMPyH4PyMwT5SCjOo/eh34g04m+D/K6ncbHY/q
P0CBODtdK/g/caWgoreR6j/MSLmpejX4P8Aa8rDsluo/5Ne6hrVJ+D9dBZXN
VqHqPxT2vUArcvg/l9raBiu26j90MsS0FsP4PwuFZnnT3+o/ZjQgoJHI+D+M
dMC0peLqP1g2fIsMzvg/DmQa8Hfl6j87OjRiAtn4PxFDzmYc6+o/AkKkD+7u
+D8YATZUZfbqP49RhGrFGvk/JX0FL/cM6z+AU+BVQCD5P6dsX2rJD+s/clU8
Qbsl+T8oXLmlmxLrP1ZZ9BexMPk/LDttHEAY6z8cYWTFnEb5PzL51AmJI+s/
qnBEIHRy+T9AdaTkGjrrP5xyoAvvd/k/wmT+H+086z+NdPz2aX35P0NUWFu/
P+s/cHi0zV+I+T9GMwzSY0XrP2J6ELnajfk/yCJmDTZI6z9UfGykVZP5P0oS
wEgIS+s/2c1vIWCU+T9e5Vx5kUvrP7QI4WI=
                "]], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAW2XDEdOe+T+x4EuztU/rPyiCgGbG
o/k/45Wr5RVR6z8ahNxRQan5P9icRsabUus//oeUKDe0+T/BqnyHp1XrP8SP
BNYiyvk/ksboCb9b6z+2kWDBnc/5P4fNg+pEXes/qJO8rBjV+T981B7Lyl7r
P4uXdIMO4Pk/ZOJUjNZh6z9Sn+Qw+vX5Pzb+wA7uZ+s/367Ei9Eh+j/aNZkT
HXTrP9DtBOwyJ/o/sB/12pt16z/ALEVMlCz6P4YJUaIad+s/oKrFDFc3+j8z
3QgxGHrrP2Kmxo3cTPo/jIR4ThOA6z/mnciP53f6Pz/TV4kJjOs/7YzMk/3N
+j+lcBb/9aPrP/tq1Jspevs/cKuT6s7T6z8rQQf+Zrv8P5wjiAoVLew/DAGj
VJPH/D8BgMUVdzDsPymtpgc=
                "]], 
               Line[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAjpj2RAbS/D8YTOu9cDPsPyCO++Ta
If4/YWBT7luV7D/6edViBCz+P5N60nNSmOw/rVGJXldA/j/5rtB+P57sPxMB
8VX9aP4/wxfNlBmq7D/fX8BESbr+P1jpxcDNwew/zFWtA16//j9xdoUDScPs
P7hLmsJyxP4/igNFRsTE7D+SN3RAnM7+P70dxMu6x+w/RQ8oPO/i/j8iUsLW
p83sP6u+jzOVC/8/7Lq+7IHZ7D93HV8i4Vz/P4GMtxg28ew/YlAwVtxh/z/w
jdjoqfLsP06DAYrXZv8/YI/5uB307D8m6aPxzXD/Pz6SO1kF9+w/1LTowLqE
/z/7l7+Z1PzsPzBMcl+UrP8/daPHGnMI7T8cf0OTj7H/P+Sk6OrmCe0/B7IU
x4q2/z9Upgm7WgvtP94Xty6BwP8/MqlLW0IO7T+M4/v9bdT/P++uz5sRFO0/
eBbNMWnZ/z9esPBrhRXtP2NJnmVk3v8/zbERPPkW7T86r0DNWuj/P6y0U9zg
Ge0/JuIRAVbt/z8btnSsVBvtPxEV4zRR8v8/ireVfMgc7T/8R7RoTPf/P/m4
tkw8Hu0/PzTWh8b6/z904n/VPx/tP8ZJ9Wo=
                "]], 
               
               Line[{{2.001275510204082, 0.9103638835944402}, {
                2.0039562426140143`, 0.9106020352208352}, {2.008820753763886, 
                0.9110341899699126}, {2.0185497760636295`, 
                0.9118984994680674}, {2.0380078206631165`, 
                0.9136271184643773}, {2.0393271393937447`, 
                0.9137443244563921}, {2.0406464581243724`, 
                0.9138615304484068}, {2.0432850955856283`, 
                0.9140959424324364}, {2.0485623705081406`, 
                0.9145647664004956}, {2.0591169203531647`, 
                0.915502414336614}, {2.080226020043213, 0.9173777102088505}, {
                2.122444219423309, 0.9211283019533237}, {2.1987244897959184`, 
                0.9279049091162662}}], 
               Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAe3+uVTacAUCbjEuhLrPtP2s0u9kJ
SwJAhQ49QYfs7T/A0NWsuE0CQJuUu4to7e0/FW3wf2dQAkCxGjrWSe7tP7+l
JSbFVQJA3SY3awzw7T8TF5BygGACQDU/MZWR8+0/u/lkC/d1AkDmbyXpm/rt
Pwu/Dj3koAJARtENkbAI7j9gWykQk6MCQFxXjNuRCe4/tfdD40GmAkBz3Qom
cwruP18weYmfqwJAn+kHuzUM7j+zoePVWrYCQPcBAuW6D+4/W4S4btHLAkCn
MvY4xRbuP6tJYqC+9gJACJTe4Nkk7j80LCE+P/kCQLdbHgOsJe4/vg7g27/7
AkBmI14lfibuP9DTXRfBAANAxLLdaSIo7j/0XVmOwwoDQIDR3PJqK+4/fUAY
LEQNA0AvmRwVPSzuPwYj18nEDwNA3mBcNw8t7j8Z6FQFxhQDQDzw23uzLu4/
PnJQfMgeA0D5DtsE/DHuP8dUDxpJIQNAqNYaJ84y7j9QN863ySMDQFeeWkmg
M+4/YvxL88ooA0C1LdqNRDXuP+veCpFLKwNAZPUZsBY27j90wckuzC0DQBO9
WdLoNu4//qOIzEwwA0DChJn0ujfuP1JNHneWMANALyGPHtM37j/hL86W
                "]], 
               
               Line[{{2.4012755102040817`, 0.9444888661614991}, {
                2.4046933744994785`, 0.9446757197904045}, {2.409580888186021, 
                0.9449429187163203}, {2.4108027666076564`, 
                0.9450097184477992}, {2.412024645029292, 
                0.9450765181792782}, {2.414468401872563, 
                0.9452101176422361}, {2.419355915559106, 
                0.9454773165681518}, {2.429130942932191, 
                0.9460117144199833}, {2.4486809976783612`, 
                0.9470805101236465}, {2.5334854370252864`, 
                0.9517167437098109}, {2.53472237080263, 0.951784366513128}, {
                2.5359593045799738`, 0.9518519893164453}, {
                2.5384331721346607`, 0.9519872349230797}, {
                2.5433809072440345`, 0.9522577261363484}, {2.553276377462783, 
                0.9527987085628858}, {2.5730673179002794`, 
                0.9538806734159608}, {2.5987244897959183`, 
                0.9552833434056996}}], 
               Line[{{2.601275510204082, 0.955408279484915}, {
                2.6150743461754633`, 0.9560054956203506}, {
                2.6174994935756546`, 0.9561104564417712}, {
                2.6223497883760363`, 0.9563203780846123}, {
                2.6320503779767996`, 0.9567402213702946}, {
                2.6514515571783264`, 0.957579907941659}, {2.6902539155813803`,
                 0.9592592810843881}, {2.774462852749733, 
                0.9629038592306265}, {2.798724489795918, 
                0.9639539073032405}}], 
               Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAR0x7IgNpBkAe++Lfu9nuP/XKjeJw
gQdATzapxQ4X7z/cC9Vo/IMHQClXKT+dF+8/wkwc74eGB0ADeKm4KxjvP5DO
qvueiwdAuLmpq0gZ7z8q0scUzZUHQCI9qpGCG+8/XtkBRymqB0D1Q6td9h/v
P0QaSc20rAdAz2Qr14Qg7z8rW5BTQK8HQKmFq1ATIe8/+NweYFe0B0Bex6tD
MCLvP5LgO3mFvgdAx0qsKWok7z/G53Wr4dIHQJpRrfXdKO8/rCi9MW3VB0B0
ci1vbCnvP5NpBLj41wdAT5Ot6Pop7z9g65LED90HQATVrdsXK+8/+u6v3T3n
B0BtWK7BUS3vP+Av92PJ6QdAR3kuO+At7z/HcD7qVOwHQCKarrRuLu8/lPLM
9mvxB0DW266niy/vP3szFH338wdAsfwuIRow7z9idFsDg/YHQIsdr5qoMO8/
L/bpD5r7B0BAX6+NxTHvPx8a60Nj/QdAgLO6iCky7z+nOrBK
                "]], 
               Line[CompressedData["
1:eJwVx2tIE1AYgOGxks5Zq1EZQhQ0mzYl1Mih0+h8pYvVtOXchhEstW2VRqFZ
WmOKsRTtBpGb3ViE5OYFDY0sopFupgbmhUxLDTWlUjnZmtIy7fTj5eURZp5V
GbgcDieY9f9jk4Ev73MRCC/iRd4uShrjDjWkIgQpXS5ZC7PNVCH5zEPQURKX
GxBNif7vtn3zAgTNy5Fv7cyVK3V5KhEC40RAJI6hZOl4kKQ3FEFhduygmlnf
1uNThiGwerOKHzJHXU7IT45A4FnR0x8TS0nHsviSPBaBSHS3wCilZMHvLdqT
hGBcH9HaFk+Jdq7sangeAt2UVlMIlGwYffqI60ag+VZt8h6g5AbfbH7WjqAI
nbwuO0gJLz4x7XQnAud2sd3GzK3sWzPQjWDJ4GiNV1DyM4UWOIcQPB53YEsS
JT0esfIwRbDwyWkLVFJyrf7enwebMFR21zZJ1JSg4cwB1RYMrbPZnlJmCy/8
yaqtGGb4Oz4MMZtOtBhzQjCAos5v1lCSJXzfmxiF4eubur3tWkrkFWsd0zIM
0tf177RHKAkwF6ulORg+NjVM5+soaZ6b+e06h2G2ZbfFzaw3ptn3X8DAedW5
ed0xStzKyO+pJgyhHRPJNcyW4JGiM1cw5A4HNQ6nUxJtk4f4SjGUjFXJwzIo
+bK6uctUjuHO1M6x88yJvvKNZTcxuH4o1gsyKfl1av6F4BaGPt9gzVHmqtGM
dOttDJN+Q4KD+XmTZWTRiqG2up8/x/wPYI7/GA==
                "]], 
               Line[{{3.201275510204082, 0.980891753056576}, {
                3.2049527235388684`, 0.9809671401181093}, {3.209886242298752, 
                0.9810682828717288}, {3.21975327981852, 0.9812705683789678}, {
                3.2209866595084913`, 0.9812958540673726}, {
                3.2222200391984623`, 0.9813211397557775}, {
                3.2246867985784045`, 0.9813717111325873}, {
                3.2296203173382887`, 0.9814728538862068}, {
                3.2394873548580567`, 0.9816751393934456}, {
                3.2592214298975932`, 0.9820797104079236}, {
                3.3447619504179835`, 0.9838333885051526}, {3.398724489795918, 
                0.9849396820231513}}], 
               
               Line[{{3.4012755102040817`, 0.9849861698665803}, {
                3.507084223974069, 0.9866733247558511}, {3.5920292423158866`, 
                0.9880278011303221}, {3.5987244897959183`, 
                0.9881345590628055}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAWIQvW7Tw47M8zwOm+UZjqjPf29vFr789d1kXgc3nUiW
Xyvf2+/m5998PYPXYaf7xbthq97bH2u453i6iNdhbt3BCQKr39vfTqqN39TG
65D6ZuG35jXv7dnUd89qWMfr8O140qGs9e/tPZnz6/5u4HVYf1VOfyaQ33Nf
KalqM69DxuNbs48D+YIzujRLdvA63PoXVKqy4b29DGfUjvRDvA77TJ017gH5
Rq9/XPW7xuvQvli5L3DTe/vY9WaCsv94HSTqn0RabH1vvy3qB98FBj6HtENG
O7KAfD62XTzNzHwOW1gbxeYC+QdibDlecvA5BPTIXmbc9t5eicvl/xZhPofO
mWE+p4H8ZymBb300+Rx+bz5hF7fjvb2dgPDr/9p8Dp7fxeZOAPKn777yYpMe
n8N0q9Tfh4B8D6GIJxImfA7GBxl3qO98b79qf9ztJ3Z8DjnnrAw/Avl5Ujkn
a0L4HO6+WKPcshsYXkd1j+uH8zno6Pxu3Abkyxe+P/Ioks+hKt/zwQsgv0Jm
46GpMXwOJzZNt5Pe897+wvGiAx7xfA5i357O8QXyNYpN9v1O5HNIsTT5XQ/k
tzYErjqZzOdQt+nTsoVAPgCVZdnA
                "]], 
               Line[CompressedData["
1:eJwVx3lIk3EYwPGpgTL190OxgnCpg7ItyoIyZdX7EOFmHqkoghEeFdnUxDS8
Mo+c1TCnNZOaSfY6sTwyjy7mVebsMNNZS5ApmaMifSdpgrnW0x9fvnx8ktKj
TtnzeDxf7P+loflChzMEivht1SYdxyi9Jd36VALR5RUiC3r27VpHXjoBX4Fw
YA2tFha1zWQReH8w2LK+h2NWRsu0LYUEBCU14TJ0RL6MjS8hYHHfbo5GN23l
17srCAyyvQWJ6LiCa7U5SgIpr+Za8tA6sfrG4WoCz5z2OLeiixT1xVMPCMSo
PujdejnGNdvxSGIrgR/y8csC9O3kNHfzQwKFQRNSEbozJJDlugjctxr1gDa7
jQ3a9xGwpkzr09EhdTwnkYFAg2xBP4Le8CS+4vwfAr/sXIav9nFM6zeBhoRS
qMqSDtsNcMyVO4oEUziFsN2bzQR9Mmp+S1skBf7CkoMn2lOnaw+LpVBy+h7j
j1aqjg2VJ1HIjLM+lqOT/W8t8nMpxECn1oAWlnrIHBspbHLxuqR9wTF/Ay64
GpsofBpevtuBnpyfHW9spnBd8a63D10Z23k86BEFZ1vu6iTaJo7KVOgorC1O
ZJCXHDM1pqpzMFAwGZUJ2einZSsnDB8paNSJF0vRakm8iP1MITYyoLYKHaLd
2XXIRGH0zZyxGf08Z+R18XcK/T1wdAZ9c8deVeRPCgV5G9Pm0RlfaqN9OAqB
+xaUq+htoanT/UsUOto1Qx6DHLPObqKhcoXC2bRzX33QM90SecIqBbE42N4P
rZOzfrusFMxmL+/96Bov52WbjQLL/j4QjP4HM7g31Q==
                "]]}, 
              "Charting`Private`Tag$72657#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Munc13-1 intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {192., -189.}, {Center, Center}, {360., 360.}], 
    InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT6aBcrKFmZVPwRDGnDf
GVQ/wwceEF8BXD8zn5icsxlkP/YEuapTTmE/S83Xsp0ZdD8fBw3wm+lnP1dk
972SGYQ/uYVaPRaQcj/dL4dDjRmUPwuKAsimxn8/oBVPhooZpD9YSanu4xmN
P4EIsyeJGbQ//qj8gYLDmz8qR5GIsnC0P47tgDUbNpw/0oVv6dvHtD8dMgXp
s6icPyQDLKsudrU/PbsNUOWNnT/G/aQu1NK2P3vNHh5IWJ8/DPOWNR+MuT/+
eCDdhnahP5jdekO1/r4/fJ1CeUwLpT9BHFmk3lW/P8S/BNOYRKU/6lo3BQit
vz8M4sYs5X2lPx7seWOtLcA/nSZL4H3wpT9vaTYlANzAP7yvU0ev1aY/EmSv
qKU4wj/7wWQVEqCoP1hZoa/w8cQ/euaGsdc0rD/v21QKohrFP8pdUf9Xaqw/
hl4IZVNDxT8a1RtN2J+sP7Njbxq2lMU/ucOw6NgKrT8Obj2FezfGP/ig2h/a
4K0/pfDw3yxgxj9IGKVtWhauPzxzpDreiMY/mI9vu9pLrj9qeAvwQNrGPzh+
BFfbtq4/xYLZWgZ9xz93Wy6O3IyvP1wFjbW3pcc/x9L421zCrz/yh0AQac7H
PxVKwynd968/II2nxcsfyD9bHKzibjGwP7cPWyB9SMg/A1iRCS9MsD9Okg57
LnHIP6qTdjDvZrA/fJd1MJHCyD/6CkF+b5ywPxMaKYtC68g/okYmpS+3sD+q
nNzl8xPJP0qCC8zv0bA/QB+QQKU8yT/yvfDyr+ywP9ehQ5tWZck/mvnVGXAH
sT+QO0vYzW/JP0iaYWBRDrE/z14sMQ==
                "]], 
               LineBox[{{0.20127551020408163`, 0.06807126420441924}, {
                0.2033724813112215, 0.06976016126502382}, {
                0.20461432671651483`, 0.07076034150002282}, {
                0.20585617212180818`, 0.07176052173502181}, {
                0.20833986293239484`, 0.07376088220501978}, {
                0.2133072445535682, 0.07776160314501573}, {0.2232420077959149,
                 0.08576304502500764}, {0.24311153428060836`, 
                0.10176592878499148`}, {0.2443290196086536, 
                0.1027464894540745}, {0.24554650493669883`, 
                0.1037270501231575}, {0.24798147559278932`, 
                0.10568817146132356`}, {0.2528514169049703, 
                0.10961041413765565`}, {0.2625912995293323, 
                0.11745489949031986`}, {0.28207106477805627`, 
                0.13314387019564827`}, {0.3210305952755042, 
                0.16452181160630505`}, {0.3987244897959184, 
                0.22709634572157117`}}], 
               LineBox[{{0.40127551020408164`, 0.22928698035592118`}, {
                0.48443648039284554`, 0.30513470893470235`}, {
                0.5699233045152912, 0.38310375400937524`}, {
                0.5987244897959183, 0.4093721402361553}}], 
               LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAtsqGI6Y94z+kJmtq3FTaP/UmPQ+t
bec/AbmzWtQZ4D8+4kLHinjnPzdxwxlyIeA/hp1If2iD5z9sKdPYDyngPxYU
VO8jmec/1pnyVks44D82AWvPmsTnP6l6MVPCVuA/eNuYj4gb6D9SPK9LsJPg
P/yP9A9kyeg/o7+qPIwN4T9ES/rHQdToP9h3uvspFeE/jAYAgB/f6D8NMMq6
xxzhPx19C/Da9Og/eKDpOAMs4T8+aiLQUSDpP0yBKDV6SuE/hiUoiC8r6T+B
OTj0F1LhP87gLUANNuk/tvFHs7VZ4T9eVzmwyEvpPyBiZzHxaOE/f0RQkD93
6T/0QqYtaIfhP8j/VUgdguk/Kvu17AWP4T8Qu1sA+4zpP1+zxaujluE/FwJG
qSaP6T+S2w8kKZjhPyNJlJM=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAHTHtiQyk6T/siBgVvaThP+jsbCiU
rek/43Opy4ep4T8wqHLgcbjpP0yO0Ib+ruE/wB5+UC3O6T8ewx7967nhPwL5
qxAbJeo/ZZZX1qHl4T8bzULzPy/qPwNl4aC76uE/NKHZ1WQ56j+iM2tr1e/h
P2VJB5uuTeo/3tB+AAn64T/ImWIlQnbqP1gLpipwDuI/jzoZOmnH6j9MgPR+
PjfiPxx8hmO3aes/NGqRJ9uI4j82/2C2U67sPwM+y3gULOM/TE3AgkW47D/Y
HzeTFDHjP2ObH083wuw/rQGjrRQ24z+QN97nGtbsP1fFeuIUQOM/6W9bGeL9
7D+qTCpMFVTjP5zgVXxwTe0/UVuJHxZ84z8BwkpCjeztP554R8YXzOM/GBCq
Dn/27T90WrPgF9HjPy5eCdtwAO4/SDwf+xfW4z9a+sdzVBTuP/L/9i8Y4OM/
tDJFpRs87j9Fh6aZGPTjP2ajPwiqi+4/7JUFbRkc5D/MhDTOxirvPzqzwxMb
bOQ/Og/LApE17z9GZhD/h3HkP6iZYTdbQO8/Uxld6vR25D+Dro6g71XvP2x/
9sDOgeQ/OtjochiB7z+fSylugpfkP6hif6fii+8/rP51We+c5D8W7RXcrJbv
P7mxwkRcouQ/8QFDRUGs7z/SF1wbNq3kP6grnRdq1+8/BeSOyOnC5D8WtjNM
NOLvPxKX27NWyOQ/hEDKgP7s7z8fSiifw83kP31orA+N9e8/+Hl9GRHS5D8u
2RyH
                "]], 
               LineBox[{{1.0012755102040816`, 0.6516924249020462}, {
                1.0029484390136711`, 0.6522277329887018}, {
                1.0055826833813366`, 0.6530706453135753}, {
                1.0068998055651694`, 0.653492101476012}, {1.008216927749002, 
                0.6539135576384486}, {1.0108511721166678`, 
                0.654756469963322}, {1.0161196608519991`, 
                0.6564422946130689}, {1.017436783035832, 
                0.6568637507755056}, {1.0187539052196648`, 
                0.6572852069379423}, {1.0213881495873305`, 
                0.6581281192628158}, {1.0266566383226616`, 
                0.6598139439125625}, {1.0371936157933241`, 
                0.6631855932120563}, {1.0582675707346494`, 
                0.6699288918110436}, {1.1369227129030104`, 
                0.6950971676028352}, {1.1987244897959184`, 
                0.714872659991293}}], 
               LineBox[{{1.2012755102040815`, 0.7156278597638445}, {
                1.3058823930203434`, 0.7440907686711862}, {
                1.3839420330101317`, 0.7653303311411982}, {
                1.3987244897959183`, 0.7693525494655851}}], 
               LineBox[{{1.4012755102040815`, 0.7700300080850798}, {
                1.547629076117258, 0.8079404877186627}, {1.5489670042909665`, 
                0.8082870559656616}, {1.550304932464675, 
                0.8086336242126606}, {1.5529807888120917`, 
                0.8093267607066583}, {1.5583325015069254`, 
                0.8107130336946541}, {1.5690359268965925`, 
                0.8134855796706453}, {1.5703738550703008`, 
                0.8138321479176442}, {1.5717117832440093`, 
                0.8141787161646431}, {1.5743876395914262`, 
                0.8148718526586409}, {1.5797393522862597`, 
                0.8162581256466366}, {1.5904427776759271`, 
                0.8190306716226279}, {1.5917807058496356`, 
                0.8193772398696268}, {1.5931186340233439`, 
                0.8197238081166257}, {1.5957944903707606`, 
                0.8204169446106235}, {1.597132418544469, 
                0.8207635128576225}, {1.5984703467181776`, 
                0.8211100811046214}, {1.5987244897959185`, 
                0.8211759126811368}}], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAW2XDEdOe+T8sTvUtwkvqPyiCgGbG
o/k/Bkb2L6JN6j8ahNxRQan5PzCLyIy1T+o//oeUKDe0+T+GFW1G3FPqP8SP
BNYiyvk/MCq2uSlc6j/frsSL0SH6P9p82oZffeo/0O0E7DIn+j+1mvQ2aX/q
P8AsRUyULPo/kbgO53KB6j+gqsUMVzf6P0f0QkeGheo/YqbGjdxM+j+0a6sH
rY3qP+adyI/nd/o/j1p8iPqd6j/tjMyT/c36P0U4HoqVvuo/+2rUmyl6+z+w
82GNy//qP1Q2XZEuf/s/JT6hPLIB6z+sAeaGM4T7P5mI4OuYA+s/Xpj3cT2O
+z+CHV9KZgfrP8HFGkhRovs/VEdcBwEP6z+HIGH0eMr7P/maVoE2Hus/E9bt
TMga/D9BQkt1oTzrP2yhdkLNH/w/toyKJIg+6z/EbP830iT8PyrXydNuQOs/
dgMRI9wu/D8TbEgyPETrP9kwNPnvQvw/5ZVF79ZL6z+fi3qlF2v8P4rpP2kM
W+s/+FYDmxxw/D/+M38Y81zrP1AijJAhdfw/c36+x9le6z8CuZ17K3/8P1wT
PSanYus/ZebAUT+T/D8uPTrjQWrrP76xSUdEmPw/o4d5kihs6z8WfdI8SZ38
PxfSuEEPbus/yBPkJ1On/D8AZzeg3HHrPytBB/5mu/w/0pA0XXd56z+wqqsn
2MD8PycMAQiHe+s/NBRQUUnG/D97h82yln3rPwwBo1STx/w/CYtGsRN+6z88
/hrj
                "]], 
               LineBox[{{1.8012755102040816`, 0.85954283759651}, {
                1.8023956352454178`, 0.8596842552116547}, {
                1.8037242586975861`, 0.859851996091554}, {1.8063815056019226`,
                 0.8601874778513527}, {1.8077101290540907`, 
                0.8603552187312521}, {1.809038752506259, 
                0.8605229596111514}, {1.8116959994105954`, 
                0.8608584413709501}, {1.8170104932192683`, 
                0.8615294048905474}, {1.8382684684539596`, 
                0.8642132589689369}, {1.8807844189233422`, 
                0.8695809671257156}, {1.9601756422651684`, 
                0.8796042386838914}, {1.9987244897959184`, 
                0.8844710936181176}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBvGxIP7k/sPxMP8AjE
+gBAsHW9CCmx7D/SvYqHSf0AQAsD6PIlsuw/kmwlBs//AEBnkBLdIrPsPxLK
WgPaBAFAHqtnsRy17D8ShcX97w4BQIzgEVoQuew/EPua8hsjAUBoS2ar98Ds
PwznRdxzSwFAISEPTsbQ7D/MleBa+U0BQHyuOTjD0ew/jER72X5QAUDYO2Qi
wNLsPwuisNaJVQFAj1a59rnU7D8KXRvRn18BQP2LY5+t2Ow/CNPwxctzAUDZ
9rfwlODsP8iBi0RRdgFANITi2pHh7D+IMCbD1ngBQJARDcWO4uw/B45bwOF9
AUBHLGKZiOTsPwZJxrr3hwFAtWEMQnzo7D/G92A5fYoBQBDvNix56ew/hqb7
twKNAUBsfGEWdursPwUEMbUNkgFAI5e26m/s7D/Essszk5QBQH4k4dRs7ew/
ubOE3fyWAUC9Q2jXXu7sP8+vqvw=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUDcdAU5wvDsP9o8REjf
ngFAu8S49iXy7D+vuuzgmqEBQAQEf3KT8+w/WrY9EhKnAUCXggtqbvbsP7Gt
33QAsgFAvX8kWST87D9enCM63ccBQAh6VjeQB+0/uHmrxJbzAUCebrrzZx7t
P2s0u9kJSwJAyVeCbBdM7T/A0NWsuE0CQMqEMzx+Te0/FW3wf2dQAkDMseQL
5U7tP7+lJSbFVQJAzgtHq7JR7T8TF5BygGACQNK/C+pNV+0/u/lkC/d1AkDa
J5VnhGLtPwu/Dj3koAJA6/enYvF47T9gWykQk6MCQOwkWTJYeu0/tfdD40Gm
AkDtUQoCv3vtP18weYmfqwJA76tsoYx+7T+zoePVWrYCQPRfMeAnhO0/W4S4
btHLAkD8x7pdXo/tP6tJYqC+9gJADZjNWMul7T80LCE+P/kCQDpomAQap+0/
vg7g27/7AkBnOGOwaKjtP9DTXRfBAANAwdj4Bwar7T/0XVmOwwoDQHQZJLdA
sO0/fUAYLEQNA0Ch6e5ij7HtPwYj18nEDwNAzrm5Dt6y7T8Z6FQFxhQDQCha
T2Z7te0/PnJQfMgeA0DcmnoVtrrtP8dUDxpJIQNACGtFwQS87T9QN863ySMD
QDU7EG1Tve0/YvxL88ooA0CP26XE8L/tP+veCpFLKwNAvKtwcD/B7T90wcku
zC0DQOl7OxyOwu0//qOIzEwwA0AWTAbI3MPtP1JNHneWMANA7/8iRAPE7T/U
1gXb
                "]], 
               LineBox[{{2.4012755102040817`, 0.9304272209536839}, {
                2.4046933744994785`, 0.9306504162711892}, {2.409580888186021, 
                0.9309695834688302}, {2.4108027666076564`, 
                0.9310493752682404}, {2.412024645029292, 
                0.9311291670676507}, {2.414468401872563, 
                0.9312887506664712}, {2.419355915559106, 
                0.9316079178641121}, {2.429130942932191, 
                0.9322462522593942}, {2.4486809976783612`, 
                0.9335229210499582}, {2.450006067043157, 
                0.9336094514830097}, {2.4513311364079526`, 
                0.9336959819160613}, {2.453981275137544, 
                0.9338690427821643}, {2.459281552596727, 
                0.9342151645143704}, {2.4698821075150925`, 
                0.9349074079787826}, {2.491083217351824, 0.936291894907607}, {
                2.5334854370252864`, 0.9390608687652559}, {
                2.5987244897959183`, 0.9433211464821016}}], 
               LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAArrLhiGnPBECjbS0DEzHuPyHdStij
hQVA7fjGvEJi7j+KwjuvVYgFQIQ24u/8Yu4/8qcshgeLBUAadP0it2PuP8Jy
DjRrkAVARu8ziStl7j9kCNKPMpsFQJ/loFUUaO4/qDNZR8GwBUBR0nru5W3u
Py6KZ7be2wVAtKsuIIl57j+Wb1iNkN4FQErpSVNDeu4//1RJZELhBUDhJmWG
/XruP9AfKxKm5gVADaKb7HF87j9xte5tbfEFQGaYCLlaf+4/tOB1JfwGBkAY
heJRLIXuPzo3hJQZMgZAe16Wg8+Q7j/WYhk2nTQGQArbvj19ke4/c46u1yA3
BkCZV+f3KpLuP6zl2BooPAZAt1A4bIaT7j8elC2hNkYGQPNC2lQ9lu4/ur/C
QrpIBkCCvwIP65buP1frV+Q9SwZAETwryZiX7j+QQoInRVAGQC81fD30mO4/
AvHWrVNaBkBrJx4mq5vuP54cbE/XXAZA+qNG4Fic7j87SAHxWl8GQIkgb5oG
ne4/2HOWkt5hBkAYnZdUtJ3uP4WAUarJYwZAwjmF4jie7j8WxsAy
                "]], LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAR0x7IgNpBkDlRQaqZ5/uP+ZNgLpw
bgZAPFVbv2Wg7j+CeRVc9HAGQHwlA2/boO4/H6Wq/XdzBkC89aoeUaHuP1j8
1EB/eAZAPJb6fTyi7j/LqinHjYIGQDvXmTwTpO4/aNa+aBGFBkB7p0HsiKTu
PwQCVAqVhwZAu3fpm/6k7j8+WX5NnIwGQDsYOfvppe4/sAfT06qWBkA6Wdi5
wKfuP5RkfODHqgZAOdsWN26r7j9cHs/5AdMGQDbfkzHJsu4/9cqN4nCBB0C3
x+k3rtLuP9wL1Wj8gwdAdRgMWSXT7j/CTBzvh4YHQDNpLnqc0+4/kM6q+56L
B0CwCnO8itTuPyrSxxTNlQdAqE38QGfW7j9e2QFHKaoHQJnTDkog2u4/RBpJ
zbSsB0BYJDFrl9ruPytbkFNArwdAFnVTjA7b7j/43B5gV7QHQJIWmM782+4/
kuA7eYW+B0CLWSFT2d3uP8bndavh0gdAfN8zXJLh7j+sKL0xbdUHQDowVn0J
4u4/k2kEuPjXB0D4gHiegOLuP2DrksQP3QdAdCK94G7j7j/67q/dPecHQG1l
RmVL5e4/4C/3Y8npB0ArtmiGwuXuP8dwPupU7AdA6QaLpznm7j+U8sz2a/EH
QGaoz+kn5+4/ezMUfffzB0Ak+fEKn+fuP2J0WwOD9gdA4kkULBbo7j8v9ukP
mvsHQF7rWG4E6e4/HxrrQ2P9B0As0IMHWOnuP/O6DIo=
                "]], LineBox[CompressedData["
1:eJwVzHtIE1AYBfA5iu71kVqZtZLUNNeIZtJ6GHk/bdaQ0txErFH5XGmaSZKy
NZexEi00RJ1hYg3LEmRZ015Cglbaw1ylEaRWlpCPuy3bnPnq9sfh8OPA8UvO
lqZxORxOIMv//vZzRdt1LgJLkdJj5hcl90KjDTKEoPnpx9C4UUp0qkrRkDOC
mv4Si4o5dW59hN0dQbbrlPw1c1TYya7CZQgOBTV5TjJv0dyPdvNCII5Ieckb
o2SeEy4P4CFYlf8uJIO5etHRXGkAgvbhBozH2Z7iLTJtQOAR6e0QMqd29Npi
NiJIun1pJJ45+MKevAObEXDT0zrqmbsW+ErJDvZP/dUwQcnU30lN2H4E3Y5a
Sx6lJN5afFmQi8DkVvFpxELJ8sEWPbcTwfD287c6bZSUuqrVD18gWDjt9ZUy
O+8SJ2R2I1jT2MhbbaeEW/3erb8HgWxtX1kW8+9Yc/7dzwg6OALlyilKep/z
Yw6aEei7P0SfcFBypalmppaHIUke5HCZoQR9Se6X+mBQV7SFbGPWOgual/hi
uPY2NiuRWXX8kSInEIOJnPtuZM7w6zOJgzGEB5jeHJmlRFK59M5YJAbfCeVN
wxwli9WFcTtzMAwV9ETJOGZitI5PPzuDwdCiMCqZUxUJdXvPYtCMz/vomTtj
hKMyFYZ1h4VWC7PWf0Bz6iKGY6KrulInM9mqkwTaijAIM/lOrcw/XIyvVCUY
FvTtGQPMYluJV3EZhjoP6+5NXDP5k25/4l6OIXtfcYOMuX4wKbGqAgMp8PNU
MT9+oB2YrcKAWqe1N5j/AWfUF/M=
                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPGjxn7fXw+eytV1FabOhZ1qmPD5HHnMcyzCrTG27BDb5aEV
Ms4fbtJ0cpNEyDwtlYdq5OYxFpkwWisiteorpVK36dcf7733sohLDUvQ5/F4
Iq7/v5TTGuFYyeD38Ignblso9GuWsaeWQY+cpwrVVgr5yWXTsy0MbuTHLwYb
UNA3XdXboWUwUXW/Z4qh0K6MbijrZ7AsSHDWi1CI0w0GCIYY7NtZsP6Is3bp
VrlojEHh9UjbcpbC1a5Tdp7TDE6pNyuitlPQkzVEZn5iUFodqHhjRIHXKGtb
MCG478HHIyvmFAY/z6Tc3kWwxN/uWByfQrEk1D6GT1B/4YLLa87mXZ4tr4QE
Pxj99p3YQ8F+SNQ0LCLYnmKQ2CWgELO0Vt/qTtBPbFVddIBCt4WyKjuJoOJO
jJnNYQpXEngyp2SCK87VglrOJxuzhD9SCUZPLFoKRRQmJPLKZAVB6WaSg7EN
hRUI1ZzLJbgtNitoQ0xht0yg9lYTrOGri0bsKaRr2lQmWoLjJeO6844UOnUa
pbaf4NRox/N3nHWywrz0IYJzhlU3o5woKK1iFZNjBN/nyI/7OVOobCax12cI
/kll5CIXCgM9CbYmXwhah3jOL7tRIBahh7SUoLhY3ChzpxCS73owfY2gZNg4
Y5rznI+p2eQvgi741mQQKHydePa3VJ/FYMll/zopBf6iYNSYz2K2UWd3vBeF
WC/Dgb69LOYGVCnnOdc0rPWkCVksKCqIOO1NwVY+0v7SksVrvPBvHj4U0l48
bM6zZvGG64nex5w7JNX1DiIWNZmWqqO+FKTrFzWldizWra6KLP0oFJ6JK5NK
WGyynf1ZwTkscH+GmvPdWab3Hud/uesbtw==
                "]], LineBox[CompressedData["
1:eJwVzn0sFGAcB/DTC7bn8XLzEjY1klpcu2bkvPT8dGvz3u5aKjncobxsONYm
Oeo4HUM4zltKL3OEVBdtDXWrrK6MYrPSTFZC9HTtlKatnv747rvPH9/t6yHL
Eadt4nA4u1n+t6NrOB33RzCQaPSESEriir2UokAEVRO+Oilz25xdkUUwghrZ
rmYV89yhjbP3QhFcNrtXdDNnWr3N4AoRaFzsskzM/RnDKYbDCBpuWyU4RVFi
ftUlkYcj0IZwYgTMJbUlojcxCFqSTfsuMje48gR1JxB0dE3+sI+mZNhHbc3N
RtAb2FzIj6EkYGrbWH0ugr/xGgsx890iXZ1jPgKxokadz3xjbNTNpQDBL0OZ
dpBZnbOVt0OJQBglvx8SS4lYrxTxtAjeSSKXw49Q8iVI0RoxgsCy9M9JqYgS
bmSer9IWQ9JYsqD+GCUdBjsUxMWQ7LysGWTmC/qWTA4YpEn5394zx+5Z7JS6
Ykg1qW7ujKOk0jLRI8wLQ7pTj80A85anEc6cIAxyydrH6eOU/Az24BSnYShd
rah0j6dEpR+Z9U/HUBbg8DmM2dEnYXg1E4Oq5Ao5zezn1lQoycWg5vab7zDn
ruO1kPMYqvynEuEUJUsP1pc2ajE0Krb7pSRQUuCrfaHXYNCO6qovMVvf8tNl
aTE02e1f7GH21mSnzrRhaL0ubDczy+SfZh91Yrj6PN2qXELJB97E5LkhDDob
/UxXIiXXvnIVmx9j+L1w8LWRWdZ91LvagCH6iXFohdn7TOO48zO2b4nrs01i
f7ymCzpGMXzPm2/nM/fOu3jufYlBGJ1dI2ZeWXhozzdiOFB+ITSZ+R+xgRWh

                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPGL8tTv+/UsayokD8vDZlFby++jbuqslIcQwh3yUJGj5lCe
Ej2sZYSeSGlGi3PEjebh5iEhatScMIZC/LZoY5E+/fHeey8zUZxXhAqPx7PH
/r9aNpkbPcCAMmKlvCCEY68XCa8ohxkw8rZsbEVv1Z9RLCoZiLKVVUyidbV+
RhrMMEAmenL3hXLsULedbsl3Bhp6tTOc0cXZcU1W8wyEyM9KjqN3b1lmDnMM
yPImo6PRtqtrtcI1Bnz5a+5v0G6z6uvVhEBppTVxEnKsZrng1SEdAoLC2G1u
6D7hXQ+FHoFfmfUbvmjvMVo2vIMAPwiWktChQ4Zu62YE5qj/wDt0imLvA4Ez
AcfEnDy+iGOlJazFdDCBDpdZQ58wjl1OXlYXCgmcaeyQh6Od/SoWxsIIfHN4
GXgV3aytXfc1isCKaWhZIborfdy1V0zAQlVpO4IeFV0Pkd0ikNXdfyw4nGPV
rJofp1cTOHrmbXxUBMcKVONubEgJfHyfbyBB35swFyXXEQhwFTfeRusW37FJ
lBMQOzpsVKFNNAPkkQoCLwwqcxfRjgurwx5fCKiMPC0VX+DY8zXOurv+EmgX
3uxPjeTYhoBVOsijUL5oo7yPpmpNTJYqhRzJwOxzdFvQEY05DQqn8nbyOtHm
WvzNen0KI21SRxLFsbPhnosnbSj82jNW9AztoqO/sLmfwvDrzPIadFHz0A+Z
PQX5QevadvQJPf9p4wMU0k4nfJhBV7UGj067UNieprlhF82xKhdNR4pcKSxp
1WgCOtBo6os7n8KnQh8jLzRzOeKzVEChuLrU4Ro6duelnlQfChbjTqIWdFen
XbeDHwX1mNHYQfSeeK5j6hyF+d/pKVPoJJNaxcMgCv0Zlrkr6MFucduJEApS
0legFsOx1gkHWv4IKeQ/ii8zRmene1b1hFF4Ijkts0D/A+T8U3g=
                "]], LineBox[CompressedData["
1:eJwV0X0sFHAYB/DjmGJ+vzqm/tDirBzrTWKZ5ffMTKe7S8wm2o1Uw3W3SxHh
QhzSy12760W4ZtfJOHpxynLpZSZm1nT0suwyyi5jP70Ylbp+/fHsu88fz/bs
+wRmKZOPuXI4nGA2/3OvuITPzUUwbNRfkckoqQuI7n4pR+BjGw9+yDw9vPKg
WInAenpAMses55d3TuYjwH136g8ep2TpVbXJXIbAIpaFhckpOVAiNGacQyBd
SE/NZm7d7NnMUyPw0ItUTczpqkuNRXUI0j5sGVqtoMQaqtfFXUXgzKWZU8zl
6uaKiTYECTX5Wp2SEu9Cj32HOxDIubnrBphv5ih4M3cRaMqkhmXmLlGUkVoQ
vCmMN0tPUDKzdrTf9SmCrJz1g8F5lIgMnFUhNgQlCVZn70lK/B5lXC74jcDs
5ab8VEBJh2NDAxJjWKPVSSJKKaltUmfa92O4EWW3KJiPJs9v6kzCEDgt8G9h
9rda70lSMeyM7Jv1U7G+NIcGLmZhSJlw1Cwz50TWf/U8g6FeEPOit4wSfpWv
0KMFA/+5IzK2kpK/u0u937ZiaJeFG4qZ389Pv25pxxDue9a9i1mb2iWNv48h
LttnLKiKEmdo8im1FUO2d0yeu5qSiVGNgWtj+2m69sFqSnqql47YxjHs4tp5
LjXsP9EZIcZ3GKxmQXEUs8i0zRJrxzDifCJsY35cNDJU8QXDgsnx+UItJde2
RmiS5jAUJYZL+pnzphpTAikGl58qywqzQCz/+OwHBp7Yp1JxnhI3l7Hb2iUM
DYvSWRPzZHe0LPMXhqBbrUl2ZqvMuH3HHwxm4fcevzpKrm/0WnQ62X3f9gQk
Mv8D96YmeA==
                "]]},
              Annotation[#, "Charting`Private`Tag$72721#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT41ly1xpGRmPwRDGnDf
GVQ/jtpebt3BbD8zn5icsxlkP/QOyDWLj3E/S83Xsp0ZdD9OUvkyxOx3P1dk
972SGYQ/geytFptTgj/dL4dDjRmUPzRzEBENDo8/oBVPhooZpD9OwOqCeEGc
P4EIsyeJGbQ/2ubXOy7bqj8qR5GIsnC0P/NaN3WSSas/0oVv6dvHtD8Lz5au
9rerPyQDLKsudrU/PbdVIb+UrD/G/aQu1NK2P5+H0wZQTq4/DPOWNR+MuT8y
lOfouOCwP5jdekO1/r4/+DTjs9pTtD9BHFmk3lW/PwXvktAMi7Q/6lo3BQit
vz8SqULtPsK0Px7seWOtLcA/Kx2iJqMwtT9vaTYlANzAP1wFYZlrDbY/EmSv
qKU4wj+/1d5+/Ma3P1hZoa/w8cQ/hXbaSR46uz/v21QKohrFP5nongWobbs/
hl4IZVNDxT+tWmPBMaG7P7Njbxq2lMU/0z7sOEUIvD8Obj2FezfGPyEH/ids
1rw/xYLZWgZ9xz++lyEGunK+P1wFjbW3pcc/0gnmwUOmvj/yh0AQac7HP+V7
qn3N2b4/II2nxcsfyD8MYDP14EC/P7cPWyB9SMg/INL3sGp0vz9Okg57LnHI
PzREvGz0p78/fJd1MJHCyD8ulCLygwfAPxMaKYtC68g/OM0E0EghwD+qnNzl
8xPJP0IG560NO8A/QB+QQKU8yT9LP8mL0lTAP9ehQ5tWZck/VXiraZduwD+Q
O0vYzW/JP7lNcQ84dcA/kV0T+w==
                "]], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAApPfnWmXDyT8sw6b7AMHAPzKsEQYc
CMo/z3yqKxUSwT/JLsVgzTDKPxuhjiwZQsE/YLF4u35Zyj9mxXItHXLBP422
33Dhqso//A07LyXSwT/owK3bpk3LPymfyzI1ksI/ntVJsTGTzD+Dwew5VRLE
Pwv/gVxHHs8/OAYvSJUSxz+YaVdeLEbPP+JARiqoQcc/JNQsYBFuzz+Le10M
u3DHPz6p12Pbvc8/3vCL0ODOxz+5qZa1ty7QP4bb6Fgsi8g/7VPsvEvO0D/V
sKJpwwPKP1Wol8tzDdI/c1sWi/H0zD8lUe7ow4vUP1jY/uama9E/Gn9HOmeh
1D+ckIALL4XRPxCtoIsKt9Q/4kgCMLee0T/6CFMuUeLUP2u5BXnH0dE/0MC3
c9441T+AmgwL6DfSP3owgf745dU/qFwaLykE0z/ODxQULkDXP/fgNXernNQ/
wz1tZdFV1z88mbebM7bUP7hrxrZ0a9c/gFE5wLvP1D+jx3hZu5bXPwvCPAnM
AtU/eH/dnkjt1z8eo0Ob7GjVPyLvpiljmtg/RmVRvy011j8XHQB7BrDYP4sd
0+O1TtY/DEtZzKnF2D/Q1VQIPmjWP/emC2/w8Ng/WkZYUU6b1j/MXnC0fUfZ
P24nX+NuAdc/lWryuLOE2T+Mo4jLqEnXP4cB+Qs=
                "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAn8hAen+u2T/PLIe4Q3TXP6SNMIz7
HNo/x4rPOiXT1z/RTCfZXkXaP4R1a0/U9dc/K8sUcyWW2j/9SqN4MjvYP9/H
76ayN9s/7/USy+7F2D9HwaUOzXrcP9NL8m9n29k/F7QR3gEB3z+c97C5WAbc
P1yM+1TkFt8/IScT9CMZ3D+iZOXLxizfP6dWdS7vK9w/LBW5uYtY3z+ytTmj
hVHcP0J2YJUVsN8/yXPCjLKc3D82nFemlC/gP/Xv018MM90/YV6mXaje4D9Q
6PYFwF/eP4RKG5mZ6eA/1hdZQIty3j+mNpDUivTgP1pHu3pWhd4/7A56S20K
4T9mpn/v7KreP3a/TTkyNuE/fGQI2Rn23j+MIPUUvI3hP6rgGaxzjN8/tuJD
zM884j+BbB6pk1zgP9ZIgfGNR+I/jpUhZ81l4D/2rr4WTFLiP5u+JCUHb+A/
N3s5Ychn4j+2ECuheoHgP7gTL/bAkuI/6rQ3mWGm4D/YeWwbf53iP/fdOleb
r+A/+N+pQD2o4j8EBz4V1bjgPzisJIu5veI/HllEkUjL4D+5RBogsujiP1L9
UIkv8OA/2qpXRXDz4j9gJlRHafngP/oQlWou/uI/bU9XBaMC4T863Q+1qhPj
P4ehXYEWFeE/WkNN2mge4z+UymA/UB7hP7Cb30LAKOM/H9wqwzEn4T8ihAXk

                "]], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAtsqGI6Y94z8tQmIqWzbhP9rbQm9h
SeM/S7UG4k094T/6QYCUH1TjP6ScsKuqQ+E/Ow773ptp4z9VawQ/ZFDhP7ym
8HOUlOM/twisZddp4T/cDC6ZUp/jPw/wVS80cOE//HJrvhCq4z9o1//4kHbh
Pz0/5giNv+M/GaZTjEqD4T++19udherjP3tD+7K9nOE/vwjHx3ZA5D8+fkoA
pM/hP8JqnRtZ7OQ/xfPomnA14j/1Jj0PrW3nP/xW4AVFseM/PuJCx4p45z/4
AZyCtLfjP4adSH9og+c/9KxX/yO+4z8WFFTvI5nnP+sCz/gCy+M/NgFrz5rE
5z/Yrr3rwOTjP3jbmI+IG+g/tQab0TwY5D/8j/QPZMnoP262VZ00f+Q/REv6
x0HU6D9pYREapIXkP4wGAIAf3+g/ZAzNlhOM5D8dfQvw2vToP1xiRJDymOQ/
Pmoi0FEg6T9KDjODsLLkP4YlKIgvK+k/Rrnu/x+55D/O4C1ADTbpP0FkqnyP
v+Q/Xlc5sMhL6T84uiF2bszkP39EUJA/d+k/JmYQaSzm5D/I/1VIHYLpPyIR
zOWb7OQ/ELtbAPuM6T8dvIdiC/PkPxcCRqkmj+k/BOUtelT05D8iFO0G
                "]], 
               LineBox[{{0.8012755102040817, 0.656109664822649}, {
                0.8024388112602567, 0.6565919445315871}, {0.8037652381656297, 
                0.657141852724703}, {0.8064180919763757, 
                0.6582416691109348}, {0.8170295072193599, 
                0.6626409346558622}, {0.8182677985372807, 
                0.6631543037216061}, {0.8195060898552016, 
                0.6636676727873502}, {0.8219826724910432, 
                0.664694410918838}, {0.8269358377627265, 
                0.6667478871818138}, {0.8368421683060933, 
                0.6708548397077654}, {0.8566548293928267, 
                0.6790687447596685}, {0.8962801515662935, 
                0.6954965548634748}, {0.9739717509693491, 
                0.7277058284200947}, {0.9987244897959183, 
                0.7379677839245038}}], 
               LineBox[{{1.0012755102040816`, 0.7389149737343684}, {
                1.1369227129030104`, 0.783409728150418}, {1.1382548904425511`,
                 0.7838467066599712}, {1.1395870679820916`, 
                0.7842836851695244}, {1.142251423061173, 
                0.7851576421886308}, {1.147580133219336, 
                0.7869055562268438}, {1.158237553535662, 
                0.7904013843032696}, {1.1795523941683133`, 
                0.797393040456121}, {1.180884571707854, 0.7978300189656742}, {
                1.1822167492473947`, 0.7982669974752274}, {
                1.1848811043264762`, 0.7991409544943339}, {1.190209814484639, 
                0.8008888685325467}, {1.1915419920241797`, 0.8013258470421}, {
                1.1928741695637202`, 0.8017628255516531}, {
                1.1955385246428016`, 0.8026367825707595}, {
                1.1968707021823424`, 0.8030737610803128}, {1.198202879721883, 
                0.803510739589866}, {1.1987244897959184`, 
                0.8036818371995723}}], 
               LineBox[{{1.2012755102040815`, 0.8043965877922923}, {
                1.2021994123405053`, 0.8046112529811652}, {1.203531589880046, 
                0.804920779425432}, {1.2061959449591275`, 
                0.8055398323139659}, {1.2115246551172902`, 
                0.8067779380910333}, {1.222182075433616, 
                0.8092541496451682}, {1.2234898928959086`, 
                0.8095580161170448}, {1.224797710358201, 
                0.8098618825889214}, {1.2274133452827862`, 
                0.8104696155326747}, {1.2326446151319568`, 
                0.8116850814201813}, {1.2431071548302977`, 
                0.8141160131951944}, {1.2640322342269796`, 
                0.8189778767452208}, {1.3058823930203434`, 
                0.8287016038452734}, {1.3839420330101317`, 
                0.8468384678064543}, {1.3987244897959183`, 
                0.850273116080145}}], 
               LineBox[{{1.4012755102040815`, 0.8508164427502207}, {
                1.547629076117258, 0.8791536935534554}, {1.5489670042909665`, 
                0.8794127457055402}, {1.550304932464675, 0.879671797857625}, {
                1.5529807888120917`, 0.8801899021617945}, {
                1.5583325015069254`, 0.8812261107701336}, {
                1.5690359268965925`, 0.8832985279868117}, {
                1.5703738550703008`, 0.8835575801388964}, {
                1.5717117832440093`, 0.8838166322909813}, {
                1.5743876395914262`, 0.8843347365951508}, {
                1.5797393522862597`, 0.8853709452034899}, {
                1.5904427776759271`, 0.8874433624201681}, {
                1.5917807058496356`, 0.8877024145722529}, {
                1.5931186340233439`, 0.8879614667243376}, {
                1.5957944903707606`, 0.8884795710285072}, {1.597132418544469, 
                0.8887386231805919}, {1.5984703467181776`, 
                0.8889976753326767}, {1.5987244897959185`, 
                0.889046882990098}}], LineBox[CompressedData["
1:eJwVx30s1HEAx3FPK8lqJg+72jhuncbMPHQ90Gd0Hm4pDukP06Txh5A2UcrD
uBAudDbq+rlkXGRNqyxjjeUpYx66PNRtVObW+n6ntsTvd19Kf7z32lucejUu
zcrCwkK603+T0t45fGjm4a9vXi7OI/AqLUkfaeXh175YbsgnEKmMytAOHpFL
drqzNwm2Kxq8ZK945CqzpnCbYKjWZs5jnMdkkL+fpJSgpz5lkJvisZJ9OYor
I3iq6e9y/chD0DekON8hqG7MLdu3zEMq2qizrSSI0634Ces8Srb7fhE1wdLz
oeoZsYCA0fCXrx8QTFMb4i8VcHd+gkq1BAM+4dENPgKWTPFeDx8RPO4ctr8g
E1Blm8oV6QhS20fUxmgBy4qiisg2glVurNaUL0A90ZO02E1AayY0W5MCTDNS
m61RAnOGQXukwAytcc95+R+ChKPJ9b7FZpyoinjDbRB0Wa6WB6jMWJCVHdzY
JLjYtHEt5J4ZThr2pcNMMDgsilI+MaNOsZa935Kiwv3S7xvjZqh6DJWf9lI4
ztHoMRFDVp2uP0dMkdmSFzbpxmB/yug27kExlPlXNith6PzhWuYpocizdvA0
+jKYIu4r5g5TLPoF8mthDKlbqrmTPhS66oI2lysMiRkZP3fJKDYTrbWHchjW
XfTxKccoYj1q6sTXGTTD33p6j1NY9XK3vIsZpt2TCzODKdJWB5TQMJyZj7Gb
DaV4+0IRKW9i+K6qyfI+TeFcOBus4Bgq/d9Pq+QUY44r0ng9w7A6rFEWSeEd
uns7vY8B8iAJF03R3flMujDAYBdiyzmeowg8EKtUjDAYgj47VcVQ2Fu2JmhG
GaZaksa/7vw/PRBJug==
                "]], 
               LineBox[{{1.8012755102040816`, 0.916283529357073}, {
                1.8023956352454178`, 0.9163804877888971}, {
                1.8037242586975861`, 0.9164954939191532}, {
                1.8063815056019226`, 0.9167255061796652}, {
                1.8077101290540907`, 0.9168405123099213}, {1.809038752506259, 
                0.9169555184401772}, {1.8116959994105954`, 
                0.9171855307006893}, {1.8170104932192683`, 
                0.9176455552217133}, {1.8382684684539596`, 
                0.9194856533058097}, {1.8807844189233422`, 
                0.9231658494740023}, {1.9601756422651684`, 
                0.9300379827017685}, {1.9987244897959184`, 
                0.9333747849937241}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBo1kr6CeDtPxMP8AjE
+gBAONFkmTg47j/SvYqHSf0AQAplSPodOe4/kmwlBs//AEDc+CtbAzruPxLK
WgPaBAFAgCDzHM477j8ShcX97w4BQMdvgaBjP+4/EPua8hsjAUBWDp6njkbu
PwznRdxzSwFAc0vXteRU7j/MleBa+U0BQEXfuhbKVe4/jER72X5QAUAXc553
r1buPwuisNaJVQFAu5plOXpY7j8KXRvRn18BQALq87wPXO4/CNPwxctzAUCR
iBDEOmPuP8iBi0RRdgFAYxz0JCBk7j+IMCbD1ngBQDWw14UFZe4/B45bwOF9
AUDY155H0GbuPwZJxrr3hwFAICcty2Vq7j/G92A5fYoBQPK6ECxLa+4/hqb7
twKNAUDETvSMMGzuPwUEMbUNkgFAZ3a7Tvtt7j/Essszk5QBQDkKn6/gbu4/
ubOE3fyWAUAIYqksvG/uP7NPouo=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUBJQembYHHuP9o8REjf
ngFAOky7vhpy7j+vuuzgmqEBQBq4ifrZcu4/WrY9EhKnAUDYjyZyWHTuP7Gt
33QAsgFAVj9gYVV37j9enCM63ccBQFKe0z9Pfe4/uHmrxJbzAUBIXLr8Qonu
P2s0u9kJSwJANtiHdiqh7j/A0NWsuE0CQJ3ymzTmoe4/FW3wf2dQAkAFDbDy
oaLuP7+lJSbFVQJA1EHYbhmk7j8TF5BygGACQHOrKGcIp+4/u/lkC/d1AkCx
fslX5qzuPwu/Dj3koAJALCULOaK47j9gWykQk6MCQJQ/H/ddue4/tfdD40Gm
AkD8WTO1GbruP18weYmfqwJAy45bMZG77j+zoePVWrYCQGr4qymAvu4/W4S4
btHLAkCoy0waXsTuP6tJYqC+9gJAI3KO+xnQ7j80LCE+P/kCQODtGBjJ0O4/
vg7g27/7AkCcaaM0eNHuP9DTXRfBAANAFWG4bdbS7j/0XVmOwwoDQAdQ4t+S
1e4/fUAYLEQNA0DEy2z8QdbuPwYj18nEDwNAgEf3GPHW7j8Z6FQFxhQDQPk+
DFJP2O4/PnJQfMgeA0DsLTbEC9vuP8dUDxpJIQNAqKnA4Lrb7j9QN863ySMD
QGUlS/1p3O4/YvxL88ooA0DeHGA2yN3uP+veCpFLKwNAmpjqUnfe7j90wcku
zC0DQFYUdW8m3+4//qOIzEwwA0ATkP+L1d/uP1JNHneWMANAxOf2runf7j8M
mAwB
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAFBlI7881A0AAF8BAFOHuP6wQQ+HP
PANAEczNeUri7j/Qmj5Y0kYDQGbjcBcG5O4/WX399VJJA0A7qdn+dOTuP+Jf
vJPTSwNAEW9C5uPk7j/0JDrP1FADQLv6E7XB5e4/Ga81RtdaA0AQErdSfefu
P2LDLDTcbgNAukD9jfTq7j/16xoQ5pYDQA+eiQTj8e4/lJ3nx5yZA0Amo61J
W/LuPzNPtH9TnANAPqjRjtPy7j9xsk3vwKEDQGyyGRnE8+4/7XiAzpusA0DK
xqktpfXuP+UF5oxRwgNAhu/JVmf57j/VH7EJve0DQP1ACqnrAO8/tVNHA5RE
BEDr44pN9A/vP4hLuIUcRwRAMK/GkmQQ7z9cQykIpUkEQHR6AtjUEO8/AjML
DbZOBED+EHpitRHvP04SzxbYWARAED5pd3YT7z/o0FYqHG0EQDWYR6H4Fu8/
Gk5mUaSVBEB/TAT1/B3vP+1F19MsmARAxBdAOm0e7z/APUhWtZoEQAjje3/d
Hu8/Zi0qW8afBECSefMJvh/vP7MM7mToqQRApKbiHn8h7z+GBF/ncKwEQOlx
HmTvIe8/WvzPafmuBEAuPVqpXyLvPwDssW4KtARAt9PRM0Aj7z9My3V4LL4E
QMkAwUgBJe8/H8Pm+rTABEAOzPyNcSXvP/K6V309wwRAUpc40+El7z/Gssj/
xcUEQJdidBhSJu8/mao5gk7IBEDcLbBdwibvP+zmtxAwygRAozPAuxUn7z9O
Tgh1
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAWIQvW7Tw47M8ywOzr4bt99Qf2+/szGP7+cVFgejqjOh
jRrv7Xsq709ovM7iIFB4S+0ckG+UeXDqpDssDmfivp1I13xvX+/ROn/LMxYH
Vys93tla7+0vxWXEGLxkcTjy53PUMyBfpdRbcs1rFgeX/TtXGGq/tz+1UHDy
4g9A+1xcXU4A+SK/57ZN+sXi4OgXU/1V5739irXbcgv4WB3skrpe+uu/t78g
9MJax4zVwbzr2VEWk/f2ine9bixuZXXQvDWvLs/2vX3XIev1oR2sDruNP5kc
API/LddpY+9mdfDtdX0taPfe/lARn0n2BFaHQoc34VuB/BSOS/1Gs1kddi6z
NPxjD7TPONL94AZWB4/iK487nd7b63Wlb7t3m9UhjYfLc6n7e/tp+RG9E+6x
OvxIjf3/Dcj/H+KZ4vSQ1aFr/4atHh5A98lrCy17xuqwrihc6Q2QX7j1XW7u
R1aHbzeW/Dbyem+/5UGp6h82NofWpfbrDvi8t7cyb5kiacTmsNiuVPhO4Hv7
a0mSZnNN2Bzk6qYGaAS9ty/uW3ddwZzNYeberb0lQP6apzekNGzYHPptvrHz
Br+3l5uiu9DMjc2h2qr8j23Ie/td+w857fJgc/hWOd2yC8gPfx3+xNabzaFw
5/aya0D+BKcmddcANoc0ix8f8kLf2zN9vLY2OIrNIcis8un8sPf282Ry/K/H
sDmcLZ2p9AbIt/Zg/BgVz+bgsXVnvEX4e/sbxdMm3Utkczj85eacFiC/tSFw
1clkoPrq6hP7gHwAU+kLpw==
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7e5TrcScyebAsliozyjivf0z34ZdBXlsDufs+Nrq
gPymStGYLwVsDhP2fd26EMiXX7rqb3kxm0Ow3d2nR4D8iD9XHOor2Bxu2K5x
5Y58b396lebx3iY2h0c2XqwzgPyMa/syBFvZHJbuMTTdDeSzMIVwTW1nc0i3
kUy9B+TbRdb5zulhc3hr/eKIStR7+w3sly+vmsbm8N2qrWUjkD8lpebB8VVs
DjyWh5hPR7+3j5E7/5PxMpuDqakV07/Y9/Z8kkVbd19lc1CP9VdXiXtvf1BY
tLD0BpuDVGuKjxeQr8YZ/eLFXTaH/1f6pk0D8t9/fnbt/As2hxMlj7X044H+
O/lv89x/bA4xW3qCExLe268o0cuz1GJ3aDK+v+RQ0nv7r6d6HxU0sjtcMGxx
b08H+l/qtXPyX3YH2YkeP3zz3tsDAKC9k+c=
                "]], 
               LineBox[{{3.001275510204082, 0.9822526846729579}, {
                3.0957081519843626`, 0.9837584443368803}, {
                3.1802851297394477`, 0.9851070521826334}, {
                3.1987244897959184`, 0.9854010738691831}}], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGCQB2IQXV2/LtRsDqfDr+P+1oc73tsfe3M9b74ol4NvHfPl
ORPf2/cYBOrFSHA5BC5Oen4eyBff4bz2qiyXQ/hbBQGzSe/t9Y5rrD6hweWQ
2jg3kWnye/uYp5+WrbPjcmhYOY1l9pT39jsV2+dVZXE5bP3Z4XVm+nv7ulSG
OPNcLocdci/i/gP5LisrZb/kcznscXYvNprx3v6CQc6c3FIuh0O9rHNmAPkv
7ANnJTRwOVxQbHqbMvO9vVic9DS3aVwOrzyrJ/yd9d6+aNb6XqFDXA4Ks3Kv
6c17b7/9z6z2Q0e4HNa9rfiTAOT/iWtrLDrO5WDj2KI0GchvV44tvXSGyyHi
xay870D+nDVcsZOuczlMMDvBdmD+e/uj+1J1hN5yOTBeVjIPXPjenksxUO3Q
ey6HfjW92GYgP6DZRqHoE5eDbJVl81Yg/5a7sMil71wOlooB5yUXvbd/d+HA
74lM3A5F+bXpj4B8icfSpwUluB0ecd+YXrzkvX2sK/vRg1LcDgXxj/cuBfIX
Lf+0r1CW2+H/pnePrwP5OjknN11U4naQjmI1sFn63r7w3JY1jarcDivXCoTl
AfnbDBYsM9TgdjBnlKlZAOQ7fi2bNVGX2yF4hdEJlmXv7dvCk6Y4GnA7PPxt
+84MyA/ylSufBuQfjXKSswXyAcM65rQ=
                "]], LineBox[CompressedData["
1:eJwVzHtI02EUxvFlq5T3TR2Oagrmcom1DUY2Saf9jpXhxC4zkKKMmhk5w8tM
MJsXVooUpnO6TC2lxqbivGRhipoiSmaSdkFKGwaijcoXsWwgUac/Dg8fvnDE
2szEVA8ej7cb7/8KRXHsjZJAteqzpNjGuKRCiVFzgIBCnN5uQtfP+xg2qAiU
XugwWNHzh9Zzu6IJzDauxvegdVvepgkOEygJNCzNoTvSBlKGY7EnDz1j6J8T
zcnZcfjvAf+Wh51xRZVFmulj2APKg0LR1SJ5hOk0dtHDMznoAWmZpyCDwCe/
oQmvZsaFv98+WZVFQDPSkhSA7jTYTcIcAuN68xcZ+tHkmP+OPAI905d/n0CX
ZW6S7zQSqKnYGmxBJ3YbNXILgZPkbP6uFsYtRRbUqQcJjHqshapaGSeI18uM
3hS6VqSlV9sY1zTsQyIFFCC37U4RWhHhcK34UZhyy0xV6OOhX20XRRSW/8ob
nqNvbz4vjpFQkHornvAdjOOPqLfxIinY9u53NqDXVGJeYSqFupSo8Ml2xpV0
DzqVVyjsWepXzaOF0nMDP3QUenXRMavoMP97+clZFGayDyaIOhiX5aa/om5Q
EBaDNhXteup2rVdSqGg4cvcPOk9medltphAYNGr27WScpzXMnm6h4Hgcez8Y
HWLOuDRbT+F161GrGq3NXnD22Sh49cb11aDn5FPvrvdTuPkhYVHexbjGb4KC
jS8oKMf1zRxa23IqpHyYwmJ/rU6Ddklm8prGKKitC8vX0N8Xe3wVryg07XN/
LEf/A1wREiU=
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQvW7Tw47M8zwO1h9EGndsfG9fOz2x4NZVHoeX927M
/ALkswg/PfT2Fo+DxL4XX5Q3vbcX5HqTLvKUx6GkhmN1E5Dv9oz9zzpeXofn
pe3Nfze/t98wz17lSRyvw5mMVpPP297bx643E5T9x+vwVp79zIE97+23Rf3g
u8DA5zDFUe/3TSCfj20XTzMzn4NNcqjWZyD/QIwtx0sOPoeuZYs7VPe+t1fi
cvm/RZjPQU3XwbULyH+WEvjWR5PPId6qcl/wvvf2dgLCr/9r8zmwxSx4mwPk
T9995cUmPT6HtbXHZdqAfA+hiCcSJnwOvw+IVu8A8lftj7v9xI7PYYb7JnPZ
/e/t86RyTtaE8DlcCHm94RmQf+yo7nH9cD6H8jKhB/+BfPnC90ceRfI5yM2w
5Jc88N7+wvGiAx7xfA65t9tzvYF8jWKTfb8T+RxE/q6bkwLktzYErjqZzOew
0LKvqBTIBwBlE6sb
                "]], LineBox[CompressedData["
1:eJwVz1tIk3EYBvClgpn5vXRaBIk5C9qisou0WvS9dGHpVuBSjE6eFqgYOjuY
h0zDrdBIy+GhUpSlhanTTcls5SzTTCTWLJXGsuZMI/kXpSNb2tvFw8Pv6uEJ
TEhTnPYQCARBlP99QJ4j8kzmcK+rcV2tmfFFG6Qd/akczj/OyewiOwbdhuw0
DkNXjR0bImtF+S3j5zg0vCwL/El2vdHUN13m8L7ER7+vh/H56roCWyOHuc/s
E6nPGe+X6R0R38zhh6ufCvPIt5POrJzUcyiNnNhYSjbKdutYO+05ppVG8uQK
S69HN4eZPrMTv8myGsFSsZXDjChfp+YF44WPYm+c/8Nh8tdQZ20v45un/O9w
csBo4U3ncB/jr1Wr4+yHAdN3HLk1RVYqZja1RAIWydfwbvJ6k6n1UAxg95Wq
yqB++ltyvO96AqCY1ckyyEkhVT+WZQG6+w1t8IrxosLVB70bAHVZw5ciBhi/
sCvXb+QB4FNtueQUeWzG8bbhIeCo/uiIilwaYzwZ1ga4fNIWXEVelCjOqk2A
FxROxxeyzVJS42kFDN8yF65+zfhOjSvR+g5QGdY5V0nWSmPFulHAvPhsXRNZ
Vr+tfb8d0Fix4LaSuy4ODRRMA/p7ebeKBhlfvnVnSeQ3wNCAgRMhZNXnu1GB
DFCxp9gngrxZnvrR/AtQkw6JKrLXkuF7pS7AumILqMnjHdKUuHnAJw1lpkqy
KUW3Pfgv4Pue6OQmckWA7+ziIuB321qhmfwPcb4dbA==
                "]]},
              
              Annotation[#, 
               "Charting`Private`Tag$72721#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, Automatic},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Cav2.1 intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT6aBcrKFmZVPwRDGnDf
GVQ/wwceEF8BXD8zn5icsxlkP/YEuapTTmE/S83Xsp0ZdD8fBw3wm+lnP1dk
972SGYQ/uYVaPRaQcj/dL4dDjRmUPwuKAsimxn8/oBVPhooZpD9YSanu4xmN
P4EIsyeJGbQ//qj8gYLDmz8qR5GIsnC0P47tgDUbNpw/0oVv6dvHtD8dMgXp
s6icPyQDLKsudrU/PbsNUOWNnT/G/aQu1NK2P3vNHh5IWJ8/DPOWNR+MuT/+
eCDdhnahP5jdekO1/r4/fJ1CeUwLpT9BHFmk3lW/P8S/BNOYRKU/6lo3BQit
vz8M4sYs5X2lPx7seWOtLcA/nSZL4H3wpT9vaTYlANzAP7yvU0ev1aY/EmSv
qKU4wj/7wWQVEqCoP1hZoa/w8cQ/euaGsdc0rD/v21QKohrFP8pdUf9Xaqw/
hl4IZVNDxT8a1RtN2J+sP7Njbxq2lMU/ucOw6NgKrT8Obj2FezfGP/ig2h/a
4K0/pfDw3yxgxj9IGKVtWhauPzxzpDreiMY/mI9vu9pLrj9qeAvwQNrGPzh+
BFfbtq4/xYLZWgZ9xz93Wy6O3IyvP1wFjbW3pcc/x9L421zCrz/yh0AQac7H
PxVKwynd968/II2nxcsfyD9bHKzibjGwP7cPWyB9SMg/A1iRCS9MsD9Okg57
LnHIP6qTdjDvZrA/fJd1MJHCyD/6CkF+b5ywPxMaKYtC68g/okYmpS+3sD+q
nNzl8xPJP0qCC8zv0bA/QB+QQKU8yT/yvfDyr+ywP9ehQ5tWZck/mvnVGXAH
sT+QO0vYzW/JP0iaYWBRDrE/z14sMQ==
                "]], 
               
               Line[{{0.20127551020408163`, 0.06807126420441924}, {
                0.2033724813112215, 0.06976016126502382}, {
                0.20461432671651483`, 0.07076034150002282}, {
                0.20585617212180818`, 0.07176052173502181}, {
                0.20833986293239484`, 0.07376088220501978}, {
                0.2133072445535682, 0.07776160314501573}, {0.2232420077959149,
                 0.08576304502500764}, {0.24311153428060836`, 
                0.10176592878499148`}, {0.2443290196086536, 
                0.1027464894540745}, {0.24554650493669883`, 
                0.1037270501231575}, {0.24798147559278932`, 
                0.10568817146132356`}, {0.2528514169049703, 
                0.10961041413765565`}, {0.2625912995293323, 
                0.11745489949031986`}, {0.28207106477805627`, 
                0.13314387019564827`}, {0.3210305952755042, 
                0.16452181160630505`}, {0.3987244897959184, 
                0.22709634572157117`}}], 
               
               Line[{{0.40127551020408164`, 0.22928698035592118`}, {
                0.48443648039284554`, 0.30513470893470235`}, {
                0.5699233045152912, 0.38310375400937524`}, {
                0.5987244897959183, 0.4093721402361553}}], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAtsqGI6Y94z+kJmtq3FTaP/UmPQ+t
bec/AbmzWtQZ4D8+4kLHinjnPzdxwxlyIeA/hp1If2iD5z9sKdPYDyngPxYU
VO8jmec/1pnyVks44D82AWvPmsTnP6l6MVPCVuA/eNuYj4gb6D9SPK9LsJPg
P/yP9A9kyeg/o7+qPIwN4T9ES/rHQdToP9h3uvspFeE/jAYAgB/f6D8NMMq6
xxzhPx19C/Da9Og/eKDpOAMs4T8+aiLQUSDpP0yBKDV6SuE/hiUoiC8r6T+B
OTj0F1LhP87gLUANNuk/tvFHs7VZ4T9eVzmwyEvpPyBiZzHxaOE/f0RQkD93
6T/0QqYtaIfhP8j/VUgdguk/Kvu17AWP4T8Qu1sA+4zpP1+zxaujluE/FwJG
qSaP6T+S2w8kKZjhPyNJlJM=
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAHTHtiQyk6T/siBgVvaThP+jsbCiU
rek/43Opy4ep4T8wqHLgcbjpP0yO0Ib+ruE/wB5+UC3O6T8ewx7967nhPwL5
qxAbJeo/ZZZX1qHl4T8bzULzPy/qPwNl4aC76uE/NKHZ1WQ56j+iM2tr1e/h
P2VJB5uuTeo/3tB+AAn64T/ImWIlQnbqP1gLpipwDuI/jzoZOmnH6j9MgPR+
PjfiPxx8hmO3aes/NGqRJ9uI4j82/2C2U67sPwM+y3gULOM/TE3AgkW47D/Y
HzeTFDHjP2ObH083wuw/rQGjrRQ24z+QN97nGtbsP1fFeuIUQOM/6W9bGeL9
7D+qTCpMFVTjP5zgVXxwTe0/UVuJHxZ84z8BwkpCjeztP554R8YXzOM/GBCq
Dn/27T90WrPgF9HjPy5eCdtwAO4/SDwf+xfW4z9a+sdzVBTuP/L/9i8Y4OM/
tDJFpRs87j9Fh6aZGPTjP2ajPwiqi+4/7JUFbRkc5D/MhDTOxirvPzqzwxMb
bOQ/Og/LApE17z9GZhD/h3HkP6iZYTdbQO8/Uxld6vR25D+Dro6g71XvP2x/
9sDOgeQ/OtjochiB7z+fSylugpfkP6hif6fii+8/rP51We+c5D8W7RXcrJbv
P7mxwkRcouQ/8QFDRUGs7z/SF1wbNq3kP6grnRdq1+8/BeSOyOnC5D8WtjNM
NOLvPxKX27NWyOQ/hEDKgP7s7z8fSiifw83kP31orA+N9e8/+Hl9GRHS5D8u
2RyH
                "]], 
               
               Line[{{1.0012755102040816`, 0.6516924249020462}, {
                1.0029484390136711`, 0.6522277329887018}, {
                1.0055826833813366`, 0.6530706453135753}, {
                1.0068998055651694`, 0.653492101476012}, {1.008216927749002, 
                0.6539135576384486}, {1.0108511721166678`, 
                0.654756469963322}, {1.0161196608519991`, 
                0.6564422946130689}, {1.017436783035832, 
                0.6568637507755056}, {1.0187539052196648`, 
                0.6572852069379423}, {1.0213881495873305`, 
                0.6581281192628158}, {1.0266566383226616`, 
                0.6598139439125625}, {1.0371936157933241`, 
                0.6631855932120563}, {1.0582675707346494`, 
                0.6699288918110436}, {1.1369227129030104`, 
                0.6950971676028352}, {1.1987244897959184`, 
                0.714872659991293}}], 
               
               Line[{{1.2012755102040815`, 0.7156278597638445}, {
                1.3058823930203434`, 0.7440907686711862}, {
                1.3839420330101317`, 0.7653303311411982}, {
                1.3987244897959183`, 0.7693525494655851}}], 
               
               Line[{{1.4012755102040815`, 0.7700300080850798}, {
                1.547629076117258, 0.8079404877186627}, {1.5489670042909665`, 
                0.8082870559656616}, {1.550304932464675, 
                0.8086336242126606}, {1.5529807888120917`, 
                0.8093267607066583}, {1.5583325015069254`, 
                0.8107130336946541}, {1.5690359268965925`, 
                0.8134855796706453}, {1.5703738550703008`, 
                0.8138321479176442}, {1.5717117832440093`, 
                0.8141787161646431}, {1.5743876395914262`, 
                0.8148718526586409}, {1.5797393522862597`, 
                0.8162581256466366}, {1.5904427776759271`, 
                0.8190306716226279}, {1.5917807058496356`, 
                0.8193772398696268}, {1.5931186340233439`, 
                0.8197238081166257}, {1.5957944903707606`, 
                0.8204169446106235}, {1.597132418544469, 
                0.8207635128576225}, {1.5984703467181776`, 
                0.8211100811046214}, {1.5987244897959185`, 
                0.8211759126811368}}], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAW2XDEdOe+T8sTvUtwkvqPyiCgGbG
o/k/Bkb2L6JN6j8ahNxRQan5PzCLyIy1T+o//oeUKDe0+T+GFW1G3FPqP8SP
BNYiyvk/MCq2uSlc6j/frsSL0SH6P9p82oZffeo/0O0E7DIn+j+1mvQ2aX/q
P8AsRUyULPo/kbgO53KB6j+gqsUMVzf6P0f0QkeGheo/YqbGjdxM+j+0a6sH
rY3qP+adyI/nd/o/j1p8iPqd6j/tjMyT/c36P0U4HoqVvuo/+2rUmyl6+z+w
82GNy//qP1Q2XZEuf/s/JT6hPLIB6z+sAeaGM4T7P5mI4OuYA+s/Xpj3cT2O
+z+CHV9KZgfrP8HFGkhRovs/VEdcBwEP6z+HIGH0eMr7P/maVoE2Hus/E9bt
TMga/D9BQkt1oTzrP2yhdkLNH/w/toyKJIg+6z/EbP830iT8PyrXydNuQOs/
dgMRI9wu/D8TbEgyPETrP9kwNPnvQvw/5ZVF79ZL6z+fi3qlF2v8P4rpP2kM
W+s/+FYDmxxw/D/+M38Y81zrP1AijJAhdfw/c36+x9le6z8CuZ17K3/8P1wT
PSanYus/ZebAUT+T/D8uPTrjQWrrP76xSUdEmPw/o4d5kihs6z8WfdI8SZ38
PxfSuEEPbus/yBPkJ1On/D8AZzeg3HHrPytBB/5mu/w/0pA0XXd56z+wqqsn
2MD8PycMAQiHe+s/NBRQUUnG/D97h82yln3rPwwBo1STx/w/CYtGsRN+6z88
/hrj
                "]], 
               
               Line[{{1.8012755102040816`, 0.85954283759651}, {
                1.8023956352454178`, 0.8596842552116547}, {
                1.8037242586975861`, 0.859851996091554}, {1.8063815056019226`,
                 0.8601874778513527}, {1.8077101290540907`, 
                0.8603552187312521}, {1.809038752506259, 
                0.8605229596111514}, {1.8116959994105954`, 
                0.8608584413709501}, {1.8170104932192683`, 
                0.8615294048905474}, {1.8382684684539596`, 
                0.8642132589689369}, {1.8807844189233422`, 
                0.8695809671257156}, {1.9601756422651684`, 
                0.8796042386838914}, {1.9987244897959184`, 
                0.8844710936181176}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBvGxIP7k/sPxMP8AjE
+gBAsHW9CCmx7D/SvYqHSf0AQAsD6PIlsuw/kmwlBs//AEBnkBLdIrPsPxLK
WgPaBAFAHqtnsRy17D8ShcX97w4BQIzgEVoQuew/EPua8hsjAUBoS2ar98Ds
PwznRdxzSwFAISEPTsbQ7D/MleBa+U0BQHyuOTjD0ew/jER72X5QAUDYO2Qi
wNLsPwuisNaJVQFAj1a59rnU7D8KXRvRn18BQP2LY5+t2Ow/CNPwxctzAUDZ
9rfwlODsP8iBi0RRdgFANITi2pHh7D+IMCbD1ngBQJARDcWO4uw/B45bwOF9
AUBHLGKZiOTsPwZJxrr3hwFAtWEMQnzo7D/G92A5fYoBQBDvNix56ew/hqb7
twKNAUBsfGEWdursPwUEMbUNkgFAI5e26m/s7D/Essszk5QBQH4k4dRs7ew/
ubOE3fyWAUC9Q2jXXu7sP8+vqvw=
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUDcdAU5wvDsP9o8REjf
ngFAu8S49iXy7D+vuuzgmqEBQAQEf3KT8+w/WrY9EhKnAUCXggtqbvbsP7Gt
33QAsgFAvX8kWST87D9enCM63ccBQAh6VjeQB+0/uHmrxJbzAUCebrrzZx7t
P2s0u9kJSwJAyVeCbBdM7T/A0NWsuE0CQMqEMzx+Te0/FW3wf2dQAkDMseQL
5U7tP7+lJSbFVQJAzgtHq7JR7T8TF5BygGACQNK/C+pNV+0/u/lkC/d1AkDa
J5VnhGLtPwu/Dj3koAJA6/enYvF47T9gWykQk6MCQOwkWTJYeu0/tfdD40Gm
AkDtUQoCv3vtP18weYmfqwJA76tsoYx+7T+zoePVWrYCQPRfMeAnhO0/W4S4
btHLAkD8x7pdXo/tP6tJYqC+9gJADZjNWMul7T80LCE+P/kCQDpomAQap+0/
vg7g27/7AkBnOGOwaKjtP9DTXRfBAANAwdj4Bwar7T/0XVmOwwoDQHQZJLdA
sO0/fUAYLEQNA0Ch6e5ij7HtPwYj18nEDwNAzrm5Dt6y7T8Z6FQFxhQDQCha
T2Z7te0/PnJQfMgeA0DcmnoVtrrtP8dUDxpJIQNACGtFwQS87T9QN863ySMD
QDU7EG1Tve0/YvxL88ooA0CP26XE8L/tP+veCpFLKwNAvKtwcD/B7T90wcku
zC0DQOl7OxyOwu0//qOIzEwwA0AWTAbI3MPtP1JNHneWMANA7/8iRAPE7T/U
1gXb
                "]], 
               
               Line[{{2.4012755102040817`, 0.9304272209536839}, {
                2.4046933744994785`, 0.9306504162711892}, {2.409580888186021, 
                0.9309695834688302}, {2.4108027666076564`, 
                0.9310493752682404}, {2.412024645029292, 
                0.9311291670676507}, {2.414468401872563, 
                0.9312887506664712}, {2.419355915559106, 
                0.9316079178641121}, {2.429130942932191, 
                0.9322462522593942}, {2.4486809976783612`, 
                0.9335229210499582}, {2.450006067043157, 
                0.9336094514830097}, {2.4513311364079526`, 
                0.9336959819160613}, {2.453981275137544, 
                0.9338690427821643}, {2.459281552596727, 
                0.9342151645143704}, {2.4698821075150925`, 
                0.9349074079787826}, {2.491083217351824, 0.936291894907607}, {
                2.5334854370252864`, 0.9390608687652559}, {
                2.5987244897959183`, 0.9433211464821016}}], 
               Line[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAArrLhiGnPBECjbS0DEzHuPyHdStij
hQVA7fjGvEJi7j+KwjuvVYgFQIQ24u/8Yu4/8qcshgeLBUAadP0it2PuP8Jy
DjRrkAVARu8ziStl7j9kCNKPMpsFQJ/loFUUaO4/qDNZR8GwBUBR0nru5W3u
Py6KZ7be2wVAtKsuIIl57j+Wb1iNkN4FQErpSVNDeu4//1RJZELhBUDhJmWG
/XruP9AfKxKm5gVADaKb7HF87j9xte5tbfEFQGaYCLlaf+4/tOB1JfwGBkAY
heJRLIXuPzo3hJQZMgZAe16Wg8+Q7j/WYhk2nTQGQArbvj19ke4/c46u1yA3
BkCZV+f3KpLuP6zl2BooPAZAt1A4bIaT7j8elC2hNkYGQPNC2lQ9lu4/ur/C
QrpIBkCCvwIP65buP1frV+Q9SwZAETwryZiX7j+QQoInRVAGQC81fD30mO4/
AvHWrVNaBkBrJx4mq5vuP54cbE/XXAZA+qNG4Fic7j87SAHxWl8GQIkgb5oG
ne4/2HOWkt5hBkAYnZdUtJ3uP4WAUarJYwZAwjmF4jie7j8WxsAy
                "]], 
               Line[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAR0x7IgNpBkDlRQaqZ5/uP+ZNgLpw
bgZAPFVbv2Wg7j+CeRVc9HAGQHwlA2/boO4/H6Wq/XdzBkC89aoeUaHuP1j8
1EB/eAZAPJb6fTyi7j/LqinHjYIGQDvXmTwTpO4/aNa+aBGFBkB7p0HsiKTu
PwQCVAqVhwZAu3fpm/6k7j8+WX5NnIwGQDsYOfvppe4/sAfT06qWBkA6Wdi5
wKfuP5RkfODHqgZAOdsWN26r7j9cHs/5AdMGQDbfkzHJsu4/9cqN4nCBB0C3
x+k3rtLuP9wL1Wj8gwdAdRgMWSXT7j/CTBzvh4YHQDNpLnqc0+4/kM6q+56L
B0CwCnO8itTuPyrSxxTNlQdAqE38QGfW7j9e2QFHKaoHQJnTDkog2u4/RBpJ
zbSsB0BYJDFrl9ruPytbkFNArwdAFnVTjA7b7j/43B5gV7QHQJIWmM782+4/
kuA7eYW+B0CLWSFT2d3uP8bndavh0gdAfN8zXJLh7j+sKL0xbdUHQDowVn0J
4u4/k2kEuPjXB0D4gHiegOLuP2DrksQP3QdAdCK94G7j7j/67q/dPecHQG1l
RmVL5e4/4C/3Y8npB0ArtmiGwuXuP8dwPupU7AdA6QaLpznm7j+U8sz2a/EH
QGaoz+kn5+4/ezMUfffzB0Ak+fEKn+fuP2J0WwOD9gdA4kkULBbo7j8v9ukP
mvsHQF7rWG4E6e4/HxrrQ2P9B0As0IMHWOnuP/O6DIo=
                "]], 
               Line[CompressedData["
1:eJwVzHtIE1AYBfA5iu71kVqZtZLUNNeIZtJ6GHk/bdaQ0txErFH5XGmaSZKy
NZexEi00RJ1hYg3LEmRZ015Cglbaw1ylEaRWlpCPuy3bnPnq9sfh8OPA8UvO
lqZxORxOIMv//vZzRdt1LgJLkdJj5hcl90KjDTKEoPnpx9C4UUp0qkrRkDOC
mv4Si4o5dW59hN0dQbbrlPw1c1TYya7CZQgOBTV5TjJv0dyPdvNCII5Ieckb
o2SeEy4P4CFYlf8uJIO5etHRXGkAgvbhBozH2Z7iLTJtQOAR6e0QMqd29Npi
NiJIun1pJJ45+MKevAObEXDT0zrqmbsW+ErJDvZP/dUwQcnU30lN2H4E3Y5a
Sx6lJN5afFmQi8DkVvFpxELJ8sEWPbcTwfD287c6bZSUuqrVD18gWDjt9ZUy
O+8SJ2R2I1jT2MhbbaeEW/3erb8HgWxtX1kW8+9Yc/7dzwg6OALlyilKep/z
Yw6aEei7P0SfcFBypalmppaHIUke5HCZoQR9Se6X+mBQV7SFbGPWOgual/hi
uPY2NiuRWXX8kSInEIOJnPtuZM7w6zOJgzGEB5jeHJmlRFK59M5YJAbfCeVN
wxwli9WFcTtzMAwV9ETJOGZitI5PPzuDwdCiMCqZUxUJdXvPYtCMz/vomTtj
hKMyFYZ1h4VWC7PWf0Bz6iKGY6KrulInM9mqkwTaijAIM/lOrcw/XIyvVCUY
FvTtGQPMYluJV3EZhjoP6+5NXDP5k25/4l6OIXtfcYOMuX4wKbGqAgMp8PNU
MT9+oB2YrcKAWqe1N5j/AWfUF/M=
                "]], 
               Line[CompressedData["
1:eJwVx30s1HEcwPGjxn7fXw+eytV1FabOhZ1qmPD5HHnMcyzCrTG27BDb5aEV
Ms4fbtJ0cpNEyDwtlYdq5OYxFpkwWisiteorpVK36dcf7733sohLDUvQ5/F4
Iq7/v5TTGuFYyeD38Ignblso9GuWsaeWQY+cpwrVVgr5yWXTsy0MbuTHLwYb
UNA3XdXboWUwUXW/Z4qh0K6MbijrZ7AsSHDWi1CI0w0GCIYY7NtZsP6Is3bp
VrlojEHh9UjbcpbC1a5Tdp7TDE6pNyuitlPQkzVEZn5iUFodqHhjRIHXKGtb
MCG478HHIyvmFAY/z6Tc3kWwxN/uWByfQrEk1D6GT1B/4YLLa87mXZ4tr4QE
Pxj99p3YQ8F+SNQ0LCLYnmKQ2CWgELO0Vt/qTtBPbFVddIBCt4WyKjuJoOJO
jJnNYQpXEngyp2SCK87VglrOJxuzhD9SCUZPLFoKRRQmJPLKZAVB6WaSg7EN
hRUI1ZzLJbgtNitoQ0xht0yg9lYTrOGri0bsKaRr2lQmWoLjJeO6844UOnUa
pbaf4NRox/N3nHWywrz0IYJzhlU3o5woKK1iFZNjBN/nyI/7OVOobCax12cI
/kll5CIXCgM9CbYmXwhah3jOL7tRIBahh7SUoLhY3ChzpxCS73owfY2gZNg4
Y5rznI+p2eQvgi741mQQKHydePa3VJ/FYMll/zopBf6iYNSYz2K2UWd3vBeF
WC/Dgb69LOYGVCnnOdc0rPWkCVksKCqIOO1NwVY+0v7SksVrvPBvHj4U0l48
bM6zZvGG64nex5w7JNX1DiIWNZmWqqO+FKTrFzWldizWra6KLP0oFJ6JK5NK
WGyynf1ZwTkscH+GmvPdWab3Hud/uesbtw==
                "]], 
               Line[CompressedData["
1:eJwVzn0sFGAcB/DTC7bn8XLzEjY1klpcu2bkvPT8dGvz3u5aKjncobxsONYm
Oeo4HUM4zltKL3OEVBdtDXWrrK6MYrPSTFZC9HTtlKatnv747rvPH9/t6yHL
Eadt4nA4u1n+t6NrOB33RzCQaPSESEriir2UokAEVRO+Oilz25xdkUUwghrZ
rmYV89yhjbP3QhFcNrtXdDNnWr3N4AoRaFzsskzM/RnDKYbDCBpuWyU4RVFi
ftUlkYcj0IZwYgTMJbUlojcxCFqSTfsuMje48gR1JxB0dE3+sI+mZNhHbc3N
RtAb2FzIj6EkYGrbWH0ugr/xGgsx890iXZ1jPgKxokadz3xjbNTNpQDBL0OZ
dpBZnbOVt0OJQBglvx8SS4lYrxTxtAjeSSKXw49Q8iVI0RoxgsCy9M9JqYgS
bmSer9IWQ9JYsqD+GCUdBjsUxMWQ7LysGWTmC/qWTA4YpEn5394zx+5Z7JS6
Ykg1qW7ujKOk0jLRI8wLQ7pTj80A85anEc6cIAxyydrH6eOU/Az24BSnYShd
rah0j6dEpR+Z9U/HUBbg8DmM2dEnYXg1E4Oq5Ao5zezn1lQoycWg5vab7zDn
ruO1kPMYqvynEuEUJUsP1pc2ajE0Krb7pSRQUuCrfaHXYNCO6qovMVvf8tNl
aTE02e1f7GH21mSnzrRhaL0ubDczy+SfZh91Yrj6PN2qXELJB97E5LkhDDob
/UxXIiXXvnIVmx9j+L1w8LWRWdZ91LvagCH6iXFohdn7TOO48zO2b4nrs01i
f7ymCzpGMXzPm2/nM/fOu3jufYlBGJ1dI2ZeWXhozzdiOFB+ITSZ+R+xgRWh

                "]], 
               Line[CompressedData["
1:eJwVx30s1HEcwPGL8tTv+/UsayokD8vDZlFby++jbuqslIcQwh3yUJGj5lCe
Ej2sZYSeSGlGi3PEjebh5iEhatScMIZC/LZoY5E+/fHeey8zUZxXhAqPx7PH
/r9aNpkbPcCAMmKlvCCEY68XCa8ohxkw8rZsbEVv1Z9RLCoZiLKVVUyidbV+
RhrMMEAmenL3hXLsULedbsl3Bhp6tTOc0cXZcU1W8wyEyM9KjqN3b1lmDnMM
yPImo6PRtqtrtcI1Bnz5a+5v0G6z6uvVhEBppTVxEnKsZrng1SEdAoLC2G1u
6D7hXQ+FHoFfmfUbvmjvMVo2vIMAPwiWktChQ4Zu62YE5qj/wDt0imLvA4Ez
AcfEnDy+iGOlJazFdDCBDpdZQ58wjl1OXlYXCgmcaeyQh6Od/SoWxsIIfHN4
GXgV3aytXfc1isCKaWhZIborfdy1V0zAQlVpO4IeFV0Pkd0ikNXdfyw4nGPV
rJofp1cTOHrmbXxUBMcKVONubEgJfHyfbyBB35swFyXXEQhwFTfeRusW37FJ
lBMQOzpsVKFNNAPkkQoCLwwqcxfRjgurwx5fCKiMPC0VX+DY8zXOurv+EmgX
3uxPjeTYhoBVOsijUL5oo7yPpmpNTJYqhRzJwOxzdFvQEY05DQqn8nbyOtHm
WvzNen0KI21SRxLFsbPhnosnbSj82jNW9AztoqO/sLmfwvDrzPIadFHz0A+Z
PQX5QevadvQJPf9p4wMU0k4nfJhBV7UGj067UNieprlhF82xKhdNR4pcKSxp
1WgCOtBo6os7n8KnQh8jLzRzOeKzVEChuLrU4Ro6duelnlQfChbjTqIWdFen
XbeDHwX1mNHYQfSeeK5j6hyF+d/pKVPoJJNaxcMgCv0Zlrkr6MFucduJEApS
0legFsOx1gkHWv4IKeQ/ii8zRmene1b1hFF4Ijkts0D/A+T8U3g=
                "]], 
               Line[CompressedData["
1:eJwV0X0sFHAYB/DjmGJ+vzqm/tDirBzrTWKZ5ffMTKe7S8wm2o1Uw3W3SxHh
QhzSy12760W4ZtfJOHpxynLpZSZm1nT0suwyyi5jP70Ylbp+/fHsu88fz/bs
+wRmKZOPuXI4nGA2/3OvuITPzUUwbNRfkckoqQuI7n4pR+BjGw9+yDw9vPKg
WInAenpAMses55d3TuYjwH136g8ep2TpVbXJXIbAIpaFhckpOVAiNGacQyBd
SE/NZm7d7NnMUyPw0ItUTczpqkuNRXUI0j5sGVqtoMQaqtfFXUXgzKWZU8zl
6uaKiTYECTX5Wp2SEu9Cj32HOxDIubnrBphv5ih4M3cRaMqkhmXmLlGUkVoQ
vCmMN0tPUDKzdrTf9SmCrJz1g8F5lIgMnFUhNgQlCVZn70lK/B5lXC74jcDs
5ab8VEBJh2NDAxJjWKPVSSJKKaltUmfa92O4EWW3KJiPJs9v6kzCEDgt8G9h
9rda70lSMeyM7Jv1U7G+NIcGLmZhSJlw1Cwz50TWf/U8g6FeEPOit4wSfpWv
0KMFA/+5IzK2kpK/u0u937ZiaJeFG4qZ389Pv25pxxDue9a9i1mb2iWNv48h
LttnLKiKEmdo8im1FUO2d0yeu5qSiVGNgWtj+2m69sFqSnqql47YxjHs4tp5
LjXsP9EZIcZ3GKxmQXEUs8i0zRJrxzDifCJsY35cNDJU8QXDgsnx+UItJde2
RmiS5jAUJYZL+pnzphpTAikGl58qywqzQCz/+OwHBp7Yp1JxnhI3l7Hb2iUM
DYvSWRPzZHe0LPMXhqBbrUl2ZqvMuH3HHwxm4fcevzpKrm/0WnQ62X3f9gQk
Mv8D96YmeA==
                "]]}, "Charting`Private`Tag$72721#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT41ly1xpGRmPwRDGnDf
GVQ/jtpebt3BbD8zn5icsxlkP/QOyDWLj3E/S83Xsp0ZdD9OUvkyxOx3P1dk
972SGYQ/geytFptTgj/dL4dDjRmUPzRzEBENDo8/oBVPhooZpD9OwOqCeEGc
P4EIsyeJGbQ/2ubXOy7bqj8qR5GIsnC0P/NaN3WSSas/0oVv6dvHtD8Lz5au
9rerPyQDLKsudrU/PbdVIb+UrD/G/aQu1NK2P5+H0wZQTq4/DPOWNR+MuT8y
lOfouOCwP5jdekO1/r4/+DTjs9pTtD9BHFmk3lW/PwXvktAMi7Q/6lo3BQit
vz8SqULtPsK0Px7seWOtLcA/Kx2iJqMwtT9vaTYlANzAP1wFYZlrDbY/EmSv
qKU4wj+/1d5+/Ma3P1hZoa/w8cQ/hXbaSR46uz/v21QKohrFP5nongWobbs/
hl4IZVNDxT+tWmPBMaG7P7Njbxq2lMU/0z7sOEUIvD8Obj2FezfGPyEH/ids
1rw/xYLZWgZ9xz++lyEGunK+P1wFjbW3pcc/0gnmwUOmvj/yh0AQac7HP+V7
qn3N2b4/II2nxcsfyD8MYDP14EC/P7cPWyB9SMg/INL3sGp0vz9Okg57LnHI
PzREvGz0p78/fJd1MJHCyD8ulCLygwfAPxMaKYtC68g/OM0E0EghwD+qnNzl
8xPJP0IG560NO8A/QB+QQKU8yT9LP8mL0lTAP9ehQ5tWZck/VXiraZduwD+Q
O0vYzW/JP7lNcQ84dcA/kV0T+w==
                "]], 
               Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAApPfnWmXDyT8sw6b7AMHAPzKsEQYc
CMo/z3yqKxUSwT/JLsVgzTDKPxuhjiwZQsE/YLF4u35Zyj9mxXItHXLBP422
33Dhqso//A07LyXSwT/owK3bpk3LPymfyzI1ksI/ntVJsTGTzD+Dwew5VRLE
Pwv/gVxHHs8/OAYvSJUSxz+YaVdeLEbPP+JARiqoQcc/JNQsYBFuzz+Le10M
u3DHPz6p12Pbvc8/3vCL0ODOxz+5qZa1ty7QP4bb6Fgsi8g/7VPsvEvO0D/V
sKJpwwPKP1Wol8tzDdI/c1sWi/H0zD8lUe7ow4vUP1jY/uama9E/Gn9HOmeh
1D+ckIALL4XRPxCtoIsKt9Q/4kgCMLee0T/6CFMuUeLUP2u5BXnH0dE/0MC3
c9441T+AmgwL6DfSP3owgf745dU/qFwaLykE0z/ODxQULkDXP/fgNXernNQ/
wz1tZdFV1z88mbebM7bUP7hrxrZ0a9c/gFE5wLvP1D+jx3hZu5bXPwvCPAnM
AtU/eH/dnkjt1z8eo0Ob7GjVPyLvpiljmtg/RmVRvy011j8XHQB7BrDYP4sd
0+O1TtY/DEtZzKnF2D/Q1VQIPmjWP/emC2/w8Ng/WkZYUU6b1j/MXnC0fUfZ
P24nX+NuAdc/lWryuLOE2T+Mo4jLqEnXP4cB+Qs=
                "]], 
               Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAn8hAen+u2T/PLIe4Q3TXP6SNMIz7
HNo/x4rPOiXT1z/RTCfZXkXaP4R1a0/U9dc/K8sUcyWW2j/9SqN4MjvYP9/H
76ayN9s/7/USy+7F2D9HwaUOzXrcP9NL8m9n29k/F7QR3gEB3z+c97C5WAbc
P1yM+1TkFt8/IScT9CMZ3D+iZOXLxizfP6dWdS7vK9w/LBW5uYtY3z+ytTmj
hVHcP0J2YJUVsN8/yXPCjLKc3D82nFemlC/gP/Xv018MM90/YV6mXaje4D9Q
6PYFwF/eP4RKG5mZ6eA/1hdZQIty3j+mNpDUivTgP1pHu3pWhd4/7A56S20K
4T9mpn/v7KreP3a/TTkyNuE/fGQI2Rn23j+MIPUUvI3hP6rgGaxzjN8/tuJD
zM884j+BbB6pk1zgP9ZIgfGNR+I/jpUhZ81l4D/2rr4WTFLiP5u+JCUHb+A/
N3s5Ychn4j+2ECuheoHgP7gTL/bAkuI/6rQ3mWGm4D/YeWwbf53iP/fdOleb
r+A/+N+pQD2o4j8EBz4V1bjgPzisJIu5veI/HllEkUjL4D+5RBogsujiP1L9
UIkv8OA/2qpXRXDz4j9gJlRHafngP/oQlWou/uI/bU9XBaMC4T863Q+1qhPj
P4ehXYEWFeE/WkNN2mge4z+UymA/UB7hP7Cb30LAKOM/H9wqwzEn4T8ihAXk

                "]], 
               Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAtsqGI6Y94z8tQmIqWzbhP9rbQm9h
SeM/S7UG4k094T/6QYCUH1TjP6ScsKuqQ+E/Ow773ptp4z9VawQ/ZFDhP7ym
8HOUlOM/twisZddp4T/cDC6ZUp/jPw/wVS80cOE//HJrvhCq4z9o1//4kHbh
Pz0/5giNv+M/GaZTjEqD4T++19udherjP3tD+7K9nOE/vwjHx3ZA5D8+fkoA
pM/hP8JqnRtZ7OQ/xfPomnA14j/1Jj0PrW3nP/xW4AVFseM/PuJCx4p45z/4
AZyCtLfjP4adSH9og+c/9KxX/yO+4z8WFFTvI5nnP+sCz/gCy+M/NgFrz5rE
5z/Yrr3rwOTjP3jbmI+IG+g/tQab0TwY5D/8j/QPZMnoP262VZ00f+Q/REv6
x0HU6D9pYREapIXkP4wGAIAf3+g/ZAzNlhOM5D8dfQvw2vToP1xiRJDymOQ/
Pmoi0FEg6T9KDjODsLLkP4YlKIgvK+k/Rrnu/x+55D/O4C1ADTbpP0FkqnyP
v+Q/Xlc5sMhL6T84uiF2bszkP39EUJA/d+k/JmYQaSzm5D/I/1VIHYLpPyIR
zOWb7OQ/ELtbAPuM6T8dvIdiC/PkPxcCRqkmj+k/BOUtelT05D8iFO0G
                "]], 
               
               Line[{{0.8012755102040817, 0.656109664822649}, {
                0.8024388112602567, 0.6565919445315871}, {0.8037652381656297, 
                0.657141852724703}, {0.8064180919763757, 
                0.6582416691109348}, {0.8170295072193599, 
                0.6626409346558622}, {0.8182677985372807, 
                0.6631543037216061}, {0.8195060898552016, 
                0.6636676727873502}, {0.8219826724910432, 
                0.664694410918838}, {0.8269358377627265, 
                0.6667478871818138}, {0.8368421683060933, 
                0.6708548397077654}, {0.8566548293928267, 
                0.6790687447596685}, {0.8962801515662935, 
                0.6954965548634748}, {0.9739717509693491, 
                0.7277058284200947}, {0.9987244897959183, 
                0.7379677839245038}}], 
               
               Line[{{1.0012755102040816`, 0.7389149737343684}, {
                1.1369227129030104`, 0.783409728150418}, {1.1382548904425511`,
                 0.7838467066599712}, {1.1395870679820916`, 
                0.7842836851695244}, {1.142251423061173, 
                0.7851576421886308}, {1.147580133219336, 
                0.7869055562268438}, {1.158237553535662, 
                0.7904013843032696}, {1.1795523941683133`, 
                0.797393040456121}, {1.180884571707854, 0.7978300189656742}, {
                1.1822167492473947`, 0.7982669974752274}, {
                1.1848811043264762`, 0.7991409544943339}, {1.190209814484639, 
                0.8008888685325467}, {1.1915419920241797`, 0.8013258470421}, {
                1.1928741695637202`, 0.8017628255516531}, {
                1.1955385246428016`, 0.8026367825707595}, {
                1.1968707021823424`, 0.8030737610803128}, {1.198202879721883, 
                0.803510739589866}, {1.1987244897959184`, 
                0.8036818371995723}}], 
               
               Line[{{1.2012755102040815`, 0.8043965877922923}, {
                1.2021994123405053`, 0.8046112529811652}, {1.203531589880046, 
                0.804920779425432}, {1.2061959449591275`, 
                0.8055398323139659}, {1.2115246551172902`, 
                0.8067779380910333}, {1.222182075433616, 
                0.8092541496451682}, {1.2234898928959086`, 
                0.8095580161170448}, {1.224797710358201, 
                0.8098618825889214}, {1.2274133452827862`, 
                0.8104696155326747}, {1.2326446151319568`, 
                0.8116850814201813}, {1.2431071548302977`, 
                0.8141160131951944}, {1.2640322342269796`, 
                0.8189778767452208}, {1.3058823930203434`, 
                0.8287016038452734}, {1.3839420330101317`, 
                0.8468384678064543}, {1.3987244897959183`, 
                0.850273116080145}}], 
               
               Line[{{1.4012755102040815`, 0.8508164427502207}, {
                1.547629076117258, 0.8791536935534554}, {1.5489670042909665`, 
                0.8794127457055402}, {1.550304932464675, 0.879671797857625}, {
                1.5529807888120917`, 0.8801899021617945}, {
                1.5583325015069254`, 0.8812261107701336}, {
                1.5690359268965925`, 0.8832985279868117}, {
                1.5703738550703008`, 0.8835575801388964}, {
                1.5717117832440093`, 0.8838166322909813}, {
                1.5743876395914262`, 0.8843347365951508}, {
                1.5797393522862597`, 0.8853709452034899}, {
                1.5904427776759271`, 0.8874433624201681}, {
                1.5917807058496356`, 0.8877024145722529}, {
                1.5931186340233439`, 0.8879614667243376}, {
                1.5957944903707606`, 0.8884795710285072}, {1.597132418544469, 
                0.8887386231805919}, {1.5984703467181776`, 
                0.8889976753326767}, {1.5987244897959185`, 
                0.889046882990098}}], 
               Line[CompressedData["
1:eJwVx30s1HEAx3FPK8lqJg+72jhuncbMPHQ90Gd0Hm4pDukP06Txh5A2UcrD
uBAudDbq+rlkXGRNqyxjjeUpYx66PNRtVObW+n6ntsTvd19Kf7z32lucejUu
zcrCwkK603+T0t45fGjm4a9vXi7OI/AqLUkfaeXh175YbsgnEKmMytAOHpFL
drqzNwm2Kxq8ZK945CqzpnCbYKjWZs5jnMdkkL+fpJSgpz5lkJvisZJ9OYor
I3iq6e9y/chD0DekON8hqG7MLdu3zEMq2qizrSSI0634Ces8Srb7fhE1wdLz
oeoZsYCA0fCXrx8QTFMb4i8VcHd+gkq1BAM+4dENPgKWTPFeDx8RPO4ctr8g
E1Blm8oV6QhS20fUxmgBy4qiisg2glVurNaUL0A90ZO02E1AayY0W5MCTDNS
m61RAnOGQXukwAytcc95+R+ChKPJ9b7FZpyoinjDbRB0Wa6WB6jMWJCVHdzY
JLjYtHEt5J4ZThr2pcNMMDgsilI+MaNOsZa935Kiwv3S7xvjZqh6DJWf9lI4
ztHoMRFDVp2uP0dMkdmSFzbpxmB/yug27kExlPlXNith6PzhWuYpocizdvA0
+jKYIu4r5g5TLPoF8mthDKlbqrmTPhS66oI2lysMiRkZP3fJKDYTrbWHchjW
XfTxKccoYj1q6sTXGTTD33p6j1NY9XK3vIsZpt2TCzODKdJWB5TQMJyZj7Gb
DaV4+0IRKW9i+K6qyfI+TeFcOBus4Bgq/d9Pq+QUY44r0ng9w7A6rFEWSeEd
uns7vY8B8iAJF03R3flMujDAYBdiyzmeowg8EKtUjDAYgj47VcVQ2Fu2JmhG
GaZaksa/7vw/PRBJug==
                "]], 
               
               Line[{{1.8012755102040816`, 0.916283529357073}, {
                1.8023956352454178`, 0.9163804877888971}, {
                1.8037242586975861`, 0.9164954939191532}, {
                1.8063815056019226`, 0.9167255061796652}, {
                1.8077101290540907`, 0.9168405123099213}, {1.809038752506259, 
                0.9169555184401772}, {1.8116959994105954`, 
                0.9171855307006893}, {1.8170104932192683`, 
                0.9176455552217133}, {1.8382684684539596`, 
                0.9194856533058097}, {1.8807844189233422`, 
                0.9231658494740023}, {1.9601756422651684`, 
                0.9300379827017685}, {1.9987244897959184`, 
                0.9333747849937241}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBo1kr6CeDtPxMP8AjE
+gBAONFkmTg47j/SvYqHSf0AQAplSPodOe4/kmwlBs//AEDc+CtbAzruPxLK
WgPaBAFAgCDzHM477j8ShcX97w4BQMdvgaBjP+4/EPua8hsjAUBWDp6njkbu
PwznRdxzSwFAc0vXteRU7j/MleBa+U0BQEXfuhbKVe4/jER72X5QAUAXc553
r1buPwuisNaJVQFAu5plOXpY7j8KXRvRn18BQALq87wPXO4/CNPwxctzAUCR
iBDEOmPuP8iBi0RRdgFAYxz0JCBk7j+IMCbD1ngBQDWw14UFZe4/B45bwOF9
AUDY155H0GbuPwZJxrr3hwFAICcty2Vq7j/G92A5fYoBQPK6ECxLa+4/hqb7
twKNAUDETvSMMGzuPwUEMbUNkgFAZ3a7Tvtt7j/Essszk5QBQDkKn6/gbu4/
ubOE3fyWAUAIYqksvG/uP7NPouo=
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUBJQembYHHuP9o8REjf
ngFAOky7vhpy7j+vuuzgmqEBQBq4ifrZcu4/WrY9EhKnAUDYjyZyWHTuP7Gt
33QAsgFAVj9gYVV37j9enCM63ccBQFKe0z9Pfe4/uHmrxJbzAUBIXLr8Qonu
P2s0u9kJSwJANtiHdiqh7j/A0NWsuE0CQJ3ymzTmoe4/FW3wf2dQAkAFDbDy
oaLuP7+lJSbFVQJA1EHYbhmk7j8TF5BygGACQHOrKGcIp+4/u/lkC/d1AkCx
fslX5qzuPwu/Dj3koAJALCULOaK47j9gWykQk6MCQJQ/H/ddue4/tfdD40Gm
AkD8WTO1GbruP18weYmfqwJAy45bMZG77j+zoePVWrYCQGr4qymAvu4/W4S4
btHLAkCoy0waXsTuP6tJYqC+9gJAI3KO+xnQ7j80LCE+P/kCQODtGBjJ0O4/
vg7g27/7AkCcaaM0eNHuP9DTXRfBAANAFWG4bdbS7j/0XVmOwwoDQAdQ4t+S
1e4/fUAYLEQNA0DEy2z8QdbuPwYj18nEDwNAgEf3GPHW7j8Z6FQFxhQDQPk+
DFJP2O4/PnJQfMgeA0DsLTbEC9vuP8dUDxpJIQNAqKnA4Lrb7j9QN863ySMD
QGUlS/1p3O4/YvxL88ooA0DeHGA2yN3uP+veCpFLKwNAmpjqUnfe7j90wcku
zC0DQFYUdW8m3+4//qOIzEwwA0ATkP+L1d/uP1JNHneWMANAxOf2runf7j8M
mAwB
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAFBlI7881A0AAF8BAFOHuP6wQQ+HP
PANAEczNeUri7j/Qmj5Y0kYDQGbjcBcG5O4/WX399VJJA0A7qdn+dOTuP+Jf
vJPTSwNAEW9C5uPk7j/0JDrP1FADQLv6E7XB5e4/Ga81RtdaA0AQErdSfefu
P2LDLDTcbgNAukD9jfTq7j/16xoQ5pYDQA+eiQTj8e4/lJ3nx5yZA0Amo61J
W/LuPzNPtH9TnANAPqjRjtPy7j9xsk3vwKEDQGyyGRnE8+4/7XiAzpusA0DK
xqktpfXuP+UF5oxRwgNAhu/JVmf57j/VH7EJve0DQP1ACqnrAO8/tVNHA5RE
BEDr44pN9A/vP4hLuIUcRwRAMK/GkmQQ7z9cQykIpUkEQHR6AtjUEO8/AjML
DbZOBED+EHpitRHvP04SzxbYWARAED5pd3YT7z/o0FYqHG0EQDWYR6H4Fu8/
Gk5mUaSVBEB/TAT1/B3vP+1F19MsmARAxBdAOm0e7z/APUhWtZoEQAjje3/d
Hu8/Zi0qW8afBECSefMJvh/vP7MM7mToqQRApKbiHn8h7z+GBF/ncKwEQOlx
HmTvIe8/WvzPafmuBEAuPVqpXyLvPwDssW4KtARAt9PRM0Aj7z9My3V4LL4E
QMkAwUgBJe8/H8Pm+rTABEAOzPyNcSXvP/K6V309wwRAUpc40+El7z/Gssj/
xcUEQJdidBhSJu8/mao5gk7IBEDcLbBdwibvP+zmtxAwygRAozPAuxUn7z9O
Tgh1
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGBQAWIQvW7Tw47M8ywOzr4bt99Qf2+/szGP7+cVFgejqjOh
jRrv7Xsq709ovM7iIFB4S+0ckG+UeXDqpDssDmfivp1I13xvX+/ROn/LMxYH
Vys93tla7+0vxWXEGLxkcTjy53PUMyBfpdRbcs1rFgeX/TtXGGq/tz+1UHDy
4g9A+1xcXU4A+SK/57ZN+sXi4OgXU/1V5739irXbcgv4WB3skrpe+uu/t78g
9MJax4zVwbzr2VEWk/f2ine9bixuZXXQvDWvLs/2vX3XIev1oR2sDruNP5kc
API/LddpY+9mdfDtdX0taPfe/lARn0n2BFaHQoc34VuB/BSOS/1Gs1kddi6z
NPxjD7TPONL94AZWB4/iK487nd7b63Wlb7t3m9UhjYfLc6n7e/tp+RG9E+6x
OvxIjf3/Dcj/H+KZ4vSQ1aFr/4atHh5A98lrCy17xuqwrihc6Q2QX7j1XW7u
R1aHbzeW/Dbyem+/5UGp6h82NofWpfbrDvi8t7cyb5kiacTmsNiuVPhO4Hv7
a0mSZnNN2Bzk6qYGaAS9ty/uW3ddwZzNYeberb0lQP6apzekNGzYHPptvrHz
Br+3l5uiu9DMjc2h2qr8j23Ie/td+w857fJgc/hWOd2yC8gPfx3+xNabzaFw
5/aya0D+BKcmddcANoc0ix8f8kLf2zN9vLY2OIrNIcis8un8sPf282Ry/K/H
sDmcLZ2p9AbIt/Zg/BgVz+bgsXVnvEX4e/sbxdMm3Utkczj85eacFiC/tSFw
1clkoPrq6hP7gHwAU+kLpw==
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7e5TrcScyebAsliozyjivf0z34ZdBXlsDufs+Nrq
gPymStGYLwVsDhP2fd26EMiXX7rqb3kxm0Ow3d2nR4D8iD9XHOor2Bxu2K5x
5Y58b396lebx3iY2h0c2XqwzgPyMa/syBFvZHJbuMTTdDeSzMIVwTW1nc0i3
kUy9B+TbRdb5zulhc3hr/eKIStR7+w3sly+vmsbm8N2qrWUjkD8lpebB8VVs
DjyWh5hPR7+3j5E7/5PxMpuDqakV07/Y9/Z8kkVbd19lc1CP9VdXiXtvf1BY
tLD0BpuDVGuKjxeQr8YZ/eLFXTaH/1f6pk0D8t9/fnbt/As2hxMlj7X044H+
O/lv89x/bA4xW3qCExLe268o0cuz1GJ3aDK+v+RQ0nv7r6d6HxU0sjtcMGxx
b08H+l/qtXPyX3YH2YkeP3zz3tsDAKC9k+c=
                "]], 
               
               Line[{{3.001275510204082, 0.9822526846729579}, {
                3.0957081519843626`, 0.9837584443368803}, {
                3.1802851297394477`, 0.9851070521826334}, {
                3.1987244897959184`, 0.9854010738691831}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQB2IQXV2/LtRsDqfDr+P+1oc73tsfe3M9b74ol4NvHfPl
ORPf2/cYBOrFSHA5BC5Oen4eyBff4bz2qiyXQ/hbBQGzSe/t9Y5rrD6hweWQ
2jg3kWnye/uYp5+WrbPjcmhYOY1l9pT39jsV2+dVZXE5bP3Z4XVm+nv7ulSG
OPNcLocdci/i/gP5LisrZb/kcznscXYvNprx3v6CQc6c3FIuh0O9rHNmAPkv
7ANnJTRwOVxQbHqbMvO9vVic9DS3aVwOrzyrJ/yd9d6+aNb6XqFDXA4Ks3Kv
6c17b7/9z6z2Q0e4HNa9rfiTAOT/iWtrLDrO5WDj2KI0GchvV44tvXSGyyHi
xay870D+nDVcsZOuczlMMDvBdmD+e/uj+1J1hN5yOTBeVjIPXPjenksxUO3Q
ey6HfjW92GYgP6DZRqHoE5eDbJVl81Yg/5a7sMil71wOlooB5yUXvbd/d+HA
74lM3A5F+bXpj4B8icfSpwUluB0ecd+YXrzkvX2sK/vRg1LcDgXxj/cuBfIX
Lf+0r1CW2+H/pnePrwP5OjknN11U4naQjmI1sFn63r7w3JY1jarcDivXCoTl
AfnbDBYsM9TgdjBnlKlZAOQ7fi2bNVGX2yF4hdEJlmXv7dvCk6Y4GnA7PPxt
+84MyA/ylSufBuQfjXKSswXyAcM65rQ=
                "]], 
               Line[CompressedData["
1:eJwVzHtI02EUxvFlq5T3TR2Oagrmcom1DUY2Saf9jpXhxC4zkKKMmhk5w8tM
MJsXVooUpnO6TC2lxqbivGRhipoiSmaSdkFKGwaijcoXsWwgUac/Dg8fvnDE
2szEVA8ej7cb7/8KRXHsjZJAteqzpNjGuKRCiVFzgIBCnN5uQtfP+xg2qAiU
XugwWNHzh9Zzu6IJzDauxvegdVvepgkOEygJNCzNoTvSBlKGY7EnDz1j6J8T
zcnZcfjvAf+Wh51xRZVFmulj2APKg0LR1SJ5hOk0dtHDMznoAWmZpyCDwCe/
oQmvZsaFv98+WZVFQDPSkhSA7jTYTcIcAuN68xcZ+tHkmP+OPAI905d/n0CX
ZW6S7zQSqKnYGmxBJ3YbNXILgZPkbP6uFsYtRRbUqQcJjHqshapaGSeI18uM
3hS6VqSlV9sY1zTsQyIFFCC37U4RWhHhcK34UZhyy0xV6OOhX20XRRSW/8ob
nqNvbz4vjpFQkHornvAdjOOPqLfxIinY9u53NqDXVGJeYSqFupSo8Ml2xpV0
DzqVVyjsWepXzaOF0nMDP3QUenXRMavoMP97+clZFGayDyaIOhiX5aa/om5Q
EBaDNhXteup2rVdSqGg4cvcPOk9medltphAYNGr27WScpzXMnm6h4Hgcez8Y
HWLOuDRbT+F161GrGq3NXnD22Sh49cb11aDn5FPvrvdTuPkhYVHexbjGb4KC
jS8oKMf1zRxa23IqpHyYwmJ/rU6Ddklm8prGKKitC8vX0N8Xe3wVryg07XN/
LEf/A1wREiU=
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQA2IQvW7Tw47M8zwO1h9EGndsfG9fOz2x4NZVHoeX927M
/ALkswg/PfT2Fo+DxL4XX5Q3vbcX5HqTLvKUx6GkhmN1E5Dv9oz9zzpeXofn
pe3Nfze/t98wz17lSRyvw5mMVpPP297bx643E5T9x+vwVp79zIE97+23Rf3g
u8DA5zDFUe/3TSCfj20XTzMzn4NNcqjWZyD/QIwtx0sOPoeuZYs7VPe+t1fi
cvm/RZjPQU3XwbULyH+WEvjWR5PPId6qcl/wvvf2dgLCr/9r8zmwxSx4mwPk
T9995cUmPT6HtbXHZdqAfA+hiCcSJnwOvw+IVu8A8lftj7v9xI7PYYb7JnPZ
/e/t86RyTtaE8DlcCHm94RmQf+yo7nH9cD6H8jKhB/+BfPnC90ceRfI5yM2w
5Jc88N7+wvGiAx7xfA65t9tzvYF8jWKTfb8T+RxE/q6bkwLktzYErjqZzOew
0LKvqBTIBwBlE6sb
                "]], 
               Line[CompressedData["
1:eJwVz1tIk3EYBvClgpn5vXRaBIk5C9qisou0WvS9dGHpVuBSjE6eFqgYOjuY
h0zDrdBIy+GhUpSlhanTTcls5SzTTCTWLJXGsuZMI/kXpSNb2tvFw8Pv6uEJ
TEhTnPYQCARBlP99QJ4j8kzmcK+rcV2tmfFFG6Qd/akczj/OyewiOwbdhuw0
DkNXjR0bImtF+S3j5zg0vCwL/El2vdHUN13m8L7ER7+vh/H56roCWyOHuc/s
E6nPGe+X6R0R38zhh6ufCvPIt5POrJzUcyiNnNhYSjbKdutYO+05ppVG8uQK
S69HN4eZPrMTv8myGsFSsZXDjChfp+YF44WPYm+c/8Nh8tdQZ20v45un/O9w
csBo4U3ncB/jr1Wr4+yHAdN3HLk1RVYqZja1RAIWydfwbvJ6k6n1UAxg95Wq
yqB++ltyvO96AqCY1ckyyEkhVT+WZQG6+w1t8IrxosLVB70bAHVZw5ciBhi/
sCvXb+QB4FNtueQUeWzG8bbhIeCo/uiIilwaYzwZ1ga4fNIWXEVelCjOqk2A
FxROxxeyzVJS42kFDN8yF65+zfhOjSvR+g5QGdY5V0nWSmPFulHAvPhsXRNZ
Vr+tfb8d0Fix4LaSuy4ODRRMA/p7ebeKBhlfvnVnSeQ3wNCAgRMhZNXnu1GB
DFCxp9gngrxZnvrR/AtQkw6JKrLXkuF7pS7AumILqMnjHdKUuHnAJw1lpkqy
KUW3Pfgv4Pue6OQmckWA7+ziIuB321qhmfwPcb4dbA==
                "]]}, 
              "Charting`Private`Tag$72721#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Cav2.1 intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {576., -189.}, {Center, Center}, {360., 360.}]}, {}},
  AspectRatio->0.6,
  ContentSelectable->True,
  ImageSize->1000,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.8508742146951265`*^9, 3.8508743038884163`*^9, 3.8508911808651085`*^9, 
   3.850891264590987*^9, 3.8509830931059465`*^9, 3.852255306774928*^9, 
   3.8522554865767984`*^9, 3.852255724728649*^9, 3.8522557675898933`*^9, 
   3.855045268472585*^9, {3.855045364108375*^9, 3.855045388586759*^9}, 
   3.855045920499544*^9, 3.8550460743314505`*^9, 3.8550462124263415`*^9, 
   3.8550463199491296`*^9, {3.8550463849728317`*^9, 3.855046414162945*^9}, 
   3.855281676100159*^9, 3.855287539289589*^9, 3.855287947160612*^9, 
   3.8552890319197254`*^9, 3.8553512953155193`*^9, 3.858052499683204*^9},
 CellLabel->
  "Out[333]=",ExpressionUUID->"ccb4dd0c-2f1a-4ef2-8f8f-b3ea83b0007c"],

Cell[BoxData[
 TemplateBox[{TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "Munc13-1 (n)", "Cav2.1 (n)", "Munc13-1 cluster intensity", 
            "Cav2.1 cluster intensity"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[
          Association[{All, 
             TypeSystem`PackageScope`KeyDummy[11]} -> 
           1, {All, "Munc13-1 (n)"} -> 1, {All, "Cav2.1 (n)"} -> 
           1, {All, "Munc13-1 cluster intensity"} -> 
           1, {All, "Cav2.1 cluster intensity"} -> 1], 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             TypeSystem`PackageScope`RowShape[
              Association[
              "Munc13-1 (n)" -> TypeSystem`PackageScope`AtomShape[34], 
               "Cav2.1 (n)" -> TypeSystem`PackageScope`AtomShape[34], 
               "Munc13-1 cluster intensity" -> 
               TypeSystem`PackageScope`AtomShape[60], 
               "Cav2.1 cluster intensity" -> 
               TypeSystem`PackageScope`AtomShape[60]]]]], 2, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[429248108], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "Munc13-1 (n)", "Cav2.1 (n)", "Munc13-1 cluster intensity", 
            "Cav2.1 cluster intensity"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real]}], 2], "HandleQ" -> True, "RowTarget" -> 20,
         "Data" -> TypeSystem`PackageScope`CacheHandle[429248108]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2033466616][{All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 (n)\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 (n)\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2033466616][{All, "Munc13-1 (n)"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[All, "Munc13-1 (n)"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 (n)\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 (n)\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2033466616][{All, "Cav2.1 (n)"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[All, "Cav2.1 (n)"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 cluster intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 cluster intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2033466616][{All, "Munc13-1 cluster intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[All, "Munc13-1 cluster intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 cluster intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 cluster intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2033466616][{All, "Cav2.1 cluster intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[All, "Cav2.1 cluster intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["WT", 
                    Style[
                    "WT", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2033466616][{
                    Key["WT"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2033466616][
                   GeneralUtilities`Slice[
                    Key["WT"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["8702"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["5743"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 cluster intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 cluster intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["KO", 
                    Style[
                    "KO", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2033466616][{
                    Key["KO"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2033466616][
                   GeneralUtilities`Slice[
                    Key["KO"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7514"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["4977"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.06457"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 cluster intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0.887897"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 cluster intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2033466616][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2033466616]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2033466616][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {538., {42., 48.}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 CellChangeTimes->{
  3.8508742146951265`*^9, 3.8508743038884163`*^9, 3.8508911808651085`*^9, 
   3.850891264590987*^9, 3.8509830931059465`*^9, 3.852255306774928*^9, 
   3.8522554865767984`*^9, 3.852255724728649*^9, 3.8522557675898933`*^9, 
   3.855045268472585*^9, {3.855045364108375*^9, 3.855045388586759*^9}, 
   3.855045920499544*^9, 3.8550460743314505`*^9, 3.8550462124263415`*^9, 
   3.8550463199491296`*^9, {3.8550463849728317`*^9, 3.855046414162945*^9}, 
   3.855281676100159*^9, 3.855287539289589*^9, 3.855287947160612*^9, 
   3.8552890319197254`*^9, 3.8553512953155193`*^9, 3.8580524998238015`*^9},
 CellLabel->
  "Out[334]=",ExpressionUUID->"a3ae13b0-5df0-4e83-b87b-9fb9fdd66dcb"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAASmXo0cDpdT7cRsV761bzPQRDGnDf
GVQ/R3xTAYW90T4zn5icsxlkP7yEfFNeveE+S83Xsp0ZdD/3CJH8Sr3xPldk
972SGYQ/FEsbUUG9AT/dL4dDjRmUPyNsYHs8vRE/oBVPhooZpD+r/IIQOr0h
P3vNl8RWuqQ/FCmwzSNLIj9WheACI1ulP35V3YoN2SI/DPVxf7ucpj9RrjcF
4fQjP3jUlHjsH6k/9l/s+YcsJj9Rk9pqTiauP0PDVePVmyo/gQizJ4kZtD/u
RBTbOL0xPypHkYiycLQ/WGrkpyUKMj/ShW/p28e0P8GPtHQSVzI/JAMsqy52
tT+W2lQO7PAyP8b9pC7U0rY/PHCVQZ8kND9vPIOP/Sm3P6aVZQ6McTQ/GHth
8CaBtz8RuzXbeL40P2n4HbJ5L7g/5AXWdFJYNT8SN/wSo4a4P04rpkE/pTU/
unXac8zduD+3UHYOLPI1P2O0uNT1NLk/IXZG2xg/Nj+F3fwWAka5P8iF544k
TjY/uuawNQ==
                "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAr1U2HDHtuT+EtHT5lSRFP15wU/dx
Oro/SovMChU+Tj+v7Q+5xOi6P5XuLdtPY1k/UuiIPGpFvD9DoF5D7fVmP5jd
ekO1/r4/Gfl29zu/dT9BHFmk3lW/PznuL6LEB3c/6lo3BQitvz9Z4+hMTVB4
Px7seWOtLcA/mc1aol7hej9vaTYlANzAPwlRn6bAAYA/EmSvqKU4wj+FJYNR
4yOFP1hZoa/w8cQ/fc5Kpyhojz/v21QKohrFPwjVACDFAJA/hl4IZVNDxT/S
QlzsdU2QP7Njbxq2lMU/Yx4ThdfmkD8Obj2FezfGP4fVgLaaGZI/pfDw3yxg
xj9RQ9yCS2aSPzxzpDreiMY/GrE3T/yykj9qeAvwQNrGP62M7uddTJM/xYLZ
WgZ9xz/SQ1wZIX+UP1wFjbW3pcc/m7G35dHLlD/yh0AQac7HP2MfE7KCGJU/
II2nxcsfyD/2+slK5LGVP7cPWyB9SMg/v2glF5X+lT9Okg57LnHIP4nWgONF
S5Y/fJd1MJHCyD8csjd8p+SWPxMaKYtC68g/5h+TSFgxlz+qnNzl8xPJP6+N
7hQJfpc/QB+QQKU8yT93+0nhucqXP9ehQ5tWZck/QGmlrWoXmD+QO0vYzW/J
P/AsMAkkK5g/drnlDw==
                "]], 
               LineBox[{{0.20127551020408163`, 0.02498575274743314}, {
                0.2033724813112215, 0.026766563650876433`}, {
                0.20461432671651483`, 0.027821176101476046`}, {
                0.20585617212180818`, 0.028875788552075655`}, {
                0.20833986293239484`, 0.030985013453274857`}, {
                0.2133072445535682, 0.035203463255673285`}, {
                0.2232420077959149, 0.04364036286047014}, {
                0.24311153428060836`, 0.06051416207006387}, {
                0.2443290196086536, 0.06154808721075042}, {
                0.24554650493669883`, 0.06258201235143696}, {
                0.24798147559278932`, 0.06464986263281006}, {
                0.2528514169049703, 0.06878556319555626}, {0.2625912995293323,
                 0.0770569643210487}, {0.28207106477805627`, 
                0.09359976657203353}, {0.29872448979591837`, 
                0.10774235573337587`}}], 
               LineBox[{{0.3012755102040816, 0.10999523918967724`}, {
                0.3987244897959184, 0.19935893226516072`}}], 
               LineBox[{{0.40127551020408164`, 0.20168363829098637`}, {
                0.48443648039284554`, 0.2769891364623791}, {
                0.4987244897959184, 0.2899274855885816}}], 
               LineBox[{{0.5012755102040817, 0.2921217383758836}, {
                0.5987244897959183, 0.37151880402816145`}}], 
               LineBox[{{0.6012755102040817, 0.3734946575734408}, {
                0.6987244897959183, 0.4450528027805008}}], 
               LineBox[{{0.7012755102040816, 0.44683517511808224`}, {
                0.7987244897959184, 0.5114502765022351}}], 
               LineBox[{{0.8012755102040817, 0.513071414500068}, {
                0.8962801515662935, 0.5708253277161218}, {0.8987244897959182, 
                0.572311256150357}}], 
               LineBox[{{0.9012755102040816, 0.5737389129404922}, {
                0.9987244897959183, 0.6235720500565199}}], 
               LineBox[{{1.0012755102040816`, 0.6248340752067317}, {
                1.0987244897959185`, 0.6714196595668835}}], 
               LineBox[{{1.1012755102040817`, 0.6725468341783967}, {
                1.1987244897959184`, 0.7120773901378524}}], 
               LineBox[{{1.2012755102040815`, 0.7130521250099671}, {
                1.2987244897959185`, 0.747991313280081}}], 
               LineBox[{{1.3012755102040816`, 0.748842923747297}, {
                1.3839420330101317`, 0.7743971579863542}, {
                1.3987244897959183`, 0.7789667751724914}}], 
               LineBox[{{1.4012755102040815`, 0.7796893981679088}, {
                1.4987244897959184`, 0.8047739435926059}}], 
               LineBox[{{1.5012755102040816`, 0.8054188809515991}, {
                1.5987244897959185`, 0.8296075497539857}}], 
               LineBox[{{1.6012755102040817`, 0.8302143771781293}, {
                1.6987244897959184`, 0.852387323580317}}], 
               LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAA9P5cq2w4+z+NjsBbPEvrP6wB5oYz
hPs/fNbus7Zp6z9emPdxPY77P6RVJFfAbes/wcUaSFGi+z/zU4+d03XrP4cg
YfR4yvs/kVBlKvqF6z8T1u1MyBr8P85JEURHpus/bKF2Qs0f/D9iCawVTKjr
P8Rs/zfSJPw/9chG51Cq6z92AxEj3C78Px1IfIparus/2TA0+e9C/D9sRufQ
bbbrP5+LeqUXa/w/CkO9XZTG6z/4VgObHHD8P54CWC+ZyOs/UCKMkCF1/D8y
wvIAnsrrPwK5nXsrf/w/WUEopKfO6z9l5sBRP5P8P6k/k+q61us/K0EH/ma7
/D9HPGl34ebrP7CqqyfYwPw/OgotzhHp6z80FFBRScb8PyzY8CRC6+s/DAGj
VJPH/D/MaKzgxuvrP8Jun8w=
                "]], 
               LineBox[{{1.8012755102040816`, 0.872988674899976}, {
                1.8023956352454178`, 0.8731650218669527}, {
                1.8037242586975861`, 0.8733741937963333}, {
                1.8063815056019226`, 0.8737925376550946}, {
                1.8170104932192683`, 0.8754659130901399}, {
                1.8382684684539596`, 0.8788126639602303}, {
                1.8807844189233422`, 0.8855061657004112}, {
                1.8820249067880583`, 0.8857014619972006}, {
                1.8832653946527742`, 0.88589675829399}, {1.8857463703822064`, 
                0.8862873508875686}, {1.8907083218410705`, 
                0.887068536074726}, {1.8987244897959183`, 
                0.8883305620570452}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAJzKQ3p9r/j8cY3AtcnDsP7hLmsJy
xP4/VmUd7piL7D+SN3RAnM7+P3lrWiW0juw/RQ8oPO/i/j/Ad9ST6pTsP6u+
jzOVC/8/TZDIcFeh7D93HV8i4Vz/P2bBsCoxuuw/YlAwVtxh/z+KnXT3trvs
P06DAYrXZv8/rnk4xDy97D8m6aPxzXD/P/cxwF1IwOw/1LTowLqE/z+Ios+Q
X8bsPzBMcl+UrP8/qoPu9o3S7D8cf0OTj7H/P85fssMT1Ow/B7IUx4q2/z/y
O3aQmdXsP94Xty6BwP8/O/T9KaXY7D+M4/v9bdT/P8tkDV283uw/eBbNMWnZ
/z/wQNEpQuDsP2NJnmVk3v8/FB2V9sfh7D86r0DNWuj/P1zVHJDT5Ow/JuIR
AVbt/z+BseBcWebsPxEV4zRR8v8/pY2kKd/n7D/8R7RoTPf/P8lpaPZk6ew/
PzTWh8b6/z/H1VYNdersPxWXxTs=
                "]], 
               LineBox[{{2.001275510204082, 0.9039442023649266}, {
                2.0039562426140143`, 0.9042152945874893}, {2.008820753763886, 
                0.9047072240073798}, {2.0185497760636295`, 
                0.9056910828471607}, {2.0380078206631165`, 
                0.9076588005267228}, {2.0393271393937447`, 
                0.90779221818737}, {2.0406464581243724`, 
                0.9079256358480173}, {2.0432850955856283`, 
                0.9081924711693119}, {2.0485623705081406`, 
                0.908726141811901}, {2.0591169203531647`, 
                0.9097934830970793}, {2.080226020043213, 
                0.9119281656674358}, {2.098724489795918, 
                0.9137988452103432}}], 
               LineBox[{{2.1012755102040814`, 0.9140480255535907}, {
                2.1987244897959184`, 0.9232307609322744}}], 
               LineBox[{{2.201275510204082, 0.9234682151417221}, {
                2.2866398821120604`, 0.9313160084681278}, {2.298724489795918, 
                0.932426981364828}}], 
               LineBox[{{2.4012755102040817`, 0.9426401507511761}, {
                2.412024645029292, 0.9434677674292835}, {2.414468401872563, 
                0.9436559215415556}, {2.419355915559106, 
                0.9440322297660998}, {2.429130942932191, 
                0.9447848462151882}, {2.4486809976783612`, 
                0.9462900791133649}, {2.450006067043157, 0.946392101231776}, {
                2.4513311364079526`, 0.9464941233501871}, {2.453981275137544, 
                0.9466981675870092}, {2.459281552596727, 
                0.9471062560606535}, {2.4698821075150925`, 
                0.9479224330079421}, {2.491083217351824, 
                0.9495547869025192}, {2.498724489795918, 
                0.9501431174630275}}], 
               LineBox[{{2.601275510204082, 0.9565039587427707}, {
                2.6052275961112112`, 0.9566810804968251}, {2.607701463665898, 
                0.9567919525200758}, {2.6126491987752725`, 
                0.9570136965665773}, {2.613861772475368, 
                0.9570680408257174}, {2.6150743461754633`, 
                0.9571223850848575}, {2.6174994935756546`, 
                0.9572310736031377}, {2.6223497883760363`, 
                0.9574484506396982}, {2.6320503779767996`, 
                0.9578832047128191}, {2.6514515571783264`, 
                0.9587527128590607}, {2.6902539155813803`, 
                0.9604917291515442}, {2.698724489795918, 
                0.9608713572765349}}], 
               LineBox[{{2.7012755102040815`, 0.9609798240141839}, {
                2.798724489795918, 0.9648992842367928}}], 
               LineBox[{{2.8012755102040816`, 0.9650121482746166}, {
                2.854361932320109, 0.9675743520540617}, {2.8556927523190727`, 
                0.9676385837708584}, {2.8583543923169996`, 
                0.9677670472044517}, {2.863677672312853, 
                0.9680239740716384}, {2.87432423230456, 0.9685378278060117}, {
                2.8756550523035234`, 0.9686020595228084}, {2.876985872302487, 
                0.9686662912396051}, {2.879647512300414, 
                0.9687947546731984}, {2.8849707922962673`, 
                0.9690516815403851}, {2.886301612295231, 
                0.9691159132571818}, {2.887632432294194, 
                0.9691801449739785}, {2.8902940722921207`, 
                0.9693086084075718}, {2.8956173522879745`, 
                0.9695655352747585}, {2.8969481722869377`, 
                0.9696297669915551}, {2.8982789922859014`, 
                0.9696939987083518}, {2.898724489795918, 
                0.9697155005417473}}], 
               LineBox[{{2.9012755102040817`, 0.9698166384457712}, {
                2.9022714522827915`, 0.9698475398892614}, {
                2.9036022722817547`, 0.9698888317072021}, {
                2.9062639122796816`, 0.9699714153430835}, {
                2.9075947322786453`, 0.9700127071610243}, {
                2.9089255522776085`, 0.9700539989789649}, {2.911587192275535, 
                0.9701365826148464}, {2.9169104722713888`, 
                0.9703017498866093}, {2.9382035922548035`, 
                0.9709624189736608}, {2.939446276666315, 
                0.9710009761778791}, {2.940688961077826, 
                0.9710395333820975}, {2.943174329900849, 
                0.9711166477905342}, {2.9481450675468936`, 
                0.9712708766074075}, {2.9580865428389833`, 
                0.9715793342411543}, {2.9779694934231626`, 
                0.9721962495086478}, {2.998724489795918, 
                0.9728402220460695}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ/fCpyJ45TBwOXbMvBtsqvbdPOXzhq78mh4NKwev1
nhrv7Q2anMt99TgcpL48DhfUfG9/4r9GlYcFhwPrnyvLF2i9t//+63O9nQ+H
wx3u7e77dd/bh33s7NYqAZqnXd3+x/i9/Z4AZ5+VZRwOrbnl0Qkm7+2VNvzh
0ajkcGhYX6x/BMh/l5ffp1rH4VBqnHO92/S9feubkIkKHRwOidax6tLm7+23
PJefLjaHw8Hc2/64pdV7eyn3m+FT53E4GPVaz54L5DcsmyQhspDDQfe8eT6j
9Xt7n1TWWYLLOByUgw3ETwL5Tx69msOzgcOBL1oxPcL2vb2X05LY7k0cDpxz
Za33APkbFsbKcW3lcGC5L8mvYPfevibhwnz2XRwOv5KEtj8H8oXvbV3EdITD
4WkWM3u5w3v7Pp7a2u3HOBzENCf6PwbyuaxdInJOcji4PZeb4e/43v71s+0C
BqeA9s3aq5cH5AMASHeVKQ==
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQvXbTw47M8xwO37SfSQo6vbevOzbzRddFDoeKlMzd
DkD+ry8Jh+2vcDgsMvC3qwXyPwW+r1h5k8Ph+wkpl29Afl7DtuC4OxwOilMZ
jhs5v7d/ta5WT/g+h4N34jPPfCD/ITfPk5onHA7zf270fwHkXziq4R/wnsPB
Xcsz+pbLe/uetbN/z5XidHj5ZmnnIo/39hx3kq4FyXI6CO/s5rkP5LdwaW1k
V+B0sG0t7Jf2fG9fnb4jrVCV02GSrO3UKUB+luLViy4GnA5WflcWtHm9t/eY
yrfitSunQ/d6ph1ZPu/tWWsbQywLOR10i+KfGQW8t9/y8c3P/cWcDv6tygnZ
QH5KWsR8tzJOh8IZz28uBvKP+Ou/Cq7mdNi2L/+sSCDQfqW79XmtnA4O3A1b
vgH5JtM9VL+2czokybno6Qe9t3/CveVUdRenQ4shx4p0IN/la5doZz+nw8nw
CbNvAPlfMr/t4p/E6fAmK0RUMPi9/ZJ7iQnTpnA68NVJ9HsC+Ts3t9z9M43T
oab1kWU9kA8A3S+4Vg==
                "]], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAe3+uVTacCUAn3mfGElTvP8Sa5kC+
owlAX8STxRNV7z+DbZTW2K0JQNP1CpJsVu8/AhPwAQ7CCUC6WPkqHlnvP7KH
W6eUxAlAFyUXXnRZ7z9i/MZMG8cJQHPxNJHKWe8/wuWdlyjMCUAtinD3dlrv
P4K4Sy1D1glAobvnw89b7z8BXqdYeOoJQIge1lyBXu8/AKler+ISCkBW5LKO
5GPvP8bs126fFQpAlYsQ+EFk7z+MMFEuXBgKQNUybmGfZO8/F7hDrdUdCkBT
gSk0WmXvPy7HKKvIKApAUB6g2c9m7z9c5fKmrj4KQEpYjSS7ae8/IilsZmtB
CkCJ/+qNGGrvP+hs5SUoRApAyaZI93Vq7z9z9NekoUkKQEf1A8owa+8/igO9
opRUCkBEknpvpmzvP1BHNmJRVwpAgznY2ANt7z8Wi68hDloKQMPgNUJhbe8/
ohKioIdfCkBBL/EUHG7vP2hWG2BEYgpAgNZOfnlu7z+FgFGqyWMKQAH7A2Ot
bu8/gEWuQw==
                "]], 
               LineBox[{{3.3012755102040816`, 0.9823336999704501}, {
                3.303328260790919, 0.9823832377345544}, {3.3046648314240503`, 
                0.982415492369461}, {3.3073379726903127`, 
                0.9824800016392743}, {3.3126842552228375`, 
                0.9826090201789008}, {3.323376820287886, 
                0.9828670572581539}, {3.3447619504179835`, 
                0.9833831314166601}, {3.3460741609738665`, 
                0.9834147981848439}, {3.3473863715297494`, 
                0.9834464649530277}, {3.3500107926415157`, 
                0.9835097984893952}, {3.355259634865048, 
                0.9836364655621305}, {3.3657573193121118`, 
                0.9838897997076008}, {3.38675268820624, 0.9843964679985416}, {
                3.398724489795918, 0.9846853761040154}}], 
               LineBox[{{3.4012755102040817`, 0.9847410752395648}, {
                3.4987244897959178`, 0.9866448130619748}}], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQ/eCpyJ45TDwOrolCu5knv7dfcJCf20qQx+HCjL8e
llPe2xtYrn35UZjH4V9FwZ0iIN9P48WyREkehwjLMOZnQH4XW5yiowqPA+8u
xcAzU9/bsxz2FGOw4nEo373jzYzp7+2/WSsy1KXyOPjse6ZsNPu9fevmffdM
M3gcKudFbs8G8kW0Y/a+zeJxWFZ3xmspkG8sNb0qtoDHgdF+U6HEnPf2BT94
vtpU8zhs21+7/x+Q/3LLj5e/J/A4KBwUiT497719hc60E5sn8zj4Lmx/xzL/
vT3HEuPl2dN4HKoafzXaAflqk/NSbs/mcbjq+GDFRiA/qfDJvV3LeBy6Dq3+
Nn3Be/s7uhcuV+7hcfhy2GlSyqL39vNfC9Yy7+dxCGD6EjQLyE9aGazWe5DH
YY3DUuELQL5a+tTzYkd4HDjqw66wLga6R+V6xYJjPA7Je9mnWgP5ax5JKGmd
5HHY/3tHaCGQ/+bZdgGDUzwOK3tPM7YD+QC07a+v
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQvW7Tw47M8zwON1b/vnV58Xv72umJBbeu8jho3A14
ybHkvT2L8NNDb2/xODyaLbzDCMgX5HqTLvKUxyFEcmZoG5B/5biu4LznPA4b
K37ZzAbyZ7Tm71J/xePAeyNaZQOQL8f4mcf6PY/DsWlyn28C+To/fm5M/Mnj
YCmyZILu0vf2bs/Y/6zj5XWQ419/+gqQz7nEc6mFAK9DVZ7A5pdA/pnEbr9D
QrwO188WzvoH5Aff5Vt4VZzXYUKPSabGsvf2CVdE3f4o8jowce1iqwHyqw8p
T/A043V4znLUUXn5e/sN8+xVnsTxOmz8dWt74Yr39p+rPrMnJvI6mOdwmLUB
+Wbhy1/fTeZ12HvXdMssIH83P//m6xm8DicPTNhwGMg/1nDP8XQRr8PDNreV
oivf23PETlL1KOV1SP9RrK4F5HtbunEeLed1eJu5cKkdkH/h49oL+2p4HX76
/FmYDuTfTqqN39TG6yAovGnWTiBfzt7QWb+T12F6y32Jc0B+gvRTtTXdvA6y
33imPwLyn132ebd0Aq+D5s30ydyr3ttrbGC4pDSZ12G911RBBSA/u2fL1vlT
eR1M9xzqNwHyd2xuuftnGq/DsecXT9sD+QCpKeLA
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQXVW/LtRsDq/Dg6hC46pV7+1/b33N3buE18Emserz
eyCfTX33rIZ1vA4y7i6VNavf23sy59f93cDrMOXAtlnzgfye+0pJVZt5HXis
NPccAvIFZ3Rpluzgdfijw/efY817exnOqB3ph3gd7gjdaJkK5Bu9/nHV7xqv
w5x72RPWrX1vH7veTFD2H9D8ssnLH6x/b78t6gffBQY+hxiev0fYNry352Pb
xdPMzOcwe1HaIx0g/0CMLcdLDj4H6fOWspVAvhKXy/8twnwOkhoPJglufG//
LCXwrY8mn4PYLZ06p03v7e0EhF//1+ZzCC2YNjsDyJ+++8qLTXp8DlPZGHb2
AfkeQhFPJEz4HESML3++BeSv2h93+4kdn4NwT2Vm8eb39nlSOSdrQvgc+O2O
hSzZ8t7+2FHd4/rhfA7+V/SLTgH58oXvjzyK5HPoz5rZ/wHIr5DZeGhqDJ/D
OQbmtWJb39tfOF50wCOez4Fves4pGyBfo9hk3+9EPgdf3WvPk4D81obAVSeT
+RwqKqYn1QD5AHBXuts=
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQ7e5TrcScyeewo9Jz++at7+27FKy3Hs/hc6hYNSvw
HJD/+PSfTVX5fA7TS/0THgL5U5Qa1j0o4XO4zr2zln3be/vv59uWrqnncwiz
6NkRDOQHVHssjm/icyhjdjyeBuSvUONaKNTK5zDt3NerlUB+VG3vnIouPoer
KfGf5wP5e7SmTHaZyucQOtFI7w2Q39C6sPHOKj6H4Fc3Frdsf2/PW87ulbiW
z0FXyzdnGpA/KyNX6Nl6Pgf2rIMmK4D8zd6Wi99v4XPY/XLl0dNA/jPBi0eY
9vM5KL+sei6047299zwGDs3LfA6fn8toLwTyxbbH95X+5nOY/DRh096d7+0X
rzga9usvn0Ou6tWq80C+wSxt+XoGfgf3VE/nh0C+Z+339R2s/A6/nxheYdn1
3r7Guf/ibH5+h+QnTN+8gXxO068zFYT4HWxVyvfFAvnT1KKTlorwO4invG7L
B/LXc6p/XifJ73Dq8WXxyUD+o/P7RA4p8zsYPV5ieQvIzz+octdNjd+BR1mS
6Q2Q/2dT19LTGvwOz5J6T/0F8juWfMgN0OZ3OLCIcTL/7vf2otPCzK7q8jvM
elQarQjkL2rf8y/SgN+hROmVsjGQH+QrVz4NyG/puHPOBMgHABp952M=
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQLSLp8f68Kb+DlcmxV0m739tf8Q1RyLXid/gnkXRi
MpCfaL/rxUcbfoejFQKl64D8KqW2yt+O/A7BFrnnHgP5a1/Izubz4XfI367W
6LfnvX3H3NaEe378DtOtmTxygPyUoLeq6wL5Hfbvv8vXBeTL7NmzwTec30Hg
xJQ5R4H8rv7oYz1J/A6bbjDtsNn73j7DbOZHrkp+h68/773T2vfeXqlFxIN9
Gb9Dtc30GPYD7+3/WdTwXl/B77D4QJGyKpB/8+3jS8tW8zuccfF75QTkTwjf
HOu2kd9B1pe1og7I/68VVNy6h99hX2zx5K9A/p2L/fOYL/M7MNb7n3p88L39
jrbvyZev8jtoMWtPZDz03n6Kdbzm4hv8DkHtbBHyQL73Ur0tTveA9vXvfRoF
5O+qOHuy8SW/g8sCbcZLQP40XdP+wDf8Drkq7CfeA/mFj+aEKL7nd5i64lEf
7+H39ho+OfcPfOF3eLZhpownkM/CeGXJhO/8DnympY/TgPwHW62zEn7xO5jv
DFjVAuTvyVqsb/CX3yHeVqdwEZA/XZ776////A7tB9ktDgD5ADoQ0iw=
                "]], 
               LineBox[{{2.501275510204082, 0.9503204752367506}, {
                2.5359593045799738`, 0.9524727676939997}, {
                2.5384331721346607`, 0.952626282803116}, {2.5433809072440345`,
                 0.9529333130213489}, {2.553276377462783, 
                0.9535473734578145}, {2.5730673179002794`, 
                0.9547754943307458}, {2.574304251677623, 0.954852251885304}, {
                2.5755411854549664`, 0.9549290094398623}, {
                2.5780150530096533`, 0.9550825245489786}, {
                2.5829627881190276`, 0.9553895547672114}, {2.584199721896371, 
                0.9554663123217697}, {2.585436655673715, 
                0.9555430698763279}, {2.587910523228402, 
                0.9556965849854443}, {2.5928582583377757`, 
                0.956003615203677}, {2.594095192115119, 0.9560803727582353}, {
                2.5953321258924626`, 0.9561571303127935}, {2.59780599344715, 
                0.9563106454219099}, {2.5987244897959183`, 
                0.9563676424373472}}], 
               LineBox[{{2.3012755102040816`, 0.9326717644079006}, {
                2.372924535536952, 0.9398350202157145}, {2.375368292380223, 
                0.940079339734635}, {2.3802558060667653`, 
                0.9405679787724759}, {2.390030833439851, 
                0.9415452568481578}, {2.398724489795918, 
                0.9424144226755284}}]},
              Annotation[#, "Charting`Private`Tag$73032#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT4jB+2nhSFDPgRDGnDf
GVQ/eJhRj4mMIT8zn5icsxlkP55IRkxjjDE/S83Xsp0ZdD+xoMAqUIxBP1dk
972SGYQ/u8z9mUaMUT/dL4dDjRmUP79inNFBjGE/oBVPhooZpD/CrWttP4xx
P4EIsyeJGbQ/Q1NTOz6MgT8qR5GIsnC0PwpZ+aJW2IE/0oVv6dvHtD/RXp8K
bySCPyQDLKsudrU/YWrr2Z+8gj/G/aQu1NK2P36Bg3gB7YM/DPOWNR+MuT+7
r7O1xE2GP5jdekO1/r4/NAwUMEsPiz9BHFmk3lW/P/wRupdjW4s/6lo3BQit
vz/EF2D/e6eLPx7seWOtLcA/UyOszqw/jD9vaTYlANzAP3E6RG0OcI0/EmSv
qKU4wj+taHSq0dCPP1hZoa/w8cQ/k2JqEixJkj/v21QKohrFPyexws6ybJI/
hl4IZVNDxT+7/xqLOZCSP7Njbxq2lMU/4ZzLA0fXkj8Obj2FezfGPzDXLPVh
ZZM/pfDw3yxgxj/DJYWx6IiTPzxzpDreiMY/V3TdbW+skz9qeAvwQNrGP38R
juZ885M/xYLZWgZ9xz/NS+/Xl4GUP1wFjbW3pcc/YZpHlB6llD/yh0AQac7H
P/Ton1ClyJQ/II2nxcsfyD8bhlDJsg+VP7cPWyB9SMg/r9SohTkzlT9Okg57
LnHIP0MjAULAVpU/fJd1MJHCyD9qwLG6zZ2VPxMaKYtC68g//g4Kd1TBlT+q
nNzl8xPJP5JdYjPb5JU/QB+QQKU8yT8lrLrvYQiWP9ehQ5tWZck/uPoSrOgr
lj+QO0vYzW/JP+jGFL8LNZY/kD0oVA==
                "]], 
               LineBox[{{0.20127551020408163`, 0.02287838212207959}, {
                0.2033724813112215, 0.02460864840691684}, {
                0.20461432671651483`, 0.025633327873621492`}, {
                0.20585617212180818`, 0.02665800734032614}, {
                0.20833986293239484`, 0.02870736627373542}, {
                0.2133072445535682, 0.032806084140554}, {0.2232420077959149, 
                0.04100351987419115}, {0.24311153428060836`, 
                0.057398391341465495`}, {0.2443290196086536, 
                0.05840297066457975}, {0.24554650493669883`, 
                0.059407549987693986`}, {0.24798147559278932`, 
                0.061416708633922505`}, {0.2528514169049703, 
                0.06543502592637954}, {0.2625912995293323, 
                0.0734716605112936}, {0.28207106477805627`, 
                0.08954492968112174}, {0.3210305952755042, 
                0.121691468020778}, {0.3987244897959184, 
                0.18579875389069653`}}], 
               LineBox[{{0.40127551020408164`, 0.18788669313879394`}, {
                0.48443648039284554`, 0.2553982606329994}, {
                0.5699233045152912, 0.3247979980760282}, {0.5987244897959183, 
                0.34817931697565896`}}], 
               LineBox[{{0.6012755102040817, 0.35011023640225325`}, {
                0.732138185275487, 0.4419788298280801}, {0.7334646121808601, 
                0.4429100118783653}, {0.7347910390862331, 
                0.44384119392865046`}, {0.7374438928969791, 
                0.44570355802922074`}, {0.742749600518471, 
                0.4494282862303613}, {0.7533610157614552, 
                0.4568777426326425}, {0.7745838462474235, 
                0.47177665543720504`}, {0.7987244897959184, 
                0.4887239398021652}}], 
               LineBox[{{0.8012755102040817, 0.4903153569119956}, {
                0.8195060898552016, 0.5002628384889973}, {0.8219826724910432, 
                0.501614181156944}, {0.8269358377627265, 
                0.5043168664928371}, {0.8368421683060933, 
                0.5097222371646237}, {0.8566548293928267, 
                0.5205329785081966}, {0.8962801515662935, 
                0.5421544611953425}, {0.9739717509693491, 
                0.5845467366215507}, {0.9987244897959183, 
                0.5980530221138229}}], 
               LineBox[{{1.0012755102040816`, 0.5992888105468431}, {
                1.1369227129030104`, 0.6566960642842126}, {
                1.1987244897959184`, 0.6828511947765532}}], 
               LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA9P5cq2w48z8qEf7FGeLlPw4dp+/k
5PQ/VFxbKJgW5z9AVoPd4+n0P6gmF/kwGuc/co9fy+Lu9D/98NLJyR3nP9YB
GKfg+PQ/poVKa/sk5z+e5ohe3Az1P/euOa5eM+c/LrBqzdM09T+bARg0JVDn
P01DLqvChPU/4abUP7KJ5z9+fAqZwYn1PzVxkBBLjec/sLXmhsCO9T+KO0zh
45DnPxQon2K+mPU/MtDDghWY5z/cDBAauqz1P4T5ssV4puc/bNbxiLHU9T8o
TJFLP8PnP4xptWagJPY/b/FNV8z85z/qQK2ICyr2P5Ye0g+zAOg/RxilqnYv
9j+9S1bImQToPwLHlO5MOvY/CqZeOWcM6D95JHR2+U/2P6ZabxsCHOg/1vtr
mGRV9j/Nh/PT6B/oPzTTY7rPWvY/9LR3jM8j6D+SqlvcOmD2Pxvi+0S2J+g/
pZo87ixh9j/AA6OOZCjoP6lluqk=
                "]], 
               LineBox[{{1.4012755102040815`, 0.7557150122492435}, {
                1.4024622524621388`, 0.7560174625319398}, {
                1.4051079980981398`, 0.7566917509126879}, {
                1.4064308709161404`, 0.757028895103062}, {1.407753743734141, 
                0.7573660392934362}, {1.410399489370142, 
                0.7580403276741844}, {1.415690980642144, 
                0.7593889044356809}, {1.426273963186148, 
                0.7620860579586736}, {1.4686058933621644`, 
                0.7728746720506448}, {1.547629076117258, 
                0.7930143306846618}, {1.5987244897959185`, 
                0.8060363851422921}}], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe+T9D+yVb7s/pP/tq1Jsp
evs/29WEQ7uZ6j9UNl2RLn/7PxVACcjcm+o/rAHmhjOE+z9Oqo1M/p3qP16Y
93E9jvs/wn6WVUGi6j/BxRpIUaL7P6knqGfHquo/hyBh9HjK+z94ecuL07vq
PxPW7UzIGvw/FB0S1Ovd6j9soXZCzR/8P06HllgN4Oo/xGz/N9Ik/D+H8Rrd
LuLqP3YDESPcLvw/+8Uj5nHm6j/ZMDT570L8P+JuNfj37uo/n4t6pRdr/D+w
wFgcBADrP/hWA5sccPw/6irdoCUC6z9QIoyQIXX8PySVYSVHBOs/Armdeyt/
/D+YaWouigjrP2XmwFE/k/w/fxJ8QBAR6z8rQQf+Zrv8P01kn2QcIus/sKqr
J9jA/D9EqPfYayTrPzQUUFFJxvw/OuxPTbsm6z8MAaNUk8f8P51Y72dHJ+s/
cFusAw==
                "]], 
               LineBox[{{1.8012755102040816`, 0.8490234894862921}, {
                1.8023956352454178`, 0.849206102365669}, {1.8037242586975861`,
                 0.8494227065350736}, {1.8063815056019226`, 
                0.8498559148738827}, {1.8170104932192683`, 
                0.8515887482291193}, {1.8382684684539596`, 
                0.8550544149395928}, {1.8807844189233422`, 
                0.8619857483605395}, {1.9601756422651684`, 
                0.8749288211039168}, {1.9987244897959184`, 
                0.8812134016502527}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEC+MO+XLjbsPxMP8AjE
+gBAlgb5Ih7M7D/SvYqHSf0AQE+J4CWkzew/kmwlBs//AEAKDMgoKs/sPxLK
WgPaBAFAfxGXLjbS7D8ShcX97w4BQGkcNTpO2Ow/EPua8hsjAUA7MnFRfuTs
PwznRdxzSwFA4F3pf9787D/MleBa+U0BQJvg0IJk/uw/jER72X5QAUBVY7iF
6v/sPwuisNaJVQFAyWiHi/YC7T8KXRvRn18BQLNzJZcOCe0/CNPwxctzAUCF
iWGuPhXtP8iBi0RRdgFAQAxJscQW7T+IMCbD1ngBQPqOMLRKGO0/B45bwOF9
AUBulP+5VhvtPwZJxrr3hwFAWJ+dxW4h7T/G92A5fYoBQBIihcj0Iu0/hqb7
twKNAUDNpGzLeiTtPwUEMbUNkgFAQao70YYn7T/Essszk5QBQPssI9QMKe0/
ubOE3fyWAUCTNCYGgirtPwOeowE=
                "]], 
               LineBox[{{2.201275510204082, 0.9117479005176731}, {
                2.2025743146728987`, 0.9118663036399967}, {
                2.2039086887592343`, 0.9119879494011279}, {2.206577436931906, 
                0.9122312409233904}, {2.21191493327725, 0.9127178239679153}, {
                2.222589925967937, 0.9136909900569652}, {2.2439399113493117`, 
                0.915637322235065}, {2.2866398821120604`, 
                0.9195299865912644}, {2.3704807786936803`, 
                0.9271731878367275}, {2.398724489795918, 
                0.9297479738501735}}], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAFBlI7881A0DsoLnQO8LtP7VTRwOU
RARAivKwJKwT7j+IS7iFHEcEQGY5XzJvFO4/XEMpCKVJBEBCgA1AMhXuPwIz
Cw22TgRA+g1qW7gW7j9OEs8W2FgEQGkpI5LEGe4/6NBWKhxtBEBJYJX/3B/u
PxpOZlGklQRACc552g0s7j/tRdfTLJgEQOQUKOjQLO4/wD1IVrWaBEDAW9b1
ky3uP2YtKlvGnwRAeOkyERov7j+zDO5k6KkEQOgE7EcmMu4/hgRf53CsBEDE
S5pV6TLuP1r8z2n5rgRAoJJIY6wz7j8A7LFuCrQEQFggpX4yNe4/TMt1eCy+
BEDIO161PjjuPx/D5vq0wARApIIMwwE57j/yuld9PcMEQIDJutDEOe4/xrLI
/8XFBEBcEGnehzruP5mqOYJOyARAOFcX7Eo77j/s5rcQMMoEQC7+y8LbO+4/
Nb6WnA==
                "]], 
               LineBox[{{2.601275510204082, 0.9449690509688038}, {
                2.603990662333868, 0.9451099758198307}, {2.6052275961112112`, 
                0.9451741765349178}, {2.607701463665898, 
                0.9453025779650919}, {2.6126491987752725`, 
                0.94555938082544}, {2.613861772475368, 0.945622317176656}, {
                2.6150743461754633`, 0.945685253527872}, {2.6174994935756546`,
                 0.9458111262303041}, {2.6223497883760363`, 
                0.9460628716351682}, {2.6320503779767996`, 
                0.9465663624448964}, {2.6514515571783264`, 
                0.9475733440643528}, {2.6902539155813803`, 
                0.9495873073032657}, {2.774462852749733, 0.953958013384668}, {
                2.798724489795918, 0.9552172679026362}}], 
               LineBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAR0x7IgNpBkBUTvdbMpLuP/XKjeJw
gQdA5fWeeW7J7j/cC9Vo/IMHQDcxlM3uye4/wkwc74eGB0CKbIkhb8ruP5DO
qvueiwdAL+NzyW/L7j8q0scUzZUHQHnQSBlxze4/XtkBRymqB0AOq/K4c9Hu
P0QaSc20rAdAYObnDPTR7j8rW5BTQK8HQLMh3WB00u4/+NweYFe0B0BYmMcI
ddPuP5LgO3mFvgdAooWcWHbV7j/G53Wr4dIHQDZgRvh42e4/rCi9MW3VB0CJ
mztM+dnuP5NpBLj41wdA29YwoHna7j9g65LED90HQIBNG0h62+4/+u6v3T3n
B0DKOvCXe93uP+Av92PJ6QdAHXbl6/vd7j/HcD7qVOwHQHCx2j983u4/lPLM
9mvxB0AVKMXnfN/uP3szFH338wdAZ2O6O/3f7j9idFsDg/YHQLqer4994O4/
L/bpD5r7B0BfFZo3fuHuPx8a60Nj/QdAEoBARdjh7j9wnb8/
                "]], 
               LineBox[{{3.001275510204082, 0.9651657042907661}, {
                3.0040658660648987`, 0.9652399751414665}, {3.00530855047641, 
                0.965273051649625}, {3.0077939192994325`, 
                0.9653392046659418}, {3.017735394591522, 0.965603816731209}, {
                3.0189537189257853`, 0.9656362448476387}, {
                3.0201720432600485`, 0.9656686729640683}, {3.022608691928575, 
                0.9657335291969277}, {3.0274819892656275`, 
                0.9658632416626465}, {3.0372285839397324`, 
                0.9661226665940839}, {3.0567217732879426`, 
                0.9666415164569588}, {3.0957081519843626`, 
                0.9676792161827086}, {3.1802851297394477`, 
                0.9699304000462988}, {3.1987244897959184`, 
                0.9704212001542698}}], 
               LineBox[{{3.201275510204082, 0.9704874031060388}, {
                3.3447619504179835`, 0.9741156202527836}, {3.398724489795918, 
                0.9754801241763673}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQLSLp8f68KbfDLIPFFQvM39sLehXpNPHxOAhpXZJe
6fXefsFBfm4rQR6HtuWa1s+AfAPLtS8/CvM4/FJpjFL2fm/vp/FiWaIkj8Mj
eYOZc4H8LrY4RUcVHodNon1ik3ze27Mc9hRjsOJxCGT0Eqz2e2//zVqRoS6V
x2HijYNsvkHv7Vs377tnmsHjwBImqdYF5Itox+x9m8XjUHG5wPU4kG8sNb0q
toDHIeGcfItj8Hv7gh88X22qeRwMjtQymoW8t3+55cfL3xN4HC6st/wjF/be
/o7uhcuVe3gc+Ns3fvwQ+d5+/mvBWub9PA4yh/4yakW9t09aGazWe5DHQfOv
p1AykP9S5XrFgmM8Ds7Fj4yuAvlrHkkoaZ3kcQhYp+fMF/3e/s2z7QIGp3gc
DJf8c1EF8gEkjID+
                "]], 
               LineBox[{{3.601275510204082, 0.9799253977609143}, {
                3.6044205455572738`, 0.9799777173535611}, {
                3.6068988062055514`, 0.9800189447399112}, {3.611855327502106, 
                0.9801013995126114}, {3.6316814126883257`, 
                0.9804312186034123}, {3.6713335830607647`, 
                0.981090856785014}, {3.749078878861765, 0.9823841974790684}, {
                3.798724489795918, 0.9832100826756041}}], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7e5TrcScyedw976wzNWy9/ZrX8jO5vPhd+hUuzM3
uuO9fcfc1oR7fvwOSi9v60wG8lOC3qquC+R32L369u5TQL7Mnj0bfMP5Hd4Z
3L5p2fnevqs/+lhPEr9DkPUtUYmu9/YZZjM/clXyO0gH3Oi90v3eXqlFxIN9
Gb/Dmsortb797+3/WdTwXl/B7+Bqc4WnFci/+fbxpWWr+R3u/bs8ew+QPyF8
c6zbRn4HwZbLO7UnvLf/rxVU3LqH36G079JXzonv7e9c7J/HfJnfwW7xhdxj
k97b72j7nnz5Kr/D9dQLf/4C+VOs4zUX3+B3KNC40G06+b2991K9LU73+B0W
rT2/cgmQv6vi7MnGl/wO7DvOPW2a8t5+mq5pf+AbfocFVedKdgH5hY/mhCi+
53ewtD3H/AnI1/DJuX/gC79D9qGziolT39uzMF5ZMuE7vwNL69kNM4D8B1ut
sxJ+8TvMdT9rfwHI35O1WN/gL7+DGdfZc+zT3ttPl+f++v8/v8P5M2di7YF8
AFt3wNc=
                "]]},
              
              Annotation[#, 
               "Charting`Private`Tag$73032#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, Automatic},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Munc13-1 cluster intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAASmXo0cDpdT7cRsV761bzPQRDGnDf
GVQ/R3xTAYW90T4zn5icsxlkP7yEfFNeveE+S83Xsp0ZdD/3CJH8Sr3xPldk
972SGYQ/FEsbUUG9AT/dL4dDjRmUPyNsYHs8vRE/oBVPhooZpD+r/IIQOr0h
P3vNl8RWuqQ/FCmwzSNLIj9WheACI1ulP35V3YoN2SI/DPVxf7ucpj9RrjcF
4fQjP3jUlHjsH6k/9l/s+YcsJj9Rk9pqTiauP0PDVePVmyo/gQizJ4kZtD/u
RBTbOL0xPypHkYiycLQ/WGrkpyUKMj/ShW/p28e0P8GPtHQSVzI/JAMsqy52
tT+W2lQO7PAyP8b9pC7U0rY/PHCVQZ8kND9vPIOP/Sm3P6aVZQ6McTQ/GHth
8CaBtz8RuzXbeL40P2n4HbJ5L7g/5AXWdFJYNT8SN/wSo4a4P04rpkE/pTU/
unXac8zduD+3UHYOLPI1P2O0uNT1NLk/IXZG2xg/Nj+F3fwWAka5P8iF544k
TjY/uuawNQ==
                "]], 
               Line[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAr1U2HDHtuT+EtHT5lSRFP15wU/dx
Oro/SovMChU+Tj+v7Q+5xOi6P5XuLdtPY1k/UuiIPGpFvD9DoF5D7fVmP5jd
ekO1/r4/Gfl29zu/dT9BHFmk3lW/PznuL6LEB3c/6lo3BQitvz9Z4+hMTVB4
Px7seWOtLcA/mc1aol7hej9vaTYlANzAPwlRn6bAAYA/EmSvqKU4wj+FJYNR
4yOFP1hZoa/w8cQ/fc5Kpyhojz/v21QKohrFPwjVACDFAJA/hl4IZVNDxT/S
QlzsdU2QP7Njbxq2lMU/Yx4ThdfmkD8Obj2FezfGP4fVgLaaGZI/pfDw3yxg
xj9RQ9yCS2aSPzxzpDreiMY/GrE3T/yykj9qeAvwQNrGP62M7uddTJM/xYLZ
WgZ9xz/SQ1wZIX+UP1wFjbW3pcc/m7G35dHLlD/yh0AQac7HP2MfE7KCGJU/
II2nxcsfyD/2+slK5LGVP7cPWyB9SMg/v2glF5X+lT9Okg57LnHIP4nWgONF
S5Y/fJd1MJHCyD8csjd8p+SWPxMaKYtC68g/5h+TSFgxlz+qnNzl8xPJP6+N
7hQJfpc/QB+QQKU8yT93+0nhucqXP9ehQ5tWZck/QGmlrWoXmD+QO0vYzW/J
P/AsMAkkK5g/drnlDw==
                "]], 
               
               Line[{{0.20127551020408163`, 0.02498575274743314}, {
                0.2033724813112215, 0.026766563650876433`}, {
                0.20461432671651483`, 0.027821176101476046`}, {
                0.20585617212180818`, 0.028875788552075655`}, {
                0.20833986293239484`, 0.030985013453274857`}, {
                0.2133072445535682, 0.035203463255673285`}, {
                0.2232420077959149, 0.04364036286047014}, {
                0.24311153428060836`, 0.06051416207006387}, {
                0.2443290196086536, 0.06154808721075042}, {
                0.24554650493669883`, 0.06258201235143696}, {
                0.24798147559278932`, 0.06464986263281006}, {
                0.2528514169049703, 0.06878556319555626}, {0.2625912995293323,
                 0.0770569643210487}, {0.28207106477805627`, 
                0.09359976657203353}, {0.29872448979591837`, 
                0.10774235573337587`}}], 
               
               Line[{{0.3012755102040816, 0.10999523918967724`}, {
                0.3987244897959184, 0.19935893226516072`}}], 
               
               Line[{{0.40127551020408164`, 0.20168363829098637`}, {
                0.48443648039284554`, 0.2769891364623791}, {
                0.4987244897959184, 0.2899274855885816}}], 
               
               Line[{{0.5012755102040817, 0.2921217383758836}, {
                0.5987244897959183, 0.37151880402816145`}}], 
               
               Line[{{0.6012755102040817, 0.3734946575734408}, {
                0.6987244897959183, 0.4450528027805008}}], 
               
               Line[{{0.7012755102040816, 0.44683517511808224`}, {
                0.7987244897959184, 0.5114502765022351}}], 
               
               Line[{{0.8012755102040817, 0.513071414500068}, {
                0.8962801515662935, 0.5708253277161218}, {0.8987244897959182, 
                0.572311256150357}}], 
               
               Line[{{0.9012755102040816, 0.5737389129404922}, {
                0.9987244897959183, 0.6235720500565199}}], 
               
               Line[{{1.0012755102040816`, 0.6248340752067317}, {
                1.0987244897959185`, 0.6714196595668835}}], 
               
               Line[{{1.1012755102040817`, 0.6725468341783967}, {
                1.1987244897959184`, 0.7120773901378524}}], 
               
               Line[{{1.2012755102040815`, 0.7130521250099671}, {
                1.2987244897959185`, 0.747991313280081}}], 
               
               Line[{{1.3012755102040816`, 0.748842923747297}, {
                1.3839420330101317`, 0.7743971579863542}, {
                1.3987244897959183`, 0.7789667751724914}}], 
               
               Line[{{1.4012755102040815`, 0.7796893981679088}, {
                1.4987244897959184`, 0.8047739435926059}}], 
               
               Line[{{1.5012755102040816`, 0.8054188809515991}, {
                1.5987244897959185`, 0.8296075497539857}}], 
               Line[{{1.6012755102040817`, 0.8302143771781293}, {
                1.6987244897959184`, 0.852387323580317}}], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAA9P5cq2w4+z+NjsBbPEvrP6wB5oYz
hPs/fNbus7Zp6z9emPdxPY77P6RVJFfAbes/wcUaSFGi+z/zU4+d03XrP4cg
YfR4yvs/kVBlKvqF6z8T1u1MyBr8P85JEURHpus/bKF2Qs0f/D9iCawVTKjr
P8Rs/zfSJPw/9chG51Cq6z92AxEj3C78Px1IfIparus/2TA0+e9C/D9sRufQ
bbbrP5+LeqUXa/w/CkO9XZTG6z/4VgObHHD8P54CWC+ZyOs/UCKMkCF1/D8y
wvIAnsrrPwK5nXsrf/w/WUEopKfO6z9l5sBRP5P8P6k/k+q61us/K0EH/ma7
/D9HPGl34ebrP7CqqyfYwPw/OgotzhHp6z80FFBRScb8PyzY8CRC6+s/DAGj
VJPH/D/MaKzgxuvrP8Jun8w=
                "]], 
               
               Line[{{1.8012755102040816`, 0.872988674899976}, {
                1.8023956352454178`, 0.8731650218669527}, {
                1.8037242586975861`, 0.8733741937963333}, {
                1.8063815056019226`, 0.8737925376550946}, {
                1.8170104932192683`, 0.8754659130901399}, {
                1.8382684684539596`, 0.8788126639602303}, {
                1.8807844189233422`, 0.8855061657004112}, {
                1.8820249067880583`, 0.8857014619972006}, {
                1.8832653946527742`, 0.88589675829399}, {1.8857463703822064`, 
                0.8862873508875686}, {1.8907083218410705`, 
                0.887068536074726}, {1.8987244897959183`, 
                0.8883305620570452}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAJzKQ3p9r/j8cY3AtcnDsP7hLmsJy
xP4/VmUd7piL7D+SN3RAnM7+P3lrWiW0juw/RQ8oPO/i/j/Ad9ST6pTsP6u+
jzOVC/8/TZDIcFeh7D93HV8i4Vz/P2bBsCoxuuw/YlAwVtxh/z+KnXT3trvs
P06DAYrXZv8/rnk4xDy97D8m6aPxzXD/P/cxwF1IwOw/1LTowLqE/z+Ios+Q
X8bsPzBMcl+UrP8/qoPu9o3S7D8cf0OTj7H/P85fssMT1Ow/B7IUx4q2/z/y
O3aQmdXsP94Xty6BwP8/O/T9KaXY7D+M4/v9bdT/P8tkDV283uw/eBbNMWnZ
/z/wQNEpQuDsP2NJnmVk3v8/FB2V9sfh7D86r0DNWuj/P1zVHJDT5Ow/JuIR
AVbt/z+BseBcWebsPxEV4zRR8v8/pY2kKd/n7D/8R7RoTPf/P8lpaPZk6ew/
PzTWh8b6/z/H1VYNdersPxWXxTs=
                "]], 
               
               Line[{{2.001275510204082, 0.9039442023649266}, {
                2.0039562426140143`, 0.9042152945874893}, {2.008820753763886, 
                0.9047072240073798}, {2.0185497760636295`, 
                0.9056910828471607}, {2.0380078206631165`, 
                0.9076588005267228}, {2.0393271393937447`, 
                0.90779221818737}, {2.0406464581243724`, 
                0.9079256358480173}, {2.0432850955856283`, 
                0.9081924711693119}, {2.0485623705081406`, 
                0.908726141811901}, {2.0591169203531647`, 
                0.9097934830970793}, {2.080226020043213, 
                0.9119281656674358}, {2.098724489795918, 
                0.9137988452103432}}], 
               
               Line[{{2.1012755102040814`, 0.9140480255535907}, {
                2.1987244897959184`, 0.9232307609322744}}], 
               
               Line[{{2.201275510204082, 0.9234682151417221}, {
                2.2866398821120604`, 0.9313160084681278}, {2.298724489795918, 
                0.932426981364828}}], 
               
               Line[{{2.4012755102040817`, 0.9426401507511761}, {
                2.412024645029292, 0.9434677674292835}, {2.414468401872563, 
                0.9436559215415556}, {2.419355915559106, 
                0.9440322297660998}, {2.429130942932191, 
                0.9447848462151882}, {2.4486809976783612`, 
                0.9462900791133649}, {2.450006067043157, 0.946392101231776}, {
                2.4513311364079526`, 0.9464941233501871}, {2.453981275137544, 
                0.9466981675870092}, {2.459281552596727, 
                0.9471062560606535}, {2.4698821075150925`, 
                0.9479224330079421}, {2.491083217351824, 
                0.9495547869025192}, {2.498724489795918, 
                0.9501431174630275}}], 
               
               Line[{{2.601275510204082, 0.9565039587427707}, {
                2.6052275961112112`, 0.9566810804968251}, {2.607701463665898, 
                0.9567919525200758}, {2.6126491987752725`, 
                0.9570136965665773}, {2.613861772475368, 
                0.9570680408257174}, {2.6150743461754633`, 
                0.9571223850848575}, {2.6174994935756546`, 
                0.9572310736031377}, {2.6223497883760363`, 
                0.9574484506396982}, {2.6320503779767996`, 
                0.9578832047128191}, {2.6514515571783264`, 
                0.9587527128590607}, {2.6902539155813803`, 
                0.9604917291515442}, {2.698724489795918, 
                0.9608713572765349}}], 
               
               Line[{{2.7012755102040815`, 0.9609798240141839}, {
                2.798724489795918, 0.9648992842367928}}], 
               Line[{{2.8012755102040816`, 0.9650121482746166}, {
                2.854361932320109, 0.9675743520540617}, {2.8556927523190727`, 
                0.9676385837708584}, {2.8583543923169996`, 
                0.9677670472044517}, {2.863677672312853, 
                0.9680239740716384}, {2.87432423230456, 0.9685378278060117}, {
                2.8756550523035234`, 0.9686020595228084}, {2.876985872302487, 
                0.9686662912396051}, {2.879647512300414, 
                0.9687947546731984}, {2.8849707922962673`, 
                0.9690516815403851}, {2.886301612295231, 
                0.9691159132571818}, {2.887632432294194, 
                0.9691801449739785}, {2.8902940722921207`, 
                0.9693086084075718}, {2.8956173522879745`, 
                0.9695655352747585}, {2.8969481722869377`, 
                0.9696297669915551}, {2.8982789922859014`, 
                0.9696939987083518}, {2.898724489795918, 
                0.9697155005417473}}], 
               
               Line[{{2.9012755102040817`, 0.9698166384457712}, {
                2.9022714522827915`, 0.9698475398892614}, {
                2.9036022722817547`, 0.9698888317072021}, {
                2.9062639122796816`, 0.9699714153430835}, {
                2.9075947322786453`, 0.9700127071610243}, {
                2.9089255522776085`, 0.9700539989789649}, {2.911587192275535, 
                0.9701365826148464}, {2.9169104722713888`, 
                0.9703017498866093}, {2.9382035922548035`, 
                0.9709624189736608}, {2.939446276666315, 
                0.9710009761778791}, {2.940688961077826, 
                0.9710395333820975}, {2.943174329900849, 
                0.9711166477905342}, {2.9481450675468936`, 
                0.9712708766074075}, {2.9580865428389833`, 
                0.9715793342411543}, {2.9779694934231626`, 
                0.9721962495086478}, {2.998724489795918, 
                0.9728402220460695}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ/fCpyJ45TBwOXbMvBtsqvbdPOXzhq78mh4NKwev1
nhrv7Q2anMt99TgcpL48DhfUfG9/4r9GlYcFhwPrnyvLF2i9t//+63O9nQ+H
wx3u7e77dd/bh33s7NYqAZqnXd3+x/i9/Z4AZ5+VZRwOrbnl0Qkm7+2VNvzh
0ajkcGhYX6x/BMh/l5ffp1rH4VBqnHO92/S9feubkIkKHRwOidax6tLm7+23
PJefLjaHw8Hc2/64pdV7eyn3m+FT53E4GPVaz54L5DcsmyQhspDDQfe8eT6j
9Xt7n1TWWYLLOByUgw3ETwL5Tx69msOzgcOBL1oxPcL2vb2X05LY7k0cDpxz
Za33APkbFsbKcW3lcGC5L8mvYPfevibhwnz2XRwOv5KEtj8H8oXvbV3EdITD
4WkWM3u5w3v7Pp7a2u3HOBzENCf6PwbyuaxdInJOcji4PZeb4e/43v71s+0C
BqeA9s3aq5cH5AMASHeVKQ==
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBGIQvXbTw47M8xwO37SfSQo6vbevOzbzRddFDoeKlMzd
DkD+ry8Jh+2vcDgsMvC3qwXyPwW+r1h5k8Ph+wkpl29Afl7DtuC4OxwOilMZ
jhs5v7d/ta5WT/g+h4N34jPPfCD/ITfPk5onHA7zf270fwHkXziq4R/wnsPB
Xcsz+pbLe/uetbN/z5XidHj5ZmnnIo/39hx3kq4FyXI6CO/s5rkP5LdwaW1k
V+B0sG0t7Jf2fG9fnb4jrVCV02GSrO3UKUB+luLViy4GnA5WflcWtHm9t/eY
yrfitSunQ/d6ph1ZPu/tWWsbQywLOR10i+KfGQW8t9/y8c3P/cWcDv6tygnZ
QH5KWsR8tzJOh8IZz28uBvKP+Ou/Cq7mdNi2L/+sSCDQfqW79XmtnA4O3A1b
vgH5JtM9VL+2czokybno6Qe9t3/CveVUdRenQ4shx4p0IN/la5doZz+nw8nw
CbNvAPlfMr/t4p/E6fAmK0RUMPi9/ZJ7iQnTpnA68NVJ9HsC+Ts3t9z9M43T
oab1kWU9kA8A3S+4Vg==
                "]], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAe3+uVTacCUAn3mfGElTvP8Sa5kC+
owlAX8STxRNV7z+DbZTW2K0JQNP1CpJsVu8/AhPwAQ7CCUC6WPkqHlnvP7KH
W6eUxAlAFyUXXnRZ7z9i/MZMG8cJQHPxNJHKWe8/wuWdlyjMCUAtinD3dlrv
P4K4Sy1D1glAobvnw89b7z8BXqdYeOoJQIge1lyBXu8/AKler+ISCkBW5LKO
5GPvP8bs126fFQpAlYsQ+EFk7z+MMFEuXBgKQNUybmGfZO8/F7hDrdUdCkBT
gSk0WmXvPy7HKKvIKApAUB6g2c9m7z9c5fKmrj4KQEpYjSS7ae8/IilsZmtB
CkCJ/+qNGGrvP+hs5SUoRApAyaZI93Vq7z9z9NekoUkKQEf1A8owa+8/igO9
opRUCkBEknpvpmzvP1BHNmJRVwpAgznY2ANt7z8Wi68hDloKQMPgNUJhbe8/
ohKioIdfCkBBL/EUHG7vP2hWG2BEYgpAgNZOfnlu7z+FgFGqyWMKQAH7A2Ot
bu8/gEWuQw==
                "]], 
               
               Line[{{3.3012755102040816`, 0.9823336999704501}, {
                3.303328260790919, 0.9823832377345544}, {3.3046648314240503`, 
                0.982415492369461}, {3.3073379726903127`, 
                0.9824800016392743}, {3.3126842552228375`, 
                0.9826090201789008}, {3.323376820287886, 
                0.9828670572581539}, {3.3447619504179835`, 
                0.9833831314166601}, {3.3460741609738665`, 
                0.9834147981848439}, {3.3473863715297494`, 
                0.9834464649530277}, {3.3500107926415157`, 
                0.9835097984893952}, {3.355259634865048, 
                0.9836364655621305}, {3.3657573193121118`, 
                0.9838897997076008}, {3.38675268820624, 0.9843964679985416}, {
                3.398724489795918, 0.9846853761040154}}], 
               
               Line[{{3.4012755102040817`, 0.9847410752395648}, {
                3.4987244897959178`, 0.9866448130619748}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQB2IQ/eCpyJ45TDwOrolCu5knv7dfcJCf20qQx+HCjL8e
llPe2xtYrn35UZjH4V9FwZ0iIN9P48WyREkehwjLMOZnQH4XW5yiowqPA+8u
xcAzU9/bsxz2FGOw4nEo373jzYzp7+2/WSsy1KXyOPjse6ZsNPu9fevmffdM
M3gcKudFbs8G8kW0Y/a+zeJxWFZ3xmspkG8sNb0qtoDHgdF+U6HEnPf2BT94
vtpU8zhs21+7/x+Q/3LLj5e/J/A4KBwUiT497719hc60E5sn8zj4Lmx/xzL/
vT3HEuPl2dN4HKoafzXaAflqk/NSbs/mcbjq+GDFRiA/qfDJvV3LeBy6Dq3+
Nn3Be/s7uhcuV+7hcfhy2GlSyqL39vNfC9Yy7+dxCGD6EjQLyE9aGazWe5DH
YY3DUuELQL5a+tTzYkd4HDjqw66wLga6R+V6xYJjPA7Je9mnWgP5ax5JKGmd
5HHY/3tHaCGQ/+bZdgGDUzwOK3tPM7YD+QC07a+v
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBWIQvW7Tw47M8zwON1b/vnV58Xv72umJBbeu8jho3A14
ybHkvT2L8NNDb2/xODyaLbzDCMgX5HqTLvKUxyFEcmZoG5B/5biu4LznPA4b
K37ZzAbyZ7Tm71J/xePAeyNaZQOQL8f4mcf6PY/DsWlyn28C+To/fm5M/Mnj
YCmyZILu0vf2bs/Y/6zj5XWQ419/+gqQz7nEc6mFAK9DVZ7A5pdA/pnEbr9D
QrwO188WzvoH5Aff5Vt4VZzXYUKPSabGsvf2CVdE3f4o8jowce1iqwHyqw8p
T/A043V4znLUUXn5e/sN8+xVnsTxOmz8dWt74Yr39p+rPrMnJvI6mOdwmLUB
+Wbhy1/fTeZ12HvXdMssIH83P//m6xm8DicPTNhwGMg/1nDP8XQRr8PDNreV
oivf23PETlL1KOV1SP9RrK4F5HtbunEeLed1eJu5cKkdkH/h49oL+2p4HX76
/FmYDuTfTqqN39TG6yAovGnWTiBfzt7QWb+T12F6y32Jc0B+gvRTtTXdvA6y
33imPwLyn132ebd0Aq+D5s30ydyr3ttrbGC4pDSZ12G911RBBSA/u2fL1vlT
eR1M9xzqNwHyd2xuuftnGq/DsecXT9sD+QCpKeLA
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBGIQXVW/LtRsDq/Dg6hC46pV7+1/b33N3buE18Emserz
eyCfTX33rIZ1vA4y7i6VNavf23sy59f93cDrMOXAtlnzgfye+0pJVZt5HXis
NPccAvIFZ3Rpluzgdfijw/efY817exnOqB3ph3gd7gjdaJkK5Bu9/nHV7xqv
w5x72RPWrX1vH7veTFD2H9D8ssnLH6x/b78t6gffBQY+hxiev0fYNry352Pb
xdPMzOcwe1HaIx0g/0CMLcdLDj4H6fOWspVAvhKXy/8twnwOkhoPJglufG//
LCXwrY8mn4PYLZ06p03v7e0EhF//1+ZzCC2YNjsDyJ+++8qLTXp8DlPZGHb2
AfkeQhFPJEz4HESML3++BeSv2h93+4kdn4NwT2Vm8eb39nlSOSdrQvgc+O2O
hSzZ8t7+2FHd4/rhfA7+V/SLTgH58oXvjzyK5HPoz5rZ/wHIr5DZeGhqDJ/D
OQbmtWJb39tfOF50wCOez4Fves4pGyBfo9hk3+9EPgdf3WvPk4D81obAVSeT
+RwqKqYn1QD5AHBXuts=
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQA2IQ7e5TrcScyeewo9Jz++at7+27FKy3Hs/hc6hYNSvw
HJD/+PSfTVX5fA7TS/0THgL5U5Qa1j0o4XO4zr2zln3be/vv59uWrqnncwiz
6NkRDOQHVHssjm/icyhjdjyeBuSvUONaKNTK5zDt3NerlUB+VG3vnIouPoer
KfGf5wP5e7SmTHaZyucQOtFI7w2Q39C6sPHOKj6H4Fc3Frdsf2/PW87ulbiW
z0FXyzdnGpA/KyNX6Nl6Pgf2rIMmK4D8zd6Wi99v4XPY/XLl0dNA/jPBi0eY
9vM5KL+sei6047299zwGDs3LfA6fn8toLwTyxbbH95X+5nOY/DRh096d7+0X
rzga9usvn0Ou6tWq80C+wSxt+XoGfgf3VE/nh0C+Z+339R2s/A6/nxheYdn1
3r7Guf/ibH5+h+QnTN+8gXxO068zFYT4HWxVyvfFAvnT1KKTlorwO4invG7L
B/LXc6p/XifJ73Dq8WXxyUD+o/P7RA4p8zsYPV5ieQvIzz+octdNjd+BR1mS
6Q2Q/2dT19LTGvwOz5J6T/0F8juWfMgN0OZ3OLCIcTL/7vf2otPCzK7q8jvM
elQarQjkL2rf8y/SgN+hROmVsjGQH+QrVz4NyG/puHPOBMgHABp952M=
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBmIQLSLp8f68Kb+DlcmxV0m739tf8Q1RyLXid/gnkXRi
MpCfaL/rxUcbfoejFQKl64D8KqW2yt+O/A7BFrnnHgP5a1/Izubz4XfI367W
6LfnvX3H3NaEe378DtOtmTxygPyUoLeq6wL5Hfbvv8vXBeTL7NmzwTec30Hg
xJQ5R4H8rv7oYz1J/A6bbjDtsNn73j7DbOZHrkp+h68/773T2vfeXqlFxIN9
Gb9Dtc30GPYD7+3/WdTwXl/B77D4QJGyKpB/8+3jS8tW8zuccfF75QTkTwjf
HOu2kd9B1pe1og7I/68VVNy6h99hX2zx5K9A/p2L/fOYL/M7MNb7n3p88L39
jrbvyZev8jtoMWtPZDz03n6Kdbzm4hv8DkHtbBHyQL73Ur0tTveA9vXvfRoF
5O+qOHuy8SW/g8sCbcZLQP40XdP+wDf8Drkq7CfeA/mFj+aEKL7nd5i64lEf
7+H39ho+OfcPfOF3eLZhpownkM/CeGXJhO/8DnympY/TgPwHW62zEn7xO5jv
DFjVAuTvyVqsb/CX3yHeVqdwEZA/XZ776////A7tB9ktDgD5ADoQ0iw=
                "]], 
               
               Line[{{2.501275510204082, 0.9503204752367506}, {
                2.5359593045799738`, 0.9524727676939997}, {
                2.5384331721346607`, 0.952626282803116}, {2.5433809072440345`,
                 0.9529333130213489}, {2.553276377462783, 
                0.9535473734578145}, {2.5730673179002794`, 
                0.9547754943307458}, {2.574304251677623, 0.954852251885304}, {
                2.5755411854549664`, 0.9549290094398623}, {
                2.5780150530096533`, 0.9550825245489786}, {
                2.5829627881190276`, 0.9553895547672114}, {2.584199721896371, 
                0.9554663123217697}, {2.585436655673715, 
                0.9555430698763279}, {2.587910523228402, 
                0.9556965849854443}, {2.5928582583377757`, 
                0.956003615203677}, {2.594095192115119, 0.9560803727582353}, {
                2.5953321258924626`, 0.9561571303127935}, {2.59780599344715, 
                0.9563106454219099}, {2.5987244897959183`, 
                0.9563676424373472}}], 
               
               Line[{{2.3012755102040816`, 0.9326717644079006}, {
                2.372924535536952, 0.9398350202157145}, {2.375368292380223, 
                0.940079339734635}, {2.3802558060667653`, 
                0.9405679787724759}, {2.390030833439851, 
                0.9415452568481578}, {2.398724489795918, 
                0.9424144226755284}}]}, "Charting`Private`Tag$73032#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT4jB+2nhSFDPgRDGnDf
GVQ/eJhRj4mMIT8zn5icsxlkP55IRkxjjDE/S83Xsp0ZdD+xoMAqUIxBP1dk
972SGYQ/u8z9mUaMUT/dL4dDjRmUP79inNFBjGE/oBVPhooZpD/CrWttP4xx
P4EIsyeJGbQ/Q1NTOz6MgT8qR5GIsnC0PwpZ+aJW2IE/0oVv6dvHtD/RXp8K
bySCPyQDLKsudrU/YWrr2Z+8gj/G/aQu1NK2P36Bg3gB7YM/DPOWNR+MuT+7
r7O1xE2GP5jdekO1/r4/NAwUMEsPiz9BHFmk3lW/P/wRupdjW4s/6lo3BQit
vz/EF2D/e6eLPx7seWOtLcA/UyOszqw/jD9vaTYlANzAP3E6RG0OcI0/EmSv
qKU4wj+taHSq0dCPP1hZoa/w8cQ/k2JqEixJkj/v21QKohrFPyexws6ybJI/
hl4IZVNDxT+7/xqLOZCSP7Njbxq2lMU/4ZzLA0fXkj8Obj2FezfGPzDXLPVh
ZZM/pfDw3yxgxj/DJYWx6IiTPzxzpDreiMY/V3TdbW+skz9qeAvwQNrGP38R
juZ885M/xYLZWgZ9xz/NS+/Xl4GUP1wFjbW3pcc/YZpHlB6llD/yh0AQac7H
P/Ton1ClyJQ/II2nxcsfyD8bhlDJsg+VP7cPWyB9SMg/r9SohTkzlT9Okg57
LnHIP0MjAULAVpU/fJd1MJHCyD9qwLG6zZ2VPxMaKYtC68g//g4Kd1TBlT+q
nNzl8xPJP5JdYjPb5JU/QB+QQKU8yT8lrLrvYQiWP9ehQ5tWZck/uPoSrOgr
lj+QO0vYzW/JP+jGFL8LNZY/kD0oVA==
                "]], 
               
               Line[{{0.20127551020408163`, 0.02287838212207959}, {
                0.2033724813112215, 0.02460864840691684}, {
                0.20461432671651483`, 0.025633327873621492`}, {
                0.20585617212180818`, 0.02665800734032614}, {
                0.20833986293239484`, 0.02870736627373542}, {
                0.2133072445535682, 0.032806084140554}, {0.2232420077959149, 
                0.04100351987419115}, {0.24311153428060836`, 
                0.057398391341465495`}, {0.2443290196086536, 
                0.05840297066457975}, {0.24554650493669883`, 
                0.059407549987693986`}, {0.24798147559278932`, 
                0.061416708633922505`}, {0.2528514169049703, 
                0.06543502592637954}, {0.2625912995293323, 
                0.0734716605112936}, {0.28207106477805627`, 
                0.08954492968112174}, {0.3210305952755042, 
                0.121691468020778}, {0.3987244897959184, 
                0.18579875389069653`}}], 
               
               Line[{{0.40127551020408164`, 0.18788669313879394`}, {
                0.48443648039284554`, 0.2553982606329994}, {
                0.5699233045152912, 0.3247979980760282}, {0.5987244897959183, 
                0.34817931697565896`}}], 
               
               Line[{{0.6012755102040817, 0.35011023640225325`}, {
                0.732138185275487, 0.4419788298280801}, {0.7334646121808601, 
                0.4429100118783653}, {0.7347910390862331, 
                0.44384119392865046`}, {0.7374438928969791, 
                0.44570355802922074`}, {0.742749600518471, 
                0.4494282862303613}, {0.7533610157614552, 
                0.4568777426326425}, {0.7745838462474235, 
                0.47177665543720504`}, {0.7987244897959184, 
                0.4887239398021652}}], 
               
               Line[{{0.8012755102040817, 0.4903153569119956}, {
                0.8195060898552016, 0.5002628384889973}, {0.8219826724910432, 
                0.501614181156944}, {0.8269358377627265, 
                0.5043168664928371}, {0.8368421683060933, 
                0.5097222371646237}, {0.8566548293928267, 
                0.5205329785081966}, {0.8962801515662935, 
                0.5421544611953425}, {0.9739717509693491, 
                0.5845467366215507}, {0.9987244897959183, 
                0.5980530221138229}}], 
               
               Line[{{1.0012755102040816`, 0.5992888105468431}, {
                1.1369227129030104`, 0.6566960642842126}, {
                1.1987244897959184`, 0.6828511947765532}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA9P5cq2w48z8qEf7FGeLlPw4dp+/k
5PQ/VFxbKJgW5z9AVoPd4+n0P6gmF/kwGuc/co9fy+Lu9D/98NLJyR3nP9YB
GKfg+PQ/poVKa/sk5z+e5ohe3Az1P/euOa5eM+c/LrBqzdM09T+bARg0JVDn
P01DLqvChPU/4abUP7KJ5z9+fAqZwYn1PzVxkBBLjec/sLXmhsCO9T+KO0zh
45DnPxQon2K+mPU/MtDDghWY5z/cDBAauqz1P4T5ssV4puc/bNbxiLHU9T8o
TJFLP8PnP4xptWagJPY/b/FNV8z85z/qQK2ICyr2P5Ye0g+zAOg/RxilqnYv
9j+9S1bImQToPwLHlO5MOvY/CqZeOWcM6D95JHR2+U/2P6ZabxsCHOg/1vtr
mGRV9j/Nh/PT6B/oPzTTY7rPWvY/9LR3jM8j6D+SqlvcOmD2Pxvi+0S2J+g/
pZo87ixh9j/AA6OOZCjoP6lluqk=
                "]], 
               
               Line[{{1.4012755102040815`, 0.7557150122492435}, {
                1.4024622524621388`, 0.7560174625319398}, {
                1.4051079980981398`, 0.7566917509126879}, {
                1.4064308709161404`, 0.757028895103062}, {1.407753743734141, 
                0.7573660392934362}, {1.410399489370142, 
                0.7580403276741844}, {1.415690980642144, 
                0.7593889044356809}, {1.426273963186148, 
                0.7620860579586736}, {1.4686058933621644`, 
                0.7728746720506448}, {1.547629076117258, 
                0.7930143306846618}, {1.5987244897959185`, 
                0.8060363851422921}}], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe+T9D+yVb7s/pP/tq1Jsp
evs/29WEQ7uZ6j9UNl2RLn/7PxVACcjcm+o/rAHmhjOE+z9Oqo1M/p3qP16Y
93E9jvs/wn6WVUGi6j/BxRpIUaL7P6knqGfHquo/hyBh9HjK+z94ecuL07vq
PxPW7UzIGvw/FB0S1Ovd6j9soXZCzR/8P06HllgN4Oo/xGz/N9Ik/D+H8Rrd
LuLqP3YDESPcLvw/+8Uj5nHm6j/ZMDT570L8P+JuNfj37uo/n4t6pRdr/D+w
wFgcBADrP/hWA5sccPw/6irdoCUC6z9QIoyQIXX8PySVYSVHBOs/Armdeyt/
/D+YaWouigjrP2XmwFE/k/w/fxJ8QBAR6z8rQQf+Zrv8P01kn2QcIus/sKqr
J9jA/D9EqPfYayTrPzQUUFFJxvw/OuxPTbsm6z8MAaNUk8f8P51Y72dHJ+s/
cFusAw==
                "]], 
               
               Line[{{1.8012755102040816`, 0.8490234894862921}, {
                1.8023956352454178`, 0.849206102365669}, {1.8037242586975861`,
                 0.8494227065350736}, {1.8063815056019226`, 
                0.8498559148738827}, {1.8170104932192683`, 
                0.8515887482291193}, {1.8382684684539596`, 
                0.8550544149395928}, {1.8807844189233422`, 
                0.8619857483605395}, {1.9601756422651684`, 
                0.8749288211039168}, {1.9987244897959184`, 
                0.8812134016502527}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEC+MO+XLjbsPxMP8AjE
+gBAlgb5Ih7M7D/SvYqHSf0AQE+J4CWkzew/kmwlBs//AEAKDMgoKs/sPxLK
WgPaBAFAfxGXLjbS7D8ShcX97w4BQGkcNTpO2Ow/EPua8hsjAUA7MnFRfuTs
PwznRdxzSwFA4F3pf9787D/MleBa+U0BQJvg0IJk/uw/jER72X5QAUBVY7iF
6v/sPwuisNaJVQFAyWiHi/YC7T8KXRvRn18BQLNzJZcOCe0/CNPwxctzAUCF
iWGuPhXtP8iBi0RRdgFAQAxJscQW7T+IMCbD1ngBQPqOMLRKGO0/B45bwOF9
AUBulP+5VhvtPwZJxrr3hwFAWJ+dxW4h7T/G92A5fYoBQBIihcj0Iu0/hqb7
twKNAUDNpGzLeiTtPwUEMbUNkgFAQao70YYn7T/Essszk5QBQPssI9QMKe0/
ubOE3fyWAUCTNCYGgirtPwOeowE=
                "]], 
               
               Line[{{2.201275510204082, 0.9117479005176731}, {
                2.2025743146728987`, 0.9118663036399967}, {
                2.2039086887592343`, 0.9119879494011279}, {2.206577436931906, 
                0.9122312409233904}, {2.21191493327725, 0.9127178239679153}, {
                2.222589925967937, 0.9136909900569652}, {2.2439399113493117`, 
                0.915637322235065}, {2.2866398821120604`, 
                0.9195299865912644}, {2.3704807786936803`, 
                0.9271731878367275}, {2.398724489795918, 
                0.9297479738501735}}], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAFBlI7881A0DsoLnQO8LtP7VTRwOU
RARAivKwJKwT7j+IS7iFHEcEQGY5XzJvFO4/XEMpCKVJBEBCgA1AMhXuPwIz
Cw22TgRA+g1qW7gW7j9OEs8W2FgEQGkpI5LEGe4/6NBWKhxtBEBJYJX/3B/u
PxpOZlGklQRACc552g0s7j/tRdfTLJgEQOQUKOjQLO4/wD1IVrWaBEDAW9b1
ky3uP2YtKlvGnwRAeOkyERov7j+zDO5k6KkEQOgE7EcmMu4/hgRf53CsBEDE
S5pV6TLuP1r8z2n5rgRAoJJIY6wz7j8A7LFuCrQEQFggpX4yNe4/TMt1eCy+
BEDIO161PjjuPx/D5vq0wARApIIMwwE57j/yuld9PcMEQIDJutDEOe4/xrLI
/8XFBEBcEGnehzruP5mqOYJOyARAOFcX7Eo77j/s5rcQMMoEQC7+y8LbO+4/
Nb6WnA==
                "]], 
               
               Line[{{2.601275510204082, 0.9449690509688038}, {
                2.603990662333868, 0.9451099758198307}, {2.6052275961112112`, 
                0.9451741765349178}, {2.607701463665898, 
                0.9453025779650919}, {2.6126491987752725`, 
                0.94555938082544}, {2.613861772475368, 0.945622317176656}, {
                2.6150743461754633`, 0.945685253527872}, {2.6174994935756546`,
                 0.9458111262303041}, {2.6223497883760363`, 
                0.9460628716351682}, {2.6320503779767996`, 
                0.9465663624448964}, {2.6514515571783264`, 
                0.9475733440643528}, {2.6902539155813803`, 
                0.9495873073032657}, {2.774462852749733, 0.953958013384668}, {
                2.798724489795918, 0.9552172679026362}}], 
               Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAR0x7IgNpBkBUTvdbMpLuP/XKjeJw
gQdA5fWeeW7J7j/cC9Vo/IMHQDcxlM3uye4/wkwc74eGB0CKbIkhb8ruP5DO
qvueiwdAL+NzyW/L7j8q0scUzZUHQHnQSBlxze4/XtkBRymqB0AOq/K4c9Hu
P0QaSc20rAdAYObnDPTR7j8rW5BTQK8HQLMh3WB00u4/+NweYFe0B0BYmMcI
ddPuP5LgO3mFvgdAooWcWHbV7j/G53Wr4dIHQDZgRvh42e4/rCi9MW3VB0CJ
mztM+dnuP5NpBLj41wdA29YwoHna7j9g65LED90HQIBNG0h62+4/+u6v3T3n
B0DKOvCXe93uP+Av92PJ6QdAHXbl6/vd7j/HcD7qVOwHQHCx2j983u4/lPLM
9mvxB0AVKMXnfN/uP3szFH338wdAZ2O6O/3f7j9idFsDg/YHQLqer4994O4/
L/bpD5r7B0BfFZo3fuHuPx8a60Nj/QdAEoBARdjh7j9wnb8/
                "]], 
               
               Line[{{3.001275510204082, 0.9651657042907661}, {
                3.0040658660648987`, 0.9652399751414665}, {3.00530855047641, 
                0.965273051649625}, {3.0077939192994325`, 
                0.9653392046659418}, {3.017735394591522, 0.965603816731209}, {
                3.0189537189257853`, 0.9656362448476387}, {
                3.0201720432600485`, 0.9656686729640683}, {3.022608691928575, 
                0.9657335291969277}, {3.0274819892656275`, 
                0.9658632416626465}, {3.0372285839397324`, 
                0.9661226665940839}, {3.0567217732879426`, 
                0.9666415164569588}, {3.0957081519843626`, 
                0.9676792161827086}, {3.1802851297394477`, 
                0.9699304000462988}, {3.1987244897959184`, 
                0.9704212001542698}}], 
               
               Line[{{3.201275510204082, 0.9704874031060388}, {
                3.3447619504179835`, 0.9741156202527836}, {3.398724489795918, 
                0.9754801241763673}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQLSLp8f68KbfDLIPFFQvM39sLehXpNPHxOAhpXZJe
6fXefsFBfm4rQR6HtuWa1s+AfAPLtS8/CvM4/FJpjFL2fm/vp/FiWaIkj8Mj
eYOZc4H8LrY4RUcVHodNon1ik3ze27Mc9hRjsOJxCGT0Eqz2e2//zVqRoS6V
x2HijYNsvkHv7Vs377tnmsHjwBImqdYF5Itox+x9m8XjUHG5wPU4kG8sNb0q
toDHIeGcfItj8Hv7gh88X22qeRwMjtQymoW8t3+55cfL3xN4HC6st/wjF/be
/o7uhcuVe3gc+Ns3fvwQ+d5+/mvBWub9PA4yh/4yakW9t09aGazWe5DHQfOv
p1AykP9S5XrFgmM8Ds7Fj4yuAvlrHkkoaZ3kcQhYp+fMF/3e/s2z7QIGp3gc
DJf8c1EF8gEkjID+
                "]], 
               
               Line[{{3.601275510204082, 0.9799253977609143}, {
                3.6044205455572738`, 0.9799777173535611}, {
                3.6068988062055514`, 0.9800189447399112}, {3.611855327502106, 
                0.9801013995126114}, {3.6316814126883257`, 
                0.9804312186034123}, {3.6713335830607647`, 
                0.981090856785014}, {3.749078878861765, 0.9823841974790684}, {
                3.798724489795918, 0.9832100826756041}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7e5TrcScyedw976wzNWy9/ZrX8jO5vPhd+hUuzM3
uuO9fcfc1oR7fvwOSi9v60wG8lOC3qquC+R32L369u5TQL7Mnj0bfMP5Hd4Z
3L5p2fnevqs/+lhPEr9DkPUtUYmu9/YZZjM/clXyO0gH3Oi90v3eXqlFxIN9
Gb/Dmsortb797+3/WdTwXl/B7+Bqc4WnFci/+fbxpWWr+R3u/bs8ew+QPyF8
c6zbRn4HwZbLO7UnvLf/rxVU3LqH36G079JXzonv7e9c7J/HfJnfwW7xhdxj
k97b72j7nnz5Kr/D9dQLf/4C+VOs4zUX3+B3KNC40G06+b2991K9LU73+B0W
rT2/cgmQv6vi7MnGl/wO7DvOPW2a8t5+mq5pf+AbfocFVedKdgH5hY/mhCi+
53ewtD3H/AnI1/DJuX/gC79D9qGziolT39uzMF5ZMuE7vwNL69kNM4D8B1ut
sxJ+8TvMdT9rfwHI35O1WN/gL7+DGdfZc+zT3ttPl+f++v8/v8P5M2di7YF8
AFt3wNc=
                "]]}, 
              "Charting`Private`Tag$73032#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Munc13-1 cluster intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {192., -189.}, {Center, Center}, {360., 360.}], 
    InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT46bsHE/zZlPgRDGnDf
GVQ/2zjccuZ1Qz8zn5icsxlkP1iv3AS8dVM/S83Xsp0ZdD+X6tzNpnVjP1dk
972SGYQ/NghdMpx1cz/dL4dDjRmUPwYXneSWdYM/oBVPhooZpD9uHr09lHWT
P4EIsyeJGbQ/ISJN6pJ1oz8qR5GIsnC0P1630Ef1yaM/0oVv6dvHtD+ZTFSl
Vx6kPyQDLKsudrU/EndbYBzHpD/G/aQu1NK2PwLMadalGKY/mpmZmZmZuT+4
o0k0xcioP5jdekO1/r4/psm/mt4Brj9BHFmk3lW/P+JeQ/hAVq4/6lo3BQit
vz8e9MZVo6quPx7seWOtLcA/lx7OEGhTrz9vaTYlANzAP8M5bsN4UrA/EmSv
qKU4wj+0jnw5AqSxP1hZoa/w8cQ/ljiZJRVHtD/v21QKohrFP7cGro16brQ/
hl4IZVNDxT/Y1ML135W0P7Njbxq2lMU/GnHsxarktD8Obj2FezfGP5+pP2ZA
grU/xYLZWgZ9xz+pGuama722P1wFjbW3pcc/y+j6DtHktj/yh0AQac7HP+u2
D3c2DLc/II2nxcsfyD8uUzlHAVu3P7cPWyB9SMg/TyFOr2aCtz9Okg57LnHI
P3HvYhfMqbc/fJd1MJHCyD+zi4znlvi3PxMaKYtC68g/1VmhT/wfuD+qnNzl
8xPJP/YntrdhR7g/QB+QQKU8yT8X9sofx264P9ehQ5tWZck/OMTfhyyWuD+Q
O0vYzW/JP6qjQmVOoLg/JV4XQQ==
                "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAApPfnWmXDyT9EtmeVyRa5PzKsEQYc
CMo/Cw16rgyXuT/JLsVgzTDKPyieBe0B47k/YLF4u35Zyj9GL5Er9y66P422
33Dhqso/f1GoqOHGuj/owK3bpk3LP/KV1qK29rs/ntVJsTGTzD/aHjOXYFa+
Pwv/gVxHHs8/Vhj2P9qKwT+YaVdeLEbPPzL6GicWsME/JNQsYBFuzz8O3D8O
UtXBPz6p12Pbvc8/yJ+J3Mkfwj+5qZa1ty7QPzsnHXm5tMI/7VPsvEvO0D8h
NkSymN7DP1Wol8tzDdI/7lOSJFcyxj8zMzMzMzPTP4B1jN+nVsg/JVHu6MOL
1D+Hjy4J1NnKPxp/RzpnodQ/0j6n1jcCyz8QraCLCrfUPx/uH6SbKss/+ghT
LlHi1D+1TBE/Y3vLP9DAt3PeONU/5Qn0dPIczD96MIH++OXVP0CEueAQYM0/
zg8UFC5A1z/4eES4TebPP8M9bWXRVdc/IpTewlgH0D+4a8a2dGvXP8frmqmK
G9A/o8d4WbuW1z8TmxN37kPQP3h/3Z5I7dc/qvkEEraU0D8i76YpY5rYP9i2
50dFNtE/Fx0Aewaw2D99DqQud0rRPwxLWcypxdg/ImZgFale0T/3pgtv8PDY
P24V2eIMh9E/zF5wtH1H2T8GdMp91NfRP5Vq8rizhNk/8IcyevUQ0j+gygE5

                "]], 
               LineBox[{{0.40127551020408164`, 0.2843839172444182}, {
                0.40801895800015076`, 0.2891864074909658}, {
                0.41048403936765704`, 0.29094196778925946`}, {
                0.4154142021026696, 0.2944530883858469}, {
                0.42527452757269474`, 0.3014753295790217}, {0.444995178512745,
                 0.31551981196537127`}, {0.48443648039284554`, 
                0.3436087767380704}, {0.5, 0.3546926693365837}, {
                0.5699233045152912, 0.4044900427420409}, {0.5987244897959183, 
                0.4250014214287491}}], 
               LineBox[{{0.6012755102040817, 0.42664050645506335`}, {0.7, 
                0.48319693539961667`}, {0.732138185275487, 
                0.5016079800724973}, {0.7334646121808601, 
                0.502367852006796}, {0.7347910390862331, 
                0.5031277239410947}, {0.7374438928969791, 
                0.504647467809692}, {0.742749600518471, 0.5076869555468866}, {
                0.7533610157614552, 0.5137659310212759}, {0.7745838462474235, 
                0.5259238819700546}, {0.7987244897959184, 
                0.5397533643441705}}], 
               LineBox[{{0.8012755102040817, 0.54104597611289}, {
                0.8195060898552016, 0.5490772083116247}, {0.8219826724910432, 
                0.5501682328752114}, {0.8269358377627265, 
                0.5523502820023852}, {0.8368421683060933, 
                0.5567143802567327}, {0.8566548293928267, 
                0.5654425767654278}, {0.8962801515662935, 
                0.5828989697828179}, {0.9, 0.5845376980672123}, {
                0.9739717509693491, 0.6171249399185884}, {0.9987244897959183, 
                0.6280294200215347}}], 
               LineBox[{{1.0012755102040816`, 0.629058845373427}, {1.1, 
                0.6652446456555803}, {1.1369227129030104`, 
                0.6787780446910738}, {1.1987244897959184`, 
                0.7014304459377343}}], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAA9P5cq2w48z89KAnSIXnmP83MzMzM
zPQ/gJHA4JJv5z8OHafv5OT0P1IVzfhBfuc/QFaD3ePp9D8nKTxmTYHnP3KP
X8vi7vQ//Tyr01iE5z/WARin4Pj0P6lkia5viuc/nuaIXtwM9T8AtEVknZbn
Py6was3TNPU/rVK+z/iu5z9NQy6rwoT1PwiQr6av3+c/fnwKmcGJ9T/dox4U
u+LnP7C15obAjvU/s7eNgcbl5z8UKJ9ivpj1P1/fa1zd6+c/3AwQGrqs9T+2
LigSC/jnP2zW8Yix1PU/Y82gfWYQ6D+MabVmoCT2P78KklQdQeg/6kCtiAsq
9j/nsH2zakToP0cYpap2L/Y/DldpErhH6D8Cx5TuTDr2P12jQNBSTug/eSR0
dvlP9j/8O+9LiFvoP6WaPO4sYfY/wfp37wNm6D8JD63+
                "]], 
               LineBox[{{1.4012755102040815`, 0.7631526578940822}, {
                1.426273963186148, 0.7692466565315353}, {1.4686058933621644`, 
                0.7795661241001272}, {1.5, 0.7872192234024029}, {
                1.547629076117258, 0.7988300028842349}, {1.5987244897959185`, 
                0.8112857889107236}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAW2XDEdOe+T9m+70FqPrpPzMzMzMz
M/s/RvMyh8mZ6j/7atSbKXr7P1EDamu2teo/VDZdkS5/+z99MnkUsLfqP6wB
5oYzhPs/qGGIvam56j9emPdxPY77P/6/pg+dveo/wcUaSFGi+z+rfOOzg8Xq
P4cgYfR4yvs/BfZc/FDV6j8T1u1MyBr8P7roT43r9Oo/bKF2Qs0f/D/lF182
5fbqP8Rs/zfSJPw/EEdu39746j92AxEj3C78P2eljDHS/Oo/2TA0+e9C/D8U
YsnVuATrP5+LeqUXa/w/bttCHoYU6z/4VgObHHD8P5kKUsd/Fus/UCKMkCF1
/D/EOWFweRjrPwK5nXsrf/w/G5h/wmwc6z9l5sBRP5P8P8hUvGZTJOs/K0EH
/ma7/D8izjWvIDTrP7CqqyfYwPw/YvXi7EQ26z80FFBRScb8P6IckCppOOs/
DAGjVJPH/D8y66cI6zjrP6BRthM=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAjpj2RAbS/D/UU/iNnDzrP8BQPc6c
1vw/7cQCrww+6z9FuuH3Ddz8P0Jc8FXBP+s/To0qS/Dm/D/sisujKkPrP3LZ
TZh5Ev0/lEU4289Q6z+5cZQyjGn9P+O6EUoabOs/R6IhZ7EX/j+CpcQnr6Lr
PzSYDibGHP4/pUl210ak6z8gjvvk2iH+P8jtJ4fepes/+nnVYgQs/j8ONovm
DanrP61RiV5XQP4/mcZRpWyv6z9mZmZmZmb+PzAyBltau+s/31/AREm6/j/c
KfkdpdXrP8xVrQNev/4//82qzTzX6z+4S5rCcsT+PyFyXH3U2Os/kjd0QJzO
/j9nur/cA9zrP0UPKDzv4v4/8kqGm2Li6z+rvo8zlQv/PwlsExkg7+s/dx1f
IuFc/z82ri0UmwjsP2JQMFbcYf8/oR5awioK7D9OgwGK12b/Pw6PhnC6C+w/
Jumj8c1w/z/mb9/M2Q7sP9S06MC6hP8/ljGRhRgV7D8wTHJflKz/P/e09PaV
Iew/HH9Dk4+x/z9jJSGlJSPsPweyFMeKtv8/z5VNU7Uk7D/eF7cugcD/P6d2
pq/UJ+w/jOP7/W3U/z9XOFhoEy7sP3gWzTFp2f8/w6iEFqMv7D9jSZ5lZN7/
Py8ZscQyMew/Oq9AzVro/z8H+gkhUjTsPybiEQFW7f8/c2o2z+E17D8RFeM0
UfL/P9/aYn1xN+w//Ee0aEz3/z9LS48rATnsPz801ofG+v8/jRAUKBg67D9D
3SCv
                "]], 
               LineBox[{{2.001275510204082, 0.8824169707931928}, {
                2.0039562426140143`, 0.8826807029561062}, {2.008820753763886, 
                0.8831592766631717}, {2.0185497760636295`, 
                0.8841164240773028}, {2.0380078206631165`, 
                0.8860307189055652}, {2.0393271393937447`, 
                0.886160514323083}, {2.0406464581243724`, 
                0.8862903097406007}, {2.0432850955856283`, 
                0.8865499005756364}, {2.0485623705081406`, 
                0.8870690822457077}, {2.0591169203531647`, 
                0.8881074455858502}, {2.080226020043213, 
                0.8901841722661353}, {2.0999999999999996`, 
                0.8921295490161936}, {2.122444219423309, 
                0.8943376256267055}, {2.1987244897959184`, 
                0.9018421272391944}}], 
               LineBox[{{2.201275510204082, 0.9020964297263394}, {
                2.2866398821120604`, 0.9107175921339012}, {2.3, 
                0.9120668640083573}, {2.3704807786936803`, 
                0.9191848949403334}, {2.398724489795918, 
                0.9220372982903766}}], 
               LineBox[{{2.4012755102040817`, 0.9222705014445269}, {2.5, 
                0.930349991293749}, {2.5334854370252864`, 
                0.933090397945653}, {2.53472237080263, 0.9331916270724772}, {
                2.5359593045799738`, 0.9332928561993014}, {
                2.5384331721346607`, 0.9334953144529498}, {
                2.5433809072440345`, 0.9339002309602467}, {2.553276377462783, 
                0.9347100639748404}, {2.5730673179002794`, 
                0.9363297300040277}, {2.5987244897959183`, 
                0.9384294811429709}}], 
               LineBox[{{2.601275510204082, 0.9386171541575014}, {
                2.6150743461754633`, 0.9395181751376979}, {
                2.6174994935756546`, 0.939676529704139}, {2.6223497883760363`,
                 0.9399932388370213}, {2.6320503779767996`, 
                0.9406266571027859}, {2.6514515571783264`, 
                0.9418934936343152}, {2.6902539155813803`, 
                0.9444271666973737}, {2.6999999999999997`, 
                0.9450635556329445}, {2.774462852749733, 
                0.9499257478288612}, {2.798724489795918, 
                0.9515099571083875}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAR0x7IgNpBkCRIaKuHXTuPzMzMzMz
MwdAqE/LQYSn7j/1yo3icIEHQHd4FUFou+4/3AvVaPyDB0CUQu7iDbzuP8JM
HO+HhgdAsQzHhLO87j+Qzqr7nosHQOygeMj+ve4/KtLHFM2VB0BgydtPlcDu
P17ZAUcpqgdASRqiXsLF7j9EGknNtKwHQGbkegBoxu4/K1uQU0CvB0CDrlOi
DcfuP/jcHmBXtAdAvUIF5ljI7j+S4Dt5hb4HQDFraG3vyu4/xud1q+HSB0Aa
vC58HNDuP6wovTFt1QdAN4YHHsLQ7j+TaQS4+NcHQFRQ4L9n0e4/YOuSxA/d
B0CO5JEDs9LuP/rur9095wdAAw31iknV7j/gL/djyekHQCDXzSzv1e4/x3A+
6lTsB0A9oabOlNbuP5TyzPZr8QdAdzVYEuDX7j97MxR99/MHQJT/MLSF2O4/
YnRbA4P2B0CyyQlWK9nuPy/26Q+a+wdA7F27mXba7j8fGutDY/0HQL999NTq
2u4/Q+nCYA==
                "]], 
               LineBox[{{3.001275510204082, 0.9643432377304046}, {
                3.0040658660648987`, 0.9644282651160294}, {3.00530855047641, 
                0.9644661320448148}, {3.0077939192994325`, 
                0.9645418659023857}, {3.0090366037109435`, 
                0.964579732831171}, {3.010279288122455, 0.9646175997599564}, {
                3.0127646569454773`, 0.9646933336175272}, {3.017735394591522, 
                0.9648448013326687}, {3.0189537189257853`, 
                0.9648819259641324}, {3.0201720432600485`, 
                0.9649190505955961}, {3.022608691928575, 
                0.9649932998585236}, {3.0274819892656275`, 
                0.9651417983843783}, {3.0372285839397324`, 
                0.9654387954360879}, {3.0567217732879426`, 
                0.9660327895395072}, {3.0957081519843626`, 
                0.9672207777463457}, {3.0999999999999996`, 0.9673515584189449}
                , {3.1802851297394477`, 0.9697979971625289}, {
                3.1987244897959184`, 0.9703598791074849}}], 
               LineBox[{{3.201275510204082, 0.9704331715273606}, {3.3, 
                0.9730976841372104}, {3.3447619504179835`, 
                0.974305781353785}, {3.398724489795918, 0.9757621967470602}}],
                LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQLSLp8f68KbcD98bSGBar9/b/wYDbIeD9y4aegPf2
gl5FOk18PA6Lj9lnagW9t19wkJ/bSpDHwepT2ddyIN/Acu3Lj8I8Dpdk1zUe
BfL9NF4sS5TkcWAolZmVEPzevostTtFRhcchVvnnqWkh7+1ZDnuKMVjxOIg3
bNJhDn9v/81akaEulceh21L1w+3o9/atm/fdM83gcVBKjanRjHlvL6Ids/dt
Fo/DzgmTOcqBfGOp6VWxBTwOL54zKgrFvrcv+MHz1aaax8F12r1Aj7j39i+3
/Hj5ewKPw/9P0zdvSXhvX6Ez7cTmyTwO0+TO2zMlvrfnWGK8PHsaj4OuF9sZ
fyBfbXJeyu3ZPA4xC0uevALykwqf3Nu1DGiff6CoYvJ7+zu6Fy5X7uFxKF7D
Vd6b+t5+/mvBWub9PA4SPv/uXAXyk1YGq/Ue5HHY+/qjk1wa0Lz0qefFjvA4
JHU/XZEG5L9UuV6x4BiPA7v2Tb71QP6aRxJKWid5HNacOlPyHch/82y7gMEp
Hoe5unFLRdLf2wMA2Wu1xw==
                "]], 
               LineBox[{{3.601275510204082, 0.9813886115128622}, {
                3.6044205455572738`, 0.9814378981543017}, {
                3.6068988062055514`, 0.9814767356013407}, {3.611855327502106, 
                0.9815544104954187}, {3.6130944578262447`, 
                0.9815738292189382}, {3.6143335881503837`, 
                0.9815932479424577}, {3.616811848798661, 
                0.9816320853894966}, {3.621768370095216, 
                0.9817097602835747}, {3.6316814126883257`, 
                0.9818651100717307}, {3.6713335830607647`, 
                0.9824865092243547}, {3.6999999999999997`, 
                0.9829357478669685}, {3.749078878861765, 
                0.9837048753434718}, {3.798724489795918, 
                0.9844828842210748}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7e5TrcScyefwUk9fSr/xvb0xGPA7yKxxfb2v+739
2heys/l8+B3WZl4L5u59b98xtzXhnh+/w+TFhm8NgPyUoLeq6wL5Haru9rSF
Afkye/Zs8A3nd/AIdN65EMjv6o8+1pPE7/DYYoOcRd97+wyzmR+5KvkdpDi6
Xqb0v7dXahHxYF/G79C+zLZ+38T39v8sanivr+B3yHswQ+IJkH/z7eNLy1bz
O4RKfdnIOem9/YTwzbFuG/kdlPpWPQkB8v9rBRW37uF32Fcq7vUayL9zsX8e
82V+hy8uH0Ukpry339H2PfnyVX6H23U+62yB/CnW8ZqLb/A7HNqx3D0ZyPde
qrfF6R6/wwSduKp1QP6uirMnG1/yO2iLnL7vMvW9/TRd0/7AN/wOQn5qlVlA
fuGjOSGK7/kdfrY3Ck0A8jV8cu4f+MLvcOy3uettIJ+F8cqSCd+B4WU6+R7D
tPf2D7ZaZyX84neYkv+uXA3I35O1WN/gL79D9UpPQR8gf7o899f///kdkh4v
WVUI5AMA1Ui92w==
                "]]},
              Annotation[#, "Charting`Private`Tag$73107#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAASmXo0cDpdT5O94/eTFxJPgRDGnDf
GVQ/QZxmxHBDJz8zn5icsxlkPyHfzAs+Qzc/S83Xsp0ZdD+RAICvJENHP1dk
972SGYQ/SZFZARhDVz/dL4dDjRmUP6VZRqoRQ2c/oBVPhooZpD/Tvbx+DkN3
P3vNl8RWuqQ/41ZW2Sb9dz9WheACI1ulP/Pv7zM/t3g/DPVxf7ucpj8TIiPp
byt6P3jUlHjsH6k/U4aJU9ETfT9Rk9pqTiauP2onKxRKcoE/gQizJ4kZtD/q
7/foDEOHPypHkYiycLQ/Sgggtuynhz/ShW/p28e0P6ggSIPMDIg/JAMsqy52
tT9nUZgdjNaIP8b9pC7U0rY/47I4Ugtqij9vPIOP/Sm3P0PLYB/rzoo/GHth
8CaBtz+i44jsyjOLP2n4HbJ5L7g/YBTZhor9iz8SN/wSo4a4P8AsAVRqYow/
unXac8zduD8eRSkhSseMP2O0uNT1NLk/fl1R7iksjT+F3fwWAka5PzF5hMrk
P40/GEqwlg==
                "]], 
               LineBox[{{0.10127551020408164`, 0.01576845325230755}, {
                0.10245430267554087`, 0.016971641067258906`}, {
                0.1051142646610319, 0.019686651492473776`}, {
                0.11043418863201396`, 0.02511667234290353}, {
                0.12107403657397808`, 0.035976714043763035`}, {
                0.1224040175667236, 0.037334219256370475`}, {
                0.12373399855946912`, 0.03869172446897792}, {
                0.12639396054496016`, 0.041406734894192804`}, {
                0.1317138845159422, 0.04683675574462254}, {
                0.14235373245790633`, 0.05769679744548204}, {
                0.16363342834183459`, 0.07941688084720105}, {
                0.16487527374712793`, 0.08068442648893105}, {
                0.16611711915242128`, 0.08195197213066105}, {
                0.16860080996300794`, 0.08448706341412102}, {
                0.1735681915841813, 0.08955724598104098}, {
                0.18350295482652804`, 0.09969761111488093}, {
                0.1987244897959184, 0.11523415876296271`}}], 
               LineBox[{{0.20127551020408163`, 0.11785847551799501`}, {
                0.24311153428060836`, 0.16123277413862552`}, {
                0.29872448979591837`, 0.21889057009181012`}}], 
               LineBox[{{0.3012755102040816, 0.2214943843721937}, {
                0.3223512715467095, 0.24266754224101822`}, {
                0.32367194781791486`, 0.24399432169772442`}, {
                0.32631330036032546`, 0.2466478806111367}, {
                0.3315960054451468, 0.25195499843796143`}, {
                0.3421614156147893, 0.2625692340916107}, {
                0.36329223595407434`, 0.2837977053989093}, {
                0.36461291222527964`, 0.2851244848556155}, {
                0.36593358849648494`, 0.2864512643123216}, {
                0.3685749410388956, 0.28910482322573394`}, {
                0.37385764612371686`, 0.29441194105255863`}, {
                0.3844230562933594, 0.3050261767062079}, {0.3987244897959184, 
                0.319393700819689}}], 
               LineBox[{{0.40127551020408164`, 0.32169510359900444`}, {
                0.40801895800015076`, 0.32708769396033754`}, {
                0.41048403936765704`, 0.32905896658293654`}, {
                0.4154142021026696, 0.3330015118281344}, {
                0.42527452757269474`, 0.34088660231853024`}, {
                0.444995178512745, 0.35665678329932193`}, {
                0.48443648039284554`, 0.3881971452609052}, {
                0.4987244897959184, 0.3996229594912106}}], 
               LineBox[{{0.5012755102040817, 0.4016347648161133}, {
                0.5987244897959183, 0.4774088357464746}}], 
               LineBox[{{0.6012755102040817, 0.4792130535155594}, {
                0.6987244897959183, 0.5412812201432713}}], 
               LineBox[{{0.7012755102040816, 0.5427932776486122}, {
                0.7987244897959184, 0.5962463044289446}}], 
               LineBox[{{0.8012755102040817, 0.5975456487598053}, {
                0.8962801515662935, 0.6422132920765776}, {0.8987244897959182, 
                0.643362528857233}}], 
               LineBox[{{0.9012755102040816, 0.6445183558655528}, {
                0.9987244897959183, 0.6870066592037658}}], 
               LineBox[{{1.0012755102040816`, 0.6880189688895448}, {
                1.0987244897959185`, 0.7228711255448532}}], 
               LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe8T8pg4fbVinnP7Znj8JK
NvI/RYL61LmY5z+A1z6mvzvyP5NakBS9nOc/FredbalG8j8wC7yTw6TnP0J2
W/x8XPI/aWwTktC05z+a9NYZJIjyP9suwo7q1Oc/ZWSG/ZiN8j8qB1jO7djn
PzDUNeENk/I/eN/tDfHc5z/Gs5So953yPxWQGY335Oc/8XJSN8uz8j9N8XCL
BPXnP0jxzVRy3/I/v7MfiB4V6D8TYX045+TyPw2MtcchGeg/3tAsHFzq8j9b
ZEsHJR3oP3Swi+NF9fI/+BR3hisl6D+fb0lyGQvzPzB2zoQ4Neg/at/4VY4Q
8z9/TmTEOznoPzRPqDkDFvM/zCb6Az896D/KLgcB7SDzP2nXJYNFReg/lZ62
5GEm8z+3r7vCSEnoP2AOZsjWK/M/BohRAkxN6D9yZwm7+S3zPxpxnDneTug/
8T+sOg==
                "]], 
               LineBox[{{1.2012755102040815`, 0.7604193576164642}, {
                1.2021994123405053`, 0.7606532568915082}, {1.203531589880046, 
                0.7609905170281008}, {1.2061959449591275`, 
                0.761665037301286}, {1.2115246551172902`, 
                0.7630140778476563}, {1.222182075433616, 
                0.7657121589403969}, {1.2234898928959086`, 
                0.7660432519688255}, {1.224797710358201, 0.766374344997254}, {
                1.2274133452827862`, 0.767036531054111}, {1.2326446151319568`,
                 0.768360903167825}, {1.2431071548302977`, 
                0.7710096473952531}, {1.2640322342269796`, 
                0.7763071358501092}, {1.2987244897959185`, 
                0.7850899853612331}}], 
               LineBox[{{1.3012755102040816`, 0.7857563157873154}, {
                1.3083217567700243`, 0.7876534366228315}, {
                1.3107611205197052`, 0.7883102072526431}, {1.315639848019067, 
                0.7896237485122664}, {1.3253973030177906`, 
                0.7922508310315127}, {1.3449122130152376`, 
                0.7975049960700057}, {1.3461318948900778`, 
                0.7978333813849113}, {1.3473515767649182`, 
                0.7981617666998172}, {1.3497909405145991`, 
                0.7988185373296288}, {1.354669668013961, 
                0.8001320785892521}, {1.3644271230126845`, 
                0.8027591611084985}, {1.3839420330101317`, 
                0.8080133261469914}, {1.3852649058281323`, 
                0.8083694944363466}, {1.3865877786461327`, 
                0.8087256627257018}, {1.3892335242821336`, 
                0.8094379993044121}, {1.3945250155541358`, 
                0.8108626724618327}, {1.3987244897959183`, 
                0.8119933325952442}}], 
               LineBox[{{1.4012755102040815`, 0.8126007184067116}, {
                1.4064308709161404`, 0.8136676305090665}, {1.407753743734141, 
                0.8139414016568545}, {1.410399489370142, 
                0.8144889439524303}, {1.415690980642144, 0.815584028543582}, {
                1.426273963186148, 0.8177741977258854}, {1.4686058933621644`, 
                0.8265348744550992}, {1.4987244897959184`, 
                0.8327679775948956}}], 
               LineBox[{{1.5012755102040816`, 0.8332702882237885}, {
                1.5987244897959185`, 0.8514795610830226}}], 
               LineBox[{{1.6012755102040817`, 0.8519639320465978}, {
                1.6345700473310565`, 0.8583860248016503}, {
                1.6358836154275167`, 0.8586393953808349}, {
                1.6385107516204371`, 0.8591461365392041}, {
                1.6437650240062784`, 0.8601596188559426}, {1.654273568777961, 
                0.8621865834894197}, {1.675290658321326, 
                0.8662405127563737}, {1.6766042264177865`, 
                0.8664938833355584}, {1.6779177945142467`, 
                0.866747253914743}, {1.6805449307071672`, 
                0.8672539950731123}, {1.6857992030930085`, 
                0.8682674773898508}, {1.6871127711894687`, 
                0.8685208479690354}, {1.6884263392859291`, 
                0.86877421854822}, {1.6910534754788498`, 
                0.8692809597065893}, {1.696307747864691, 
                0.8702944420233278}, {1.6976213159611513`, 
                0.8705478126025125}, {1.6987244897959184`, 
                0.8707606008045169}}], 
               LineBox[{{1.7012755102040815`, 0.8711885899628083}, {
                1.7028755883469926`, 0.8714168510601495}, {1.704189156443453, 
                0.8716042397176715}, {1.7068162926363737`, 
                0.8719790170327154}, {1.717324837408056, 
                0.8734781262928911}, {1.7185502699170643`, 
                0.8736529418607826}, {1.7197757024260723`, 
                0.873827757428674}, {1.7222265674440886`, 
                0.8741773885644569}, {1.7271282974801212`, 
                0.8748766508360227}, {1.7369317575521863`, 
                0.8762751753791544}, {1.7565386776963166`, 
                0.8790722244654178}, {1.795752517984577, 
                0.8846663226379443}, {1.7970811414367454`, 
                0.8848558590355814}, {1.7984097648889135`, 
                0.8850453954332184}, {1.7987244897959185`, 
                0.8850902928983527}}], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAjpj2RAbS/D+jY3aTY1XsP06NKkvw
5vw/xdEF91ha7D9y2U2YeRL9P8rHSmmrZOw/uXGUMoxp/T/Us9RNUHnsPz7b
OFz9bv0/lVIdnJp67D/CRN2FbnT9P1XxZerke+w/yhcm2VB//T/WLveGeX7s
P9y9t38Vlf0/2akZwKKD7D8ACtvMnsD9P96fXjL1jew/R6IhZ7EX/j/ni+gW
mqLsPzSYDibGHP4/Ca7ue86j7D8gjvvk2iH+PyrQ9OACpew/+nnVYgQs/j9u
FAGra6fsP61RiV5XQP4/9JwZPz2s7D+aR3YdbEX+Pxa/H6Rxrew/hj1j3IBK
/j834SUJpq7sP2ApPVqqVP4/eiUy0w6x7D9NHyoZv1n+P5xHODhDsuw/OhUX
2NNe/j++aT6dd7PsP6WaPO4sYf4/GPlOIAa07D/dWaXD
                "]], 
               LineBox[{{1.9012755102040815`, 0.8972369840039691}, {
                1.905594176217663, 0.8976101056406659}, {1.910556127676527, 
                0.8980388054854141}, {1.9204800305942553`, 
                0.8988962051749104}, {1.9601756422651684`, 
                0.9023258039328956}, {1.9987244897959184`, 
                0.9056563252184537}}], 
               LineBox[{{2.001275510204082, 0.9059100433422312}, {
                2.0393271393937447`, 0.9101915206068909}, {
                2.0406464581243724`, 0.9103399671588603}, {
                2.0432850955856283`, 0.9106368602627991}, {
                2.0485623705081406`, 0.9112306464706768}, {
                2.0591169203531647`, 0.9124182188864319}, {2.080226020043213, 
                0.9147933637179423}, {2.098724489795918, 
                0.9168747667843506}}], 
               LineBox[{{2.201275510204082, 0.925564740664198}, {
                2.2866398821120604`, 0.9327684851290063}, {2.298724489795918, 
                0.9337882832457877}}], 
               LineBox[{{2.3012755102040816`, 0.9339933079922745}, {
                2.398724489795918, 0.9414336560422841}}], 
               LineBox[{{2.4012755102040817`, 0.9416258667421157}, {
                2.450006067043157, 0.9452485924866321}, {2.4513311364079526`, 
                0.9453471007576737}, {2.453981275137544, 
                0.9455441172997571}, {2.459281552596727, 
                0.9459381503839238}, {2.4698821075150925`, 
                0.9467262165522572}, {2.4712071768798882`, 
                0.9468247248232988}, {2.472532246244684, 
                0.9469232330943405}, {2.4751823849742753`, 
                0.9471202496364238}, {2.480482662433458, 
                0.9475142827205906}, {2.491083217351824, 0.948302348888924}, {
                2.4924082867166195`, 0.9484008571599656}, {2.493733356081415, 
                0.9484993654310073}, {2.4963834948110066`, 
                0.9486963819730906}, {2.4977085641758023`, 
                0.9487948902441323}, {2.498724489795918, 
                0.9488704161592303}}], 
               LineBox[{{2.501275510204082, 0.9490344359564199}, {
                2.503008841634985, 0.9491284684029427}, {2.504333910999781, 
                0.949200352816946}, {2.5069840497293723`, 
                0.9493441216449529}, {2.512284327188555, 
                0.9496316593009664}, {2.5334854370252864`, 
                0.9507818099250205}, {2.53472237080263, 0.9508489130232489}, {
                2.5359593045799738`, 0.9509160161214774}, {
                2.5384331721346607`, 0.9510502223179341}, {
                2.5433809072440345`, 0.9513186347108478}, {2.553276377462783, 
                0.9518554594966749}, {2.5730673179002794`, 
                0.9529291090683294}, {2.5987244897959183`, 
                0.9543209990445847}}], 
               LineBox[{{2.601275510204082, 0.9544645163671255}, {
                2.6902539155813803`, 0.9596491130236288}, {2.691569680224636, 
                0.9597257800412184}, {2.6928854448678914`, 
                0.9598024470588082}, {2.695516974154402, 
                0.9599557810939876}, {2.698724489795919, 
                0.9601426767210802}}], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAfH+uVTacBUCt9SlcyrruPy6KZ7be
2wVABDlMfKzL7j+Wb1iNkN4FQEL63nFjzO4//1RJZELhBUCAu3FnGs3uP9Af
KxKm5gVA+z2XUojO7j9xte5tbfEFQPJC4ihk0e4/tOB1JfwGBkDhTHjVG9fu
Pzo3hJQZMgZAvWCkLovi7j/WYhk2nTQGQA4z1eI14+4/c46u1yA3BkBgBQaX
4OPuP6zl2BooPAZAA6pn/zXl7j8elC2hNkYGQEjzKtDg5+4/ur/CQrpIBkCZ
xVuEi+juP1frV+Q9SwZA65eMODbp7j+QQoInRVAGQI087qCL6u4/AvHWrVNa
BkDShbFxNu3uP54cbE/XXAZAJFjiJeHt7j87SAHxWl8GQHUqE9qL7u4/2HOW
kt5hBkDH/EOONu/uP4WAUarJYwZAUnCnzbjv7j/YjZyj
                "]], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAR0x7IgNpBkDKDe7H5fDuP+ZNgLpw
bgZA3wnYpebx7j+CeRVc9HAGQKt1jZ9d8u4/H6Wq/XdzBkB34UKZ1PLuP1j8
1EB/eAZAD7mtjMLz7j/LqinHjYIGQEBog3Oe9e4/aNa+aBGFBkAM1DhtFfbu
PwQCVAqVhwZA2D/uZoz27j8+WX5NnIwGQHAXWVp69+4/sAfT06qWBkChxi5B
VvnuP5RkfODHqgZAASXaDg797j9cHs/5AdMGQMLhMKp9BO8/DhlytbvVBkCo
Hhak/gTvP8ETFXF12AZAjlv7nX8F7z8mCVvo6N0GQFrVxZGBBu8/7/Pm1s/o
BkDxyFp5hQjvP4LJ/rOd/gZAILCESI0M7z80xKFvVwEHQAbtaUIODe8/575E
KxEEB0DsKU88jw3vP0y0iqKECQdAuKMZMJEO7z8VnxaRaxQHQE+XrheVEO8/
qHQubjkqB0B+ftjmnBTvP1pv0SnzLAdAZLu94B0V7z8NanTlrC8HQEr4otqe
Fe8/Uk0ed5YwB0DQkYMHyhXvP7/BulE=
                "]], 
               LineBox[{{2.9012755102040817`, 0.9715123240375113}, {
                2.9022714522827915`, 0.9715463425533604}, {
                2.9036022722817547`, 0.9715917995354427}, {
                2.9062639122796816`, 0.9716827134996073}, {
                2.9169104722713888`, 0.972046369356266}, {2.9382035922548035`,
                 0.9727736810695834}, {2.939446276666315, 
                0.9728161275935852}, {2.940688961077826, 0.972858574117587}, {
                2.943174329900849, 0.9729434671655905}, {2.9481450675468936`, 
                0.9731132532615977}, {2.9580865428389833`, 
                0.973452825453612}, {2.9779694934231626`, 
                0.9741319698376407}, {2.998724489795918, 
                0.9748409007967261}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCCEA0AkwojDLvP2TD0PVP
KQhAN0D75OY27z8wgkN3TS4IQE7g5KJ2N+8/yP8oekg4CEB7ILgeljjvP/f6
838+TAhA16BeFtU67z9W8YmLKnQIQI+hqwVTP+8/vFBDTKl2CECacaDkmj/v
PyKw/AwoeQhApkGVw+I/7z/ubm+OJX4IQL3hfoFyQO8/hexUkSCICEDqIVL9
kUHvP7TnH5cWnAhARqL49NBD7z8aR9lXlZ4IQFJy7dMYRO8/gKaSGBShCEBd
QuKyYETvP0xlBZoRpghAdOLLcPBE7z/k4uqcDLAIQKIin+wPRu8/SkKkXYuy
CECt8pPLV0bvP7ChXR4KtQhAucKIqp9G7z98YNCfB7oIQNBicmgvR+8/E961
ogLECED+okXkTkjvP44MfX23xghAfVaa2ZxI7z8KO0RYbMkIQPwJ787qSO8/
6+a3EDDKCEDfwZDUAEnvPzTCppA=
                "]], 
               LineBox[{{3.1012755102040814`, 0.9777179105518036}, {
                3.1023157283714786`, 0.9777346309563428}, {3.103637243648902, 
                0.9777558729137859}, {3.1062802742037485`, 
                0.9777983568286719}, {3.107601789481172, 
                0.9778195987861148}, {3.108923304758595, 
                0.9778408407435578}, {3.1115663353134413`, 
                0.9778833246584439}, {3.116852396423134, 
                0.9779682924882159}, {3.137996640861905, 0.978308163807304}, {
                3.1802851297394477`, 0.9789879064454804}, {
                3.1815185094294183`, 0.9790077317167678}, {
                3.1827518891193893`, 0.9790275569880552}, {
                3.1852186484993315`, 0.9790672075306301}, {
                3.1901521672592157`, 0.97914650861578}, {3.1987244897959184`, 
                0.9792842996149635}}], 
               LineBox[{{3.201275510204082, 0.979327867373592}, {
                3.2592214298975932`, 0.980375714022661}, {3.2605580005307244`,
                 0.9803998834735314}, {3.2618945711638556`, 
                0.9804240529244017}, {3.2645677124301176`, 
                0.9804723918261424}, {3.269913994962642, 
                0.9805690696296239}, {3.2806065600276906`, 
                0.9807624252365867}, {3.2819431306608218`, 
                0.9807865946874571}, {3.283279701293953, 
                0.9808107641383275}, {3.285952842560215, 
                0.9808591030400682}, {3.2912991250927393`, 
                0.9809557808435496}, {3.2926356957258704`, 
                0.98097995029442}, {3.2939722663590016`, 
                0.9810041197452903}, {3.296645407625264, 
                0.9810524586470312}, {3.298724489795918, 0.981090055069647}}],
                LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7e5TrcScyeVgwFV5rT31vX1dKkOceS6XQ0uA4aL3
QL7LykrZL/lcDivYYsyN097bXzDImZNbyuXwoWhj4i4g/4V94KyEBi6HRu+Y
bSfS39uLxUlPc5vG5bDwz8b4p5nv7Ytmre8VOsTl8CgudpNc3nv77X9mtR86
wuXAaWDCkwjk/4lrayw6zuVgyMidthjIb1eOLb10hsuhYfEOSY389/Zz1nDF
TrrO5SD3QrjRsOC9/dF9qTpCb7kcogpP+bsUvbfnUgxUO/Sey6HJaeHKNiA/
oNlGoegTl8NK4Qrmk0D+LXdhkUvfuRx+bFXd7lv83v7dhQO/JzJxO0z/1SAX
XvLeXuKx9GlBCW6Hy83mbzPL3tvHurIfPSjF7fArhM99DZC/aPmnfYWy3A5K
ak8XvAPydXJObrqoxO1QeGJSSHH5e/vCc1vWNKpyO8ycmbluK5C/zWDBMkMN
bocDWQ4cP4B8x69lsybqcjvw877bXVPx3r4tPGmKowG3g/m9I6L7gfwgX7ny
aUB+aGq/63EgHwDtULNC
                "]], 
               LineBox[{{3.4012755102040817`, 0.9835447138469614}, {
                3.402499214876836, 0.9835643836026015}, {3.403811425432719, 
                0.9835854759965075}, {3.405123635988602, 
                0.9836065683904136}, {3.4077480571003678`, 
                0.9836487531782258}, {3.4090602676562507`, 
                0.9836698455721319}, {3.4103724782121336`, 
                0.983690937966038}, {3.4129968993239, 0.9837331227538502}, {
                3.418245741547432, 0.9838174923294746}, {3.428743425994496, 
                0.9839862314807234}, {3.4299675009629267`, 
                0.9840059071884739}, {3.431191575931358, 
                0.9840255828962244}, {3.433639725868219, 
                0.9840649343117255}, {3.438536025741943, 
                0.9841436371427277}, {3.4483286254893892`, 
                0.9843010428047321}, {3.4679138249842825`, 
                0.9846158541287408}, {3.4987244897959178`, 
                0.9851111029101213}}], 
               LineBox[{{3.5012755102040813`, 0.9851546706687498}, {
                3.5920292423158866`, 0.9867957869818024}, {3.593268372640025, 
                0.9868181944017688}, {3.5945075029641638`, 
                0.986840601821735}, {3.5969857636124414`, 
                0.9868854166616677}, {3.5987244897959183`, 
                0.9869168583648048}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQvW7Tw47M8zwOmi2/0o2nvrcX5HqTLvKUx+HR16QF
R6a9t3d7xv5nHS+vg9WEFXVbZr6351ziudRCgNfh/suemsdA/pnEbr9DQrwO
rc6FVUKz3tsH3+VbeFWc1+HCN8uyAiA/4Yqo2x9FXoe02NO5OrPf21cfUp7g
acbrMEnrXcySOe/tN8yzV3kSx+vw6oix9ZT57+0/V31mT0zkdbhkNNPnEJBv
Fr789d1kXoddC/7FfgDyd/Pzb76ewevQVXOywWfBe/tjDfccTxfxOmibxB9j
WfjeniN2kqpHKa+D8KIj142AfG9LN86j5bwOv/m1XiYA+Rc+rr2wr4bX4fTr
L9x7gfzbSbXxm9p4HXIWdwWWLnpvL2dv6KzfyesQIvghaTGQnyD9VG1NN6+D
TX1oyUUg/9lln3dLJ/A68EQrTNdd/N5eYwPDJaXJvA5fTrSuiAbys3u2bJ0/
ldfhjtnrnZ1A/o7NLXf/TON1aPHw/r0IyAcAFu2zLA==
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQXVW/LtRsDq/DKanvN18sfm//e+tr7t4lvA5TnoRV
6S55b8+mvntWwzpeh7buhIR6IN+TOb/u7wZeB+evj25OBvJ77islVW3mdfgf
lxq8AsgXnNGlWbKD16HCKMvtIpAvwxm1I/0Qr0PWzWId5aXv7Y1e/7jqd43X
wU+9/ccxID92vZmg7D9eB7HDayfwLX9vvy3qB98FBj6H1SoFx1WAfD62XTzN
zHwO9m1G/6yA/AMxthwvOfgcMjy3Z6cD+UpcLv+3CPM57Dp/wO0AkP8sJfCt
jyafQ+ydy38KV7y3txMQfv1fm8/hk+004w4gf/ruKy826fE5tM2PyJoH5HsI
RTyRMOFzWJ909/opIH/V/rjbT+z4HBhfPtukvPK9fZ5UzsmaED6HpV9/ZlwF
8o8d1T2uH87nYBm+Z/5rIF++8P2RR5F8Dud21F1jXPXe/sLxogMe8XwO36uZ
XfSA/NaGwFUnk/kcrj0ODgkG8gFVnLN6
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7e5TrcScyeewPTFjc/Oq9/ZdCtZbj+fwORzN8yhb
BeQ/Pv1nU1U+n8P+jN1Wx4D8KUoN6x6U8Dlsill4+C+Q//1829I19XwOM11y
r+asfm/f0Lqw8c4qPgejJ3NkNNe+t+ctZ/dKXMvnoF6ymdUZyJ+VkSv0bD2f
gzTLqXcxQP5mb8vF77fwObCqfD8wAch/JnjxCNN+PocbyYGpP4B873kMHJqX
+RzqHrOuO77uvb3Y9vi+0t98Dqcf5dmnbXhvv3jF0bBff/kcDhS1ajQA+Qaz
tOXrGfgdtjDNEZwF5HvWfl/fwcrvME/p5OOzQH6Nc//F2fz8DoVJyh2mG9/b
c5p+nakgxO+Q9smy0B/In6YWnbRUhN8huikgKhPIX8+p/nmdJL+Dy6JanblA
/qPz+0QOKfM7iD+6foFl03v7/IMqd93U+B14it7tlAPy/2zqWnpag9+BkYl1
sQWQ37HkQ26ANr/Dt4nSPUFAvui0MLOruvwOrxWNSnOA/EXte/5FGvA73N/o
EdcG5Af5ypVPA/LZYmPOdAD5AByIw3s=
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQLSLp8f68Kb/DOdbu05s3vbe/4huikGvF75CTEOR2
AchPtN/14qMNv8OZbTqX7gP5VUptlb8d+R26kx++/Afkr30hO5vPh9+Ba6+X
pO3m9/Ydc1sT7vnxOzD1MJT4AfkpQW9V1wXyO/yK2nYuHsiX2bNng284v8Or
H4otTUB+V3/0sZ4kfofTJj/fHQfyM8xmfuSq5HfoXbP8SNCW9/ZKLSIe7Mv4
HfjnsBRkbH1v/8+ihvf6Cn4HjuxdpyqB/JtvH19atprfgcGqQLUbyJ8QvjnW
bSO/w4frt2+tBfL/awUVt+7hd7govNn1M5B/52L/PObL/A6TuhOl67a9t9/R
9j358lWgf6LEy/qB/CnW8ZqLb/A7NGuevbAAyPdeqrfF6R6/Q/Fxi7bDQP6u
irMnG1/yO4QwC3zk2P7efpquaX/gG34Hn0tHvaWA/MJHc0IU3/M7uCysXqYN
5Gv45Nw/8IXfwcT+ebQfkM/CeGXJhO/8Drp8c7fFA/kPtlpnJfzid1C9GyRY
COTvyVqsb/CX30F2DUdOE5A/XZ776////A6i1fuOTQbyATBI09U=
                "]], 
               LineBox[{{2.1012755102040814`, 0.9171259220987972}, {
                2.1249065857096605`, 0.9191201056857659}, {
                2.1273689519960124`, 0.9193279003090867}, {2.132293684568716, 
                0.9197434895557284}, {2.142143149714123, 
                0.9205746680490117}, {2.161842080004936, 
                0.9222370250355781}, {2.1987244897959184`, 
                0.9253494646803868}}]},
              
              Annotation[#, 
               "Charting`Private`Tag$73107#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, Automatic},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Cav2.1 cluster intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT46bsHE/zZlPgRDGnDf
GVQ/2zjccuZ1Qz8zn5icsxlkP1iv3AS8dVM/S83Xsp0ZdD+X6tzNpnVjP1dk
972SGYQ/NghdMpx1cz/dL4dDjRmUPwYXneSWdYM/oBVPhooZpD9uHr09lHWT
P4EIsyeJGbQ/ISJN6pJ1oz8qR5GIsnC0P1630Ef1yaM/0oVv6dvHtD+ZTFSl
Vx6kPyQDLKsudrU/EndbYBzHpD/G/aQu1NK2PwLMadalGKY/mpmZmZmZuT+4
o0k0xcioP5jdekO1/r4/psm/mt4Brj9BHFmk3lW/P+JeQ/hAVq4/6lo3BQit
vz8e9MZVo6quPx7seWOtLcA/lx7OEGhTrz9vaTYlANzAP8M5bsN4UrA/EmSv
qKU4wj+0jnw5AqSxP1hZoa/w8cQ/ljiZJRVHtD/v21QKohrFP7cGro16brQ/
hl4IZVNDxT/Y1ML135W0P7Njbxq2lMU/GnHsxarktD8Obj2FezfGP5+pP2ZA
grU/xYLZWgZ9xz+pGuama722P1wFjbW3pcc/y+j6DtHktj/yh0AQac7HP+u2
D3c2DLc/II2nxcsfyD8uUzlHAVu3P7cPWyB9SMg/TyFOr2aCtz9Okg57LnHI
P3HvYhfMqbc/fJd1MJHCyD+zi4znlvi3PxMaKYtC68g/1VmhT/wfuD+qnNzl
8xPJP/YntrdhR7g/QB+QQKU8yT8X9sofx264P9ehQ5tWZck/OMTfhyyWuD+Q
O0vYzW/JP6qjQmVOoLg/JV4XQQ==
                "]], 
               Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAApPfnWmXDyT9EtmeVyRa5PzKsEQYc
CMo/Cw16rgyXuT/JLsVgzTDKPyieBe0B47k/YLF4u35Zyj9GL5Er9y66P422
33Dhqso/f1GoqOHGuj/owK3bpk3LP/KV1qK29rs/ntVJsTGTzD/aHjOXYFa+
Pwv/gVxHHs8/Vhj2P9qKwT+YaVdeLEbPPzL6GicWsME/JNQsYBFuzz8O3D8O
UtXBPz6p12Pbvc8/yJ+J3Mkfwj+5qZa1ty7QPzsnHXm5tMI/7VPsvEvO0D8h
NkSymN7DP1Wol8tzDdI/7lOSJFcyxj8zMzMzMzPTP4B1jN+nVsg/JVHu6MOL
1D+Hjy4J1NnKPxp/RzpnodQ/0j6n1jcCyz8QraCLCrfUPx/uH6SbKss/+ghT
LlHi1D+1TBE/Y3vLP9DAt3PeONU/5Qn0dPIczD96MIH++OXVP0CEueAQYM0/
zg8UFC5A1z/4eES4TebPP8M9bWXRVdc/IpTewlgH0D+4a8a2dGvXP8frmqmK
G9A/o8d4WbuW1z8TmxN37kPQP3h/3Z5I7dc/qvkEEraU0D8i76YpY5rYP9i2
50dFNtE/Fx0Aewaw2D99DqQud0rRPwxLWcypxdg/ImZgFale0T/3pgtv8PDY
P24V2eIMh9E/zF5wtH1H2T8GdMp91NfRP5Vq8rizhNk/8IcyevUQ0j+gygE5

                "]], 
               
               Line[{{0.40127551020408164`, 0.2843839172444182}, {
                0.40801895800015076`, 0.2891864074909658}, {
                0.41048403936765704`, 0.29094196778925946`}, {
                0.4154142021026696, 0.2944530883858469}, {
                0.42527452757269474`, 0.3014753295790217}, {0.444995178512745,
                 0.31551981196537127`}, {0.48443648039284554`, 
                0.3436087767380704}, {0.5, 0.3546926693365837}, {
                0.5699233045152912, 0.4044900427420409}, {0.5987244897959183, 
                0.4250014214287491}}], 
               
               Line[{{0.6012755102040817, 0.42664050645506335`}, {0.7, 
                0.48319693539961667`}, {0.732138185275487, 
                0.5016079800724973}, {0.7334646121808601, 
                0.502367852006796}, {0.7347910390862331, 
                0.5031277239410947}, {0.7374438928969791, 
                0.504647467809692}, {0.742749600518471, 0.5076869555468866}, {
                0.7533610157614552, 0.5137659310212759}, {0.7745838462474235, 
                0.5259238819700546}, {0.7987244897959184, 
                0.5397533643441705}}], 
               
               Line[{{0.8012755102040817, 0.54104597611289}, {
                0.8195060898552016, 0.5490772083116247}, {0.8219826724910432, 
                0.5501682328752114}, {0.8269358377627265, 
                0.5523502820023852}, {0.8368421683060933, 
                0.5567143802567327}, {0.8566548293928267, 
                0.5654425767654278}, {0.8962801515662935, 
                0.5828989697828179}, {0.9, 0.5845376980672123}, {
                0.9739717509693491, 0.6171249399185884}, {0.9987244897959183, 
                0.6280294200215347}}], 
               
               Line[{{1.0012755102040816`, 0.629058845373427}, {1.1, 
                0.6652446456555803}, {1.1369227129030104`, 
                0.6787780446910738}, {1.1987244897959184`, 
                0.7014304459377343}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAA9P5cq2w48z89KAnSIXnmP83MzMzM
zPQ/gJHA4JJv5z8OHafv5OT0P1IVzfhBfuc/QFaD3ePp9D8nKTxmTYHnP3KP
X8vi7vQ//Tyr01iE5z/WARin4Pj0P6lkia5viuc/nuaIXtwM9T8AtEVknZbn
Py6was3TNPU/rVK+z/iu5z9NQy6rwoT1PwiQr6av3+c/fnwKmcGJ9T/dox4U
u+LnP7C15obAjvU/s7eNgcbl5z8UKJ9ivpj1P1/fa1zd6+c/3AwQGrqs9T+2
LigSC/jnP2zW8Yix1PU/Y82gfWYQ6D+MabVmoCT2P78KklQdQeg/6kCtiAsq
9j/nsH2zakToP0cYpap2L/Y/DldpErhH6D8Cx5TuTDr2P12jQNBSTug/eSR0
dvlP9j/8O+9LiFvoP6WaPO4sYfY/wfp37wNm6D8JD63+
                "]], 
               
               Line[{{1.4012755102040815`, 0.7631526578940822}, {
                1.426273963186148, 0.7692466565315353}, {1.4686058933621644`, 
                0.7795661241001272}, {1.5, 0.7872192234024029}, {
                1.547629076117258, 0.7988300028842349}, {1.5987244897959185`, 
                0.8112857889107236}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAW2XDEdOe+T9m+70FqPrpPzMzMzMz
M/s/RvMyh8mZ6j/7atSbKXr7P1EDamu2teo/VDZdkS5/+z99MnkUsLfqP6wB
5oYzhPs/qGGIvam56j9emPdxPY77P/6/pg+dveo/wcUaSFGi+z+rfOOzg8Xq
P4cgYfR4yvs/BfZc/FDV6j8T1u1MyBr8P7roT43r9Oo/bKF2Qs0f/D/lF182
5fbqP8Rs/zfSJPw/EEdu39746j92AxEj3C78P2eljDHS/Oo/2TA0+e9C/D8U
YsnVuATrP5+LeqUXa/w/bttCHoYU6z/4VgObHHD8P5kKUsd/Fus/UCKMkCF1
/D/EOWFweRjrPwK5nXsrf/w/G5h/wmwc6z9l5sBRP5P8P8hUvGZTJOs/K0EH
/ma7/D8izjWvIDTrP7CqqyfYwPw/YvXi7EQ26z80FFBRScb8P6IckCppOOs/
DAGjVJPH/D8y66cI6zjrP6BRthM=
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAjpj2RAbS/D/UU/iNnDzrP8BQPc6c
1vw/7cQCrww+6z9FuuH3Ddz8P0Jc8FXBP+s/To0qS/Dm/D/sisujKkPrP3LZ
TZh5Ev0/lEU4289Q6z+5cZQyjGn9P+O6EUoabOs/R6IhZ7EX/j+CpcQnr6Lr
PzSYDibGHP4/pUl210ak6z8gjvvk2iH+P8jtJ4fepes/+nnVYgQs/j8ONovm
DanrP61RiV5XQP4/mcZRpWyv6z9mZmZmZmb+PzAyBltau+s/31/AREm6/j/c
KfkdpdXrP8xVrQNev/4//82qzTzX6z+4S5rCcsT+PyFyXH3U2Os/kjd0QJzO
/j9nur/cA9zrP0UPKDzv4v4/8kqGm2Li6z+rvo8zlQv/PwlsExkg7+s/dx1f
IuFc/z82ri0UmwjsP2JQMFbcYf8/oR5awioK7D9OgwGK12b/Pw6PhnC6C+w/
Jumj8c1w/z/mb9/M2Q7sP9S06MC6hP8/ljGRhRgV7D8wTHJflKz/P/e09PaV
Iew/HH9Dk4+x/z9jJSGlJSPsPweyFMeKtv8/z5VNU7Uk7D/eF7cugcD/P6d2
pq/UJ+w/jOP7/W3U/z9XOFhoEy7sP3gWzTFp2f8/w6iEFqMv7D9jSZ5lZN7/
Py8ZscQyMew/Oq9AzVro/z8H+gkhUjTsPybiEQFW7f8/c2o2z+E17D8RFeM0
UfL/P9/aYn1xN+w//Ee0aEz3/z9LS48rATnsPz801ofG+v8/jRAUKBg67D9D
3SCv
                "]], 
               
               Line[{{2.001275510204082, 0.8824169707931928}, {
                2.0039562426140143`, 0.8826807029561062}, {2.008820753763886, 
                0.8831592766631717}, {2.0185497760636295`, 
                0.8841164240773028}, {2.0380078206631165`, 
                0.8860307189055652}, {2.0393271393937447`, 
                0.886160514323083}, {2.0406464581243724`, 
                0.8862903097406007}, {2.0432850955856283`, 
                0.8865499005756364}, {2.0485623705081406`, 
                0.8870690822457077}, {2.0591169203531647`, 
                0.8881074455858502}, {2.080226020043213, 
                0.8901841722661353}, {2.0999999999999996`, 
                0.8921295490161936}, {2.122444219423309, 
                0.8943376256267055}, {2.1987244897959184`, 
                0.9018421272391944}}], 
               
               Line[{{2.201275510204082, 0.9020964297263394}, {
                2.2866398821120604`, 0.9107175921339012}, {2.3, 
                0.9120668640083573}, {2.3704807786936803`, 
                0.9191848949403334}, {2.398724489795918, 
                0.9220372982903766}}], 
               
               Line[{{2.4012755102040817`, 0.9222705014445269}, {2.5, 
                0.930349991293749}, {2.5334854370252864`, 
                0.933090397945653}, {2.53472237080263, 0.9331916270724772}, {
                2.5359593045799738`, 0.9332928561993014}, {
                2.5384331721346607`, 0.9334953144529498}, {
                2.5433809072440345`, 0.9339002309602467}, {2.553276377462783, 
                0.9347100639748404}, {2.5730673179002794`, 
                0.9363297300040277}, {2.5987244897959183`, 
                0.9384294811429709}}], 
               
               Line[{{2.601275510204082, 0.9386171541575014}, {
                2.6150743461754633`, 0.9395181751376979}, {
                2.6174994935756546`, 0.939676529704139}, {2.6223497883760363`,
                 0.9399932388370213}, {2.6320503779767996`, 
                0.9406266571027859}, {2.6514515571783264`, 
                0.9418934936343152}, {2.6902539155813803`, 
                0.9444271666973737}, {2.6999999999999997`, 
                0.9450635556329445}, {2.774462852749733, 
                0.9499257478288612}, {2.798724489795918, 
                0.9515099571083875}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAR0x7IgNpBkCRIaKuHXTuPzMzMzMz
MwdAqE/LQYSn7j/1yo3icIEHQHd4FUFou+4/3AvVaPyDB0CUQu7iDbzuP8JM
HO+HhgdAsQzHhLO87j+Qzqr7nosHQOygeMj+ve4/KtLHFM2VB0BgydtPlcDu
P17ZAUcpqgdASRqiXsLF7j9EGknNtKwHQGbkegBoxu4/K1uQU0CvB0CDrlOi
DcfuP/jcHmBXtAdAvUIF5ljI7j+S4Dt5hb4HQDFraG3vyu4/xud1q+HSB0Aa
vC58HNDuP6wovTFt1QdAN4YHHsLQ7j+TaQS4+NcHQFRQ4L9n0e4/YOuSxA/d
B0CO5JEDs9LuP/rur9095wdAAw31iknV7j/gL/djyekHQCDXzSzv1e4/x3A+
6lTsB0A9oabOlNbuP5TyzPZr8QdAdzVYEuDX7j97MxR99/MHQJT/MLSF2O4/
YnRbA4P2B0CyyQlWK9nuPy/26Q+a+wdA7F27mXba7j8fGutDY/0HQL999NTq
2u4/Q+nCYA==
                "]], 
               
               Line[{{3.001275510204082, 0.9643432377304046}, {
                3.0040658660648987`, 0.9644282651160294}, {3.00530855047641, 
                0.9644661320448148}, {3.0077939192994325`, 
                0.9645418659023857}, {3.0090366037109435`, 
                0.964579732831171}, {3.010279288122455, 0.9646175997599564}, {
                3.0127646569454773`, 0.9646933336175272}, {3.017735394591522, 
                0.9648448013326687}, {3.0189537189257853`, 
                0.9648819259641324}, {3.0201720432600485`, 
                0.9649190505955961}, {3.022608691928575, 
                0.9649932998585236}, {3.0274819892656275`, 
                0.9651417983843783}, {3.0372285839397324`, 
                0.9654387954360879}, {3.0567217732879426`, 
                0.9660327895395072}, {3.0957081519843626`, 
                0.9672207777463457}, {3.0999999999999996`, 
                0.9673515584189449}, {3.1802851297394477`, 
                0.9697979971625289}, {3.1987244897959184`, 
                0.9703598791074849}}], 
               
               Line[{{3.201275510204082, 0.9704331715273606}, {3.3, 
                0.9730976841372104}, {3.3447619504179835`, 
                0.974305781353785}, {3.398724489795918, 0.9757621967470602}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBGIQLSLp8f68KbcD98bSGBar9/b/wYDbIeD9y4aegPf2
gl5FOk18PA6Lj9lnagW9t19wkJ/bSpDHwepT2ddyIN/Acu3Lj8I8Dpdk1zUe
BfL9NF4sS5TkcWAolZmVEPzevostTtFRhcchVvnnqWkh7+1ZDnuKMVjxOIg3
bNJhDn9v/81akaEulceh21L1w+3o9/atm/fdM83gcVBKjanRjHlvL6Ids/dt
Fo/DzgmTOcqBfGOp6VWxBTwOL54zKgrFvrcv+MHz1aaax8F12r1Aj7j39i+3
/Hj5ewKPw/9P0zdvSXhvX6Ez7cTmyTwO0+TO2zMlvrfnWGK8PHsaj4OuF9sZ
fyBfbXJeyu3ZPA4xC0uevALykwqf3Nu1DGiff6CoYvJ7+zu6Fy5X7uFxKF7D
Vd6b+t5+/mvBWub9PA4SPv/uXAXyk1YGq/Ue5HHY+/qjk1wa0Lz0qefFjvA4
JHU/XZEG5L9UuV6x4BiPA7v2Tb71QP6aRxJKWid5HNacOlPyHch/82y7gMEp
Hoe5unFLRdLf2wMA2Wu1xw==
                "]], 
               
               Line[{{3.601275510204082, 0.9813886115128622}, {
                3.6044205455572738`, 0.9814378981543017}, {
                3.6068988062055514`, 0.9814767356013407}, {3.611855327502106, 
                0.9815544104954187}, {3.6130944578262447`, 
                0.9815738292189382}, {3.6143335881503837`, 
                0.9815932479424577}, {3.616811848798661, 
                0.9816320853894966}, {3.621768370095216, 
                0.9817097602835747}, {3.6316814126883257`, 
                0.9818651100717307}, {3.6713335830607647`, 
                0.9824865092243547}, {3.6999999999999997`, 
                0.9829357478669685}, {3.749078878861765, 
                0.9837048753434718}, {3.798724489795918, 
                0.9844828842210748}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7e5TrcScyefwUk9fSr/xvb0xGPA7yKxxfb2v+739
2heys/l8+B3WZl4L5u59b98xtzXhnh+/w+TFhm8NgPyUoLeq6wL5Haru9rSF
Afkye/Zs8A3nd/AIdN65EMjv6o8+1pPE7/DYYoOcRd97+wyzmR+5KvkdpDi6
Xqb0v7dXahHxYF/G79C+zLZ+38T39v8sanivr+B3yHswQ+IJkH/z7eNLy1bz
O4RKfdnIOem9/YTwzbFuG/kdlPpWPQkB8v9rBRW37uF32Fcq7vUayL9zsX8e
82V+hy8uH0Ukpry339H2PfnyVX6H23U+62yB/CnW8ZqLb/A7HNqx3D0ZyPde
qrfF6R6/wwSduKp1QP6uirMnG1/yO2iLnL7vMvW9/TRd0/7AN/wOQn5qlVlA
fuGjOSGK7/kdfrY3Ck0A8jV8cu4f+MLvcOy3uettIJ+F8cqSCd+B4WU6+R7D
tPf2D7ZaZyX84neYkv+uXA3I35O1WN/gL79D9UpPQR8gf7o899f///kdkh4v
WVUI5AMA1Ui92w==
                "]]}, "Charting`Private`Tag$73107#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAASmXo0cDpdT5O94/eTFxJPgRDGnDf
GVQ/QZxmxHBDJz8zn5icsxlkPyHfzAs+Qzc/S83Xsp0ZdD+RAICvJENHP1dk
972SGYQ/SZFZARhDVz/dL4dDjRmUP6VZRqoRQ2c/oBVPhooZpD/Tvbx+DkN3
P3vNl8RWuqQ/41ZW2Sb9dz9WheACI1ulP/Pv7zM/t3g/DPVxf7ucpj8TIiPp
byt6P3jUlHjsH6k/U4aJU9ETfT9Rk9pqTiauP2onKxRKcoE/gQizJ4kZtD/q
7/foDEOHPypHkYiycLQ/Sgggtuynhz/ShW/p28e0P6ggSIPMDIg/JAMsqy52
tT9nUZgdjNaIP8b9pC7U0rY/47I4Ugtqij9vPIOP/Sm3P0PLYB/rzoo/GHth
8CaBtz+i44jsyjOLP2n4HbJ5L7g/YBTZhor9iz8SN/wSo4a4P8AsAVRqYow/
unXac8zduD8eRSkhSseMP2O0uNT1NLk/fl1R7iksjT+F3fwWAka5PzF5hMrk
P40/GEqwlg==
                "]], 
               
               Line[{{0.10127551020408164`, 0.01576845325230755}, {
                0.10245430267554087`, 0.016971641067258906`}, {
                0.1051142646610319, 0.019686651492473776`}, {
                0.11043418863201396`, 0.02511667234290353}, {
                0.12107403657397808`, 0.035976714043763035`}, {
                0.1224040175667236, 0.037334219256370475`}, {
                0.12373399855946912`, 0.03869172446897792}, {
                0.12639396054496016`, 0.041406734894192804`}, {
                0.1317138845159422, 0.04683675574462254}, {
                0.14235373245790633`, 0.05769679744548204}, {
                0.16363342834183459`, 0.07941688084720105}, {
                0.16487527374712793`, 0.08068442648893105}, {
                0.16611711915242128`, 0.08195197213066105}, {
                0.16860080996300794`, 0.08448706341412102}, {
                0.1735681915841813, 0.08955724598104098}, {
                0.18350295482652804`, 0.09969761111488093}, {
                0.1987244897959184, 0.11523415876296271`}}], 
               
               Line[{{0.20127551020408163`, 0.11785847551799501`}, {
                0.24311153428060836`, 0.16123277413862552`}, {
                0.29872448979591837`, 0.21889057009181012`}}], 
               
               Line[{{0.3012755102040816, 0.2214943843721937}, {
                0.3223512715467095, 0.24266754224101822`}, {
                0.32367194781791486`, 0.24399432169772442`}, {
                0.32631330036032546`, 0.2466478806111367}, {
                0.3315960054451468, 0.25195499843796143`}, {
                0.3421614156147893, 0.2625692340916107}, {
                0.36329223595407434`, 0.2837977053989093}, {
                0.36461291222527964`, 0.2851244848556155}, {
                0.36593358849648494`, 0.2864512643123216}, {
                0.3685749410388956, 0.28910482322573394`}, {
                0.37385764612371686`, 0.29441194105255863`}, {
                0.3844230562933594, 0.3050261767062079}, {0.3987244897959184, 
                0.319393700819689}}], 
               
               Line[{{0.40127551020408164`, 0.32169510359900444`}, {
                0.40801895800015076`, 0.32708769396033754`}, {
                0.41048403936765704`, 0.32905896658293654`}, {
                0.4154142021026696, 0.3330015118281344}, {
                0.42527452757269474`, 0.34088660231853024`}, {
                0.444995178512745, 0.35665678329932193`}, {
                0.48443648039284554`, 0.3881971452609052}, {
                0.4987244897959184, 0.3996229594912106}}], 
               
               Line[{{0.5012755102040817, 0.4016347648161133}, {
                0.5987244897959183, 0.4774088357464746}}], 
               
               Line[{{0.6012755102040817, 0.4792130535155594}, {
                0.6987244897959183, 0.5412812201432713}}], 
               
               Line[{{0.7012755102040816, 0.5427932776486122}, {
                0.7987244897959184, 0.5962463044289446}}], 
               
               Line[{{0.8012755102040817, 0.5975456487598053}, {
                0.8962801515662935, 0.6422132920765776}, {0.8987244897959182, 
                0.643362528857233}}], 
               
               Line[{{0.9012755102040816, 0.6445183558655528}, {
                0.9987244897959183, 0.6870066592037658}}], 
               
               Line[{{1.0012755102040816`, 0.6880189688895448}, {
                1.0987244897959185`, 0.7228711255448532}}], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe8T8pg4fbVinnP7Znj8JK
NvI/RYL61LmY5z+A1z6mvzvyP5NakBS9nOc/FredbalG8j8wC7yTw6TnP0J2
W/x8XPI/aWwTktC05z+a9NYZJIjyP9suwo7q1Oc/ZWSG/ZiN8j8qB1jO7djn
PzDUNeENk/I/eN/tDfHc5z/Gs5So953yPxWQGY335Oc/8XJSN8uz8j9N8XCL
BPXnP0jxzVRy3/I/v7MfiB4V6D8TYX045+TyPw2MtcchGeg/3tAsHFzq8j9b
ZEsHJR3oP3Swi+NF9fI/+BR3hisl6D+fb0lyGQvzPzB2zoQ4Neg/at/4VY4Q
8z9/TmTEOznoPzRPqDkDFvM/zCb6Az896D/KLgcB7SDzP2nXJYNFReg/lZ62
5GEm8z+3r7vCSEnoP2AOZsjWK/M/BohRAkxN6D9yZwm7+S3zPxpxnDneTug/
8T+sOg==
                "]], 
               
               Line[{{1.2012755102040815`, 0.7604193576164642}, {
                1.2021994123405053`, 0.7606532568915082}, {1.203531589880046, 
                0.7609905170281008}, {1.2061959449591275`, 
                0.761665037301286}, {1.2115246551172902`, 
                0.7630140778476563}, {1.222182075433616, 
                0.7657121589403969}, {1.2234898928959086`, 
                0.7660432519688255}, {1.224797710358201, 0.766374344997254}, {
                1.2274133452827862`, 0.767036531054111}, {1.2326446151319568`,
                 0.768360903167825}, {1.2431071548302977`, 
                0.7710096473952531}, {1.2640322342269796`, 
                0.7763071358501092}, {1.2987244897959185`, 
                0.7850899853612331}}], 
               
               Line[{{1.3012755102040816`, 0.7857563157873154}, {
                1.3083217567700243`, 0.7876534366228315}, {
                1.3107611205197052`, 0.7883102072526431}, {1.315639848019067, 
                0.7896237485122664}, {1.3253973030177906`, 
                0.7922508310315127}, {1.3449122130152376`, 
                0.7975049960700057}, {1.3461318948900778`, 
                0.7978333813849113}, {1.3473515767649182`, 
                0.7981617666998172}, {1.3497909405145991`, 
                0.7988185373296288}, {1.354669668013961, 
                0.8001320785892521}, {1.3644271230126845`, 
                0.8027591611084985}, {1.3839420330101317`, 
                0.8080133261469914}, {1.3852649058281323`, 
                0.8083694944363466}, {1.3865877786461327`, 
                0.8087256627257018}, {1.3892335242821336`, 
                0.8094379993044121}, {1.3945250155541358`, 
                0.8108626724618327}, {1.3987244897959183`, 
                0.8119933325952442}}], 
               
               Line[{{1.4012755102040815`, 0.8126007184067116}, {
                1.4064308709161404`, 0.8136676305090665}, {1.407753743734141, 
                0.8139414016568545}, {1.410399489370142, 
                0.8144889439524303}, {1.415690980642144, 0.815584028543582}, {
                1.426273963186148, 0.8177741977258854}, {1.4686058933621644`, 
                0.8265348744550992}, {1.4987244897959184`, 
                0.8327679775948956}}], 
               
               Line[{{1.5012755102040816`, 0.8332702882237885}, {
                1.5987244897959185`, 0.8514795610830226}}], 
               
               Line[{{1.6012755102040817`, 0.8519639320465978}, {
                1.6345700473310565`, 0.8583860248016503}, {
                1.6358836154275167`, 0.8586393953808349}, {
                1.6385107516204371`, 0.8591461365392041}, {
                1.6437650240062784`, 0.8601596188559426}, {1.654273568777961, 
                0.8621865834894197}, {1.675290658321326, 
                0.8662405127563737}, {1.6766042264177865`, 
                0.8664938833355584}, {1.6779177945142467`, 
                0.866747253914743}, {1.6805449307071672`, 
                0.8672539950731123}, {1.6857992030930085`, 
                0.8682674773898508}, {1.6871127711894687`, 
                0.8685208479690354}, {1.6884263392859291`, 
                0.86877421854822}, {1.6910534754788498`, 
                0.8692809597065893}, {1.696307747864691, 
                0.8702944420233278}, {1.6976213159611513`, 
                0.8705478126025125}, {1.6987244897959184`, 
                0.8707606008045169}}], 
               
               Line[{{1.7012755102040815`, 0.8711885899628083}, {
                1.7028755883469926`, 0.8714168510601495}, {1.704189156443453, 
                0.8716042397176715}, {1.7068162926363737`, 
                0.8719790170327154}, {1.717324837408056, 
                0.8734781262928911}, {1.7185502699170643`, 
                0.8736529418607826}, {1.7197757024260723`, 
                0.873827757428674}, {1.7222265674440886`, 
                0.8741773885644569}, {1.7271282974801212`, 
                0.8748766508360227}, {1.7369317575521863`, 
                0.8762751753791544}, {1.7565386776963166`, 
                0.8790722244654178}, {1.795752517984577, 
                0.8846663226379443}, {1.7970811414367454`, 
                0.8848558590355814}, {1.7984097648889135`, 
                0.8850453954332184}, {1.7987244897959185`, 
                0.8850902928983527}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAjpj2RAbS/D+jY3aTY1XsP06NKkvw
5vw/xdEF91ha7D9y2U2YeRL9P8rHSmmrZOw/uXGUMoxp/T/Us9RNUHnsPz7b
OFz9bv0/lVIdnJp67D/CRN2FbnT9P1XxZerke+w/yhcm2VB//T/WLveGeX7s
P9y9t38Vlf0/2akZwKKD7D8ACtvMnsD9P96fXjL1jew/R6IhZ7EX/j/ni+gW
mqLsPzSYDibGHP4/Ca7ue86j7D8gjvvk2iH+PyrQ9OACpew/+nnVYgQs/j9u
FAGra6fsP61RiV5XQP4/9JwZPz2s7D+aR3YdbEX+Pxa/H6Rxrew/hj1j3IBK
/j834SUJpq7sP2ApPVqqVP4/eiUy0w6x7D9NHyoZv1n+P5xHODhDsuw/OhUX
2NNe/j++aT6dd7PsP6WaPO4sYf4/GPlOIAa07D/dWaXD
                "]], 
               
               Line[{{1.9012755102040815`, 0.8972369840039691}, {
                1.905594176217663, 0.8976101056406659}, {1.910556127676527, 
                0.8980388054854141}, {1.9204800305942553`, 
                0.8988962051749104}, {1.9601756422651684`, 
                0.9023258039328956}, {1.9987244897959184`, 
                0.9056563252184537}}], 
               
               Line[{{2.001275510204082, 0.9059100433422312}, {
                2.0393271393937447`, 0.9101915206068909}, {
                2.0406464581243724`, 0.9103399671588603}, {
                2.0432850955856283`, 0.9106368602627991}, {
                2.0485623705081406`, 0.9112306464706768}, {
                2.0591169203531647`, 0.9124182188864319}, {2.080226020043213, 
                0.9147933637179423}, {2.098724489795918, 
                0.9168747667843506}}], 
               
               Line[{{2.201275510204082, 0.925564740664198}, {
                2.2866398821120604`, 0.9327684851290063}, {2.298724489795918, 
                0.9337882832457877}}], 
               
               Line[{{2.3012755102040816`, 0.9339933079922745}, {
                2.398724489795918, 0.9414336560422841}}], 
               
               Line[{{2.4012755102040817`, 0.9416258667421157}, {
                2.450006067043157, 0.9452485924866321}, {2.4513311364079526`, 
                0.9453471007576737}, {2.453981275137544, 
                0.9455441172997571}, {2.459281552596727, 
                0.9459381503839238}, {2.4698821075150925`, 
                0.9467262165522572}, {2.4712071768798882`, 
                0.9468247248232988}, {2.472532246244684, 
                0.9469232330943405}, {2.4751823849742753`, 
                0.9471202496364238}, {2.480482662433458, 
                0.9475142827205906}, {2.491083217351824, 0.948302348888924}, {
                2.4924082867166195`, 0.9484008571599656}, {2.493733356081415, 
                0.9484993654310073}, {2.4963834948110066`, 
                0.9486963819730906}, {2.4977085641758023`, 
                0.9487948902441323}, {2.498724489795918, 
                0.9488704161592303}}], 
               
               Line[{{2.501275510204082, 0.9490344359564199}, {
                2.503008841634985, 0.9491284684029427}, {2.504333910999781, 
                0.949200352816946}, {2.5069840497293723`, 
                0.9493441216449529}, {2.512284327188555, 
                0.9496316593009664}, {2.5334854370252864`, 
                0.9507818099250205}, {2.53472237080263, 0.9508489130232489}, {
                2.5359593045799738`, 0.9509160161214774}, {
                2.5384331721346607`, 0.9510502223179341}, {
                2.5433809072440345`, 0.9513186347108478}, {2.553276377462783, 
                0.9518554594966749}, {2.5730673179002794`, 
                0.9529291090683294}, {2.5987244897959183`, 
                0.9543209990445847}}], 
               
               Line[{{2.601275510204082, 0.9544645163671255}, {
                2.6902539155813803`, 0.9596491130236288}, {2.691569680224636, 
                0.9597257800412184}, {2.6928854448678914`, 
                0.9598024470588082}, {2.695516974154402, 
                0.9599557810939876}, {2.698724489795919, 
                0.9601426767210802}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAfH+uVTacBUCt9SlcyrruPy6KZ7be
2wVABDlMfKzL7j+Wb1iNkN4FQEL63nFjzO4//1RJZELhBUCAu3FnGs3uP9Af
KxKm5gVA+z2XUojO7j9xte5tbfEFQPJC4ihk0e4/tOB1JfwGBkDhTHjVG9fu
Pzo3hJQZMgZAvWCkLovi7j/WYhk2nTQGQA4z1eI14+4/c46u1yA3BkBgBQaX
4OPuP6zl2BooPAZAA6pn/zXl7j8elC2hNkYGQEjzKtDg5+4/ur/CQrpIBkCZ
xVuEi+juP1frV+Q9SwZA65eMODbp7j+QQoInRVAGQI087qCL6u4/AvHWrVNa
BkDShbFxNu3uP54cbE/XXAZAJFjiJeHt7j87SAHxWl8GQHUqE9qL7u4/2HOW
kt5hBkDH/EOONu/uP4WAUarJYwZAUnCnzbjv7j/YjZyj
                "]], 
               Line[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAR0x7IgNpBkDKDe7H5fDuP+ZNgLpw
bgZA3wnYpebx7j+CeRVc9HAGQKt1jZ9d8u4/H6Wq/XdzBkB34UKZ1PLuP1j8
1EB/eAZAD7mtjMLz7j/LqinHjYIGQEBog3Oe9e4/aNa+aBGFBkAM1DhtFfbu
PwQCVAqVhwZA2D/uZoz27j8+WX5NnIwGQHAXWVp69+4/sAfT06qWBkChxi5B
VvnuP5RkfODHqgZAASXaDg797j9cHs/5AdMGQMLhMKp9BO8/DhlytbvVBkCo
Hhak/gTvP8ETFXF12AZAjlv7nX8F7z8mCVvo6N0GQFrVxZGBBu8/7/Pm1s/o
BkDxyFp5hQjvP4LJ/rOd/gZAILCESI0M7z80xKFvVwEHQAbtaUIODe8/575E
KxEEB0DsKU88jw3vP0y0iqKECQdAuKMZMJEO7z8VnxaRaxQHQE+XrheVEO8/
qHQubjkqB0B+ftjmnBTvP1pv0SnzLAdAZLu94B0V7z8NanTlrC8HQEr4otqe
Fe8/Uk0ed5YwB0DQkYMHyhXvP7/BulE=
                "]], 
               
               Line[{{2.9012755102040817`, 0.9715123240375113}, {
                2.9022714522827915`, 0.9715463425533604}, {
                2.9036022722817547`, 0.9715917995354427}, {
                2.9062639122796816`, 0.9716827134996073}, {
                2.9169104722713888`, 0.972046369356266}, {2.9382035922548035`,
                 0.9727736810695834}, {2.939446276666315, 
                0.9728161275935852}, {2.940688961077826, 0.972858574117587}, {
                2.943174329900849, 0.9729434671655905}, {2.9481450675468936`, 
                0.9731132532615977}, {2.9580865428389833`, 
                0.973452825453612}, {2.9779694934231626`, 
                0.9741319698376407}, {2.998724489795918, 
                0.9748409007967261}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCCEA0AkwojDLvP2TD0PVP
KQhAN0D75OY27z8wgkN3TS4IQE7g5KJ2N+8/yP8oekg4CEB7ILgeljjvP/f6
838+TAhA16BeFtU67z9W8YmLKnQIQI+hqwVTP+8/vFBDTKl2CECacaDkmj/v
PyKw/AwoeQhApkGVw+I/7z/ubm+OJX4IQL3hfoFyQO8/hexUkSCICEDqIVL9
kUHvP7TnH5cWnAhARqL49NBD7z8aR9lXlZ4IQFJy7dMYRO8/gKaSGBShCEBd
QuKyYETvP0xlBZoRpghAdOLLcPBE7z/k4uqcDLAIQKIin+wPRu8/SkKkXYuy
CECt8pPLV0bvP7ChXR4KtQhAucKIqp9G7z98YNCfB7oIQNBicmgvR+8/E961
ogLECED+okXkTkjvP44MfX23xghAfVaa2ZxI7z8KO0RYbMkIQPwJ787qSO8/
6+a3EDDKCEDfwZDUAEnvPzTCppA=
                "]], 
               
               Line[{{3.1012755102040814`, 0.9777179105518036}, {
                3.1023157283714786`, 0.9777346309563428}, {3.103637243648902, 
                0.9777558729137859}, {3.1062802742037485`, 
                0.9777983568286719}, {3.107601789481172, 
                0.9778195987861148}, {3.108923304758595, 
                0.9778408407435578}, {3.1115663353134413`, 
                0.9778833246584439}, {3.116852396423134, 
                0.9779682924882159}, {3.137996640861905, 0.978308163807304}, {
                3.1802851297394477`, 0.9789879064454804}, {
                3.1815185094294183`, 0.9790077317167678}, {
                3.1827518891193893`, 0.9790275569880552}, {
                3.1852186484993315`, 0.9790672075306301}, {
                3.1901521672592157`, 0.97914650861578}, {3.1987244897959184`, 
                0.9792842996149635}}], 
               
               Line[{{3.201275510204082, 0.979327867373592}, {
                3.2592214298975932`, 0.980375714022661}, {3.2605580005307244`,
                 0.9803998834735314}, {3.2618945711638556`, 
                0.9804240529244017}, {3.2645677124301176`, 
                0.9804723918261424}, {3.269913994962642, 
                0.9805690696296239}, {3.2806065600276906`, 
                0.9807624252365867}, {3.2819431306608218`, 
                0.9807865946874571}, {3.283279701293953, 
                0.9808107641383275}, {3.285952842560215, 
                0.9808591030400682}, {3.2912991250927393`, 
                0.9809557808435496}, {3.2926356957258704`, 
                0.98097995029442}, {3.2939722663590016`, 
                0.9810041197452903}, {3.296645407625264, 
                0.9810524586470312}, {3.298724489795918, 0.981090055069647}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7e5TrcScyeVgwFV5rT31vX1dKkOceS6XQ0uA4aL3
QL7LykrZL/lcDivYYsyN097bXzDImZNbyuXwoWhj4i4g/4V94KyEBi6HRu+Y
bSfS39uLxUlPc5vG5bDwz8b4p5nv7Ytmre8VOsTl8CgudpNc3nv77X9mtR86
wuXAaWDCkwjk/4lrayw6zuVgyMidthjIb1eOLb10hsuhYfEOSY389/Zz1nDF
TrrO5SD3QrjRsOC9/dF9qTpCb7kcogpP+bsUvbfnUgxUO/Sey6HJaeHKNiA/
oNlGoegTl8NK4Qrmk0D+LXdhkUvfuRx+bFXd7lv83v7dhQO/JzJxO0z/1SAX
XvLeXuKx9GlBCW6Hy83mbzPL3tvHurIfPSjF7fArhM99DZC/aPmnfYWy3A5K
ak8XvAPydXJObrqoxO1QeGJSSHH5e/vCc1vWNKpyO8ycmbluK5C/zWDBMkMN
bocDWQ4cP4B8x69lsybqcjvw877bXVPx3r4tPGmKowG3g/m9I6L7gfwgX7ny
aUB+aGq/63EgHwDtULNC
                "]], 
               
               Line[{{3.4012755102040817`, 0.9835447138469614}, {
                3.402499214876836, 0.9835643836026015}, {3.403811425432719, 
                0.9835854759965075}, {3.405123635988602, 
                0.9836065683904136}, {3.4077480571003678`, 
                0.9836487531782258}, {3.4090602676562507`, 
                0.9836698455721319}, {3.4103724782121336`, 
                0.983690937966038}, {3.4129968993239, 0.9837331227538502}, {
                3.418245741547432, 0.9838174923294746}, {3.428743425994496, 
                0.9839862314807234}, {3.4299675009629267`, 
                0.9840059071884739}, {3.431191575931358, 
                0.9840255828962244}, {3.433639725868219, 
                0.9840649343117255}, {3.438536025741943, 
                0.9841436371427277}, {3.4483286254893892`, 
                0.9843010428047321}, {3.4679138249842825`, 
                0.9846158541287408}, {3.4987244897959178`, 
                0.9851111029101213}}], 
               
               Line[{{3.5012755102040813`, 0.9851546706687498}, {
                3.5920292423158866`, 0.9867957869818024}, {3.593268372640025, 
                0.9868181944017688}, {3.5945075029641638`, 
                0.986840601821735}, {3.5969857636124414`, 
                0.9868854166616677}, {3.5987244897959183`, 
                0.9869168583648048}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQB2IQvW7Tw47M8zwOmi2/0o2nvrcX5HqTLvKUx+HR16QF
R6a9t3d7xv5nHS+vg9WEFXVbZr6351ziudRCgNfh/suemsdA/pnEbr9DQrwO
rc6FVUKz3tsH3+VbeFWc1+HCN8uyAiA/4Yqo2x9FXoe02NO5OrPf21cfUp7g
acbrMEnrXcySOe/tN8yzV3kSx+vw6oix9ZT57+0/V31mT0zkdbhkNNPnEJBv
Fr789d1kXoddC/7FfgDyd/Pzb76ewevQVXOywWfBe/tjDfccTxfxOmibxB9j
WfjeniN2kqpHKa+D8KIj142AfG9LN86j5bwOv/m1XiYA+Rc+rr2wr4bX4fTr
L9x7gfzbSbXxm9p4HXIWdwWWLnpvL2dv6KzfyesQIvghaTGQnyD9VG1NN6+D
TX1oyUUg/9lln3dLJ/A68EQrTNdd/N5eYwPDJaXJvA5fTrSuiAbys3u2bJ0/
ldfhjtnrnZ1A/o7NLXf/TON1aPHw/r0IyAcAFu2zLA==
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQB2IQXVW/LtRsDq/DKanvN18sfm//e+tr7t4lvA5TnoRV
6S55b8+mvntWwzpeh7buhIR6IN+TOb/u7wZeB+evj25OBvJ77islVW3mdfgf
lxq8AsgXnNGlWbKD16HCKMvtIpAvwxm1I/0Qr0PWzWId5aXv7Y1e/7jqd43X
wU+9/ccxID92vZmg7D9eB7HDayfwLX9vvy3qB98FBj6H1SoFx1WAfD62XTzN
zHwO9m1G/6yA/AMxthwvOfgcMjy3Z6cD+UpcLv+3CPM57Dp/wO0AkP8sJfCt
jyafQ+ydy38KV7y3txMQfv1fm8/hk+004w4gf/ruKy826fE5tM2PyJoH5HsI
RTyRMOFzWJ909/opIH/V/rjbT+z4HBhfPtukvPK9fZ5UzsmaED6HpV9/ZlwF
8o8d1T2uH87nYBm+Z/5rIF++8P2RR5F8Dud21F1jXPXe/sLxogMe8XwO36uZ
XfSA/NaGwFUnk/kcrj0ODgkG8gFVnLN6
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7e5TrcScyeewPTFjc/Oq9/ZdCtZbj+fwORzN8yhb
BeQ/Pv1nU1U+n8P+jN1Wx4D8KUoN6x6U8Dlsill4+C+Q//1829I19XwOM11y
r+asfm/f0Lqw8c4qPgejJ3NkNNe+t+ctZ/dKXMvnoF6ymdUZyJ+VkSv0bD2f
gzTLqXcxQP5mb8vF77fwObCqfD8wAch/JnjxCNN+PocbyYGpP4B873kMHJqX
+RzqHrOuO77uvb3Y9vi+0t98Dqcf5dmnbXhvv3jF0bBff/kcDhS1ajQA+Qaz
tOXrGfgdtjDNEZwF5HvWfl/fwcrvME/p5OOzQH6Nc//F2fz8DoVJyh2mG9/b
c5p+nakgxO+Q9smy0B/In6YWnbRUhN8huikgKhPIX8+p/nmdJL+Dy6JanblA
/qPz+0QOKfM7iD+6foFl03v7/IMqd93U+B14it7tlAPy/2zqWnpag9+BkYl1
sQWQ37HkQ26ANr/Dt4nSPUFAvui0MLOruvwOrxWNSnOA/EXte/5FGvA73N/o
EdcG5Af5ypVPA/LZYmPOdAD5AByIw3s=
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBmIQLSLp8f68Kb/DOdbu05s3vbe/4huikGvF75CTEOR2
AchPtN/14qMNv8OZbTqX7gP5VUptlb8d+R26kx++/Afkr30hO5vPh9+Ba6+X
pO3m9/Ydc1sT7vnxOzD1MJT4AfkpQW9V1wXyO/yK2nYuHsiX2bNng284v8Or
H4otTUB+V3/0sZ4kfofTJj/fHQfyM8xmfuSq5HfoXbP8SNCW9/ZKLSIe7Mv4
HfjnsBRkbH1v/8+ihvf6Cn4HjuxdpyqB/JtvH19atprfgcGqQLUbyJ8QvjnW
bSO/w4frt2+tBfL/awUVt+7hd7govNn1M5B/52L/PObL/A6TuhOl67a9t9/R
9j358lWgf6LEy/qB/CnW8ZqLb/A7NGuevbAAyPdeqrfF6R6/Q/Fxi7bDQP6u
irMnG1/yO4QwC3zk2P7efpquaX/gG34Hn0tHvaWA/MJHc0IU3/M7uCysXqYN
5Gv45Nw/8IXfwcT+ebQfkM/CeGXJhO/8Drp8c7fFA/kPtlpnJfzid1C9GyRY
COTvyVqsb/CX30F2DUdOE5A/XZ776////A6i1fuOTQbyATBI09U=
                "]], 
               
               Line[{{2.1012755102040814`, 0.9171259220987972}, {
                2.1249065857096605`, 0.9191201056857659}, {
                2.1273689519960124`, 0.9193279003090867}, {2.132293684568716, 
                0.9197434895557284}, {2.142143149714123, 
                0.9205746680490117}, {2.161842080004936, 
                0.9222370250355781}, {2.1987244897959184`, 
                0.9253494646803868}}]}, 
              "Charting`Private`Tag$73107#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Cav2.1 cluster intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {576., -189.}, {Center, Center}, {360., 360.}]}, {}},
  AspectRatio->0.6,
  ContentSelectable->True,
  ImageSize->1000,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.8508742146951265`*^9, 3.8508743038884163`*^9, 3.8508911808651085`*^9, 
   3.850891264590987*^9, 3.8509830931059465`*^9, 3.852255306774928*^9, 
   3.8522554865767984`*^9, 3.852255724728649*^9, 3.8522557675898933`*^9, 
   3.855045268472585*^9, {3.855045364108375*^9, 3.855045388586759*^9}, 
   3.855045920499544*^9, 3.8550460743314505`*^9, 3.8550462124263415`*^9, 
   3.8550463199491296`*^9, {3.8550463849728317`*^9, 3.855046414162945*^9}, 
   3.855281676100159*^9, 3.855287539289589*^9, 3.855287947160612*^9, 
   3.8552890319197254`*^9, 3.8553512953155193`*^9, 3.8580525009328737`*^9},
 CellLabel->
  "Out[339]=",ExpressionUUID->"69ef1cdb-3242-41ad-b5ed-18d5338b8e81"],

Cell[BoxData[
 TemplateBox[{TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "n", "Munc13-1 cluster number / AZ", 
            "Cav2.1 cluster number / AZ"}, {
            TypeSystem`Atom[Integer], TypeSystem`AnyType, 
            TypeSystem`AnyType}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[
          Association[{All, 
             TypeSystem`PackageScope`KeyDummy[12]} -> 1, {All, "n"} -> 
           1, {All, "Munc13-1 cluster number / AZ"} -> 
           1, {All, "Cav2.1 cluster number / AZ"} -> 1], 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             TypeSystem`PackageScope`RowShape[
              Association[
              "n" -> TypeSystem`PackageScope`AtomShape[34], 
               "Munc13-1 cluster number / AZ" -> 
               TypeSystem`PackageScope`UnknownShape, 
               "Cav2.1 cluster number / AZ" -> 
               TypeSystem`PackageScope`UnknownShape]]]], 2, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[1743688104], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "n", "Munc13-1 cluster number / AZ", 
            "Cav2.1 cluster number / AZ"}, {
            TypeSystem`Atom[Integer], TypeSystem`AnyType, 
            TypeSystem`AnyType}], 2], "HandleQ" -> True, "RowTarget" -> 20, 
        "Data" -> TypeSystem`PackageScope`CacheHandle[1743688104]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 485331164][{
                    All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"n\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"n\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 485331164][{
                    All, "n"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[All, "n"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 cluster number / AZ\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 cluster number / AZ\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 485331164][{
                    All, "Munc13-1 cluster number / AZ"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[
                  All, "Munc13-1 cluster number / AZ"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 cluster number / AZ\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 cluster number / AZ\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 485331164][{
                    All, "Cav2.1 cluster number / AZ"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[All, "Cav2.1 cluster number / AZ"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["WT", 
                    Style[
                    "WT", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 485331164][{
                    Key["WT"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                   GeneralUtilities`Slice[
                    Key["WT"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2297"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["n"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   InterpretationBox[
                    TemplateBox[{"3.8", "2.3"}, "Around"], 
                    Around[3.7892903787548975`, 2.321316210135508]], 
                   FontFamily -> "Source Code Pro", FontSize -> 13, 
                   ShowStringCharacters -> True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 cluster number / AZ"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   InterpretationBox[
                    TemplateBox[{"2.5", "1.6"}, "Around"], 
                    Around[2.5302568567696997`, 1.6251704746353617`]], 
                   FontFamily -> "Source Code Pro", FontSize -> 13, 
                   ShowStringCharacters -> True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 cluster number / AZ"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["KO", 
                    Style[
                    "KO", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 485331164][{
                    Key["KO"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                   GeneralUtilities`Slice[
                    Key["KO"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2195"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["n"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   InterpretationBox[
                    TemplateBox[{"3.4", "2.1"}, "Around"], 
                    Around[3.4236902050113893`, 2.079764040388144]], 
                   FontFamily -> "Source Code Pro", FontSize -> 13, 
                   ShowStringCharacters -> True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 cluster number / AZ"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   InterpretationBox[
                    TemplateBox[{"2.3", "1.5"}, "Around"], 
                    Around[2.29749430523918, 1.5271377142562903`]], 
                   FontFamily -> "Source Code Pro", FontSize -> 13, 
                   ShowStringCharacters -> True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 cluster number / AZ"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 485331164][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 485331164]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[485331164][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {460., {43., 49.}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 CellChangeTimes->{
  3.8508742146951265`*^9, 3.8508743038884163`*^9, 3.8508911808651085`*^9, 
   3.850891264590987*^9, 3.8509830931059465`*^9, 3.852255306774928*^9, 
   3.8522554865767984`*^9, 3.852255724728649*^9, 3.8522557675898933`*^9, 
   3.855045268472585*^9, {3.855045364108375*^9, 3.855045388586759*^9}, 
   3.855045920499544*^9, 3.8550460743314505`*^9, 3.8550462124263415`*^9, 
   3.8550463199491296`*^9, {3.8550463849728317`*^9, 3.855046414162945*^9}, 
   3.855281676100159*^9, 3.855287539289589*^9, 3.855287947160612*^9, 
   3.8552890319197254`*^9, 3.8553512953155193`*^9, 3.8580525010735025`*^9},
 CellLabel->
  "Out[340]=",ExpressionUUID->"15cbf250-bfaa-4569-a11a-4c1c768bdf86"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQPbcuic0wpduOAQqOXFbwCVfItIfx/x/b16ygUAnn
zz3QK8+q0Ann59iW5n6XnwnnX/6dMeWD/Eo4n/32I/W38jvh/IWn5he+lj8J
569b33k7R+8WnJ9uf3Hmm6LHcH7eU83HW9a9hPMfxN3kOHgSwQ++0aF39gmC
b3H6eeVTqVdwPvPGpQJi7Qj+jBpFu/L413D+QWHJmZYCb+F8k94T+1y1Efxl
bBVPAt0Q/J6f1/SzahD8sPtTjs16geC/WiXw5feBd3B+jMoBSY47CP75ufn2
It8R/C0TznXp6L6H8+vLehRjZyL4n95bu2duQfBTMl/nlJ5H8C1Z9Zc/eIrg
AwB1yHkP
                "]], LineBox[CompressedData["
1:eJwBAQP+/CFib1JlAgAAAC8AAAACAAAAY31orA8N8D86cen0ktU0P5in1AHT
HfA//yzkUGTJRz8KIYQn3zjwPwxhmRbqrVY/yDyRL35F8D9RdoZvY7ZbP4ZY
njcdUvA/y8U5ZG5fYD8CkLhHW2vwPxDbJr3nZ2U/+v7sZ9ed8D+aBQFv2nhv
P+vcVajPAvE/ca1a6V/NeT/MmCcpwMzxP0+Bh6ai94Y/jhDLKqFg8z8+6x0F
xIyVP2LbVL8DzPY/vBtHFxSvpT9xxYRibyf6P3GVtedrMrA/HuRGBvYz+j9P
Q63kZkawP8sCCap8QPo/LfGk4WFasD8lQI3xiVn6P+hMlNtXgrA/2bqVgKSL
+j9gBHPPQ9KwP0Gwpp7Z7/o/T3MwtxtysT8Rm8jaQ7j7Py5Rq4bLsbI/vrmK
fsrE+z8M/6KDxsWyP2vYTCJR0fs/6qyagMHZsj/FFdFpXur7P6UIinq3AbM/
eZDZ+Hgc/D8dwGhuo1GzP+GF6haugPw/DC8mVnvxsz+xcAxTGEn9P+sMoSUr
MbU/zJoTea1W/T/Bdl6h1Ua1P+bEGp9CZP0/leAbHYBctT8aGSnrbH/9Pz60
lhTVh7U/hMFFg8G1/T+UW4wDf961P1YSf7NqIv4/O6p34dKLtj9wPIbZ/y/+
PxAUNV19obY/imaN/5Q9/j/lffLYJ7e2P7+6m0u/WP4/j1Ft0Hzitj8oY7jj
E4/+P+P4Yr8mObc/+rPxE737/j+LR06deua3PxTe+DlSCf8/X7ELGSX8tz8u
CABg5xb/PzQbyZTPEbg/Y1wOrBEy/z/e7kOMJD24P8wEK0RmaP8/MpY5e86T
uD/mLjJq+3X/PwcA9/Z4qbg/AFk5kJCD/z/babRyI7+4PzWtR9y6nv8/hj0v
anjquD9Q104CUKz/P1yn7OUiALk/agFWKOW5/z8xEaphzRW5P55VZHQP1f8/
2uQkWSJBuT+4f2uapOL/P65O4tTMVrk/06lywDnw/z+EuJ9Qd2y5P52Cl1Pw
8v8/Ydt1P8twuT+caHvK
                "]], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAsj401ocGAECi3fngB7i5PxEURJl8
DABA4zIN1P/luT8eqUcsRxMAQEH9V/VpGro/ONNOUtwgAED9ke03PoO6P0Vo
UuWmJwBAW1w4Wai3uj9S/VV4cS4AQLkmg3oS7Lo/bCddngY8AEB0uxi95lS7
P6F7a+owVwBA9ORDQo8mvD8wwAn4h10AQBqPQc99V7w/wASoBd9jAEBHOT9c
bIi8P+CN5CCNcABAo406dknqvD8eoF1X6YkAQEo2MaoDrr0/msRPxKG8AECY
hx4SeDW/P5INNJ4SIgFAG5X8cDAiwT+Cn/xR9OwBQLg310AZMcQ/ANPgQLx6
A0AGngA7HTDKPyZ0ZnhUKgVAYTrnq85Y0D/k9ZdWC70GQHAifHXVYdM/TsHL
KXj5B0CUg5YZXsTVP6VXgqA=
                "]], 
               LineBox[{{3.0031887755102042`, 0.34153326654998095`}, {
                3.264705982550857, 0.3951573869314121}, {3.459855082525327, 
                0.43517272262491474`}, {3.6715147334054086`, 
                0.4785735478597943}, {3.869072690293142, 
                0.5190828198206661}, {3.9968112244897958`, 
                0.5452756145993443}}], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAWR8a60MDEEA8XHHQZHzhP9jCZAFa
LBFAk7C4qQX14j+1iMReIPURQBppBHSN8+M/ZgV14M7OEkCqy0o0hAflP2Ny
e7UMmhNAjEACiCwJ5j82Mt61KZ0TQMhEIuweDeY/CvJAtkagE0AFSUJQERHm
P7BxBreAphNAflGCGPYY5j/8cJG49LITQG5iAqm/KOY/lm+nu9zLE0BShALK
UkjmP2kvCrz5zhNAj4giLkVM5j8872y8FtITQMuMQpI3UOY/424yvVDYE0BE
lYJaHFjmPzBuvb7E5BNANqYC6+Vn5j8DLiC/4ecTQHOqIk/Ya+Y/1u2Cv/7q
E0CvrkKzym/mP3xtSMA48RNAJ7eCe6935j9PLavAVfQTQGS7ot+he+Y/Iu0N
wXL3E0Cgv8JDlH/mP/ascMGP+hNA3cPip4aD5j+n4OUUvPwTQPoNzu5HhuY/
GOGgMQ==
                "]], LineBox[CompressedData["
1:eJwBoQJe/SFib1JlAgAAACkAAAACAAAAWR8a60MDFEBdyoayXY3mPxZsXsMg
ChRAG3LTc46T5j9ia+nElBYUQFD0VS7KnuY//Gn/x3wvFEC8+FqjQbXmPy9n
K85MYRRAkwFljTDi5j/eaR9vrWQUQFS6wXw85eY/jGwTEA5oFEAUcx5sSOjm
P+lx+1HPbhRAlOTXSmDu5j+jfMvVUXwUQJXHSgiQ+uY/F5Jr3VaXFECWjTCD
7xLnP/+8q+xgzRRAmRn8eK5D5z/PEiwLdTkVQJ8xk2Qspec/u66CmywDFkBl
wpapIVvoP3sBKlDM3RZA2F+gHVcg6T/mRAvYJuEWQLcc1IxdI+k/UIjsX4Hk
FkCV2Qf8YybpPyQPr2826xZAUFNv2nAs6T/MHDSPoPgWQMdGPpeKOOk/Hjg+
znQTF0C4LdwQvlDpP8JuUkwdSRdAmPsXBCWB6T8ssjPUd0wXQHW4S3MrhOk/
lvUUXNJPF0BTdX/iMYfpP2t812uHVhdAEO/mwD6N6T8UilyL8WMXQIjitX1Y
mek/ZqVmysV+F0B4yVP3i7HpPwrcekhutBdAWJeP6vLh6T82d6kNj7cXQLmp
ej/F5Ok/YRLY0q+6F0AavGWUl+fpP7hINV3xwBdA3OA7Pjzt6T9mte9xdM0X
QF8q6JGF+Ok/klAeN5XQF0DBPNPmV/vpP73rTPy10xdAIU++Oyr+6T8UIqqG
99kXQONzlOXOA+o/wY5km3rmF0BmvUA5GA/qP+wpk2Cb6RdAx88rjuoR6j8Y
xcElvOwXQCjiFuO8FOo/bvsesP3yF0DpBu2MYRrqP5qWTXUe9hdASxnY4TMd
6j/FMXw6P/kXQKsrwzYGIOo/8Myq/1/8F0AMPq6L2CLqP6fg5RS8/BdAmpfS
mysj6j+HYDkh
                "]], LineBox[CompressedData["
1:eJwBsQJO/SFib1JlAgAAACoAAAACAAAAWR8a60MDGEAdn/Ua+yfqP8rUk9kD
DBhAoUxLgvos6j94QU7uhhgYQJatSgsgNOo/pNx8s6cbGEDUhYpt6TXqP893
q3jIHhhAEV7Kz7I36j8mrggDCiUYQIwOSpRFO+o/0xrDF40xGECBb0kda0Lq
Py70N0GTShhAazFIL7ZQ6j/lpiGUn3wYQEG1RVNMbeo/7ITh+QOAGEDNSBxW
PG/qP/JioV9ogxhAWdzyWCxx6j8AHyErMYoYQHEDoF4Mdeo/GpcgwsKXGECg
UfppzHzqP1CHH/DlshhAAO6ugEyM6j+8Zx1MLOkYQL8mGK5Mq+o/lCgZBLlV
GUA9mOoITenqP5CaZsdhIBpA8OVRRw5d6z9alF3ODOcaQKkWde2Hzus/HLMK
G2vqGkC6XqR0dNDrP9/Rt2fJ7RpAzKbT+2DS6z9kDxIBhvQaQO42Mgo61us/
borGM/8BG0A0V+8m7N3rP4KAL5nxHBtAwJdpYFDt6z+pbAFk1lIbQNcYXtMY
DOw/bIuusDRWG0DpYI1aBQ7sPy6qW/2SWRtA+qi84fEP7D+y57WWT2AbQB05
G/DKE+w/vGJqychtG0BiWdgMfRvsP9BY0y67iBtA7plSRuEq7D/4RKX5n74b
QAYbR7mpSew/fLufg8TBG0DCbJlCdUvsPwAymg3pxBtAf77ry0BN7D8HH48h
MssbQPhhkN7XUOw/Fvl4ScTXG0DpqNkDBljsP5pvc9Po2htApvorjdFZ7D8d
5m1dDd4bQGFMfhadW+w/JNNicVbkG0Da7yIpNF/sPzOtTJno8BtAyzZsTmJm
7D+2I0cjDfQbQIeIvtctaOw/OppBrTH3G0BE2hBh+WnsP74QPDdW+htAACxj
6sRr7D+m4OUUvPwbQC/CGYsjbew/duoztQ==
                "]], LineBox[CompressedData["
1:eJwVzX0sFGAcwHFzLUtvCFt63KPULQljLEv2+430JpI5mUne0zQv6RTOJDXp
YiNyXXFcCq1SJr2cXpyiuyNKG9P7iljPEzu90KW3P777/PldHpcWmmhqYmLi
/K//RlC7z/4CgtHZh0KE6QxCYh3GF5gTFFWPrU07wODFoF2m+0KCFoWPuwoy
GUQE28yKLQj+TFbFVBxksMfH3FJpS7DPM6riThaDVJuv3u6OBA/39BkFuQwM
si8asYhgfMuVSlspA4np+PYcJ4JB8mI3pzwG0onXMZ1uBJcn+McH5zOQabtP
iDcQ1BnbdPJCBo1554ayxQTtnWvOupxi8GHE77CmiGBH8f51u6oZ+CmfqtbI
CPqEh44eqWFQGxHZW15K8OYK78rLSgbR+owV8ZUEm9SCqdk6BsPXa3sEFwiW
ccW1+ksMnuf+dgi4TzBup3aVoZmBxvKutvsrQdOlIusSDQOVr/uy3lh79G98
O6n5xODqcYnlXhchvuwonUAXDkXi+EDBNyE+W5TtEZfBQbXjVVTitBArakp6
ig9waN8qTu02CjHCVZV0I5ODwXdzmcyU4tsgvcIki0OUyHlwiQVFfspeoMzh
4PHDELfSmaL5fM3Ay0IOb+RHcwJiKfqbzZeIz3CYKTfKGhIomlXRxXlVHKxL
DlbPS6aoE3k21cs5bC1IetibSjF00+7XUwoOrfu2zQ2XUow53hxQruRwcr1V
eVIVRakgzLavkYPXq7qmol6KbX/O39qi5mDhmjzd3E8xMb9LEdXOgeW7bh4a
oGjzZyIv/R6Hekf1x9XDFCW//TbKH/z7p7ygulGKXrNj/Z86OUy2K1IN4xRH
pFatxkccehbF3rPjFCt/+VQt7uJwrIVHpkxR/GYs3b3uCYeYOa1Np79TvJh7
GwO1HDaE50yrZyiGGd877tFxaHg3Yt3+i+JggT44Uc/hL3v3S8M=
                "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAArA+N9aEBIEAy+3GnJc3tP7IgkOhW
BiBABNBorPvO7T9qxByGpwwgQAQ97EVy0e0/2Qs2wUgZIEADF/N4X9btP8Y0
mejcGiBAQ/JTH/3W7T+0XfwPcRwgQIPNtMWa1+0/kK/CXpkfIEADhHYS1tjt
P0hTT/zpJSBAA/H5q0zb7T+4mmg3izIgQAPLAN854O0/mCmbrc1LIEACfw5F
FOrtP3/AjZhLuSBAYxodA8oU7j9NG1WlyiQhQEMccnq4Pu4/QW7HWxGJIUAv
0sT01WXuP/rY6UbEiiFANHxFm39m7j+0Qwwyd4whQDomxkEpZ+4/JhlRCN2P
IUBEeseOfGjuPwzE2rSoliFAWSLKKCNr7j/YGe4NQKQhQINyz1xwcO4/cMUU
wG6/IUDXEtrECnvuPyowN6shwSFA3bxaa7R77j/jmlmW1MIhQOJm2xFefO4/
VnCebDrGIUDsutxesX3uPzwbKBkGzSFAAWPf+FeA7j8IcTtyndohQCyz5Cyl
he4/nxxiJMz1IUB/U++UP5DuPzozKy5i9yFAVfR7992Q7j/USfQ3+PghQCuV
CFp8ke4/CHeGSyT8IUDW1iEfuZLuP6KNT1W6/SFAq3eugVeT7j9U8HIKXv4h
QHfbWF2Xk+4/l6XgdA==
                "]], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAArA+N9aEBIkCgELvDsZTuP6T+PIao
BSJAY5BlFdiV7j/YK8+Z1AgiQMAyIQHAlu4/QIbzwCwPIkB6d5jYj5juP+Lv
hF2NKCJAY4p1Ns+f7j8kw6eWTlsiQDWwL/JNru4/kC3CKtK+IkCb9JKDucru
P2bzBNHJKiNA6u1hHo/p7j9isfIgiY8jQOeBYdtUBu8/bIJT/EqRI0Ce5+BU
1QbvP3VTtNcMkyNAVU1gzlUH7z+I9XWOkJYjQMMYX8FWCO8/rjn5+5edI0Cg
r1ynWArvP/nB/9amqyNAWd1Xc1wO7z+Q0gyNxMcjQMs4TgtkFu8/mqNtaIbJ
I0CCns2E5BbvP6N0zkNIyyNAOQRN/mQX7z+2FpD6y84jQKjPS/FlGO8/3FoT
aNPVI0CEZknXZxrvPyfjGUPi4yNAPZREo2se7z8wtHoepOUjQPT5wxzsHu8/
OoXb+WXnI0CrX0OWbB/vP0wnnbDp6iNAGStCiW0g7z9yayAe8fEjQPbBP29v
Iu8/fDyB+bLzI0CtJ7/o7yLvP4UN4tR09SNAZI0+YnAj7z+Yr6OL+PgjQNNY
PVVxJO8/ooAEZ7r6I0CKvrzO8STvP6tRZUJ8/CNAQSQ8SHIl7z+0IsYdPv4j
QPiJu8HyJe8/vvMm+f//I0Cv7zo7cybvPwAv9WY=
                "]]},
              Annotation[#, "Charting`Private`Tag$73410#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQPbcuic0wpduOAQqOXFbwCVfItIfx/x/b16ygUAnn
zz3QK8+q0Ann59iW5n6XnwnnX/6dMeWD/Eo4n/32I/W38jvh/IWn5he+lj8J
569b33k7R+8WnJ9uf3Hmm6LHcH7eU83HW9a9hPMfxN3kOHgSwQ++0aF39gmC
b3H6eeVTqVdwPvPGpQJi7Qj+jBpFu/L413D+QWHJmZYCb+F8k94T+1y1Efxl
bBVPAt0Q/J6f1/SzahD8sPtTjs16geC/WiXw5feBd3B+jMoBSY47CP75ufn2
It8R/C0TznXp6L6H8+vLehRjZyL4n95bu2duQfBTMl/nlJ5H8C1Z9Zc/eIrg
AwB1yHkP
                "]], LineBox[CompressedData["
1:eJwVxXkwVAEAB+C1umyHtKikRGO0Ct3RqB9SShcr6yjaiNitcUS1HVTERLKm
FR3oMOVYpmbZdte+lGjeZGcMFemSDjW63lajenu86o9vPue4FH4Cm8Vief3z
//ijSXLriRTIsENOK6XeKL/x2OLRTAptsoK0iPEbwXHOdRvwplAVO7bNiYgG
6VvilbWGAvWF1+AoECIvsnL5TD4F6fwQSe2meLClqqBtYgrdtZds7vsmgzZ/
3t1XQYHX4+B8uCgdn16E13Sx9SB1itBGcRZ05W68uzo9fr5Oj+LYFuLM5E73
K8If4Ij5Md5J5xH3fGurpW4EfQFtzXJpLdI6cuNS3GgUXQ0uLp+mwKx3a8eM
LKYRMyKyd1ugQCfbqu6IHw3P4MKK5iAFXP2K9KeiaHTpO+t79ivQryk9Vl1I
Y4r/JnLCEwX8b16v7P9Go2xgi8XxkibYXCSfrVYZcNkxfF8yR4k76oKsh+0G
pKVm0r+clRA/3egS2m2Af3vp8TwfJTrsupNjhw14K+4tvpakhETa//ugoxGu
LRHylw+UGDw5bN94zIi6qOj3oTm3cSt1Qti09SY0ndsRscKogu4CV9IgMKF+
eP75Djs1htodqgJ2mXBlFf0sxEsNh+m8T3uyTTg9JIvdHadG7r01OfeaTUhc
9jBBRqohmJKtELmYMbV3ScZXmQapvnn9jJcZE93ZSkmjBgWJRYxspRmWWV2/
RpEatGoubmiNNINyFR2eYdBgbrzqLbfYDDKz6sS6nS2gFXouYTBDYscpueqh
he2r3z58KwYpyX09HkFaeI5jCT/YM0ggqm3VQi3it0+S2yxiwE9AeddZLXSj
5gUmJjFwb86oMv7RYshzkciQyWC2VcBgPpcAK8pHKs1hYB9jPYfrQWBpQ9AL
TSUDy9F113lCAiF9m9khcgZ05IGPTRICIgvB3PdqBpQ80N3vLIHK8F0Z1k8Y
PN860CB4QECVLb5Q/YZBd4382+AAgUe16Xd9KAakUbJw7x8CFSfKwqjvDGYJ
e1PyzQT+Ag2jevE=
                "]], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAsj401ocGAEDDxRKbgFC+PxEURJl8
DABAP4wyntyEvj8eqUcsRxMAQM6m9zqQwL4/ONNOUtwgAEDr24F09ze/P0Vo
UuWmJwBAefZGEatzvz9S/VV4cS4AQAgRDK5er78/bCddngY8AEASI8vzYhPA
P6F7a+owVwBANFhVLcqKwD8wwAn4h10AQP76gTeopsA/wASoBd9jAEDNna5B
hsLAP+CN5CCNcABAauMHVkL6wD8eoF1X6YkAQJ1uun66acE/msRPxKG8AEAB
hR/QqkjCP5INNJ4SIgFAy7HpcosGxD+Cn/xR9OwBQF4LfrhMgsc/ANPgQLx6
A0Boy8BMuVbOPyZ0ZnhUKgVA23ejC+Pf0j/k9ZdWC70GQJs6KerwVNY/TsHL
KXj5B0ByGCsCWwzZP7JrhwI=
                "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAsj401ocGCEDbrvkJayfZP07kkCse
HgpADP+t2sw53T/qw2KAyK0LQHSzsJ/SIeA/LhHWHUNfDUCre/ltpsfhP+aN
5oKVZQ1ApZq2Us3N4T+dCvfn52sNQJ+5czf00+E/DAQYsox4DUCT9+0AQuDh
P+r2WUbWkQ1AfHPik9344T+l3N1uacQNQExry7kUKuI/HKjlv48pDkDuWp0F
g4ziP9Qk9iTiLw5A6Xla6qmS4j+LoQaKNDYOQOOYF8/QmOI/+ponVNlCDkDX
1pGYHqXiP9iNaegiXA5AwFKGK7q94j+Tc+0Qto4OQJBKb1Hx7uI/Cj/1Ydzz
DkAyOkGdX1HjP3hBKAi2+g5AfRVuIApY4z/mQ1uujwEPQMjwmqO0XuM/wkjB
+kIPD0Bfp/SpCWzjP3pSjZOpKg9AjBSotrOG4z/rZSXFdmEPQObuDtAHvOM/
WmhYa1BoD0AyyjtTssLjP8hqixEqbw9AfqVo1lzJ4z+kb/Fd3XwPQBRcwtyx
1uM/XHm99kOYD0BByXXpW/HjP8yMVSgRzw9AmqPcArAm5D86j4jO6tUPQOZ+
CYZaLeQ/qJG7dMTcD0AxWjYJBTTkP4SWIcF36g9AyBCQD1pB5D/ymFRnUfEP
QBLsvJIESOQ/YJuHDSv4D0Bex+kVr07kP07Byyl4+Q9AkvkDPvNP5D85afgV

                "]], LineBox[CompressedData["
1:eJwVj31MzHEcxy+RzrCv+55Yhh5QTU9r1oPi80FLhil2ppCViiSlMCUupWVY
MpMr1cJU6jZdXEqdck5Uduiks65k/c7vK26kTnrQnD9ee//x+uf9coxJ3hk3
QyAQeFn4vxHL7b9tsiYY4ll7whzBgSScCPbZEIzUKhoS93NwpctN90pIUB5y
RIvRHEy835d+hxAM8+sdHzrMwYeP6heSZQRli1VhcJqDeXsNMrUjwaGCk/Hi
TA6CDeZEr5UEg4SemV+lHNT1u4qE7gQHxssqr+dxkD+YH9UcQNCtN2uaL+Rg
sylyzElC8ElpsLxAyUGZOEcn3UOQ6sTGXY0cjAbWPDDsJZhoa1y6SMVB+aXJ
Q4UxBJek5V4t1Vj+uZTohSkEz4a2pVbrOJDH9DX+vEQQRjYHaIY5IPoDmU9b
CapDt7aNeRhBr461inRfgB0j4QNRFUZQXtREOZgXYEZVkX5m3heIn3VyQKsV
YU7s2uIbGTzYL2/vmXwnQtPb8CDnczxo/Ze+ce0W4Z51Cf2153nwPfpCld0r
Qk87mdPrizzY6Bbe8mUi1L80V8+4ycO98npJmRVFj9WKpuSHPHCBfzqS1lDs
GXbp2/KdB5lkm7rYj+LGKJD2/OBhW3J548u1FOUdux3jRnh4dCe0ynEDxey7
uXFZEzxcEBbldm+n6C4ZNNXbMljRE4DrDll8Q9m080oGB1PPKOcWW7x0ocP0
fga+Pv1Kt1KKpVXBxvRoBnN+YX1IOcX5XWnV5lgGtcdtHmdVUPy5omuNKZHB
VMq1htE6inUd+VsM6QwKkyubDJ0UA+xs057cYJDgNad5XEuxGvz8fYsYBP04
2mzXRdE+If6vooTB4DEfVZie4lSTJu/+XQbex1RPNRzF1ujzJTIFA2tPh5bP
PEXvy7XRYiWDD6bslukhircffVpV0MAgMym01X/Y0jN7vSKvhcEOj5pWySjF
X95Jp6yfM3AyzXuWOkbxYGRJoLSNwW95yrOrExS7czoFk+0MKgeM4uYpihF/
+zISXjP4B9cecHA=
                "]], LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAWR8a60MDFEAfJdxHO9LoPxZsXsMg
ChRAmIIdpMjW6D9ia+nElBYUQMA62VML3+g//Gn/x3wvFEASq1CzkO/oPy9n
K85MYRRAtYs/cpsQ6T/eaR9vrWQUQD+bDfrYEuk/jGwTEA5oFEDKqtuBFhXp
P+lx+1HPbhRA38l3kZEZ6T+jfMvVUXwUQAgIsLCHIuk/F5Jr3VaXFEBchCDv
czTpP/+8q+xgzRRABH0BbExY6T/PEiwLdTkVQFRuw2X9n+k/u66CmywDFkC9
qNk/yyXqP3sBKlDM3RZAOkO4EdC26j/mRAvYJuEWQA9PBo4Jueo/UIjsX4Hk
FkDjWlQKQ7vqPyQPr2826xZAi3LwAra/6j/MHDSPoPgWQNuhKPSbyOo/Hjg+
znQTF0B9AJnWZ9rqP8JuUkwdSRdAwL15m//96j8ssjPUd0wXQJTJxxc5AOs/
lvUUXNJPF0Bo1RWUcgLrP2t812uHVhdAEO2xjOUG6z8UilyL8WMXQGEc6n3L
D+s/ZqVmysV+F0ACe1pglyHrPwrcekhutBdARTg7JS9F6z82d6kNj7cXQHmN
I1FCR+s/YRLY0q+6F0Cs4gt9VUnrP7hINV3xwBdAE43c1HtN6z9mte9xdM0X
QODhfYTIVes/wY5km3rmF0B6i8DjYWbrP+wpk2Cb6RdAruCoD3Vo6z8YxcEl
vOwXQOE1kTuIaus/bvsesP3yF0BH4GGTrm7rP5qWTXUe9hdAezVKv8Fw6z/F
MXw6P/kXQK6KMuvUcus/8Myq/1/8F0Dh3xoX6HTrP6fg5RS8/BdAcPLVKyV1
6z+g4x16
                "]], LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAWR8a60MDGEDAPU6Iz3jrP8rUk9kD
DBhAUiqJKtR86z94QU7uhhgYQBygRxqTgus/pNx8s6cbGECOPTfWAoTrP893
q3jIHhhAANsmknKF6z8mrggDCiUYQOUVBgpSiOs/0xrDF40xGECui8T5EI7r
Py70N0GTShhAQHdB2Y6Z6z/lpiGUn3wYQGVOO5iKsOs/lCgZBLlVGUCQKPwr
PRTsP5CaZsdhIBpAqrVJJE5x7D9alF3ODOcaQOnjkueJzOw/HLMKG2vqGkCY
bv/kFc7sP9/Rt2fJ7RpASPlr4qHP7D9kDxIBhvQaQKcORd250uw/borGM/8B
G0BkOffS6djsP4KAL5nxHBtA345bvknl7D+pbAFk1lIbQNU5JJUJ/uw/bIuu
sDRWG0CFxJCSlf/sPy6qW/2SWRtANE/9jyEB7T+y57WWT2AbQJJk1oo5BO0/
vGJqychtG0BQj4iAaQrtP9BY0y67iBtAy+Tsa8kW7T/4RKX5n74bQMGPtUKJ
L+0/fLufg8TBG0A9TbS5+jDtPwAymg3pxBtAuAqzMGwy7T8HH48hMssbQK6F
sB5PNe0/Fvl4ScTXG0Cae6v6FDvtP5pvc9Po2htAFjmqcYY87T8d5m1dDd4b
QJD2qOj3Pe0/JNNicVbkG0CGcabW2kDtPzOtTJno8BtAc2ehsqBG7T+2I0cj
DfQbQO4koCkSSO0/OppBrTH3G0Bp4p6gg0ntP74QPDdW+htA5J+dF/VK7T+m
4OUUvPwbQKkawP4OTO0/klQP3g==
                "]], LineBox[CompressedData["
1:eJwVjX0s1GEcwOWsxnoh1OLpHnUlUnKa9Xb2/XbVhELsp+smjtxV6ExYOHqx
SnPLhvVq5qUW1lTr5Z9IxW236s6aFB1dtpBbnifzXteb/vjss89fn1UpmbFq
RwcHh4A5/ltBvb7tEhH83jOQmx/FICbZx7bQhWDZ3xVMFcOgu8crW7qIoJO4
64n8AANFlOdvwZVggaz09JpYBkk7XNxqlhHU5P9cMhLHQOs5uVUqIRg6YQnO
PMhgXM/bBV+Cj9wq7TEKBrmOtn0F/gT9gyINwYcYFH7/pOrYRNDzRIswrWSg
f2W8JMgIjg5X5RUlMmgsqurNFwhWWRLa9GoGX4bkee0lBH++tIY3ZjOQ13TW
r9cT3F/su6g6h0GtQmmuKCNYJ9e+Lc9lkPgma/WRKwT3dvyO151iYHlQaxLd
InjVQFKjdAy6dH989rQR3GxUnp4sZtDu9vSVcZJghunDQ6xgUB8q9TYnr0Tr
h07vjw8YNF/IdTu6UYxZ9y6e/WVjUCIciRRNiXHsvMZv3moO9dH9CepZMa67
cyVkcq5bwwWt0S7GJKNB/lXCYTw0rFzvSLHTWXLYvJZDgm9Aj7srxeayz+U3
/DkEz4ynrAmgmHZdYZdKOVivFxfsSaY4dDeiMwU5/Kiw6xtSKa405/cJOzl4
XM6pdj5GUeCNI3vlHMLPaV6YtRQNQQtEm3ZzeHw8Yn58IcX6Jx1b7GEcSrcv
rdBco6h6LqurjOYQ0l/XVGKmaOkKzDEkcnANPDZ7/y1F4t4U2ZDEYfRMYFjv
O4pJcRJJqYrDbUnLoJ+F4uC75V3RKXP/9G76epgi63YI6lNzGGu9qR23UQzy
1C1o03AwLU5+5sUonhSmrLVHOZx/yJTpExRn3tsua45zUDk9bqqcprhtWao6
PI2DLL5gtuUHxcJ4q2xDOoeGgSGP1l8Ui9p1JlEGh39thkVL
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAArA+N9aEBIEC89V3EiW3uP7IgkOhW
BiBAyFg1tklv7j9qxByGpwwgQIVF6rGice4/2Qs2wUgZIEAAH1SpVHbuP8Y0
mejcGiBALlpB6Op27j+0XfwPcRwgQF6VLieBd+4/kK/CXpkfIEC8CwmlrXju
P0hTT/zpJSBAevi9oAZ77j+4mmg3izIgQPTRJ5i4f+4/mCmbrc1LIEDphPuG
HInuP3/AjZhLuSBAkgPNwtCx7j9NG1WlyiQhQMqY0xPH2e4/QW7HWxGJIUBu
dmhEDv/uP/rY6UbEiiFAsNQs86//7j+0Qwwyd4whQPIy8aFRAO8/JhlRCN2P
IUB273n/lAHvPwzE2rSoliFAfWiLuhsE7z/YGe4NQKQhQI1arjApCe8/cMUU
wG6/IUCsPvQcRBPvPyowN6shwSFA7py4y+UT7z/jmlmW1MIhQDD7fHqHFO8/
VnCebDrGIUCztwXYyhXvPzwbKBkGzSFAuzAXk1EY7z8IcTtyndohQMsiOglf
He8/wttdXVDcIUANgf63AB7vP3tGgEgD3iFATt/CZqIe7z/uG8UeaeEhQNKb
S8TlH+8/1MZOyzToIUDaFF1/bCLvP58cYiTM9SFA6QaA9Xkn7z86MysuYvch
QE2ewucQKO8/1En0N/j4IUCxNQXapyjvP25gvUGO+iFAFM1HzD4p7z8Id4ZL
JPwhQHhkir7VKe8/oo1PVbr9IUDb+8ywbCrvP1Twcgpe/iFAZJ6wjKkq7z+7
vQY5
                "]], LineBox[CompressedData["
1:eJwV0H0sFGAcB3AVpmgqb5MxPY95ufM20vKS5+dl1m7SSjMyK7aLIUZHpbO8
3N2onbyMJFQcKYpkGZldKMlIKCYpZAntiXPLobue/vjuu89f3+17KCb5NH+n
lpaWPcv/bjKUKh/sQJBgT/ULuJTI1D6SBh0EgnWvMH9HSia57++M6yHQFMXH
jjCDRCF3NERgMjSQv+JEyVRl17uefQim7kYXuztTInguHg8/gOB+vKoig7nh
m9miyAQBV8+hSc+Fkv3ePoZfLBD4BeQN27hSMkdFUVJ7BIkdQUZRbpQIdUNi
MQeBW96MhYzZ1NIspYOL4E9Yus0yM4/3SLTgjCBnvc7jqjslrbKhxmMeCMpd
dMJLD1OSG2G6+csPQV9db+XQEUpseh+WhUQisCgGW19vSgqdejij3Qiy2l+v
1AdTckGh/WGAg2F03Yp34xwlMc/WrPNvYTh6ZjGYk0JJYk7oNq8IQ438t+YK
c1po24RBCQZ9J1VrP3OeMq2gsAzDV5095vxUSp56qrZuV2GQtHMX7l2iRPVK
86m+EcPYweRMk3S2P2og7evHkDSrfKJ1jZKK2otxkgEMkyfU508y1wqGA44P
YvDr1DWuZn5hWrg5OIzBpMQsw1tIyfRZo7ixjxheBnoGpWdSYjdvHjA3j2F3
g3Bm+Tolrm0ZVrIFDKnG4iKvLEq8xJ9V/B8YprOkgfnMwXZVLT+XMDRHVD+2
zaYkNcHaanUVQ5i+PD06h/3vk61qVWCQX37r0MIs3js3LlBi4HwfmVYzlzfX
3tzYwPC3a9a/MpeSmizt2M5NDLEOS8ol5sZTfH/hNoaR0rUGTxElbeiNpa8a
g9fOrcg85m6FrUqjwSBL2mU4wfwPmgk1ig==
                "]]},
              
              Annotation[#, 
               "Charting`Private`Tag$73410#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, 0},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Munc13-1 cluster number / AZ\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {6., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {8., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {10., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {6.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {7., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {7.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {8.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {9., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {9.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {10.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {11., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {11.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {12., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBWIQPbcuic0wpduOAQqOXFbwCVfItIfx/x/b16ygUAnn
zz3QK8+q0Ann59iW5n6XnwnnX/6dMeWD/Eo4n/32I/W38jvh/IWn5he+lj8J
569b33k7R+8WnJ9uf3Hmm6LHcH7eU83HW9a9hPMfxN3kOHgSwQ++0aF39gmC
b3H6eeVTqVdwPvPGpQJi7Qj+jBpFu/L413D+QWHJmZYCb+F8k94T+1y1Efxl
bBVPAt0Q/J6f1/SzahD8sPtTjs16geC/WiXw5feBd3B+jMoBSY47CP75ufn2
It8R/C0TznXp6L6H8+vLehRjZyL4n95bu2duQfBTMl/nlJ5H8C1Z9Zc/eIrg
AwB1yHkP
                "]], 
               Line[CompressedData["
1:eJwBAQP+/CFib1JlAgAAAC8AAAACAAAAY31orA8N8D86cen0ktU0P5in1AHT
HfA//yzkUGTJRz8KIYQn3zjwPwxhmRbqrVY/yDyRL35F8D9RdoZvY7ZbP4ZY
njcdUvA/y8U5ZG5fYD8CkLhHW2vwPxDbJr3nZ2U/+v7sZ9ed8D+aBQFv2nhv
P+vcVajPAvE/ca1a6V/NeT/MmCcpwMzxP0+Bh6ai94Y/jhDLKqFg8z8+6x0F
xIyVP2LbVL8DzPY/vBtHFxSvpT9xxYRibyf6P3GVtedrMrA/HuRGBvYz+j9P
Q63kZkawP8sCCap8QPo/LfGk4WFasD8lQI3xiVn6P+hMlNtXgrA/2bqVgKSL
+j9gBHPPQ9KwP0Gwpp7Z7/o/T3MwtxtysT8Rm8jaQ7j7Py5Rq4bLsbI/vrmK
fsrE+z8M/6KDxsWyP2vYTCJR0fs/6qyagMHZsj/FFdFpXur7P6UIinq3AbM/
eZDZ+Hgc/D8dwGhuo1GzP+GF6haugPw/DC8mVnvxsz+xcAxTGEn9P+sMoSUr
MbU/zJoTea1W/T/Bdl6h1Ua1P+bEGp9CZP0/leAbHYBctT8aGSnrbH/9Pz60
lhTVh7U/hMFFg8G1/T+UW4wDf961P1YSf7NqIv4/O6p34dKLtj9wPIbZ/y/+
PxAUNV19obY/imaN/5Q9/j/lffLYJ7e2P7+6m0u/WP4/j1Ft0Hzitj8oY7jj
E4/+P+P4Yr8mObc/+rPxE737/j+LR06deua3PxTe+DlSCf8/X7ELGSX8tz8u
CABg5xb/PzQbyZTPEbg/Y1wOrBEy/z/e7kOMJD24P8wEK0RmaP8/MpY5e86T
uD/mLjJq+3X/PwcA9/Z4qbg/AFk5kJCD/z/babRyI7+4PzWtR9y6nv8/hj0v
anjquD9Q104CUKz/P1yn7OUiALk/agFWKOW5/z8xEaphzRW5P55VZHQP1f8/
2uQkWSJBuT+4f2uapOL/P65O4tTMVrk/06lywDnw/z+EuJ9Qd2y5P52Cl1Pw
8v8/Ydt1P8twuT+caHvK
                "]], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAsj401ocGAECi3fngB7i5PxEURJl8
DABA4zIN1P/luT8eqUcsRxMAQEH9V/VpGro/ONNOUtwgAED9ke03PoO6P0Vo
UuWmJwBAW1w4Wai3uj9S/VV4cS4AQLkmg3oS7Lo/bCddngY8AEB0uxi95lS7
P6F7a+owVwBA9ORDQo8mvD8wwAn4h10AQBqPQc99V7w/wASoBd9jAEBHOT9c
bIi8P+CN5CCNcABAo406dknqvD8eoF1X6YkAQEo2MaoDrr0/msRPxKG8AECY
hx4SeDW/P5INNJ4SIgFAG5X8cDAiwT+Cn/xR9OwBQLg310AZMcQ/ANPgQLx6
A0AGngA7HTDKPyZ0ZnhUKgVAYTrnq85Y0D/k9ZdWC70GQHAifHXVYdM/TsHL
KXj5B0CUg5YZXsTVP6VXgqA=
                "]], 
               
               Line[{{3.0031887755102042`, 0.34153326654998095`}, {
                3.264705982550857, 0.3951573869314121}, {3.459855082525327, 
                0.43517272262491474`}, {3.6715147334054086`, 
                0.4785735478597943}, {3.869072690293142, 
                0.5190828198206661}, {3.9968112244897958`, 
                0.5452756145993443}}], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAWR8a60MDEEA8XHHQZHzhP9jCZAFa
LBFAk7C4qQX14j+1iMReIPURQBppBHSN8+M/ZgV14M7OEkCqy0o0hAflP2Ny
e7UMmhNAjEACiCwJ5j82Mt61KZ0TQMhEIuweDeY/CvJAtkagE0AFSUJQERHm
P7BxBreAphNAflGCGPYY5j/8cJG49LITQG5iAqm/KOY/lm+nu9zLE0BShALK
UkjmP2kvCrz5zhNAj4giLkVM5j8872y8FtITQMuMQpI3UOY/424yvVDYE0BE
lYJaHFjmPzBuvb7E5BNANqYC6+Vn5j8DLiC/4ecTQHOqIk/Ya+Y/1u2Cv/7q
E0CvrkKzym/mP3xtSMA48RNAJ7eCe6935j9PLavAVfQTQGS7ot+he+Y/Iu0N
wXL3E0Cgv8JDlH/mP/ascMGP+hNA3cPip4aD5j+n4OUUvPwTQPoNzu5HhuY/
GOGgMQ==
                "]], 
               Line[CompressedData["
1:eJwBoQJe/SFib1JlAgAAACkAAAACAAAAWR8a60MDFEBdyoayXY3mPxZsXsMg
ChRAG3LTc46T5j9ia+nElBYUQFD0VS7KnuY//Gn/x3wvFEC8+FqjQbXmPy9n
K85MYRRAkwFljTDi5j/eaR9vrWQUQFS6wXw85eY/jGwTEA5oFEAUcx5sSOjm
P+lx+1HPbhRAlOTXSmDu5j+jfMvVUXwUQJXHSgiQ+uY/F5Jr3VaXFECWjTCD
7xLnP/+8q+xgzRRAmRn8eK5D5z/PEiwLdTkVQJ8xk2Qspec/u66CmywDFkBl
wpapIVvoP3sBKlDM3RZA2F+gHVcg6T/mRAvYJuEWQLcc1IxdI+k/UIjsX4Hk
FkCV2Qf8YybpPyQPr2826xZAUFNv2nAs6T/MHDSPoPgWQMdGPpeKOOk/Hjg+
znQTF0C4LdwQvlDpP8JuUkwdSRdAmPsXBCWB6T8ssjPUd0wXQHW4S3MrhOk/
lvUUXNJPF0BTdX/iMYfpP2t812uHVhdAEO/mwD6N6T8UilyL8WMXQIjitX1Y
mek/ZqVmysV+F0B4yVP3i7HpPwrcekhutBdAWJeP6vLh6T82d6kNj7cXQLmp
ej/F5Ok/YRLY0q+6F0AavGWUl+fpP7hINV3xwBdA3OA7Pjzt6T9mte9xdM0X
QF8q6JGF+Ok/klAeN5XQF0DBPNPmV/vpP73rTPy10xdAIU++Oyr+6T8UIqqG
99kXQONzlOXOA+o/wY5km3rmF0BmvUA5GA/qP+wpk2Cb6RdAx88rjuoR6j8Y
xcElvOwXQCjiFuO8FOo/bvsesP3yF0DpBu2MYRrqP5qWTXUe9hdASxnY4TMd
6j/FMXw6P/kXQKsrwzYGIOo/8Myq/1/8F0AMPq6L2CLqP6fg5RS8/BdAmpfS
mysj6j+HYDkh
                "]], 
               Line[CompressedData["
1:eJwBsQJO/SFib1JlAgAAACoAAAACAAAAWR8a60MDGEAdn/Ua+yfqP8rUk9kD
DBhAoUxLgvos6j94QU7uhhgYQJatSgsgNOo/pNx8s6cbGEDUhYpt6TXqP893
q3jIHhhAEV7Kz7I36j8mrggDCiUYQIwOSpRFO+o/0xrDF40xGECBb0kda0Lq
Py70N0GTShhAazFIL7ZQ6j/lpiGUn3wYQEG1RVNMbeo/7ITh+QOAGEDNSBxW
PG/qP/JioV9ogxhAWdzyWCxx6j8AHyErMYoYQHEDoF4Mdeo/GpcgwsKXGECg
UfppzHzqP1CHH/DlshhAAO6ugEyM6j+8Zx1MLOkYQL8mGK5Mq+o/lCgZBLlV
GUA9mOoITenqP5CaZsdhIBpA8OVRRw5d6z9alF3ODOcaQKkWde2Hzus/HLMK
G2vqGkC6XqR0dNDrP9/Rt2fJ7RpAzKbT+2DS6z9kDxIBhvQaQO42Mgo61us/
borGM/8BG0A0V+8m7N3rP4KAL5nxHBtAwJdpYFDt6z+pbAFk1lIbQNcYXtMY
DOw/bIuusDRWG0DpYI1aBQ7sPy6qW/2SWRtA+qi84fEP7D+y57WWT2AbQB05
G/DKE+w/vGJqychtG0BiWdgMfRvsP9BY0y67iBtA7plSRuEq7D/4RKX5n74b
QAYbR7mpSew/fLufg8TBG0DCbJlCdUvsPwAymg3pxBtAf77ry0BN7D8HH48h
MssbQPhhkN7XUOw/Fvl4ScTXG0DpqNkDBljsP5pvc9Po2htApvorjdFZ7D8d
5m1dDd4bQGFMfhadW+w/JNNicVbkG0Da7yIpNF/sPzOtTJno8BtAyzZsTmJm
7D+2I0cjDfQbQIeIvtctaOw/OppBrTH3G0BE2hBh+WnsP74QPDdW+htAACxj
6sRr7D+m4OUUvPwbQC/CGYsjbew/duoztQ==
                "]], 
               Line[CompressedData["
1:eJwVzX0sFGAcwHFzLUtvCFt63KPULQljLEv2+430JpI5mUne0zQv6RTOJDXp
YiNyXXFcCq1SJr2cXpyiuyNKG9P7iljPEzu90KW3P777/PldHpcWmmhqYmLi
/K//RlC7z/4CgtHZh0KE6QxCYh3GF5gTFFWPrU07wODFoF2m+0KCFoWPuwoy
GUQE28yKLQj+TFbFVBxksMfH3FJpS7DPM6riThaDVJuv3u6OBA/39BkFuQwM
si8asYhgfMuVSlspA4np+PYcJ4JB8mI3pzwG0onXMZ1uBJcn+McH5zOQabtP
iDcQ1BnbdPJCBo1554ayxQTtnWvOupxi8GHE77CmiGBH8f51u6oZ+CmfqtbI
CPqEh44eqWFQGxHZW15K8OYK78rLSgbR+owV8ZUEm9SCqdk6BsPXa3sEFwiW
ccW1+ksMnuf+dgi4TzBup3aVoZmBxvKutvsrQdOlIusSDQOVr/uy3lh79G98
O6n5xODqcYnlXhchvuwonUAXDkXi+EDBNyE+W5TtEZfBQbXjVVTitBArakp6
ig9waN8qTu02CjHCVZV0I5ODwXdzmcyU4tsgvcIki0OUyHlwiQVFfspeoMzh
4PHDELfSmaL5fM3Ay0IOb+RHcwJiKfqbzZeIz3CYKTfKGhIomlXRxXlVHKxL
DlbPS6aoE3k21cs5bC1IetibSjF00+7XUwoOrfu2zQ2XUow53hxQruRwcr1V
eVIVRakgzLavkYPXq7qmol6KbX/O39qi5mDhmjzd3E8xMb9LEdXOgeW7bh4a
oGjzZyIv/R6Hekf1x9XDFCW//TbKH/z7p7ygulGKXrNj/Z86OUy2K1IN4xRH
pFatxkccehbF3rPjFCt/+VQt7uJwrIVHpkxR/GYs3b3uCYeYOa1Np79TvJh7
GwO1HDaE50yrZyiGGd877tFxaHg3Yt3+i+JggT44Uc/hL3v3S8M=
                "]], 
               Line[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAArA+N9aEBIEAy+3GnJc3tP7IgkOhW
BiBABNBorPvO7T9qxByGpwwgQAQ97EVy0e0/2Qs2wUgZIEADF/N4X9btP8Y0
mejcGiBAQ/JTH/3W7T+0XfwPcRwgQIPNtMWa1+0/kK/CXpkfIEADhHYS1tjt
P0hTT/zpJSBAA/H5q0zb7T+4mmg3izIgQAPLAN854O0/mCmbrc1LIEACfw5F
FOrtP3/AjZhLuSBAYxodA8oU7j9NG1WlyiQhQEMccnq4Pu4/QW7HWxGJIUAv
0sT01WXuP/rY6UbEiiFANHxFm39m7j+0Qwwyd4whQDomxkEpZ+4/JhlRCN2P
IUBEeseOfGjuPwzE2rSoliFAWSLKKCNr7j/YGe4NQKQhQINyz1xwcO4/cMUU
wG6/IUDXEtrECnvuPyowN6shwSFA3bxaa7R77j/jmlmW1MIhQOJm2xFefO4/
VnCebDrGIUDsutxesX3uPzwbKBkGzSFAAWPf+FeA7j8IcTtyndohQCyz5Cyl
he4/nxxiJMz1IUB/U++UP5DuPzozKy5i9yFAVfR7992Q7j/USfQ3+PghQCuV
CFp8ke4/CHeGSyT8IUDW1iEfuZLuP6KNT1W6/SFAq3eugVeT7j9U8HIKXv4h
QHfbWF2Xk+4/l6XgdA==
                "]], 
               Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAArA+N9aEBIkCgELvDsZTuP6T+PIao
BSJAY5BlFdiV7j/YK8+Z1AgiQMAyIQHAlu4/QIbzwCwPIkB6d5jYj5juP+Lv
hF2NKCJAY4p1Ns+f7j8kw6eWTlsiQDWwL/JNru4/kC3CKtK+IkCb9JKDucru
P2bzBNHJKiNA6u1hHo/p7j9isfIgiY8jQOeBYdtUBu8/bIJT/EqRI0Ce5+BU
1QbvP3VTtNcMkyNAVU1gzlUH7z+I9XWOkJYjQMMYX8FWCO8/rjn5+5edI0Cg
r1ynWArvP/nB/9amqyNAWd1Xc1wO7z+Q0gyNxMcjQMs4TgtkFu8/mqNtaIbJ
I0CCns2E5BbvP6N0zkNIyyNAOQRN/mQX7z+2FpD6y84jQKjPS/FlGO8/3FoT
aNPVI0CEZknXZxrvPyfjGUPi4yNAPZREo2se7z8wtHoepOUjQPT5wxzsHu8/
OoXb+WXnI0CrX0OWbB/vP0wnnbDp6iNAGStCiW0g7z9yayAe8fEjQPbBP29v
Iu8/fDyB+bLzI0CtJ7/o7yLvP4UN4tR09SNAZI0+YnAj7z+Yr6OL+PgjQNNY
PVVxJO8/ooAEZ7r6I0CKvrzO8STvP6tRZUJ8/CNAQSQ8SHIl7z+0IsYdPv4j
QPiJu8HyJe8/vvMm+f//I0Cv7zo7cybvPwAv9WY=
                "]]}, "Charting`Private`Tag$73410#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBWIQPbcuic0wpduOAQqOXFbwCVfItIfx/x/b16ygUAnn
zz3QK8+q0Ann59iW5n6XnwnnX/6dMeWD/Eo4n/32I/W38jvh/IWn5he+lj8J
569b33k7R+8WnJ9uf3Hmm6LHcH7eU83HW9a9hPMfxN3kOHgSwQ++0aF39gmC
b3H6eeVTqVdwPvPGpQJi7Qj+jBpFu/L413D+QWHJmZYCb+F8k94T+1y1Efxl
bBVPAt0Q/J6f1/SzahD8sPtTjs16geC/WiXw5feBd3B+jMoBSY47CP75ufn2
It8R/C0TznXp6L6H8+vLehRjZyL4n95bu2duQfBTMl/nlJ5H8C1Z9Zc/eIrg
AwB1yHkP
                "]], 
               Line[CompressedData["
1:eJwVxXkwVAEAB+C1umyHtKikRGO0Ct3RqB9SShcr6yjaiNitcUS1HVTERLKm
FR3oMOVYpmbZdte+lGjeZGcMFemSDjW63lajenu86o9vPue4FH4Cm8Vief3z
//ijSXLriRTIsENOK6XeKL/x2OLRTAptsoK0iPEbwXHOdRvwplAVO7bNiYgG
6VvilbWGAvWF1+AoECIvsnL5TD4F6fwQSe2meLClqqBtYgrdtZds7vsmgzZ/
3t1XQYHX4+B8uCgdn16E13Sx9SB1itBGcRZ05W68uzo9fr5Oj+LYFuLM5E73
K8If4Ij5Md5J5xH3fGurpW4EfQFtzXJpLdI6cuNS3GgUXQ0uLp+mwKx3a8eM
LKYRMyKyd1ugQCfbqu6IHw3P4MKK5iAFXP2K9KeiaHTpO+t79ivQryk9Vl1I
Y4r/JnLCEwX8b16v7P9Go2xgi8XxkibYXCSfrVYZcNkxfF8yR4k76oKsh+0G
pKVm0r+clRA/3egS2m2Af3vp8TwfJTrsupNjhw14K+4tvpakhETa//ugoxGu
LRHylw+UGDw5bN94zIi6qOj3oTm3cSt1Qti09SY0ndsRscKogu4CV9IgMKF+
eP75Djs1htodqgJ2mXBlFf0sxEsNh+m8T3uyTTg9JIvdHadG7r01OfeaTUhc
9jBBRqohmJKtELmYMbV3ScZXmQapvnn9jJcZE93ZSkmjBgWJRYxspRmWWV2/
RpEatGoubmiNNINyFR2eYdBgbrzqLbfYDDKz6sS6nS2gFXouYTBDYscpueqh
he2r3z58KwYpyX09HkFaeI5jCT/YM0ggqm3VQi3it0+S2yxiwE9AeddZLXSj
5gUmJjFwb86oMv7RYshzkciQyWC2VcBgPpcAK8pHKs1hYB9jPYfrQWBpQ9AL
TSUDy9F113lCAiF9m9khcgZ05IGPTRICIgvB3PdqBpQ80N3vLIHK8F0Z1k8Y
PN860CB4QECVLb5Q/YZBd4382+AAgUe16Xd9KAakUbJw7x8CFSfKwqjvDGYJ
e1PyzQT+Ag2jevE=
                "]], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAsj401ocGAEDDxRKbgFC+PxEURJl8
DABAP4wyntyEvj8eqUcsRxMAQM6m9zqQwL4/ONNOUtwgAEDr24F09ze/P0Vo
UuWmJwBAefZGEatzvz9S/VV4cS4AQAgRDK5er78/bCddngY8AEASI8vzYhPA
P6F7a+owVwBANFhVLcqKwD8wwAn4h10AQP76gTeopsA/wASoBd9jAEDNna5B
hsLAP+CN5CCNcABAauMHVkL6wD8eoF1X6YkAQJ1uun66acE/msRPxKG8AEAB
hR/QqkjCP5INNJ4SIgFAy7HpcosGxD+Cn/xR9OwBQF4LfrhMgsc/ANPgQLx6
A0Boy8BMuVbOPyZ0ZnhUKgVA23ejC+Pf0j/k9ZdWC70GQJs6KerwVNY/TsHL
KXj5B0ByGCsCWwzZP7JrhwI=
                "]], 
               Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAsj401ocGCEDbrvkJayfZP07kkCse
HgpADP+t2sw53T/qw2KAyK0LQHSzsJ/SIeA/LhHWHUNfDUCre/ltpsfhP+aN
5oKVZQ1ApZq2Us3N4T+dCvfn52sNQJ+5czf00+E/DAQYsox4DUCT9+0AQuDh
P+r2WUbWkQ1AfHPik9344T+l3N1uacQNQExry7kUKuI/HKjlv48pDkDuWp0F
g4ziP9Qk9iTiLw5A6Xla6qmS4j+LoQaKNDYOQOOYF8/QmOI/+ponVNlCDkDX
1pGYHqXiP9iNaegiXA5AwFKGK7q94j+Tc+0Qto4OQJBKb1Hx7uI/Cj/1Ydzz
DkAyOkGdX1HjP3hBKAi2+g5AfRVuIApY4z/mQ1uujwEPQMjwmqO0XuM/wkjB
+kIPD0Bfp/SpCWzjP3pSjZOpKg9AjBSotrOG4z/rZSXFdmEPQObuDtAHvOM/
WmhYa1BoD0AyyjtTssLjP8hqixEqbw9AfqVo1lzJ4z+kb/Fd3XwPQBRcwtyx
1uM/XHm99kOYD0BByXXpW/HjP8yMVSgRzw9AmqPcArAm5D86j4jO6tUPQOZ+
CYZaLeQ/qJG7dMTcD0AxWjYJBTTkP4SWIcF36g9AyBCQD1pB5D/ymFRnUfEP
QBLsvJIESOQ/YJuHDSv4D0Bex+kVr07kP07Byyl4+Q9AkvkDPvNP5D85afgV

                "]], 
               Line[CompressedData["
1:eJwVj31MzHEcxy+RzrCv+55Yhh5QTU9r1oPi80FLhil2ppCViiSlMCUupWVY
MpMr1cJU6jZdXEqdck5Uduiks65k/c7vK26kTnrQnD9ee//x+uf9coxJ3hk3
QyAQeFn4vxHL7b9tsiYY4ll7whzBgSScCPbZEIzUKhoS93NwpctN90pIUB5y
RIvRHEy835d+hxAM8+sdHzrMwYeP6heSZQRli1VhcJqDeXsNMrUjwaGCk/Hi
TA6CDeZEr5UEg4SemV+lHNT1u4qE7gQHxssqr+dxkD+YH9UcQNCtN2uaL+Rg
sylyzElC8ElpsLxAyUGZOEcn3UOQ6sTGXY0cjAbWPDDsJZhoa1y6SMVB+aXJ
Q4UxBJek5V4t1Vj+uZTohSkEz4a2pVbrOJDH9DX+vEQQRjYHaIY5IPoDmU9b
CapDt7aNeRhBr461inRfgB0j4QNRFUZQXtREOZgXYEZVkX5m3heIn3VyQKsV
YU7s2uIbGTzYL2/vmXwnQtPb8CDnczxo/Ze+ce0W4Z51Cf2153nwPfpCld0r
Qk87mdPrizzY6Bbe8mUi1L80V8+4ycO98npJmRVFj9WKpuSHPHCBfzqS1lDs
GXbp2/KdB5lkm7rYj+LGKJD2/OBhW3J548u1FOUdux3jRnh4dCe0ynEDxey7
uXFZEzxcEBbldm+n6C4ZNNXbMljRE4DrDll8Q9m080oGB1PPKOcWW7x0ocP0
fga+Pv1Kt1KKpVXBxvRoBnN+YX1IOcX5XWnV5lgGtcdtHmdVUPy5omuNKZHB
VMq1htE6inUd+VsM6QwKkyubDJ0UA+xs057cYJDgNad5XEuxGvz8fYsYBP04
2mzXRdE+If6vooTB4DEfVZie4lSTJu/+XQbex1RPNRzF1ujzJTIFA2tPh5bP
PEXvy7XRYiWDD6bslukhircffVpV0MAgMym01X/Y0jN7vSKvhcEOj5pWySjF
X95Jp6yfM3AyzXuWOkbxYGRJoLSNwW95yrOrExS7czoFk+0MKgeM4uYpihF/
+zISXjP4B9cecHA=
                "]], 
               Line[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAWR8a60MDFEAfJdxHO9LoPxZsXsMg
ChRAmIIdpMjW6D9ia+nElBYUQMA62VML3+g//Gn/x3wvFEASq1CzkO/oPy9n
K85MYRRAtYs/cpsQ6T/eaR9vrWQUQD+bDfrYEuk/jGwTEA5oFEDKqtuBFhXp
P+lx+1HPbhRA38l3kZEZ6T+jfMvVUXwUQAgIsLCHIuk/F5Jr3VaXFEBchCDv
czTpP/+8q+xgzRRABH0BbExY6T/PEiwLdTkVQFRuw2X9n+k/u66CmywDFkC9
qNk/yyXqP3sBKlDM3RZAOkO4EdC26j/mRAvYJuEWQA9PBo4Jueo/UIjsX4Hk
FkDjWlQKQ7vqPyQPr2826xZAi3LwAra/6j/MHDSPoPgWQNuhKPSbyOo/Hjg+
znQTF0B9AJnWZ9rqP8JuUkwdSRdAwL15m//96j8ssjPUd0wXQJTJxxc5AOs/
lvUUXNJPF0Bo1RWUcgLrP2t812uHVhdAEO2xjOUG6z8UilyL8WMXQGEc6n3L
D+s/ZqVmysV+F0ACe1pglyHrPwrcekhutBdARTg7JS9F6z82d6kNj7cXQHmN
I1FCR+s/YRLY0q+6F0Cs4gt9VUnrP7hINV3xwBdAE43c1HtN6z9mte9xdM0X
QODhfYTIVes/wY5km3rmF0B6i8DjYWbrP+wpk2Cb6RdAruCoD3Vo6z8YxcEl
vOwXQOE1kTuIaus/bvsesP3yF0BH4GGTrm7rP5qWTXUe9hdAezVKv8Fw6z/F
MXw6P/kXQK6KMuvUcus/8Myq/1/8F0Dh3xoX6HTrP6fg5RS8/BdAcPLVKyV1
6z+g4x16
                "]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAWR8a60MDGEDAPU6Iz3jrP8rUk9kD
DBhAUiqJKtR86z94QU7uhhgYQBygRxqTgus/pNx8s6cbGECOPTfWAoTrP893
q3jIHhhAANsmknKF6z8mrggDCiUYQOUVBgpSiOs/0xrDF40xGECui8T5EI7r
Py70N0GTShhAQHdB2Y6Z6z/lpiGUn3wYQGVOO5iKsOs/lCgZBLlVGUCQKPwr
PRTsP5CaZsdhIBpAqrVJJE5x7D9alF3ODOcaQOnjkueJzOw/HLMKG2vqGkCY
bv/kFc7sP9/Rt2fJ7RpASPlr4qHP7D9kDxIBhvQaQKcORd250uw/borGM/8B
G0BkOffS6djsP4KAL5nxHBtA345bvknl7D+pbAFk1lIbQNU5JJUJ/uw/bIuu
sDRWG0CFxJCSlf/sPy6qW/2SWRtANE/9jyEB7T+y57WWT2AbQJJk1oo5BO0/
vGJqychtG0BQj4iAaQrtP9BY0y67iBtAy+Tsa8kW7T/4RKX5n74bQMGPtUKJ
L+0/fLufg8TBG0A9TbS5+jDtPwAymg3pxBtAuAqzMGwy7T8HH48hMssbQK6F
sB5PNe0/Fvl4ScTXG0Cae6v6FDvtP5pvc9Po2htAFjmqcYY87T8d5m1dDd4b
QJD2qOj3Pe0/JNNicVbkG0CGcabW2kDtPzOtTJno8BtAc2ehsqBG7T+2I0cj
DfQbQO4koCkSSO0/OppBrTH3G0Bp4p6gg0ntP74QPDdW+htA5J+dF/VK7T+m
4OUUvPwbQKkawP4OTO0/klQP3g==
                "]], 
               Line[CompressedData["
1:eJwVjX0s1GEcwOWsxnoh1OLpHnUlUnKa9Xb2/XbVhELsp+smjtxV6ExYOHqx
SnPLhvVq5qUW1lTr5Z9IxW236s6aFB1dtpBbnifzXteb/vjss89fn1UpmbFq
RwcHh4A5/ltBvb7tEhH83jOQmx/FICbZx7bQhWDZ3xVMFcOgu8crW7qIoJO4
64n8AANFlOdvwZVggaz09JpYBkk7XNxqlhHU5P9cMhLHQOs5uVUqIRg6YQnO
PMhgXM/bBV+Cj9wq7TEKBrmOtn0F/gT9gyINwYcYFH7/pOrYRNDzRIswrWSg
f2W8JMgIjg5X5RUlMmgsqurNFwhWWRLa9GoGX4bkee0lBH++tIY3ZjOQ13TW
r9cT3F/su6g6h0GtQmmuKCNYJ9e+Lc9lkPgma/WRKwT3dvyO151iYHlQaxLd
InjVQFKjdAy6dH989rQR3GxUnp4sZtDu9vSVcZJghunDQ6xgUB8q9TYnr0Tr
h07vjw8YNF/IdTu6UYxZ9y6e/WVjUCIciRRNiXHsvMZv3moO9dH9CepZMa67
cyVkcq5bwwWt0S7GJKNB/lXCYTw0rFzvSLHTWXLYvJZDgm9Aj7srxeayz+U3
/DkEz4ynrAmgmHZdYZdKOVivFxfsSaY4dDeiMwU5/Kiw6xtSKa405/cJOzl4
XM6pdj5GUeCNI3vlHMLPaV6YtRQNQQtEm3ZzeHw8Yn58IcX6Jx1b7GEcSrcv
rdBco6h6LqurjOYQ0l/XVGKmaOkKzDEkcnANPDZ7/y1F4t4U2ZDEYfRMYFjv
O4pJcRJJqYrDbUnLoJ+F4uC75V3RKXP/9G76epgi63YI6lNzGGu9qR23UQzy
1C1o03AwLU5+5sUonhSmrLVHOZx/yJTpExRn3tsua45zUDk9bqqcprhtWao6
PI2DLL5gtuUHxcJ4q2xDOoeGgSGP1l8Ui9p1JlEGh39thkVL
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAArA+N9aEBIEC89V3EiW3uP7IgkOhW
BiBAyFg1tklv7j9qxByGpwwgQIVF6rGice4/2Qs2wUgZIEAAH1SpVHbuP8Y0
mejcGiBALlpB6Op27j+0XfwPcRwgQF6VLieBd+4/kK/CXpkfIEC8CwmlrXju
P0hTT/zpJSBAevi9oAZ77j+4mmg3izIgQPTRJ5i4f+4/mCmbrc1LIEDphPuG
HInuP3/AjZhLuSBAkgPNwtCx7j9NG1WlyiQhQMqY0xPH2e4/QW7HWxGJIUBu
dmhEDv/uP/rY6UbEiiFAsNQs86//7j+0Qwwyd4whQPIy8aFRAO8/JhlRCN2P
IUB273n/lAHvPwzE2rSoliFAfWiLuhsE7z/YGe4NQKQhQI1arjApCe8/cMUU
wG6/IUCsPvQcRBPvPyowN6shwSFA7py4y+UT7z/jmlmW1MIhQDD7fHqHFO8/
VnCebDrGIUCztwXYyhXvPzwbKBkGzSFAuzAXk1EY7z8IcTtyndohQMsiOglf
He8/wttdXVDcIUANgf63AB7vP3tGgEgD3iFATt/CZqIe7z/uG8UeaeEhQNKb
S8TlH+8/1MZOyzToIUDaFF1/bCLvP58cYiTM9SFA6QaA9Xkn7z86MysuYvch
QE2ewucQKO8/1En0N/j4IUCxNQXapyjvP25gvUGO+iFAFM1HzD4p7z8Id4ZL
JPwhQHhkir7VKe8/oo1PVbr9IUDb+8ywbCrvP1Twcgpe/iFAZJ6wjKkq7z+7
vQY5
                "]], 
               Line[CompressedData["
1:eJwV0H0sFGAcB3AVpmgqb5MxPY95ufM20vKS5+dl1m7SSjMyK7aLIUZHpbO8
3N2onbyMJFQcKYpkGZldKMlIKCYpZAntiXPLobue/vjuu89f3+17KCb5NH+n
lpaWPcv/bjKUKh/sQJBgT/ULuJTI1D6SBh0EgnWvMH9HSia57++M6yHQFMXH
jjCDRCF3NERgMjSQv+JEyVRl17uefQim7kYXuztTInguHg8/gOB+vKoig7nh
m9miyAQBV8+hSc+Fkv3ePoZfLBD4BeQN27hSMkdFUVJ7BIkdQUZRbpQIdUNi
MQeBW96MhYzZ1NIspYOL4E9Yus0yM4/3SLTgjCBnvc7jqjslrbKhxmMeCMpd
dMJLD1OSG2G6+csPQV9db+XQEUpseh+WhUQisCgGW19vSgqdejij3Qiy2l+v
1AdTckGh/WGAg2F03Yp34xwlMc/WrPNvYTh6ZjGYk0JJYk7oNq8IQ438t+YK
c1po24RBCQZ9J1VrP3OeMq2gsAzDV5095vxUSp56qrZuV2GQtHMX7l2iRPVK
86m+EcPYweRMk3S2P2og7evHkDSrfKJ1jZKK2otxkgEMkyfU508y1wqGA44P
YvDr1DWuZn5hWrg5OIzBpMQsw1tIyfRZo7ixjxheBnoGpWdSYjdvHjA3j2F3
g3Bm+Tolrm0ZVrIFDKnG4iKvLEq8xJ9V/B8YprOkgfnMwXZVLT+XMDRHVD+2
zaYkNcHaanUVQ5i+PD06h/3vk61qVWCQX37r0MIs3js3LlBi4HwfmVYzlzfX
3tzYwPC3a9a/MpeSmizt2M5NDLEOS8ol5sZTfH/hNoaR0rUGTxElbeiNpa8a
g9fOrcg85m6FrUqjwSBL2mU4wfwPmgk1ig==
                "]]}, 
              "Charting`Private`Tag$73410#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, 0}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Munc13-1 cluster number / AZ", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {192., -189.}, {Center, Center}, {360., 360.}], 
    InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBIQPe/CFib1JlAgAAADEAAAACAAAAnX5iBjFkiz4QNy+gXQo4PsTTIExX
IGk/yFaBSnMNFj//xr6DICB5P2kWxjVDDSY/ncCNHwUgiT86dmgrKw02P2w9
dW33H5k/I6Y5Jh8NRj/T+2iU8B+pPxc+oiMZDVY/B9viJ+0fuT8RilYiFg1m
P6HKn3HrH8k/DrCwoRQNdj+ur4nbbC7aPyP3DoZ++oY/Zz/Rmexy4z/mHFDJ
1RGRPwCi9rrbi+M/E9mgC7gnkT+YBBzcyqTjP0CV8U2aPZE/yMlmHqnW4z+Z
DZPSXmmRPyhU/KJlOuQ/TP7V2+fAkT/oaCes3gHlP7LfW+75b5I/apJ9vtCQ
5j9+omcTHs6TPwL1ot+/qeY/q164VQDkkz+aV8gAr8LmP9gaCZji+ZM/yhwT
Q4305j8xk6ocpyWUPyunqMdJWOc/5YPtJTB9lD/su9PQwh/oP0tlczhCLJU/
buUp47Su6T8YKH9dZoqWP+Be2QjByek/rEYZdSOilj9T2IguzeTpP0Jls4zg
uZY/OMvneeUa6j9roue7WumWPwOxpRAWh+o/wBxQGk9Ilz+YfCE+d1/rP2gR
Idc3Bpg/CvbQY4N66z/8L7vu9B2YP31vgImPles/kU5VBrI1mD9iYt/Up8vr
P7uLiTUsZZg/LEida9g37D8OBvKTIMSYP8ETGZk5EO0/tvrCUAmCmT80jci+
RSvtP0wZXWjGmZk/pgZ45FFG7T/gN/d/g7GZP4z51i9qfO0/C3Urr/3gmT9W
35TGmujtP17vkw3yP5o/yFhE7KYD7j/yDS4lr1eaPzvS8xGzHu4/iCzIPGxv
mj8gxVJdy1TuP7Fp/Gvmnpo/6qoQ9PvA7j8F5GTK2v2aP1wkwBkI3O4/mQL/
4ZcVmz/PnW8/FPfuPy8hmflULZs/tJDOiiwt7z9YXs0oz1ybPycKfrA4SO8/
7nxnQIx0mz+agy3WRGPvP4ObAVhJjJs/f3aMIV2Z7z+t2DWHw7ubP/LvO0dp
tO8/QvfPnoDTmz9kaetsdc/vP9YVarY965s/OQUvp+Dl7z8yYSnX6v6bP7ZN
fOs=
                "]], 
               LineBox[{{1.003188775510204, 0.02825585501941306}, {
                1.0072813102255846`, 0.02931952207430302}, {1.013884691581611,
                 0.031035768774149684`}, {1.016966043290994, 
                0.03183662509565667}, {1.0200473950003768`, 
                0.03263748141716366}, {1.0262100984191425`, 
                0.03423919406017764}, {1.0385355052566738`, 
                0.0374426193462056}, {1.0631863189317368`, 
                0.04384946991826158}, {1.1124879462818624`, 
                0.05666317106237347}, {1.2110912009821138`, 
                0.08229057335059727}, {1.4248082612882276`, 
                0.13783653982980926`}, {1.6346277092346464`, 
                0.1923695003975115}, {1.8303454631887173`, 
                0.2432373711465669}, {1.996811224489796, 
                0.2865025254768865}}], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAsj401ocGAEBpkW/Ea3PSP4Kf/FH0
7AFAGRRHoSML1z8A0+BAvHoDQCNzTxuazNo/JnRmeFQqBUBYA+Fjy9/eP+T1
l1YLvQZAPopKO5dW4T+iQTNz3cMGQMMEDXfVXuE/X43Oj6/KBkBGf8+yE2fh
P9okBclT2AZAUHRUKpB34T/RU3I7nPMGQGNeXhmJmOE/vrFMIC0qB0CIMnL3
etrhP3z95zz/MAdADq00M7ni4T85SYNZ0TcHQJEn92736uE/tOC5knVFB0Ca
HHzmc/vhP6oPJwW+YAdArAaG1Wwc4j+XbQHqTpcHQNLambNeXuI/VLmcBiGe
B0BWVVzvnGbiPxIFOCPzpAdA2s8eK9tu4j+OnG5cl7IHQOTEo6JXf+I/hMvb
zt/NB0D2rq2RUKDiP0IXd+ux1AdAfClwzY6o4j//YhIIhNsHQACkMgnNsOI/
evpIQSjpB0AImbeAScHiPzhG5F367wdAjhN6vIfJ4j/1kX96zPYHQBKOPPjF
0eI/TsHLKXj5B0B2/6Q5ANXiP9eqvQk=
                "]], LineBox[CompressedData["
1:eJwBwQI+/SFib1JlAgAAACsAAAACAAAAsj401ocGCEAglXaY6OHiPy51UdBC
CwhABj9Gk4rl4j/rwOzsFBIIQKhdIYTH6uI/ZlgjJrkfCEDvmtdlQfXiP12H
kJgBOwhAfBVEKTUK4z9K5Wp9knEIQJYKHbAcNOM/Rn0jrER4CEDWUsQbQTnj
P0IV3Nr2fghAFZtrh2U+4z86RU04W4wIQJUrul6uSOM/KqUv8yOnCECUTFcN
QF3jPwtl9Gi13AhAk46RamOG4z/M5H1U2EcJQJESBiWq2OM/TuSQKx4eCkCM
Gu+ZN33kP+rDYoDIrQtAZRRPuySw5T8uEdYdQ18NQPFvsoYJ/eY/5o3mgpVl
DUAHNb5i5AHnP50K9+fnaw1AHPrJPr8G5z8MBBiyjHgNQEiE4fZ0EOc/6vZZ
RtaRDUCfmBBn4CPnP6Xc3W5pxA1ATcFuR7dK5z8cqOW/jykOQKgSKwhlmOc/
1CT2JOIvDkC+1zbkP53nP4uhBoo0Ng5A1JxCwBqi5z/6midU2UIOQAAnWnjQ
q+c/2I1p6CJcDkBXO4noO7/nP5Nz7RC2jg5ABGTnyBLm5z8KP/Vh3PMOQGC1
o4nAM+g/eEEoCLb6DkD8h1dEAznoP+ZDW66PAQ9AmVoL/0U+6D/CSMH6Qg8P
QNL/cnTLSOg/elKNk6kqD0BESkJf1l3oP+tlJcV2YQ9AKN/gNOyH6D9aaFhr
UGgPQMaxlO8ujeg/yGqLESpvD0BihEiqcZLoP6Rv8V3dfA9AmymwH/ec6D9c
eb32Q5gPQA10fwoCsug/zIxVKBHPD0DwCB7gF9zoPzqPiM7q1Q9AjdvRmlrh
6D+okbt0xNwPQCquhVWd5ug/hJYhwXfqD0BiU+3KIvHoP/KYVGdR8Q9A/yWh
hWX26D9gm4cNK/gPQJv4VECo++g/TsHLKXj5D0A9u/AQqPzoP7W2PlQ=
                "]], LineBox[CompressedData["
1:eJwBAQP+/CFib1JlAgAAAC8AAAACAAAAWR8a60MDEEBcBr8+dQTpP1VREABc
BhBA+dtBHhkH6T+M0inTyAkQQN6JF00FCuk/+tRceaIQEECo5cKq3Q/pP9bZ
wsVVHhBAPZ0ZZo4b6T8NW9yYwiEQQCJL75R6Huk/RNz1ay8lEEAH+cTDZiHp
P7LeKBIJLBBA0lRwIT8n6T+O445evDkQQGYMx9zvMuk/R+1a9yJVEECQe3RT
UUrpP54Ug9N/WBBAeHn04i9N6T/0O6uv3FsQQF53dHIOUOk/oIr7Z5ZiEEAs
c3SRy1XpP/onnNgJcBBAyGp0z0Vh6T+sYt258IoQQP9ZdEs6eOk/ENhffL7A
EEBsOHRDI6bpP9jCZAFaLBFASPVzM/UB6j+1iMReIPURQLZiicBGreo/ZgV1
4M7OEkD66S5zBWfrPxofydf70RJA5detJLtp6z/OOB3PKNUSQNHFLNZwbOs/
NmzFvYLbEkCpoSo53HHrPwbTFZs26BJAWVkm/7J86z+loLZVngETQLjIHYtg
kus/5Dv4ym00E0B2pwyju73rP5hVTMKaNxNAYpWLVHHA6z9Mb6C5xzoTQE6D
CgYnw+s/tKJIqCFBE0AmXwhpksjrP4QJmYXVTRNA1hYEL2nT6z8k1zlAPWcT
QDaG+7oW6es/Y3J7tQyaE0D0ZOrScRTsPzYy3rUpnRNA4aIT5RkX7D8K8kC2
RqATQNDgPPfBGew/sHEGt4CmE0CqXI8bEh/sP/xwkbj0shNAYFQ0ZLIp7D+W
b6e73MsTQM5DfvXyPuw/aS8KvPnOE0C7gacHm0HsPzzvbLwW0hNAqL/QGUNE
7D/jbjK9UNgTQIQ7Iz6TSew/MG69vsTkE0A7M8iGM1TsPwMuIL/h5xNAKHHx
mNtW7D/W7YK//uoTQBavGquDWew/fG1IwDjxE0DwKm3P017sP08tq8BV9BNA
3miW4Xth7D8i7Q3BcvcTQMumv/MjZOw/9qxwwY/6E0C65OgFzGbsP6fg5RS8
/BNAiBuRuqZo7D8hE2Hm
                "]], LineBox[CompressedData["
1:eJwBoQJe/SFib1JlAgAAACkAAAACAAAAWR8a60MDFEAZW3dk7WzsPxZsXsMg
ChRAfda28g5w7D9ia+nElBYUQLf4mHe9dew//Gn/x3wvFEAtPV2BGoHsPy9n
K85MYRRAGcbllNSX7D/eaR9vrWQUQJcf7hBfmew/jGwTEA5oFEAVefaM6Zrs
P+lx+1HPbhRAECwHhf6d7D+jfMvVUXwUQAiSKHUopOw/F5Jr3VaXFED3XWtV
fLDsP/+8q+xgzRRA1fXwFSTJ7D/PEiwLdTkVQJAl/JZz+uw/u66CmywDFkDu
txEAfFbtP3sBKlDM3RZAFoYbHTu67T/mRAvYJuEWQHyb59DCu+0/UIjsX4Hk
FkDhsLOESr3tPyQPr2826xZArNtL7FnA7T/MHDSPoPgWQEExfLt4xu0/Hjg+
znQTF0Bs3NxZttLtP8JuUkwdSRdAwzKeljHr7T8ssjPUd0wXQChIakq57O0/
lvUUXNJPF0COXTb+QO7tP2t812uHVhdAWYjOZVDx7T8UilyL8WMXQO7d/jRv
9+0/ZqVmysV+F0AaiV/TrAPuPwrcekhutBdAcN8gECgc7j82d6kNj7cXQKHx
iGmVHe4/YRLY0q+6F0DSA/HCAh/uP7hINV3xwBdANCjBdd0h7j9mte9xdM0X
QPlwYduSJ+4/klAeN5XQF0Aqg8k0ACnuP73rTPy10xdAW5Uxjm0q7j8UIqqG
99kXQL25AUFILe4/wY5km3rmF0CAAqKm/TLuP+wpk2Cb6RdAsRQKAGs07j8Y
xcElvOwXQOMmclnYNe4/bvsesP3yF0BES0IMszjuP5qWTXUe9hdAdV2qZSA6
7j/FMXw6P/kXQKZvEr+NO+4/8Myq/1/8F0DXgXoY+zzuP6fg5RS8/BdA3nCz
GyU97j8YQDWc
                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPE7NDLnaaqf+xKXUqLjOEm79vlYYi4rUjcPOyTFPGb9cegq
S6m0QsS6druyVGq1MJmYhVvRIzsjZdE85CHfr8TEerr+eO+9lygp+8BREx6P
t9XY/8e4CGd2m3LoWV8ZlgUUXvWVD5pacWiiHEgoDaKQG7SPFnEcps+uCtEG
U7gzpG64Rzg8X1Z2JnEPhfeqh7ld6znU+Ts3u4VQcH9sYWq5icO+U1KvB6EU
DMLOdVckHMqsj9g3ySmIFwKCyuUcWns//9wTQWH8rqhCp+aw7ni+ykxJ4du5
L8umBRzq93Zu+2D0fNLthNRCDgfcrcYexlPguYg8JcUc/hnSRkQlUhBWuXZ0
VHEoD2v3qD5CIeKCy9x4PYejIoshSKPQmuIc7jXF4RrDdTypolCxxdGs+ZAj
5vvXrZ4vo1CqOfbysKsQo0hNQmwnhdgK5Turr0KU8yXa7h8UnBosSfq0ED+l
jPXfXKAw3NuU0j0rxIx3VbZZixSSbez5RQtCvHrzT6H9EoWs4hd+f/kEe/3f
pMWtUDhb4H3juxPB6LSUHbM8BrUZ/OT+AwSTDVqDrTWDjMuPn0gVBBcDIwWj
RosfxP2+FkOw6JZZaKMNg/qvjZX7Ewnez0x/FmPHoDUprbsrk+CMeeDtagcG
PdEGcctFgjmyviwpYfAzuGZZ10bwTI2lZfQWBuoWXaG+nWAF763YyYMBz1cj
mNITrI0riRox2tylROT7mqDBzkGb6slg7XJumH6A4ObTzj55Ygaa7BOGyY8E
ZYPDB3d5M3CeyFQKPhOMlFbn8X0YbDQk5SjGCJ6cdu+8JGHg9yj8xuQcwR6F
j0IjZfDULdRNsEBwvG4+P96fwU5N0CPJEsEVq0bdhu0M2mxlAYoVgjapKv2E
0XdHxh1afxEskC9lqAMY/AMkMi3M
                "]], LineBox[CompressedData["
1:eJwVzX0sFHAYB3CRNkaj0Lp++Xkp5IZps3n/PZG85L2d2c3kzkvEToYtbzPC
VUdGM2/pnFOoScnaymVFdRGSFBnNVtQpfnbeO1q//nj27LPv891jKUyPTNTW
0tLisvm/ozHnl68OgkMGbYp6V0rCBRYqA30E4WYuFr5ulExMcjKdDREcl4XV
VDFHh5ru8owQ/OFe1J9jPu+hbyw1Q3DnlHQt350Skemaq7M1y9P0Bp94UKKW
LPfzbBC837T21vWkJFtbFZx7AkFrsffjc8z5dDZuwAlBaF1m0wqzZFB5leeJ
QD4wm2HvTUl7QeNUDg9BCKebcxso+Tbvc7lfjECm5KeV+lHiIx1tsZcgMNR+
mTPN3BzNH6m+gSDH01bsdIaS2HcZVvE1CCIercq+ME8/bB7WkSPY01g+6RBA
yXjeXwu/PgQCUZ/P5yBK+o2fDSrXEFiaWh22Daekxcv5yIjgKMiEqtdv+ZR0
lmYbX3Awh/bJjWa5iBIxL/6szro5LBe2TXGK2X3YTEziljnYqD+EpDMrAnki
pcYcYhN2+geY1V7+VRJtDKMBEZ1pVyiJseFOHjTC0GmsKeoroeTkplp4jIsh
TR7KFYop+VpXnOsnwLD4Zr2go5yS7WqNpC0Bg5Wbxeous0lFVpNeMgb+/aDk
yApKAouSXoyIMAxVSiM1zD0pQfui8jHciw60Damk5Lr7geqkWgwpi7fGVqoo
cZmRdYhHMPwwPG3tWkuJkWPyVtcYhrK8rI0y5t+Fjv5THzHYqFoHPzG3Wvd+
t5vGkPRK91JmHfufOoGHFjAs5CoVD+opWVE0iNQq1v+5WbnLPLxf8JyzxPpR
dvHBDZSUdC/xU1dZ3/ma3iJz3N6ejpsbGPZJn864NlLiGZW71buN4a7BYpeY
uW1u3kSxg8Etv6F2nPkfkY5GgA==
                "]], LineBox[CompressedData["
1:eJwVx3lIE1AcwPGpuIZNVDBizew98ZgdGiaKZr1fh+KcNtNcLNPAiFJsqSAG
GpWSkE0UraGmm6VrC43KhssMnWMeeWTRCjOVYoSTwmfq8mBFrz++fPngnCtp
F1w5HI6I9f+dXtWOBy4INBvuDnEzJV2o1i7jIthraPIxMudZ/Cp1fATzI4eK
xS2UfN4aNZAoQJC9XBGnUFMyFNlon9mBQGnM/1jHbMhyehX6Iegty1AYmWuf
mrMbdyEQbAlp5WgoSUyXOheCEFiFo271zC+bLkXfiUAgifceM7ZS0hB6/8mE
BEFMQ7PcpY2S1ZUEbUUKAu3Zc66hzNK+5eYYKQJvHNCRysxNT1Jq0xDYH+uc
Gubiso28a3IEqt4uzeF2StImT4v2XUSwOjfyvVRLCb/Yt01ZjuBZkKPwt46S
66bqBkkPguAXKVU/OilJEWZoRwMxqOqTruq6KTmiGM70uY2hM3KD+7qfks2p
hQRLFQbFomeujdlwjB9RosQQrg8Y8zBREiw4yZutwfBcmFwjZ+Zbpg16FYZu
V832NeYpwaIntGMwvTsuijBTUjDoa1L0Y/iQXyv